/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-03-29 22:00:53 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1855 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1965 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=5553 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

;

;

;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_defender_antibot` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(45) NOT NULL,
  `unlocked` tinyint(1) DEFAULT NULL,
  `unlocked_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

;

;

;

;

;

;

;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_frmt_form_entry` (
  `entry_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_type` varchar(191) NOT NULL,
  `draft_id` varchar(12) DEFAULT NULL,
  `form_id` bigint(20) unsigned NOT NULL,
  `is_spam` tinyint(1) NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`entry_id`),
  KEY `entry_is_spam` (`is_spam`),
  KEY `entry_type` (`entry_type`),
  KEY `entry_form_id` (`form_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_frmt_form_entry_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(191) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`),
  KEY `meta_entry_id` (`entry_id`),
  KEY `meta_key_object` (`entry_id`,`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_frmt_form_reports` (
  `report_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `report_value` longtext NOT NULL,
  `status` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`report_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_frmt_form_views` (
  `view_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned NOT NULL,
  `page_id` bigint(20) unsigned NOT NULL,
  `ip` varchar(191) DEFAULT NULL,
  `count` mediumint(8) unsigned NOT NULL DEFAULT 1,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`view_id`),
  KEY `view_form_id` (`form_id`),
  KEY `view_ip` (`ip`),
  KEY `view_form_object` (`form_id`,`view_id`),
  KEY `view_form_object_ip` (`form_id`,`view_id`,`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=2728 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2167 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=3571 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_smush_dir_images` (
  `id` mediumint(9) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `path_hash` char(32) DEFAULT NULL,
  `resize` varchar(55) DEFAULT NULL,
  `lossy` varchar(55) DEFAULT NULL,
  `error` varchar(55) DEFAULT NULL,
  `image_size` int(10) unsigned DEFAULT NULL,
  `orig_size` int(10) unsigned DEFAULT NULL,
  `file_time` int(10) unsigned DEFAULT NULL,
  `last_scan` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `path_hash` (`path_hash`),
  KEY `image_size` (`image_size`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("1820", "forminator_action_scheduler_cleanup", "complete", "2025-03-03 19:27:53", "2025-03-03 19:27:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1741030073;s:18:\"\0*\0first_timestamp\";i:1736616465;s:13:\"\0*\0recurrence\";i:7200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1741030073;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:7200;}", "1", "1", "2025-03-29 21:52:35", "2025-03-29 21:52:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1821", "forminator_daily_cron", "complete", "2025-03-04 18:28:10", "2025-03-04 18:28:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1741112890;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1741112890;}", "1", "1", "2025-03-29 21:52:35", "2025-03-29 21:52:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1831", "forminator_send_export", "complete", "2025-03-29 21:53:34", "2025-03-29 21:53:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285214;s:18:\"\0*\0first_timestamp\";i:1736616475;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:53:37", "2025-03-29 21:53:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1832", "forminator_process_report", "complete", "2025-03-29 21:53:34", "2025-03-29 21:53:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285214;s:18:\"\0*\0first_timestamp\";i:1736616485;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:53:37", "2025-03-29 21:53:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1833", "forminator_send_export", "complete", "2025-03-29 21:53:34", "2025-03-29 21:53:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285214;s:18:\"\0*\0first_timestamp\";i:1737573315;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285214;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:53:37", "2025-03-29 21:53:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1834", "forminator_general_data_protection_cleanup", "pending", "2025-03-29 22:52:34", "2025-03-29 22:52:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743288754;s:18:\"\0*\0first_timestamp\";i:1736616465;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743288754;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1835", "forminator_action_scheduler_cleanup", "pending", "2025-03-29 23:52:35", "2025-03-29 23:52:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743292355;s:18:\"\0*\0first_timestamp\";i:1736616465;s:13:\"\0*\0recurrence\";i:7200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743292355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:7200;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1836", "forminator_send_export", "complete", "2025-03-29 21:54:37", "2025-03-29 21:54:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285277;s:18:\"\0*\0first_timestamp\";i:1736616475;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285277;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:54:55", "2025-03-29 21:54:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1837", "forminator_process_report", "complete", "2025-03-29 21:54:37", "2025-03-29 21:54:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285277;s:18:\"\0*\0first_timestamp\";i:1736616485;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285277;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:54:55", "2025-03-29 21:54:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1838", "forminator_send_export", "complete", "2025-03-29 21:54:37", "2025-03-29 21:54:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285277;s:18:\"\0*\0first_timestamp\";i:1737573315;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285277;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:54:55", "2025-03-29 21:54:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1839", "forminator_send_export", "complete", "2025-03-29 21:55:55", "2025-03-29 21:55:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285355;s:18:\"\0*\0first_timestamp\";i:1736616475;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:55:55", "2025-03-29 21:55:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1840", "forminator_process_report", "complete", "2025-03-29 21:55:55", "2025-03-29 21:55:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285355;s:18:\"\0*\0first_timestamp\";i:1736616485;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:55:55", "2025-03-29 21:55:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1841", "forminator_send_export", "complete", "2025-03-29 21:55:55", "2025-03-29 21:55:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285355;s:18:\"\0*\0first_timestamp\";i:1737573315;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:55:55", "2025-03-29 21:55:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1842", "forminator_send_export", "complete", "2025-03-29 21:56:55", "2025-03-29 21:56:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285415;s:18:\"\0*\0first_timestamp\";i:1736616475;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285415;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:57:55", "2025-03-29 21:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1843", "forminator_process_report", "complete", "2025-03-29 21:56:55", "2025-03-29 21:56:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285415;s:18:\"\0*\0first_timestamp\";i:1736616485;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285415;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:57:55", "2025-03-29 21:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1844", "forminator_send_export", "complete", "2025-03-29 21:56:55", "2025-03-29 21:56:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285415;s:18:\"\0*\0first_timestamp\";i:1737573315;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285415;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:57:55", "2025-03-29 21:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1845", "action_scheduler/migration_hook", "complete", "2025-03-29 21:57:49", "2025-03-29 21:57:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1743285469;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1743285469;}", "2", "1", "2025-03-29 21:57:55", "2025-03-29 21:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1846", "forminator_send_export", "complete", "2025-03-29 21:58:55", "2025-03-29 21:58:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285535;s:18:\"\0*\0first_timestamp\";i:1736616475;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:59:19", "2025-03-29 21:59:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1847", "forminator_process_report", "complete", "2025-03-29 21:58:55", "2025-03-29 21:58:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285535;s:18:\"\0*\0first_timestamp\";i:1736616485;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:59:19", "2025-03-29 21:59:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1848", "forminator_send_export", "complete", "2025-03-29 21:58:55", "2025-03-29 21:58:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285535;s:18:\"\0*\0first_timestamp\";i:1737573315;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285535;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 21:59:19", "2025-03-29 21:59:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1849", "forminator_send_export", "complete", "2025-03-29 22:00:19", "2025-03-29 22:00:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285619;s:18:\"\0*\0first_timestamp\";i:1736616475;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 22:00:22", "2025-03-29 22:00:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1850", "forminator_process_report", "complete", "2025-03-29 22:00:19", "2025-03-29 22:00:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285619;s:18:\"\0*\0first_timestamp\";i:1736616485;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 22:00:22", "2025-03-29 22:00:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1851", "forminator_send_export", "complete", "2025-03-29 22:00:19", "2025-03-29 22:00:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285619;s:18:\"\0*\0first_timestamp\";i:1737573315;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285619;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "1", "2025-03-29 22:00:22", "2025-03-29 22:00:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1852", "forminator_send_export", "pending", "2025-03-29 22:01:22", "2025-03-29 22:01:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285682;s:18:\"\0*\0first_timestamp\";i:1736616475;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285682;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1853", "forminator_process_report", "pending", "2025-03-29 22:01:22", "2025-03-29 22:01:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285682;s:18:\"\0*\0first_timestamp\";i:1736616485;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285682;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1854", "forminator_send_export", "pending", "2025-03-29 22:01:22", "2025-03-29 22:01:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1743285682;s:18:\"\0*\0first_timestamp\";i:1737573315;s:13:\"\0*\0recurrence\";i:60;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1743285682;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:60;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "forminator");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "action-scheduler-migration");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("5448", "1820", "action created", "2025-03-03 17:27:53", "2025-03-03 17:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("5451", "1821", "action created", "2025-03-03 17:28:10", "2025-03-03 17:28:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5481", "1831", "action created", "2025-03-29 21:52:34", "2025-03-29 21:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5484", "1832", "action created", "2025-03-29 21:52:34", "2025-03-29 21:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5487", "1833", "action created", "2025-03-29 21:52:34", "2025-03-29 21:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5490", "1834", "action created", "2025-03-29 21:52:34", "2025-03-29 21:52:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("5491", "1820", "action started via Async Request", "2025-03-29 21:52:35", "2025-03-29 21:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5492", "1820", "action complete via Async Request", "2025-03-29 21:52:35", "2025-03-29 21:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5493", "1835", "action created", "2025-03-29 21:52:35", "2025-03-29 21:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5494", "1821", "action started via Async Request", "2025-03-29 21:52:35", "2025-03-29 21:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5495", "1821", "action complete via Async Request", "2025-03-29 21:52:35", "2025-03-29 21:52:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("5496", "1831", "action started via Async Request", "2025-03-29 21:53:37", "2025-03-29 21:53:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5497", "1831", "action complete via Async Request", "2025-03-29 21:53:37", "2025-03-29 21:53:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5498", "1836", "action created", "2025-03-29 21:53:37", "2025-03-29 21:53:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5499", "1832", "action started via Async Request", "2025-03-29 21:53:37", "2025-03-29 21:53:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5500", "1832", "action complete via Async Request", "2025-03-29 21:53:37", "2025-03-29 21:53:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5501", "1837", "action created", "2025-03-29 21:53:37", "2025-03-29 21:53:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5502", "1833", "action started via Async Request", "2025-03-29 21:53:37", "2025-03-29 21:53:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5503", "1833", "action complete via Async Request", "2025-03-29 21:53:37", "2025-03-29 21:53:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5504", "1838", "action created", "2025-03-29 21:53:37", "2025-03-29 21:53:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("5505", "1836", "action started via WP Cron", "2025-03-29 21:54:55", "2025-03-29 21:54:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5506", "1836", "action complete via WP Cron", "2025-03-29 21:54:55", "2025-03-29 21:54:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5507", "1839", "action created", "2025-03-29 21:54:55", "2025-03-29 21:54:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5508", "1837", "action started via WP Cron", "2025-03-29 21:54:55", "2025-03-29 21:54:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5509", "1837", "action complete via WP Cron", "2025-03-29 21:54:55", "2025-03-29 21:54:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5510", "1840", "action created", "2025-03-29 21:54:55", "2025-03-29 21:54:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5511", "1838", "action started via WP Cron", "2025-03-29 21:54:55", "2025-03-29 21:54:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5512", "1838", "action complete via WP Cron", "2025-03-29 21:54:55", "2025-03-29 21:54:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5513", "1841", "action created", "2025-03-29 21:54:55", "2025-03-29 21:54:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5514", "1839", "action started via WP Cron", "2025-03-29 21:55:55", "2025-03-29 21:55:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5515", "1839", "action complete via WP Cron", "2025-03-29 21:55:55", "2025-03-29 21:55:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5516", "1842", "action created", "2025-03-29 21:55:55", "2025-03-29 21:55:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5517", "1840", "action started via WP Cron", "2025-03-29 21:55:55", "2025-03-29 21:55:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5518", "1840", "action complete via WP Cron", "2025-03-29 21:55:55", "2025-03-29 21:55:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5519", "1843", "action created", "2025-03-29 21:55:55", "2025-03-29 21:55:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5520", "1841", "action started via WP Cron", "2025-03-29 21:55:55", "2025-03-29 21:55:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5521", "1841", "action complete via WP Cron", "2025-03-29 21:55:55", "2025-03-29 21:55:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5522", "1844", "action created", "2025-03-29 21:55:55", "2025-03-29 21:55:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5523", "1845", "action created", "2025-03-29 21:56:49", "2025-03-29 21:56:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("5524", "1842", "action started via WP Cron", "2025-03-29 21:57:54", "2025-03-29 21:57:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("5525", "1842", "action complete via WP Cron", "2025-03-29 21:57:55", "2025-03-29 21:57:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5526", "1846", "action created", "2025-03-29 21:57:55", "2025-03-29 21:57:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5527", "1843", "action started via WP Cron", "2025-03-29 21:57:55", "2025-03-29 21:57:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5528", "1843", "action complete via WP Cron", "2025-03-29 21:57:55", "2025-03-29 21:57:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5529", "1847", "action created", "2025-03-29 21:57:55", "2025-03-29 21:57:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5530", "1844", "action started via WP Cron", "2025-03-29 21:57:55", "2025-03-29 21:57:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5531", "1844", "action complete via WP Cron", "2025-03-29 21:57:55", "2025-03-29 21:57:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5532", "1848", "action created", "2025-03-29 21:57:55", "2025-03-29 21:57:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5533", "1845", "action started via WP Cron", "2025-03-29 21:57:55", "2025-03-29 21:57:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5534", "1845", "action complete via WP Cron", "2025-03-29 21:57:55", "2025-03-29 21:57:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("5535", "1846", "action started via Async Request", "2025-03-29 21:59:19", "2025-03-29 21:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5536", "1846", "action complete via Async Request", "2025-03-29 21:59:19", "2025-03-29 21:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5537", "1849", "action created", "2025-03-29 21:59:19", "2025-03-29 21:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5538", "1847", "action started via Async Request", "2025-03-29 21:59:19", "2025-03-29 21:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5539", "1847", "action complete via Async Request", "2025-03-29 21:59:19", "2025-03-29 21:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5540", "1850", "action created", "2025-03-29 21:59:19", "2025-03-29 21:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5541", "1848", "action started via Async Request", "2025-03-29 21:59:19", "2025-03-29 21:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5542", "1848", "action complete via Async Request", "2025-03-29 21:59:19", "2025-03-29 21:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5543", "1851", "action created", "2025-03-29 21:59:19", "2025-03-29 21:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("5544", "1849", "action started via Async Request", "2025-03-29 22:00:22", "2025-03-29 22:00:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5545", "1849", "action complete via Async Request", "2025-03-29 22:00:22", "2025-03-29 22:00:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5546", "1852", "action created", "2025-03-29 22:00:22", "2025-03-29 22:00:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5547", "1850", "action started via Async Request", "2025-03-29 22:00:22", "2025-03-29 22:00:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5548", "1850", "action complete via Async Request", "2025-03-29 22:00:22", "2025-03-29 22:00:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5549", "1853", "action created", "2025-03-29 22:00:22", "2025-03-29 22:00:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5550", "1851", "action started via Async Request", "2025-03-29 22:00:22", "2025-03-29 22:00:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5551", "1851", "action complete via Async Request", "2025-03-29 22:00:22", "2025-03-29 22:00:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("5552", "1854", "action created", "2025-03-29 22:00:22", "2025-03-29 22:00:22");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "Um comentador do WordPress", "wapuu@wordpress.example", "https://pt.wordpress.org/", "", "2025-01-05 20:50:57", "2025-01-05 20:50:57", "Olá, isto é um comentário.\nPara começar a moderar, editar e eliminar comentários, por favor visite o ecrã de comentários no painel.\nOs avatares dos comentadores são do <a href=\"https://pt.gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20250329_agrupamentodeescolasabelheir", "f3761850335021879378_20250329220036", "25", "2025-03-29 22:00:53", "gestor", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-03-29 22:00:36\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:7:\"10.4.32\";s:10:\"VersionPHP\";s:6:\"8.2.12\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";i:1;s:4:\"Name\";s:37:\"20250329_agrupamentodeescolasabelheir\";s:4:\"Hash\";s:35:\"f3761850335021879378_20250329220036\";s:8:\"NameHash\";s:73:\"20250329_agrupamentodeescolasabelheir_f3761850335021879378_20250329220036\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:83:\"20250329_agrupamentodeescolasabelheir_f3761850335021879378_20250329220036_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"25.5\";s:6:\"WPUser\";s:6:\"gestor\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:85:\"20250329_agrupamentodeescolasabelheir_f3761850335021879378_20250329220036_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:20:\"C:/xampp/htdocs/site\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2114;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:12880;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-03-29 22:00:36\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:7:\"10.4.32\";s:10:\"VersionPHP\";s:6:\"8.2.12\";s:9:\"VersionOS\";s:5:\"WINNT\";s:2:\"ID\";N;s:4:\"Name\";s:37:\"20250329_agrupamentodeescolasabelheir\";s:4:\"Hash\";s:35:\"f3761850335021879378_20250329220036\";s:8:\"NameHash\";s:73:\"20250329_agrupamentodeescolasabelheir_f3761850335021879378_20250329220036\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:91:\"20250329_agrupamentodeescolasabelheir_f3761850335021879378_20250329220036_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:34:\"C:/xampp/htdocs/site/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:86:\"20250329_agrupamentodeescolasabelheir_f3761850335021879378_20250329220036_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:31:\"mariadb.org binary distribution\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:139:\"C:/xampp/htdocs/site/wp-content/backups-dup-lite/tmp/20250329_agrupamentodeescolasabelheir_f3761850335021879378_20250329220036_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:29:\"C:/xampp/htdocs/site/wp-admin\";i:1;s:32:\"C:/xampp/htdocs/site/wp-includes\";i:2;s:41:\"C:/xampp/htdocs/site/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:20:\"C:/xampp/htdocs/site\";i:1;s:20:\"C:/xampp/htdocs/site\";i:2;s:31:\"C:/xampp/htdocs/site/wp-content\";i:3;s:39:\"C:/xampp/htdocs/site/wp-content/uploads\";i:4;s:39:\"C:/xampp/htdocs/site/wp-content/plugins\";i:5;s:42:\"C:/xampp/htdocs/site/wp-content/mu-plugins\";i:6;s:38:\"C:/xampp/htdocs/site/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:52:\"C:/xampp/htdocs/site/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_frmt_form_reports */
INSERT INTO `wp_frmt_form_reports` VALUES("1", "a:5:{s:7:\"exclude\";a:1:{i:0;i:1;}s:8:\"settings\";a:3:{s:5:\"label\";s:12:\"Form reports\";s:6:\"module\";s:5:\"forms\";s:10:\"forms_type\";s:3:\"all\";}s:8:\"schedule\";a:3:{s:9:\"frequency\";s:7:\"monthly\";s:8:\"monthDay\";s:1:\"4\";s:9:\"monthTime\";s:8:\"04:00 AM\";}s:13:\"report_status\";s:8:\"inactive\";s:10:\"recipients\";a:1:{i:0;a:5:{s:2:\"id\";i:1;s:4:\"name\";s:6:\"gestor\";s:5:\"email\";s:24:\"geral@aeabelheira.edu.pt\";s:4:\"role\";s:13:\"Administrator\";s:6:\"avatar\";s:81:\"https://secure.gravatar.com/avatar/bf35035017ca7511d6f36583b4203ad3?s=96&d=mm&r=g\";}}}", "inactive", "2025-01-11 17:27:45", "2025-01-11 17:27:45");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:33:{i:1743285705;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1743286856;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1743287400;a:1:{s:21:\"wdf_maybe_send_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:14:\"thirty_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1800;}}}i:1743288446;a:1:{s:26:\"wpdef_fetch_global_ip_list\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1743288456;a:1:{s:22:\"firewall_clean_up_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1743288656;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1743288658;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1743288753;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1743292061;a:1:{s:39:\"wpdef_firewall_send_compact_logs_to_api\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1743292800;a:1:{s:22:\"wdev_logger_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1743309995;a:1:{s:73:\"ColibriWP\\PageBuilder\\Notify\\NotificationsManager::getRemoteNotifications\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1743310282;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1743328256;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1743328363;a:1:{s:41:\"wpdef_firewall_whitelist_server_public_ip\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1743335246;a:2:{s:45:\"wpdef_firewall_fetch_trusted_proxy_preset_ips\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:27:\"wpdef_log_rotational_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1743338879;a:1:{s:22:\"wp_defender_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1743341671;a:1:{s:27:\"wphb_get_delay_js_exclusion\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1743345272;a:1:{s:15:\"wphb_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1743360232;a:1:{s:20:\"put_do_weekly_action\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1743367857;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1743367873;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1743367878;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1743367966;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1743371613;a:1:{s:19:\"wp_smush_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1743429600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1743454257;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1743594446;a:1:{s:21:\"wpdef_clear_scan_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1743594456;a:1:{s:31:\"wpdef_firewall_clean_up_lockout\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1743594466;a:1:{s:33:\"wpdef_firewall_clean_up_unlockout\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1743594506;a:1:{s:29:\"wpdef_smart_ip_detection_ping\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1743825884;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1747914446;a:1:{s:17:\"wpdef_sec_key_gen\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"sixty_days\";s:4:\"args\";a:0:{}s:8:\"interval\";i:5184000;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "http://localhost/site", "on");
INSERT INTO `wp_options` VALUES("3", "home", "http://localhost/site", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "Agrupamento de Escolas Abelheira", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "geral@aeabelheira.edu.pt", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "1", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "1", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "3", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "j \\d\\e F, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "G:i", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "j F, Y G:i", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/index.php/%year%/%monthnum%/%day%/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:138:{s:21:\"docs/page/([0-9]+)/?$\";s:24:\"index.php?post_type=docs\";s:40:\"docs/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?docs=$matches[1]&feed=$matches[2]&post_type=docs\";s:15:\"docs/([^/]+)/?$\";s:41:\"index.php?docs=$matches[1]&post_type=docs\";s:32:\"docs/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=docs&feed=$matches[1]\";s:17:\"index.php/docs/?$\";s:24:\"index.php?post_type=docs\";s:47:\"index.php/docs/feed/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=docs&feed=$matches[1]\";s:42:\"index.php/docs/(feed|rdf|rss|rss2|atom)/?$\";s:41:\"index.php?post_type=docs&feed=$matches[1]\";s:34:\"index.php/docs/page/([0-9]{1,})/?$\";s:42:\"index.php?post_type=docs&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:18:\"^entries/([^/]+)/?\";s:29:\"index.php?entries=$matches[1]\";s:42:\"archives/(\\d+)(?:/(\\d+))?/entries/(\\d+)/?$\";s:60:\"index.php?p=$matches[1]&page=$matches[2]&entries=$matches[3]\";s:38:\"(.?.+?)(?:/([0-9]+))?/entries/(\\d+)/?$\";s:67:\"index.php?pagename=$matches[1]&page=$matches[2]&entries=$matches[3]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/entries/(\\d+)/?$\";s:101:\"index.php?year=$matches[1]&monthnum=$matches[2]&name=$matches[3]&page=$matches[4]&entries=$matches[5]\";s:75:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/entries/(\\d+)/?$\";s:117:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]&entries=$matches[6]\";s:26:\"(.?.+?)/entries(/(.*))?/?$\";s:50:\"index.php?pagename=$matches[1]&entries=$matches[3]\";s:57:\"index.php/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:45:\"index.php/category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:54:\"index.php/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:49:\"index.php/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:30:\"index.php/tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:42:\"index.php/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:24:\"index.php/tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:55:\"index.php/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:50:\"index.php/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:31:\"index.php/type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:43:\"index.php/type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:25:\"index.php/type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"index.php/docs/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"index.php/docs/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"index.php/docs/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"index.php/docs/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"index.php/docs/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"index.php/docs/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"index.php/docs/([^/]+)/embed/?$\";s:37:\"index.php?docs=$matches[1]&embed=true\";s:35:\"index.php/docs/([^/]+)/trackback/?$\";s:31:\"index.php?docs=$matches[1]&tb=1\";s:55:\"index.php/docs/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?docs=$matches[1]&feed=$matches[2]\";s:50:\"index.php/docs/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?docs=$matches[1]&feed=$matches[2]\";s:43:\"index.php/docs/([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?docs=$matches[1]&paged=$matches[2]\";s:50:\"index.php/docs/([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?docs=$matches[1]&cpage=$matches[2]\";s:39:\"index.php/docs/([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?docs=$matches[1]&page=$matches[2]\";s:31:\"index.php/docs/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"index.php/docs/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"index.php/docs/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"index.php/docs/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"index.php/docs/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"index.php/docs/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"index.php/docs-category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?doc_category=$matches[1]&feed=$matches[2]\";s:59:\"index.php/docs-category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?doc_category=$matches[1]&feed=$matches[2]\";s:40:\"index.php/docs-category/([^/]+)/embed/?$\";s:45:\"index.php?doc_category=$matches[1]&embed=true\";s:52:\"index.php/docs-category/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?doc_category=$matches[1]&paged=$matches[2]\";s:34:\"index.php/docs-category/([^/]+)/?$\";s:34:\"index.php?doc_category=$matches[1]\";s:59:\"index.php/docs-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?doc_tag=$matches[1]&feed=$matches[2]\";s:54:\"index.php/docs-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?doc_tag=$matches[1]&feed=$matches[2]\";s:35:\"index.php/docs-tag/([^/]+)/embed/?$\";s:40:\"index.php?doc_tag=$matches[1]&embed=true\";s:47:\"index.php/docs-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?doc_tag=$matches[1]&paged=$matches[2]\";s:29:\"index.php/docs-tag/([^/]+)/?$\";s:29:\"index.php?doc_tag=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:42:\"index.php/feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:37:\"index.php/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:18:\"index.php/embed/?$\";s:21:\"index.php?&embed=true\";s:30:\"index.php/page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:37:\"index.php/comment-page-([0-9]{1,})/?$\";s:41:\"index.php?&page_id=2901&cpage=$matches[1]\";s:51:\"index.php/comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:46:\"index.php/comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:27:\"index.php/comments/embed/?$\";s:21:\"index.php?&embed=true\";s:54:\"index.php/search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:49:\"index.php/search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:30:\"index.php/search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:42:\"index.php/search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:24:\"index.php/search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:57:\"index.php/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:45:\"index.php/author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:79:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:55:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:49:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:66:\"index.php/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:42:\"index.php/([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:54:\"index.php/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:36:\"index.php/([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:53:\"index.php/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:48:\"index.php/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:29:\"index.php/([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:41:\"index.php/([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:23:\"index.php/([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:68:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:78:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:98:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:74:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:87:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:75:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:71:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:57:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:67:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:87:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:63:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:48:\"index.php/([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:37:\"index.php/.?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"index.php/.?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"index.php/.?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"index.php/.?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"index.php/(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:30:\"index.php/(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:50:\"index.php/(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:45:\"index.php/(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:38:\"index.php/(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:45:\"index.php/(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:34:\"index.php/(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:8:{i:0;s:25:\"betterdocs/betterdocs.php\";i:1;s:53:\"colibri-page-builder-pro/colibri-page-builder-pro.php\";i:2;s:45:\"colibri-page-builder/colibri-page-builder.php\";i:3;s:33:\"defender-security/wp-defender.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:25:\"forminator/forminator.php\";i:6;s:42:\"hummingbird-performance/wp-hummingbird.php\";i:7;s:23:\"wp-smushit/wp-smush.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "0", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "colibri-wp", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "skyline-wp", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "0", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:3:{i:1;a:0:{}i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "2902", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "2901", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "0", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1751662256", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:6:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:81:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"manage_forminator\";b:1;s:9:\"edit_docs\";b:1;s:16:\"edit_others_docs\";b:1;s:17:\"edit_private_docs\";b:1;s:19:\"edit_published_docs\";b:1;s:17:\"read_private_docs\";b:1;s:12:\"publish_docs\";b:1;s:11:\"delete_docs\";b:1;s:19:\"delete_private_docs\";b:1;s:21:\"delete_published_docs\";b:1;s:18:\"delete_others_docs\";b:1;s:16:\"manage_doc_terms\";b:1;s:14:\"edit_doc_terms\";b:1;s:16:\"delete_doc_terms\";b:1;s:27:\"manage_knowledge_base_terms\";b:1;s:25:\"edit_knowledge_base_terms\";b:1;s:27:\"delete_knowledge_base_terms\";b:1;s:18:\"edit_docs_settings\";b:1;s:19:\"read_docs_analytics\";b:1;s:16:\"read_faq_builder\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:50:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:9:\"edit_docs\";b:1;s:16:\"edit_others_docs\";b:1;s:17:\"edit_private_docs\";b:1;s:19:\"edit_published_docs\";b:1;s:17:\"read_private_docs\";b:1;s:12:\"publish_docs\";b:1;s:11:\"delete_docs\";b:1;s:19:\"delete_private_docs\";b:1;s:21:\"delete_published_docs\";b:1;s:18:\"delete_others_docs\";b:1;s:16:\"manage_doc_terms\";b:1;s:14:\"edit_doc_terms\";b:1;s:16:\"delete_doc_terms\";b:1;s:27:\"manage_knowledge_base_terms\";b:1;s:25:\"edit_knowledge_base_terms\";b:1;s:27:\"delete_knowledge_base_terms\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:15:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:9:\"edit_docs\";b:1;s:19:\"edit_published_docs\";b:1;s:12:\"publish_docs\";b:1;s:11:\"delete_docs\";b:1;s:21:\"delete_published_docs\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:7:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:9:\"edit_docs\";b:1;s:11:\"delete_docs\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:22:\"colibri_content_editor\";a:2:{s:4:\"name\";s:14:\"Content Editor\";s:12:\"capabilities\";a:36:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"edit_theme_options\";b:1;s:9:\"customize\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "WPLANG", "pt_PT", "auto");
INSERT INTO `wp_options` VALUES("105", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("106", "widget_block", "a:7:{i:2;a:1:{s:7:\"content\";s:60:\"<!-- wp:search {\"showLabel\":false,\"buttonUseIcon\":true} /-->\";}i:3;a:1:{s:7:\"content\";s:158:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Artigos recentes</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Comentários recentes</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:145:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Arquivo</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categorias</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;i:8;a:1:{s:7:\"content\";s:25:\"<!-- wp:latest-posts /-->\";}}", "on");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:14:{s:19:\"wp_inactive_widgets\";a:0:{}s:22:\"colibri-ecommerce-left\";a:0:{}s:17:\"colibri-sidebar-1\";a:9:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:8:\"search-1\";i:4;s:14:\"recent-posts-1\";i:5;s:17:\"recent-comments-1\";i:6;s:10:\"archives-1\";i:7;s:12:\"categories-2\";i:8;s:6:\"meta-1\";}s:28:\"colibri-header-widget-area-1\";a:0:{}s:28:\"colibri-header-widget-area-2\";a:0:{}s:28:\"colibri-header-widget-area-3\";a:0:{}s:29:\"colibri-content-widget-area-1\";a:1:{i:0;s:10:\"calendar-1\";}s:29:\"colibri-content-widget-area-2\";a:0:{}s:29:\"colibri-content-widget-area-3\";a:0:{}s:28:\"colibri-footer-widget-area-1\";a:5:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";i:2;s:10:\"nav_menu-1\";i:3;s:10:\"nav_menu-3\";i:4;s:10:\"nav_menu-5\";}s:28:\"colibri-footer-widget-area-2\";a:3:{i:0;s:10:\"nav_menu-2\";i:1;s:10:\"nav_menu-4\";i:2;s:10:\"nav_menu-6\";}s:28:\"colibri-footer-widget-area-3\";a:0:{}s:28:\"colibri-footer-widget-area-4\";a:0:{}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_calendar", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_archives", "a:2:{i:1;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_meta", "a:2:{i:1;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_search", "a:2:{i:1;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-posts", "a:2:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_recent-comments", "a:2:{i:1;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_nav_menu", "a:7:{i:1;a:2:{s:5:\"title\";s:13:\"usefull links\";s:8:\"nav_menu\";s:1:\"5\";}i:2;a:2:{s:5:\"title\";s:4:\"menu\";s:8:\"nav_menu\";s:1:\"6\";}i:3;a:2:{s:5:\"title\";s:13:\"usefull links\";s:8:\"nav_menu\";i:7;}i:4;a:2:{s:5:\"title\";s:4:\"menu\";s:8:\"nav_menu\";i:8;}i:5;a:2:{s:5:\"title\";s:13:\"usefull links\";s:8:\"nav_menu\";i:9;}i:6;a:2:{s:5:\"title\";s:4:\"menu\";s:8:\"nav_menu\";i:10;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("122", "_transient_wp_core_block_css_files", "a:2:{s:7:\"version\";s:5:\"6.7.1\";s:5:\"files\";a:540:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:27:\"post-content/editor-rtl.css\";i:309;s:31:\"post-content/editor-rtl.min.css\";i:310;s:23:\"post-content/editor.css\";i:311;s:27:\"post-content/editor.min.css\";i:312;s:26:\"post-content/style-rtl.css\";i:313;s:30:\"post-content/style-rtl.min.css\";i:314;s:22:\"post-content/style.css\";i:315;s:26:\"post-content/style.min.css\";i:316;s:23:\"post-date/style-rtl.css\";i:317;s:27:\"post-date/style-rtl.min.css\";i:318;s:19:\"post-date/style.css\";i:319;s:23:\"post-date/style.min.css\";i:320;s:27:\"post-excerpt/editor-rtl.css\";i:321;s:31:\"post-excerpt/editor-rtl.min.css\";i:322;s:23:\"post-excerpt/editor.css\";i:323;s:27:\"post-excerpt/editor.min.css\";i:324;s:26:\"post-excerpt/style-rtl.css\";i:325;s:30:\"post-excerpt/style-rtl.min.css\";i:326;s:22:\"post-excerpt/style.css\";i:327;s:26:\"post-excerpt/style.min.css\";i:328;s:34:\"post-featured-image/editor-rtl.css\";i:329;s:38:\"post-featured-image/editor-rtl.min.css\";i:330;s:30:\"post-featured-image/editor.css\";i:331;s:34:\"post-featured-image/editor.min.css\";i:332;s:33:\"post-featured-image/style-rtl.css\";i:333;s:37:\"post-featured-image/style-rtl.min.css\";i:334;s:29:\"post-featured-image/style.css\";i:335;s:33:\"post-featured-image/style.min.css\";i:336;s:34:\"post-navigation-link/style-rtl.css\";i:337;s:38:\"post-navigation-link/style-rtl.min.css\";i:338;s:30:\"post-navigation-link/style.css\";i:339;s:34:\"post-navigation-link/style.min.css\";i:340;s:28:\"post-template/editor-rtl.css\";i:341;s:32:\"post-template/editor-rtl.min.css\";i:342;s:24:\"post-template/editor.css\";i:343;s:28:\"post-template/editor.min.css\";i:344;s:27:\"post-template/style-rtl.css\";i:345;s:31:\"post-template/style-rtl.min.css\";i:346;s:23:\"post-template/style.css\";i:347;s:27:\"post-template/style.min.css\";i:348;s:24:\"post-terms/style-rtl.css\";i:349;s:28:\"post-terms/style-rtl.min.css\";i:350;s:20:\"post-terms/style.css\";i:351;s:24:\"post-terms/style.min.css\";i:352;s:24:\"post-title/style-rtl.css\";i:353;s:28:\"post-title/style-rtl.min.css\";i:354;s:20:\"post-title/style.css\";i:355;s:24:\"post-title/style.min.css\";i:356;s:26:\"preformatted/style-rtl.css\";i:357;s:30:\"preformatted/style-rtl.min.css\";i:358;s:22:\"preformatted/style.css\";i:359;s:26:\"preformatted/style.min.css\";i:360;s:24:\"pullquote/editor-rtl.css\";i:361;s:28:\"pullquote/editor-rtl.min.css\";i:362;s:20:\"pullquote/editor.css\";i:363;s:24:\"pullquote/editor.min.css\";i:364;s:23:\"pullquote/style-rtl.css\";i:365;s:27:\"pullquote/style-rtl.min.css\";i:366;s:19:\"pullquote/style.css\";i:367;s:23:\"pullquote/style.min.css\";i:368;s:23:\"pullquote/theme-rtl.css\";i:369;s:27:\"pullquote/theme-rtl.min.css\";i:370;s:19:\"pullquote/theme.css\";i:371;s:23:\"pullquote/theme.min.css\";i:372;s:39:\"query-pagination-numbers/editor-rtl.css\";i:373;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:374;s:35:\"query-pagination-numbers/editor.css\";i:375;s:39:\"query-pagination-numbers/editor.min.css\";i:376;s:31:\"query-pagination/editor-rtl.css\";i:377;s:35:\"query-pagination/editor-rtl.min.css\";i:378;s:27:\"query-pagination/editor.css\";i:379;s:31:\"query-pagination/editor.min.css\";i:380;s:30:\"query-pagination/style-rtl.css\";i:381;s:34:\"query-pagination/style-rtl.min.css\";i:382;s:26:\"query-pagination/style.css\";i:383;s:30:\"query-pagination/style.min.css\";i:384;s:25:\"query-title/style-rtl.css\";i:385;s:29:\"query-title/style-rtl.min.css\";i:386;s:21:\"query-title/style.css\";i:387;s:25:\"query-title/style.min.css\";i:388;s:20:\"query/editor-rtl.css\";i:389;s:24:\"query/editor-rtl.min.css\";i:390;s:16:\"query/editor.css\";i:391;s:20:\"query/editor.min.css\";i:392;s:19:\"quote/style-rtl.css\";i:393;s:23:\"quote/style-rtl.min.css\";i:394;s:15:\"quote/style.css\";i:395;s:19:\"quote/style.min.css\";i:396;s:19:\"quote/theme-rtl.css\";i:397;s:23:\"quote/theme-rtl.min.css\";i:398;s:15:\"quote/theme.css\";i:399;s:19:\"quote/theme.min.css\";i:400;s:23:\"read-more/style-rtl.css\";i:401;s:27:\"read-more/style-rtl.min.css\";i:402;s:19:\"read-more/style.css\";i:403;s:23:\"read-more/style.min.css\";i:404;s:18:\"rss/editor-rtl.css\";i:405;s:22:\"rss/editor-rtl.min.css\";i:406;s:14:\"rss/editor.css\";i:407;s:18:\"rss/editor.min.css\";i:408;s:17:\"rss/style-rtl.css\";i:409;s:21:\"rss/style-rtl.min.css\";i:410;s:13:\"rss/style.css\";i:411;s:17:\"rss/style.min.css\";i:412;s:21:\"search/editor-rtl.css\";i:413;s:25:\"search/editor-rtl.min.css\";i:414;s:17:\"search/editor.css\";i:415;s:21:\"search/editor.min.css\";i:416;s:20:\"search/style-rtl.css\";i:417;s:24:\"search/style-rtl.min.css\";i:418;s:16:\"search/style.css\";i:419;s:20:\"search/style.min.css\";i:420;s:20:\"search/theme-rtl.css\";i:421;s:24:\"search/theme-rtl.min.css\";i:422;s:16:\"search/theme.css\";i:423;s:20:\"search/theme.min.css\";i:424;s:24:\"separator/editor-rtl.css\";i:425;s:28:\"separator/editor-rtl.min.css\";i:426;s:20:\"separator/editor.css\";i:427;s:24:\"separator/editor.min.css\";i:428;s:23:\"separator/style-rtl.css\";i:429;s:27:\"separator/style-rtl.min.css\";i:430;s:19:\"separator/style.css\";i:431;s:23:\"separator/style.min.css\";i:432;s:23:\"separator/theme-rtl.css\";i:433;s:27:\"separator/theme-rtl.min.css\";i:434;s:19:\"separator/theme.css\";i:435;s:23:\"separator/theme.min.css\";i:436;s:24:\"shortcode/editor-rtl.css\";i:437;s:28:\"shortcode/editor-rtl.min.css\";i:438;s:20:\"shortcode/editor.css\";i:439;s:24:\"shortcode/editor.min.css\";i:440;s:24:\"site-logo/editor-rtl.css\";i:441;s:28:\"site-logo/editor-rtl.min.css\";i:442;s:20:\"site-logo/editor.css\";i:443;s:24:\"site-logo/editor.min.css\";i:444;s:23:\"site-logo/style-rtl.css\";i:445;s:27:\"site-logo/style-rtl.min.css\";i:446;s:19:\"site-logo/style.css\";i:447;s:23:\"site-logo/style.min.css\";i:448;s:27:\"site-tagline/editor-rtl.css\";i:449;s:31:\"site-tagline/editor-rtl.min.css\";i:450;s:23:\"site-tagline/editor.css\";i:451;s:27:\"site-tagline/editor.min.css\";i:452;s:26:\"site-tagline/style-rtl.css\";i:453;s:30:\"site-tagline/style-rtl.min.css\";i:454;s:22:\"site-tagline/style.css\";i:455;s:26:\"site-tagline/style.min.css\";i:456;s:25:\"site-title/editor-rtl.css\";i:457;s:29:\"site-title/editor-rtl.min.css\";i:458;s:21:\"site-title/editor.css\";i:459;s:25:\"site-title/editor.min.css\";i:460;s:24:\"site-title/style-rtl.css\";i:461;s:28:\"site-title/style-rtl.min.css\";i:462;s:20:\"site-title/style.css\";i:463;s:24:\"site-title/style.min.css\";i:464;s:26:\"social-link/editor-rtl.css\";i:465;s:30:\"social-link/editor-rtl.min.css\";i:466;s:22:\"social-link/editor.css\";i:467;s:26:\"social-link/editor.min.css\";i:468;s:27:\"social-links/editor-rtl.css\";i:469;s:31:\"social-links/editor-rtl.min.css\";i:470;s:23:\"social-links/editor.css\";i:471;s:27:\"social-links/editor.min.css\";i:472;s:26:\"social-links/style-rtl.css\";i:473;s:30:\"social-links/style-rtl.min.css\";i:474;s:22:\"social-links/style.css\";i:475;s:26:\"social-links/style.min.css\";i:476;s:21:\"spacer/editor-rtl.css\";i:477;s:25:\"spacer/editor-rtl.min.css\";i:478;s:17:\"spacer/editor.css\";i:479;s:21:\"spacer/editor.min.css\";i:480;s:20:\"spacer/style-rtl.css\";i:481;s:24:\"spacer/style-rtl.min.css\";i:482;s:16:\"spacer/style.css\";i:483;s:20:\"spacer/style.min.css\";i:484;s:20:\"table/editor-rtl.css\";i:485;s:24:\"table/editor-rtl.min.css\";i:486;s:16:\"table/editor.css\";i:487;s:20:\"table/editor.min.css\";i:488;s:19:\"table/style-rtl.css\";i:489;s:23:\"table/style-rtl.min.css\";i:490;s:15:\"table/style.css\";i:491;s:19:\"table/style.min.css\";i:492;s:19:\"table/theme-rtl.css\";i:493;s:23:\"table/theme-rtl.min.css\";i:494;s:15:\"table/theme.css\";i:495;s:19:\"table/theme.min.css\";i:496;s:24:\"tag-cloud/editor-rtl.css\";i:497;s:28:\"tag-cloud/editor-rtl.min.css\";i:498;s:20:\"tag-cloud/editor.css\";i:499;s:24:\"tag-cloud/editor.min.css\";i:500;s:23:\"tag-cloud/style-rtl.css\";i:501;s:27:\"tag-cloud/style-rtl.min.css\";i:502;s:19:\"tag-cloud/style.css\";i:503;s:23:\"tag-cloud/style.min.css\";i:504;s:28:\"template-part/editor-rtl.css\";i:505;s:32:\"template-part/editor-rtl.min.css\";i:506;s:24:\"template-part/editor.css\";i:507;s:28:\"template-part/editor.min.css\";i:508;s:27:\"template-part/theme-rtl.css\";i:509;s:31:\"template-part/theme-rtl.min.css\";i:510;s:23:\"template-part/theme.css\";i:511;s:27:\"template-part/theme.min.css\";i:512;s:30:\"term-description/style-rtl.css\";i:513;s:34:\"term-description/style-rtl.min.css\";i:514;s:26:\"term-description/style.css\";i:515;s:30:\"term-description/style.min.css\";i:516;s:27:\"text-columns/editor-rtl.css\";i:517;s:31:\"text-columns/editor-rtl.min.css\";i:518;s:23:\"text-columns/editor.css\";i:519;s:27:\"text-columns/editor.min.css\";i:520;s:26:\"text-columns/style-rtl.css\";i:521;s:30:\"text-columns/style-rtl.min.css\";i:522;s:22:\"text-columns/style.css\";i:523;s:26:\"text-columns/style.min.css\";i:524;s:19:\"verse/style-rtl.css\";i:525;s:23:\"verse/style-rtl.min.css\";i:526;s:15:\"verse/style.css\";i:527;s:19:\"verse/style.min.css\";i:528;s:20:\"video/editor-rtl.css\";i:529;s:24:\"video/editor-rtl.min.css\";i:530;s:16:\"video/editor.css\";i:531;s:20:\"video/editor.min.css\";i:532;s:19:\"video/style-rtl.css\";i:533;s:23:\"video/style-rtl.min.css\";i:534;s:15:\"video/style.css\";i:535;s:19:\"video/style.min.css\";i:536;s:19:\"video/theme-rtl.css\";i:537;s:23:\"video/theme-rtl.min.css\";i:538;s:15:\"video/theme.css\";i:539;s:19:\"video/theme.min.css\";}}", "on");
INSERT INTO `wp_options` VALUES("128", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("129", "theme_mods_twentytwentyfive", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1736613992;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("130", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"5ec2d6793a3d3b524444171cbbbbac09\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("148", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("161", "finished_updating_comment_type", "1", "auto");
INSERT INTO `wp_options` VALUES("162", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("172", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("186", "https_detection_errors", "a:1:{s:23:\"ssl_verification_failed\";a:1:{i:0;s:30:\"A verificação de SSL falhou.\";}}", "auto");
INSERT INTO `wp_options` VALUES("187", "_transient_health-check-site-status-result", "{\"good\":14,\"recommended\":6,\"critical\":3}", "on");
INSERT INTO `wp_options` VALUES("198", "current_theme", "Skyline WP", "auto");
INSERT INTO `wp_options` VALUES("199", "theme_mods_skyline-wp", "a:30:{i:0;b:0;s:18:\"nav_menu_locations\";a:3:{s:11:\"header-menu\";i:13;s:12:\"content-menu\";i:9;s:13:\"header-menu-1\";i:12;}s:18:\"custom_css_post_id\";i:-1;s:12:\"page_content\";a:0:{}s:11:\"custom_logo\";i:80;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1589285539;s:4:\"data\";a:14:{s:19:\"wp_inactive_widgets\";a:0:{}s:21:\"colibri-sidebar-pages\";a:0:{}s:17:\"colibri-sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:28:\"colibri-header-widget-area-1\";a:0:{}s:28:\"colibri-header-widget-area-2\";a:0:{}s:28:\"colibri-header-widget-area-3\";a:0:{}s:29:\"colibri-content-widget-area-1\";a:1:{i:0;s:10:\"calendar-3\";}s:29:\"colibri-content-widget-area-2\";a:0:{}s:29:\"colibri-content-widget-area-3\";a:0:{}s:28:\"colibri-footer-widget-area-1\";a:1:{i:0;s:10:\"nav_menu-3\";}s:28:\"colibri-footer-widget-area-2\";a:1:{i:0;s:10:\"nav_menu-4\";}s:28:\"colibri-footer-widget-area-3\";a:0:{}s:28:\"colibri-footer-widget-area-4\";a:0:{}s:22:\"colibri-ecommerce-left\";a:0:{}}}s:21:\"modal_wrapper_padding\";s:53:\"{\"input1\":\"0\",\"input2\":\"0\",\"input3\":\"0\",\"input4\":\"0\"}\";s:20:\"modal_wrapper_margin\";s:53:\"{\"input1\":\"0\",\"input2\":\"0\",\"input3\":\"0\",\"input4\":\"0\"}\";s:26:\"search_field_modal_padding\";s:53:\"{\"input1\":\"5\",\"input2\":\"5\",\"input3\":\"5\",\"input4\":\"5\"}\";s:25:\"search_field_modal_margin\";s:53:\"{\"input1\":\"0\",\"input2\":\"0\",\"input3\":\"0\",\"input4\":\"0\"}\";s:32:\"search_modal_content_tabs_margin\";s:53:\"{\"input1\":\"0\",\"input2\":\"0\",\"input3\":\"0\",\"input4\":\"0\"}\";s:33:\"search_modal_content_tabs_padding\";s:55:\"{\"input1\":\"0\",\"input2\":\"28\",\"input3\":\"0\",\"input4\":\"28\"}\";s:32:\"search_modal_content_tabs_border\";s:53:\"{\"input1\":\"0\",\"input2\":\"0\",\"input3\":\"1\",\"input4\":\"0\"}\";s:43:\"search_modal_content_tabs_docs_list_padding\";s:57:\"{\"input1\":\"16\",\"input2\":\"24\",\"input3\":\"16\",\"input4\":\"24\"}\";s:42:\"search_modal_content_tabs_docs_list_margin\";s:53:\"{\"input1\":\"0\",\"input2\":\"0\",\"input3\":\"0\",\"input4\":\"0\"}\";s:27:\"betterdocs_faq_title_margin\";s:53:\"{\"input1\":\"0\",\"input2\":\"0\",\"input3\":\"0\",\"input4\":\"0\"}\";s:36:\"betterdocs_faq_category_name_padding\";s:57:\"{\"input1\":\"20\",\"input2\":\"20\",\"input3\":\"20\",\"input4\":\"20\"}\";s:27:\"betterdocs_faq_list_padding\";s:57:\"{\"input1\":\"20\",\"input2\":\"20\",\"input3\":\"20\",\"input4\":\"20\"}\";s:45:\"betterdocs_faq_category_name_padding_layout_2\";s:57:\"{\"input1\":\"20\",\"input2\":\"20\",\"input3\":\"20\",\"input4\":\"20\"}\";s:36:\"betterdocs_faq_list_padding_layout_2\";s:57:\"{\"input1\":\"20\",\"input2\":\"20\",\"input3\":\"20\",\"input4\":\"20\"}\";s:45:\"betterdocs_faq_category_name_padding_layout_3\";s:57:\"{\"input1\":\"20\",\"input2\":\"20\",\"input3\":\"20\",\"input4\":\"20\"}\";s:36:\"betterdocs_faq_list_padding_layout_3\";s:57:\"{\"input1\":\"24\",\"input2\":\"14\",\"input3\":\"24\",\"input4\":\"14\"}\";s:45:\"betterdocs_faq_category_name_padding_layout_4\";s:57:\"{\"input1\":\"20\",\"input2\":\"20\",\"input3\":\"20\",\"input4\":\"20\"}\";s:36:\"betterdocs_faq_list_padding_layout_4\";s:57:\"{\"input1\":\"24\",\"input2\":\"14\",\"input3\":\"24\",\"input4\":\"14\"}\";s:31:\"betterdocs_search_layout_select\";s:8:\"layout-1\";s:37:\"betterdocs_live_search_heading_switch\";b:0;s:29:\"betterdocs_docs_layout_select\";s:8:\"layout-1\";s:31:\"betterdocs_single_layout_select\";s:8:\"layout-1\";s:32:\"betterdocs_archive_layout_select\";s:8:\"layout-1\";s:30:\"betterdocs_select_faq_template\";s:8:\"layout-1\";}", "on");
INSERT INTO `wp_options` VALUES("200", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("201", "cp_initialize_notifications", "1736613995", "auto");
INSERT INTO `wp_options` VALUES("202", "colibri_page_builder_demo_sites", "a:2:{s:9:\"timestamp\";i:1743285147;s:4:\"data\";a:99:{i:0;a:11:{s:16:\"import_file_name\";s:10:\"Business I\";s:4:\"slug\";s:8:\"business\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business/content.xml\";s:22:\"import_widget_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business/widgets.wie\";s:26:\"import_customizer_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business/customizer.dat\";s:24:\"import_preview_image_url\";s:90:\"https://static.colibriwp.com/templates-screenshots/colibri_default_business/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/business-i/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:04.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:0;}i:1;a:11:{s:16:\"import_file_name\";s:11:\"Business II\";s:4:\"slug\";s:11:\"business-ii\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-ii/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/business-ii/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/business-ii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:06.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:0;}i:2;a:11:{s:16:\"import_file_name\";s:7:\"Plumber\";s:4:\"slug\";s:7:\"plumber\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/plumber/content.xml\";s:22:\"import_widget_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/plumber/widgets.wie\";s:26:\"import_customizer_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/plumber/customizer.dat\";s:24:\"import_preview_image_url\";s:73:\"https://static.colibriwp.com/templates-screenshots/plumber/screenshot.jpg\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/plumber/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:07.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:0;}i:3;a:11:{s:16:\"import_file_name\";s:17:\"Creative Agency I\";s:4:\"slug\";s:11:\"advertising\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/advertising/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/advertising/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/advertising/customizer.dat\";s:24:\"import_preview_image_url\";s:97:\"https://static.colibriwp.com/templates-screenshots/colibri_default_creative_agency/screenshot.png\";s:11:\"preview_url\";s:55:\"https://colibriwp-work.colibriwp.com/creative-agency-i/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:09.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:4;a:11:{s:16:\"import_file_name\";s:3:\"SEO\";s:4:\"slug\";s:3:\"seo\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:80:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/seo/content.xml\";s:22:\"import_widget_file_url\";s:80:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/seo/widgets.wie\";s:26:\"import_customizer_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/seo/customizer.dat\";s:24:\"import_preview_image_url\";s:85:\"https://static.colibriwp.com/templates-screenshots/colibri_default_seo/screenshot.png\";s:11:\"preview_url\";s:46:\"https://colibriwp-work.colibriwp.com/seo-demo/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:11.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:5;a:11:{s:16:\"import_file_name\";s:11:\"IT Services\";s:4:\"slug\";s:11:\"it-services\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/it-services/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/it-services/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/it-services/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/it-services/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/it-services\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:13.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:6;a:11:{s:16:\"import_file_name\";s:20:\"Designer Portfolio I\";s:4:\"slug\";s:20:\"designer-portfolio-i\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-i/content.xml\";s:22:\"import_widget_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-i/widgets.wie\";s:26:\"import_customizer_file_url\";s:100:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-i/customizer.dat\";s:24:\"import_preview_image_url\";s:86:\"https://static.colibriwp.com/templates-screenshots/designer-portfolio-i/screenshot.png\";s:11:\"preview_url\";s:57:\"https://colibriwp-work.colibriwp.com/designer-portfolio-i\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:12.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:7;a:11:{s:16:\"import_file_name\";s:21:\"Designer Portfolio II\";s:4:\"slug\";s:21:\"designer-portfolio-ii\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:98:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-ii/content.xml\";s:22:\"import_widget_file_url\";s:98:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:101:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:87:\"https://static.colibriwp.com/templates-screenshots/designer-portfolio-ii/screenshot.png\";s:11:\"preview_url\";s:58:\"https://colibriwp-work.colibriwp.com/designer-portfolio-ii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:16.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:8;a:11:{s:16:\"import_file_name\";s:12:\"Business III\";s:4:\"slug\";s:12:\"business-iii\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-iii/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-iii/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-iii/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/business-iii/screenshot.png\";s:11:\"preview_url\";s:49:\"https://colibriwp-work.colibriwp.com/business-iii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:17.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:9;a:11:{s:16:\"import_file_name\";s:10:\"Restaurant\";s:4:\"slug\";s:10:\"restaurant\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/restaurant/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/restaurant/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/restaurant/customizer.dat\";s:24:\"import_preview_image_url\";s:92:\"https://static.colibriwp.com/templates-screenshots/colibri_default_restaurant/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/restaurant/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:19.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:10;a:11:{s:16:\"import_file_name\";s:10:\"Vineyard I\";s:4:\"slug\";s:8:\"vineyard\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/vineyard/content.xml\";s:22:\"import_widget_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/vineyard/widgets.wie\";s:26:\"import_customizer_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/vineyard/customizer.dat\";s:24:\"import_preview_image_url\";s:74:\"https://static.colibriwp.com/templates-screenshots/vineyard/screenshot.png\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/vineyard-i\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:22.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:11;a:11:{s:16:\"import_file_name\";s:11:\"Vineyard II\";s:4:\"slug\";s:11:\"vineyard-ii\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/vineyard-ii/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/vineyard-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/vineyard-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/vineyard-ii/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/vineyard-ii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:01:39.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:12;a:11:{s:16:\"import_file_name\";s:9:\"My Resume\";s:4:\"slug\";s:9:\"my-resume\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/my-resume/content.xml\";s:22:\"import_widget_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/my-resume/widgets.wie\";s:26:\"import_customizer_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/my-resume/customizer.dat\";s:24:\"import_preview_image_url\";s:91:\"https://static.colibriwp.com/templates-screenshots/colibri_default_my-resume/screenshot.png\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/my-resume/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:24.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:13;a:11:{s:16:\"import_file_name\";s:7:\"Lawyers\";s:4:\"slug\";s:7:\"lawyers\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/lawyers/content.xml\";s:22:\"import_widget_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/lawyers/widgets.wie\";s:26:\"import_customizer_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/lawyers/customizer.dat\";s:24:\"import_preview_image_url\";s:73:\"https://static.colibriwp.com/templates-screenshots/lawyers/screenshot.png\";s:11:\"preview_url\";s:44:\"https://colibriwp-work.colibriwp.com/lawyers\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:24.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:14;a:11:{s:16:\"import_file_name\";s:10:\"Conference\";s:4:\"slug\";s:10:\"conference\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/conference/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/conference/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/conference/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/conference/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/conference\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:11.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:15;a:11:{s:16:\"import_file_name\";s:17:\"Wedding Planner I\";s:4:\"slug\";s:17:\"wedding-planner-i\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/wedding-planner-i/content.xml\";s:22:\"import_widget_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/wedding-planner-i/widgets.wie\";s:26:\"import_customizer_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/wedding-planner-i/customizer.dat\";s:24:\"import_preview_image_url\";s:83:\"https://static.colibriwp.com/templates-screenshots/wedding-planner-i/screenshot.jpg\";s:11:\"preview_url\";s:54:\"https://colibriwp-work.colibriwp.com/wedding-planner-i\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:12.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:16;a:11:{s:16:\"import_file_name\";s:18:\"Wedding Planner II\";s:4:\"slug\";s:18:\"wedding-planner-ii\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/wedding-planner-ii/content.xml\";s:22:\"import_widget_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/wedding-planner-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:98:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/wedding-planner-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:84:\"https://static.colibriwp.com/templates-screenshots/wedding-planner-ii/screenshot.png\";s:11:\"preview_url\";s:55:\"https://colibriwp-work.colibriwp.com/wedding-planner-ii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:27.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:17;a:11:{s:16:\"import_file_name\";s:12:\"Architecture\";s:4:\"slug\";s:12:\"architecture\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/architecture/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/architecture/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/architecture/customizer.dat\";s:24:\"import_preview_image_url\";s:94:\"https://static.colibriwp.com/templates-screenshots/colibri_default_architecture/screenshot.png\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/architecture/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:27.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:18;a:11:{s:16:\"import_file_name\";s:6:\"Barber\";s:4:\"slug\";s:6:\"barber\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/barber/content.xml\";s:22:\"import_widget_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/barber/widgets.wie\";s:26:\"import_customizer_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/barber/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/template-21/screenshot.jpg\";s:11:\"preview_url\";s:43:\"https://colibriwp-work.colibriwp.com/barber\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-03-22 09:05:40.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:19;a:11:{s:16:\"import_file_name\";s:8:\"Coffee I\";s:4:\"slug\";s:8:\"coffee-i\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coffee-i/content.xml\";s:22:\"import_widget_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coffee-i/widgets.wie\";s:26:\"import_customizer_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coffee-i/customizer.dat\";s:24:\"import_preview_image_url\";s:74:\"https://static.colibriwp.com/templates-screenshots/coffee-i/screenshot.png\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/coffee-i\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:18.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:20;a:11:{s:16:\"import_file_name\";s:9:\"Coffee II\";s:4:\"slug\";s:9:\"coffee-ii\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coffee-ii/content.xml\";s:22:\"import_widget_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coffee-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coffee-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:75:\"https://static.colibriwp.com/templates-screenshots/coffee-ii/screenshot.png\";s:11:\"preview_url\";s:46:\"https://colibriwp-work.colibriwp.com/coffee-ii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:20.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:21;a:11:{s:16:\"import_file_name\";s:15:\"Interior Design\";s:4:\"slug\";s:15:\"interior-design\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/interior-design/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/interior-design/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/interior-design/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/interior-design/screenshot.png\";s:11:\"preview_url\";s:52:\"https://colibriwp-work.colibriwp.com/interior-design\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:33.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:22;a:11:{s:16:\"import_file_name\";s:4:\"Yoga\";s:4:\"slug\";s:4:\"yoga\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:81:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/yoga/content.xml\";s:22:\"import_widget_file_url\";s:81:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/yoga/widgets.wie\";s:26:\"import_customizer_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/yoga/customizer.dat\";s:24:\"import_preview_image_url\";s:70:\"https://static.colibriwp.com/templates-screenshots/yoga/screenshot.png\";s:11:\"preview_url\";s:41:\"https://colibriwp-work.colibriwp.com/yoga\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:32.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:23;a:11:{s:16:\"import_file_name\";s:13:\"Constructions\";s:4:\"slug\";s:13:\"constructions\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/constructions/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/constructions/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/constructions/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/constructions/screenshot.png\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/constructions\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:35.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:24;a:11:{s:16:\"import_file_name\";s:11:\"Pets Clinic\";s:4:\"slug\";s:11:\"pets-clinic\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pets-clinic/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pets-clinic/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pets-clinic/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/pets-clinic/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/pets-clinic\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:37.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:25;a:11:{s:16:\"import_file_name\";s:10:\"Ski Resort\";s:4:\"slug\";s:10:\"ski-resort\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/ski-resort/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/ski-resort/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/ski-resort/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/ski-resort/screenshot.png\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/ski-resort\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:39.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:26;a:11:{s:16:\"import_file_name\";s:18:\"Creative Agency II\";s:4:\"slug\";s:18:\"creative-agency-ii\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/creative-agency-ii/content.xml\";s:22:\"import_widget_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/creative-agency-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:98:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/creative-agency-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:84:\"https://static.colibriwp.com/templates-screenshots/creative-agency-ii/screenshot.png\";s:11:\"preview_url\";s:55:\"https://colibriwp-work.colibriwp.com/creative-agency-ii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:39.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:27;a:11:{s:16:\"import_file_name\";s:5:\"Sushi\";s:4:\"slug\";s:5:\"sushi\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:82:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/sushi/content.xml\";s:22:\"import_widget_file_url\";s:82:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/sushi/widgets.wie\";s:26:\"import_customizer_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/sushi/customizer.dat\";s:24:\"import_preview_image_url\";s:71:\"https://static.colibriwp.com/templates-screenshots/sushi/screenshot.png\";s:11:\"preview_url\";s:42:\"https://colibriwp-work.colibriwp.com/sushi\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:44:42.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:28;a:11:{s:16:\"import_file_name\";s:22:\"Designer Portfolio III\";s:4:\"slug\";s:22:\"designer-portfolio-iii\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-iii/content.xml\";s:22:\"import_widget_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-iii/widgets.wie\";s:26:\"import_customizer_file_url\";s:102:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-portfolio-iii/customizer.dat\";s:24:\"import_preview_image_url\";s:88:\"https://static.colibriwp.com/templates-screenshots/designer-portfolio-iii/screenshot.png\";s:11:\"preview_url\";s:59:\"https://colibriwp-work.colibriwp.com/designer-portfolio-iii\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:44.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:29;a:11:{s:16:\"import_file_name\";s:3:\"Gym\";s:4:\"slug\";s:3:\"gym\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:80:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/gym/content.xml\";s:22:\"import_widget_file_url\";s:80:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/gym/widgets.wie\";s:26:\"import_customizer_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/gym/customizer.dat\";s:24:\"import_preview_image_url\";s:85:\"https://static.colibriwp.com/templates-screenshots/colibri_default_gym/screenshot.png\";s:11:\"preview_url\";s:46:\"https://colibriwp-work.colibriwp.com/gym-demo/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-02 14:51:46.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:30;a:11:{s:16:\"import_file_name\";s:9:\"Religious\";s:4:\"slug\";s:9:\"religious\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/religious/content.xml\";s:22:\"import_widget_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/religious/widgets.wie\";s:26:\"import_customizer_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/religious/customizer.dat\";s:24:\"import_preview_image_url\";s:75:\"https://static.colibriwp.com/templates-screenshots/religious/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/religious/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:34.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:31;a:11:{s:16:\"import_file_name\";s:14:\"Medical Clinic\";s:4:\"slug\";s:17:\"medical-clinic-ii\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/medical-clinic-ii/content.xml\";s:22:\"import_widget_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/medical-clinic-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/medical-clinic-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:83:\"https://static.colibriwp.com/templates-screenshots/medical-clinic-ii/screenshot.png\";s:11:\"preview_url\";s:55:\"https://colibriwp-work.colibriwp.com/medical-clinic-ii/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:36.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:32;a:11:{s:16:\"import_file_name\";s:5:\"Detox\";s:4:\"slug\";s:5:\"detox\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:82:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/detox/content.xml\";s:22:\"import_widget_file_url\";s:82:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/detox/widgets.wie\";s:26:\"import_customizer_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/detox/customizer.dat\";s:24:\"import_preview_image_url\";s:71:\"https://static.colibriwp.com/templates-screenshots/detox/screenshot.png\";s:11:\"preview_url\";s:43:\"https://colibriwp-work.colibriwp.com/detox/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:37.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:33;a:11:{s:16:\"import_file_name\";s:6:\"School\";s:4:\"slug\";s:6:\"school\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/school/content.xml\";s:22:\"import_widget_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/school/widgets.wie\";s:26:\"import_customizer_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/school/customizer.dat\";s:24:\"import_preview_image_url\";s:72:\"https://static.colibriwp.com/templates-screenshots/school/screenshot.png\";s:11:\"preview_url\";s:44:\"https://colibriwp-work.colibriwp.com/school/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:39.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:34;a:11:{s:16:\"import_file_name\";s:6:\"Movers\";s:4:\"slug\";s:6:\"movers\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/movers/content.xml\";s:22:\"import_widget_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/movers/widgets.wie\";s:26:\"import_customizer_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/movers/customizer.dat\";s:24:\"import_preview_image_url\";s:72:\"https://static.colibriwp.com/templates-screenshots/movers/screenshot.png\";s:11:\"preview_url\";s:44:\"https://colibriwp-work.colibriwp.com/movers/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:40.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:35;a:11:{s:16:\"import_file_name\";s:8:\"Aquarium\";s:4:\"slug\";s:8:\"aquarium\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/aquarium/content.xml\";s:22:\"import_widget_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/aquarium/widgets.wie\";s:26:\"import_customizer_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/aquarium/customizer.dat\";s:24:\"import_preview_image_url\";s:74:\"https://static.colibriwp.com/templates-screenshots/aquarium/screenshot.png\";s:11:\"preview_url\";s:46:\"https://colibriwp-work.colibriwp.com/aquarium/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:42.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:36;a:11:{s:16:\"import_file_name\";s:4:\"Auto\";s:4:\"slug\";s:4:\"auto\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:81:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/auto/content.xml\";s:22:\"import_widget_file_url\";s:81:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/auto/widgets.wie\";s:26:\"import_customizer_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/auto/customizer.dat\";s:24:\"import_preview_image_url\";s:70:\"https://static.colibriwp.com/templates-screenshots/auto/screenshot.png\";s:11:\"preview_url\";s:42:\"https://colibriwp-work.colibriwp.com/auto/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:44.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:37;a:11:{s:16:\"import_file_name\";s:10:\"Business V\";s:4:\"slug\";s:10:\"business-v\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-v/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-v/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/business-v/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/business-v/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/business-v/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:47.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:38;a:11:{s:16:\"import_file_name\";s:7:\"Charity\";s:4:\"slug\";s:7:\"charity\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/charity/content.xml\";s:22:\"import_widget_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/charity/widgets.wie\";s:26:\"import_customizer_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/charity/customizer.dat\";s:24:\"import_preview_image_url\";s:73:\"https://static.colibriwp.com/templates-screenshots/charity/screenshot.png\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/charity/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:48.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:39;a:11:{s:16:\"import_file_name\";s:13:\"Makeup Artist\";s:4:\"slug\";s:13:\"makeup-artist\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/makeup-artist/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/makeup-artist/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/makeup-artist/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/makeup-artist/screenshot.png\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/makeup-artist/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:50.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:40;a:11:{s:16:\"import_file_name\";s:10:\"Mobile App\";s:4:\"slug\";s:10:\"mobile-app\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/mobile-app/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/mobile-app/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/mobile-app/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/mobile-app/screenshot.png\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/mobile-app/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:51.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:41;a:11:{s:16:\"import_file_name\";s:12:\"Music Artist\";s:4:\"slug\";s:12:\"music-artist\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/music-artist/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/music-artist/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/music-artist/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/music-artist/screenshot.png\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/music-artist/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:53.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:42;a:11:{s:16:\"import_file_name\";s:22:\"Photographer Portfolio\";s:4:\"slug\";s:22:\"photographer-portfolio\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/photographer-portfolio/content.xml\";s:22:\"import_widget_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/photographer-portfolio/widgets.wie\";s:26:\"import_customizer_file_url\";s:102:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/photographer-portfolio/customizer.dat\";s:24:\"import_preview_image_url\";s:88:\"https://static.colibriwp.com/templates-screenshots/photographer-portfolio/screenshot.png\";s:11:\"preview_url\";s:60:\"https://colibriwp-work.colibriwp.com/photographer-portfolio/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:54.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:43;a:11:{s:16:\"import_file_name\";s:6:\"Resort\";s:4:\"slug\";s:6:\"resort\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/resort/content.xml\";s:22:\"import_widget_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/resort/widgets.wie\";s:26:\"import_customizer_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/resort/customizer.dat\";s:24:\"import_preview_image_url\";s:72:\"https://static.colibriwp.com/templates-screenshots/resort/screenshot.png\";s:11:\"preview_url\";s:44:\"https://colibriwp-work.colibriwp.com/resort/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:56.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:44;a:11:{s:16:\"import_file_name\";s:6:\"Tailor\";s:4:\"slug\";s:6:\"tailor\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/tailor/content.xml\";s:22:\"import_widget_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/tailor/widgets.wie\";s:26:\"import_customizer_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/tailor/customizer.dat\";s:24:\"import_preview_image_url\";s:72:\"https://static.colibriwp.com/templates-screenshots/tailor/screenshot.png\";s:11:\"preview_url\";s:44:\"https://colibriwp-work.colibriwp.com/tailor/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:58.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:45;a:11:{s:16:\"import_file_name\";s:7:\"Theater\";s:4:\"slug\";s:7:\"theater\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/theater/content.xml\";s:22:\"import_widget_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/theater/widgets.wie\";s:26:\"import_customizer_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/theater/customizer.dat\";s:24:\"import_preview_image_url\";s:73:\"https://static.colibriwp.com/templates-screenshots/theater/screenshot.png\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/theater/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:02:59.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:46;a:11:{s:16:\"import_file_name\";s:13:\"Travel Agency\";s:4:\"slug\";s:13:\"travel-agency\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/travel-agency/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/travel-agency/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/travel-agency/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/travel-agency/screenshot.png\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/travel-agency/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-08-13 09:03:01.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:47;a:11:{s:16:\"import_file_name\";s:6:\"Bakery\";s:4:\"slug\";s:6:\"bakery\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/bakery/content.xml\";s:22:\"import_widget_file_url\";s:83:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/bakery/widgets.wie\";s:26:\"import_customizer_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/bakery/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/template-53/screenshot.jpg\";s:11:\"preview_url\";s:43:\"https://colibriwp-work.colibriwp.com/bakery\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:47:11.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:48;a:11:{s:16:\"import_file_name\";s:16:\"Cleaning Company\";s:4:\"slug\";s:16:\"cleaning-company\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/cleaning-company/content.xml\";s:22:\"import_widget_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/cleaning-company/widgets.wie\";s:26:\"import_customizer_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/cleaning-company/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/template-54/screenshot.jpg\";s:11:\"preview_url\";s:53:\"https://colibriwp-work.colibriwp.com/cleaning-company\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:47:14.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:49;a:11:{s:16:\"import_file_name\";s:15:\"Summer Festival\";s:4:\"slug\";s:15:\"summer-festival\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/summer-festival/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/summer-festival/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/summer-festival/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/summer-festival/screenshot.jpg\";s:11:\"preview_url\";s:53:\"https://colibriwp-work.colibriwp.com/summer-festival/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:47:52.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:50;a:11:{s:16:\"import_file_name\";s:12:\"Dance Studio\";s:4:\"slug\";s:12:\"dance-studio\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/dance-studio/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/dance-studio/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/dance-studio/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/dance-studio/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/dance-studio/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:47:56.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:51;a:11:{s:16:\"import_file_name\";s:9:\"Gardening\";s:4:\"slug\";s:9:\"gardening\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/gardening/content.xml\";s:22:\"import_widget_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/gardening/widgets.wie\";s:26:\"import_customizer_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/gardening/customizer.dat\";s:24:\"import_preview_image_url\";s:75:\"https://static.colibriwp.com/templates-screenshots/gardening/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/gardening/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:48:00.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:52;a:11:{s:16:\"import_file_name\";s:19:\"Political Candidate\";s:4:\"slug\";s:19:\"political-candidate\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/political-candidate/content.xml\";s:22:\"import_widget_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/political-candidate/widgets.wie\";s:26:\"import_customizer_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/political-candidate/customizer.dat\";s:24:\"import_preview_image_url\";s:85:\"https://static.colibriwp.com/templates-screenshots/political-candidate/screenshot.jpg\";s:11:\"preview_url\";s:57:\"https://colibriwp-work.colibriwp.com/political-candidate/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:48:04.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:53;a:11:{s:16:\"import_file_name\";s:19:\"Horse Riding Center\";s:4:\"slug\";s:19:\"horse-riding-center\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/horse-riding-center/content.xml\";s:22:\"import_widget_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/horse-riding-center/widgets.wie\";s:26:\"import_customizer_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/horse-riding-center/customizer.dat\";s:24:\"import_preview_image_url\";s:85:\"https://static.colibriwp.com/templates-screenshots/horse-riding-center/screenshot.jpg\";s:11:\"preview_url\";s:57:\"https://colibriwp-work.colibriwp.com/horse-riding-center/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:48:08.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:54;a:11:{s:16:\"import_file_name\";s:9:\"School II\";s:4:\"slug\";s:9:\"school-ii\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/school-ii/content.xml\";s:22:\"import_widget_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/school-ii/widgets.wie\";s:26:\"import_customizer_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/school-ii/customizer.dat\";s:24:\"import_preview_image_url\";s:75:\"https://static.colibriwp.com/templates-screenshots/school-ii/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/school-ii/\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2019-09-19 07:48:13.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:55;a:11:{s:16:\"import_file_name\";s:13:\"Therapist PRO\";s:4:\"slug\";s:13:\"therapist-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/therapist-pro/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/therapist-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/therapist-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/therapist-pro/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/therapist-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:59.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:56;a:11:{s:16:\"import_file_name\";s:10:\"Museum PRO\";s:4:\"slug\";s:10:\"museum-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/museum-pro/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/museum-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/museum-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/museum-pro/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/museum-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:55.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:57;a:11:{s:16:\"import_file_name\";s:7:\"Eco PRO\";s:4:\"slug\";s:7:\"eco-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/eco-pro/content.xml\";s:22:\"import_widget_file_url\";s:84:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/eco-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/eco-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:73:\"https://static.colibriwp.com/templates-screenshots/eco-pro/screenshot.jpg\";s:11:\"preview_url\";s:44:\"https://colibriwp-work.colibriwp.com/eco-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:53.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:58;a:11:{s:16:\"import_file_name\";s:13:\"Carpentry PRO\";s:4:\"slug\";s:13:\"carpentry-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/carpentry-pro/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/carpentry-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/carpentry-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/template-74/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/carpentry-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:51.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:59;a:11:{s:16:\"import_file_name\";s:15:\"Babysitting PRO\";s:4:\"slug\";s:15:\"babysitting-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/babysitting-pro/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/babysitting-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/babysitting-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/babysitting-pro/screenshot.jpg\";s:11:\"preview_url\";s:52:\"https://colibriwp-work.colibriwp.com/babysitting-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:50.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:60;a:11:{s:16:\"import_file_name\";s:15:\"Bike rental PRO\";s:4:\"slug\";s:15:\"bike-rental-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/bike-rental-pro/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/bike-rental-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/bike-rental-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/bike-rental-pro/screenshot.jpg\";s:11:\"preview_url\";s:52:\"https://colibriwp-work.colibriwp.com/bike-rental-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:48.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:61;a:11:{s:16:\"import_file_name\";s:8:\"City PRO\";s:4:\"slug\";s:8:\"city-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/city-pro/content.xml\";s:22:\"import_widget_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/city-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/city-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:74:\"https://static.colibriwp.com/templates-screenshots/city-pro/screenshot.jpg\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/city-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:47.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:62;a:11:{s:16:\"import_file_name\";s:12:\"Handyman PRO\";s:4:\"slug\";s:12:\"handyman-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/handyman-pro/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/handyman-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/handyman-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/handyman-pro/screenshot.jpg\";s:11:\"preview_url\";s:49:\"https://colibriwp-work.colibriwp.com/handyman-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:45.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:63;a:11:{s:16:\"import_file_name\";s:13:\"Home Deco PRO\";s:4:\"slug\";s:13:\"home-deco-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/home-deco-pro/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/home-deco-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/home-deco-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/home-deco-pro/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/home-deco-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:44.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:64;a:11:{s:16:\"import_file_name\";s:12:\"Coaching PRO\";s:4:\"slug\";s:14:\"coaching-pro-1\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coaching-pro-1/content.xml\";s:22:\"import_widget_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coaching-pro-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coaching-pro-1/customizer.dat\";s:24:\"import_preview_image_url\";s:80:\"https://static.colibriwp.com/templates-screenshots/coaching-pro-1/screenshot.jpg\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/coaching-pro-1\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-06-02 13:37:42.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:65;a:11:{s:16:\"import_file_name\";s:13:\"Coaching Free\";s:4:\"slug\";s:15:\"coaching-free-1\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coaching-free-1/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coaching-free-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coaching-free-1/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/coaching-free-1/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/coaching-free\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-09-14 08:01:48.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:0;}i:66;a:11:{s:16:\"import_file_name\";s:14:\"Designer Ui/Ux\";s:4:\"slug\";s:13:\"designer-uiux\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-uiux/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-uiux/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/designer-uiux/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/designer-uiux/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/designer-uiux\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-09-25 08:33:19.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:67;a:11:{s:16:\"import_file_name\";s:9:\"Insurance\";s:4:\"slug\";s:11:\"insurance-1\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/insurance-1/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/insurance-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/insurance-1/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/insurance-1/screenshot.jpg\";s:11:\"preview_url\";s:46:\"https://colibriwp-work.colibriwp.com/insurance\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-04 10:02:55.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:68;a:11:{s:16:\"import_file_name\";s:10:\"Veterinary\";s:4:\"slug\";s:12:\"veterinary-1\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/veterinary-1/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/veterinary-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/veterinary-1/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/veterinary-1/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/veterinary\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:56:02.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:69;a:11:{s:16:\"import_file_name\";s:8:\"Handmade\";s:4:\"slug\";s:10:\"handmade-1\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/handmade-1/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/handmade-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/handmade-1/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/handmade-1/screenshot.jpg\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/handmade\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-02-09 09:36:12.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:70;a:11:{s:16:\"import_file_name\";s:20:\"Aesthetic clinic PRO\";s:4:\"slug\";s:22:\"aesthetic-clinic-pro-1\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/aesthetic-clinic-pro-1/content.xml\";s:22:\"import_widget_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/aesthetic-clinic-pro-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:102:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/aesthetic-clinic-pro-1/customizer.dat\";s:24:\"import_preview_image_url\";s:88:\"https://static.colibriwp.com/templates-screenshots/aesthetic-clinic-pro-1/screenshot.jpg\";s:11:\"preview_url\";s:59:\"https://colibriwp-work.colibriwp.com/aesthetic-clinic-pro-1\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:56:00.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:71;a:11:{s:16:\"import_file_name\";s:10:\"Tattoo PRO\";s:4:\"slug\";s:10:\"tattoo-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/tattoo-pro/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/tattoo-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/tattoo-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/tattoo-pro/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/tattoo-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:51.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:72;a:11:{s:16:\"import_file_name\";s:14:\"Accounting PRO\";s:4:\"slug\";s:16:\"accounting-pro-1\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/accounting-pro-1/content.xml\";s:22:\"import_widget_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/accounting-pro-1/widgets.wie\";s:26:\"import_customizer_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/accounting-pro-1/customizer.dat\";s:24:\"import_preview_image_url\";s:82:\"https://static.colibriwp.com/templates-screenshots/accounting-pro-1/screenshot.jpg\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/accounting-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-11-06 07:32:11.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:73;a:11:{s:16:\"import_file_name\";s:14:\"Web Agency PRO\";s:4:\"slug\";s:14:\"web-agency-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/web-agency-pro/content.xml\";s:22:\"import_widget_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/web-agency-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/web-agency-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:80:\"https://static.colibriwp.com/templates-screenshots/web-agency-pro/screenshot.jpg\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/web-agency-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-10-30 09:48:41.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:74;a:11:{s:16:\"import_file_name\";s:13:\"Eldercare PRO\";s:4:\"slug\";s:13:\"eldercare-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/eldercare-pro/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/eldercare-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/eldercare-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/eldercare-pro/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/eldercare-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:49.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:75;a:11:{s:16:\"import_file_name\";s:20:\"Personal Stylist PRO\";s:4:\"slug\";s:20:\"personal-stylist-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/personal-stylist-pro/content.xml\";s:22:\"import_widget_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/personal-stylist-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:100:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/personal-stylist-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:86:\"https://static.colibriwp.com/templates-screenshots/personal-stylist-pro/screenshot.jpg\";s:11:\"preview_url\";s:57:\"https://colibriwp-work.colibriwp.com/personal-stylist-pro\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-09-24 13:40:49.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:76;a:11:{s:16:\"import_file_name\";s:15:\"Illusionist PRO\";s:4:\"slug\";s:15:\"illusionist-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/illusionist-pro/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/illusionist-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/illusionist-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/illusionist-pro/screenshot.jpg\";s:11:\"preview_url\";s:52:\"https://colibriwp-work.colibriwp.com/illusionist-pro\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:46.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:77;a:11:{s:16:\"import_file_name\";s:13:\"Paintball PRO\";s:4:\"slug\";s:13:\"paintball-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/paintball-pro/content.xml\";s:22:\"import_widget_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/paintball-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/paintball-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:79:\"https://static.colibriwp.com/templates-screenshots/paintball-pro/screenshot.jpg\";s:11:\"preview_url\";s:50:\"https://colibriwp-work.colibriwp.com/paintball-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:44.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:78;a:11:{s:16:\"import_file_name\";s:11:\"Painter PRO\";s:4:\"slug\";s:11:\"painter-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/painter-pro/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/painter-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/painter-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/painter-pro/screenshot.jpg\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/painter-pro\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-10-19 08:06:59.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:79;a:11:{s:16:\"import_file_name\";s:12:\"Football PRO\";s:4:\"slug\";s:12:\"football-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/football-pro/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/football-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/football-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/template-122/screenshot.jpg\";s:11:\"preview_url\";s:49:\"https://colibriwp-work.colibriwp.com/football-pro\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:42.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:80;a:11:{s:16:\"import_file_name\";s:12:\"Swimming PRO\";s:4:\"slug\";s:12:\"swimming-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/swimming-pro/content.xml\";s:22:\"import_widget_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/swimming-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/swimming-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:78:\"https://static.colibriwp.com/templates-screenshots/swimming-pro/screenshot.jpg\";s:11:\"preview_url\";s:49:\"https://colibriwp-work.colibriwp.com/swimming-pro\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:40.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:81;a:11:{s:16:\"import_file_name\";s:16:\"Pest control PRO\";s:4:\"slug\";s:16:\"pest-control-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pest-control-pro/content.xml\";s:22:\"import_widget_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pest-control-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pest-control-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:82:\"https://static.colibriwp.com/templates-screenshots/pest-control-pro/screenshot.jpg\";s:11:\"preview_url\";s:53:\"https://colibriwp-work.colibriwp.com/pest-control-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:37.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:82;a:11:{s:16:\"import_file_name\";s:19:\"Coworking Space PRO\";s:4:\"slug\";s:19:\"coworking-space-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coworking-space-pro/content.xml\";s:22:\"import_widget_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coworking-space-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/coworking-space-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:85:\"https://static.colibriwp.com/templates-screenshots/coworking-space-pro/screenshot.jpg\";s:11:\"preview_url\";s:56:\"https://colibriwp-work.colibriwp.com/coworking-space-pro\";s:7:\"plugins\";a:2:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";s:30:\"MC4WP: Mailchimp for WordPress\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-10-21 11:27:45.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:83;a:11:{s:16:\"import_file_name\";s:9:\"Print PRO\";s:4:\"slug\";s:9:\"print-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/print-pro/content.xml\";s:22:\"import_widget_file_url\";s:86:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/print-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:89:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/print-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:75:\"https://static.colibriwp.com/templates-screenshots/print-pro/screenshot.jpg\";s:11:\"preview_url\";s:46:\"https://colibriwp-work.colibriwp.com/print-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-09-25 08:38:43.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:84;a:11:{s:16:\"import_file_name\";s:14:\"Accountant PRO\";s:4:\"slug\";s:14:\"accountant-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/accountant-pro/content.xml\";s:22:\"import_widget_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/accountant-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/accountant-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:80:\"https://static.colibriwp.com/templates-screenshots/accountant-pro/screenshot.jpg\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/accountant-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-11-19 08:49:32.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:85;a:11:{s:16:\"import_file_name\";s:22:\"Marketing services PRO\";s:4:\"slug\";s:22:\"marketing-services-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/marketing-services-pro/content.xml\";s:22:\"import_widget_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/marketing-services-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:102:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/marketing-services-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:88:\"https://static.colibriwp.com/templates-screenshots/marketing-services-pro/screenshot.jpg\";s:11:\"preview_url\";s:59:\"https://colibriwp-work.colibriwp.com/marketing-services-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-09-25 08:09:48.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:86;a:11:{s:16:\"import_file_name\";s:17:\"Web Developer PRO\";s:4:\"slug\";s:17:\"web-developer-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/web-developer-pro/content.xml\";s:22:\"import_widget_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/web-developer-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/web-developer-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:83:\"https://static.colibriwp.com/templates-screenshots/web-developer-pro/screenshot.jpg\";s:11:\"preview_url\";s:54:\"https://colibriwp-work.colibriwp.com/web-developer-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-12-15 06:17:47.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:87;a:11:{s:16:\"import_file_name\";s:24:\"Full Stack Developer PRO\";s:4:\"slug\";s:24:\"full-stack-developer-pro\";s:10:\"categories\";a:1:{i:0;s:9:\"portfolio\";}s:15:\"import_file_url\";s:101:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/full-stack-developer-pro/content.xml\";s:22:\"import_widget_file_url\";s:101:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/full-stack-developer-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:104:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/full-stack-developer-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:90:\"https://static.colibriwp.com/templates-screenshots/full-stack-developer-pro/screenshot.jpg\";s:11:\"preview_url\";s:61:\"https://colibriwp-work.colibriwp.com/full-stack-developer-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-12-15 06:17:33.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:88;a:11:{s:16:\"import_file_name\";s:19:\"Holistic Healer PRO\";s:4:\"slug\";s:19:\"holistic-healer-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/holistic-healer-pro/content.xml\";s:22:\"import_widget_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/holistic-healer-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:99:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/holistic-healer-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:85:\"https://static.colibriwp.com/templates-screenshots/holistic-healer-pro/screenshot.jpg\";s:11:\"preview_url\";s:56:\"https://colibriwp-work.colibriwp.com/holistic-healer-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:19.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:89;a:11:{s:16:\"import_file_name\";s:10:\"Rental PRO\";s:4:\"slug\";s:10:\"rental-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/rental-pro/content.xml\";s:22:\"import_widget_file_url\";s:87:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/rental-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:90:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/rental-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:76:\"https://static.colibriwp.com/templates-screenshots/rental-pro/screenshot.jpg\";s:11:\"preview_url\";s:47:\"https://colibriwp-work.colibriwp.com/rental-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-10-05 12:12:27.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:90;a:11:{s:16:\"import_file_name\";s:13:\"Pub / Bar PRO\";s:4:\"slug\";s:11:\"pub-bar-pro\";s:10:\"categories\";a:1:{i:0;s:10:\"food-drink\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pub-bar-pro/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pub-bar-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/pub-bar-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/pub-bar-pro/screenshot.jpg\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/pub-bar-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:54:17.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:91;a:11:{s:16:\"import_file_name\";s:14:\"Motorcycle PRO\";s:4:\"slug\";s:14:\"motorcycle-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/motorcycle-pro/content.xml\";s:22:\"import_widget_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/motorcycle-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:94:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/motorcycle-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:80:\"https://static.colibriwp.com/templates-screenshots/motorcycle-pro/screenshot.jpg\";s:11:\"preview_url\";s:51:\"https://colibriwp-work.colibriwp.com/motorcycle-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:53:53.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:92;a:11:{s:16:\"import_file_name\";s:18:\"Transportation PRO\";s:4:\"slug\";s:18:\"transportation-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"business\";}s:15:\"import_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/transportation-pro/content.xml\";s:22:\"import_widget_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/transportation-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:98:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/transportation-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:84:\"https://static.colibriwp.com/templates-screenshots/transportation-pro/screenshot.jpg\";s:11:\"preview_url\";s:55:\"https://colibriwp-work.colibriwp.com/transportation-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-04 10:48:31.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:93;a:11:{s:16:\"import_file_name\";s:20:\"Language Courses PRO\";s:4:\"slug\";s:20:\"language-courses-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/language-courses-pro/content.xml\";s:22:\"import_widget_file_url\";s:97:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/language-courses-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:100:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/language-courses-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:86:\"https://static.colibriwp.com/templates-screenshots/language-courses-pro/screenshot.jpg\";s:11:\"preview_url\";s:57:\"https://colibriwp-work.colibriwp.com/language-courses-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:53:41.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:94;a:11:{s:16:\"import_file_name\";s:8:\"Taxi PRO\";s:4:\"slug\";s:8:\"taxi-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/taxi-pro/content.xml\";s:22:\"import_widget_file_url\";s:85:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/taxi-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/taxi-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:74:\"https://static.colibriwp.com/templates-screenshots/taxi-pro/screenshot.jpg\";s:11:\"preview_url\";s:45:\"https://colibriwp-work.colibriwp.com/taxi-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:53:39.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:95;a:11:{s:16:\"import_file_name\";s:11:\"Airclub PRO\";s:4:\"slug\";s:11:\"airclub-pro\";s:10:\"categories\";a:1:{i:0;s:12:\"sport-travel\";}s:15:\"import_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/airclub-pro/content.xml\";s:22:\"import_widget_file_url\";s:88:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/airclub-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:91:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/airclub-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:77:\"https://static.colibriwp.com/templates-screenshots/airclub-pro/screenshot.jpg\";s:11:\"preview_url\";s:48:\"https://colibriwp-work.colibriwp.com/airclub-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-01-19 15:53:11.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:96;a:11:{s:16:\"import_file_name\";s:15:\"Car service PRO\";s:4:\"slug\";s:15:\"car-service-pro\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/car-service-pro/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/car-service-pro/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/car-service-pro/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/car-service-pro/screenshot.jpg\";s:11:\"preview_url\";s:52:\"https://colibriwp-work.colibriwp.com/car-service-pro\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-03-23 12:55:42.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:97;a:11:{s:16:\"import_file_name\";s:15:\"Christmas gifts\";s:4:\"slug\";s:15:\"christmas-gifts\";s:10:\"categories\";a:1:{i:0;s:9:\"community\";}s:15:\"import_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/christmas-gifts/content.xml\";s:22:\"import_widget_file_url\";s:92:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/christmas-gifts/widgets.wie\";s:26:\"import_customizer_file_url\";s:95:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/christmas-gifts/customizer.dat\";s:24:\"import_preview_image_url\";s:81:\"https://static.colibriwp.com/templates-screenshots/christmas-gifts/screenshot.jpg\";s:11:\"preview_url\";s:52:\"https://colibriwp-work.colibriwp.com/christmas-gifts\";s:7:\"plugins\";a:1:{s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2020-12-17 16:25:20.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:1;}i:98;a:11:{s:16:\"import_file_name\";s:16:\"Colibri Handyman\";s:4:\"slug\";s:16:\"colibri-handyman\";s:10:\"categories\";a:1:{i:0;s:8:\"services\";}s:15:\"import_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/colibri-handyman/content.xml\";s:22:\"import_widget_file_url\";s:93:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/colibri-handyman/widgets.wie\";s:26:\"import_customizer_file_url\";s:96:\"https://colibri-demo-sites.s3.us-west-2.amazonaws.com/production/colibri-handyman/customizer.dat\";s:24:\"import_preview_image_url\";s:82:\"https://static.colibriwp.com/templates-screenshots/colibri-handyman/screenshot.jpg\";s:11:\"preview_url\";s:53:\"https://colibriwp-work.colibriwp.com/colibri-handyman\";s:7:\"plugins\";a:2:{s:57:\"colibri-template-generator/colibri-template-generator.php\";N;s:36:\"contact-form-7/wp-contact-form-7.php\";s:14:\"Contact Form 7\";}s:10:\"updated_at\";a:3:{s:4:\"date\";s:26:\"2021-06-07 14:29:03.000000\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}s:6:\"is_pro\";i:0;}}}", "auto");
INSERT INTO `wp_options` VALUES("217", "extend_builder_theme", "a:17:{s:5:\"icons\";a:11:{s:17:\"brandico/facebook\";s:284:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"facebook\" viewBox=\"0 0 486.037 1007\"><path d=\"M124 1005V536H0V367h124V223C124 110 197 5 366 5c68 0 119 7 119 7l-4 158s-52-1-108-1c-61 0-71 28-71 75v123h183l-8 169H302v469H123\"/></svg>\";s:17:\"font-awesome/star\";s:395:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"star\" viewBox=\"0 0 1664 1896.0833\"><path d=\"M1664 647q0 22-26 48l-363 354 86 500q1 7 1 20 0 21-10.5 35.5T1321 1619q-19 0-40-12l-449-236-449 236q-22 12-40 12-21 0-31.5-14.5T301 1569q0-6 2-20l86-500L25 695Q0 668 0 647q0-37 56-46l502-73L783 73q19-41 49-41t49 41l225 455 502 73q56 9 56 46z\"/></svg>\";s:28:\"font-awesome/facebook-square\";s:410:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"facebook-square\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M1248 128q119 0 203.5 84.5T1536 416v960q0 119-84.5 203.5T1248 1664h-188v-595h199l30-232h-229V689q0-56 23.5-84t91.5-28l122-1V369q-63-9-178-9-136 0-217.5 80T820 666v171H620v232h200v595H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960z\"/></svg>\";s:27:\"font-awesome/twitter-square\";s:630:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"twitter-square\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M1280 610q-56 25-121 34 68-40 93-117-65 38-134 51-61-66-153-66-87 0-148.5 61.5T755 722q0 29 5 48-129-7-242-65T326 550q-29 50-29 106 0 114 91 175-47-1-100-26v2q0 75 50 133.5t123 72.5q-29 8-51 8-13 0-39-4 21 63 74.5 104t121.5 42q-116 90-261 90-26 0-50-3 148 94 322 94 112 0 210-35.5t168-95 120.5-137 75-162T1176 746q0-18-1-27 63-45 105-109zm256-194v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z\"/></svg>\";s:27:\"font-awesome/youtube-square\";s:1354:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"youtube-square\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M919 1303v-157q0-50-29-50-17 0-33 16v224q16 16 33 16 29 0 29-49zm184-122h66v-34q0-51-33-51t-33 51v34zM532 915v70h-80v423h-74V985h-78v-70h232zm201 126v367h-67v-40q-39 45-76 45-33 0-42-28-6-17-6-54v-290h66v270q0 24 1 26 1 15 15 15 20 0 42-31v-280h67zm252 111v146q0 52-7 73-12 42-53 42-35 0-68-41v36h-67V915h67v161q32-40 68-40 41 0 53 42 7 21 7 74zm251 129v9q0 29-2 43-3 22-15 40-27 40-80 40-52 0-81-38-21-27-21-86v-129q0-59 20-86 29-38 80-38t78 38q21 29 21 86v76h-133v65q0 51 34 51 24 0 30-26 0-1 .5-7t.5-16.5V1281h68zM785 457v156q0 51-32 51t-32-51V457q0-52 32-52t32 52zm533 713q0-177-19-260-10-44-43-73.5t-76-34.5q-136-15-412-15-275 0-411 15-44 5-76.5 34.5T238 910q-20 87-20 260 0 176 20 260 10 43 42.5 73t75.5 35q137 15 412 15t412-15q43-5 75.5-35t42.5-73q20-84 20-260zM563 519l90-296h-75l-51 195-53-195h-78q7 23 23 69l24 69q35 103 46 158v201h74V519zm289 81V470q0-58-21-87-29-38-78-38-51 0-78 38-21 29-21 87v130q0 58 21 87 27 38 78 38 49 0 78-38 21-27 21-87zm181 120h67V350h-67v283q-22 31-42 31-15 0-16-16-1-2-1-26V350h-67v293q0 37 6 55 11 27 43 27 36 0 77-45v40zm503-304v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z\"/></svg>\";s:25:\"font-awesome/vimeo-square\";s:540:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"vimeo-square\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M1292 638q10-216-161-222-231-8-312 261 44-19 82-19 85 0 74 96-4 57-74 167t-105 110q-43 0-82-169-13-54-45-255-30-189-160-177-59 7-164 100l-81 72-81 72 52 67q76-52 87-52 57 0 107 179 15 55 45 164.5t45 164.5q68 179 164 179 157 0 383-294 220-283 226-444zm244-222v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z\"/></svg>\";s:17:\"font-awesome/plus\";s:353:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"plus\" viewBox=\"0 0 1408 1896.0833\"><path d=\"M1408 736v192q0 40-28 68t-68 28H896v416q0 40-28 68t-68 28H608q-40 0-68-28t-28-68v-416H96q-40 0-68-28T0 928V736q0-40 28-68t68-28h416V224q0-40 28-68t68-28h192q40 0 68 28t28 68v416h416q40 0 68 28t28 68z\"/></svg>\";s:18:\"font-awesome/minus\";s:251:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"minus\" viewBox=\"0 0 1408 1896.0833\"><path d=\"M1408 736v192q0 40-28 68t-68 28H96q-40 0-68-28T0 928V736q0-40 28-68t68-28h1216q40 0 68 28t28 68z\"/></svg>\";s:25:\"font-awesome/chevron-left\";s:320:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"chevron-left\" viewBox=\"0 0 1289.1823 1896.0833\"><path d=\"M1171 301L640 832l531 531q19 19 19 45t-19 45l-166 166q-19 19-45 19t-45-19L173 877q-19-19-19-45t19-45L915 45q19-19 45-19t45 19l166 166q19 19 19 45t-19 45z\"/></svg>\";s:26:\"font-awesome/chevron-right\";s:317:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"chevron-right\" viewBox=\"0 0 1280 1896.0833\"><path d=\"M1107 877l-742 742q-19 19-45 19t-45-19l-166-166q-19-19-19-45t19-45l531-531-531-531q-19-19-19-45t19-45L275 45q19-19 45-19t45 19l742 742q19 19 19 45t-19 45z\"/></svg>\";s:17:\"font-awesome/bars\";s:439:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"bars\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M1536 1344v128q0 26-19 45t-45 19H64q-26 0-45-19t-19-45v-128q0-26 19-45t45-19h1408q26 0 45 19t19 45zm0-512v128q0 26-19 45t-45 19H64q-26 0-45-19T0 960V832q0-26 19-45t45-19h1408q26 0 45 19t19 45zm0-512v128q0 26-19 45t-45 19H64q-26 0-45-19T0 448V320q0-26 19-45t45-19h1408q26 0 45 19t19 45z\"/></svg>\";}s:5:\"fonts\";a:2:{s:6:\"native\";a:0:{}s:6:\"google\";a:6:{s:4:\"Muli\";a:2:{s:7:\"weights\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"400\";i:5;s:9:\"400italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Open Sans\";a:2:{s:7:\"weights\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"400\";i:3;s:9:\"400italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Playfair Display\";a:2:{s:7:\"weights\";a:6:{i:0;s:3:\"400\";i:1;s:9:\"400italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:8:\"category\";s:10:\"sans-serif\";}s:15:\"Source Sans Pro\";a:3:{s:8:\"category\";s:10:\"sans-serif\";s:7:\"subsets\";a:7:{i:0;s:8:\"cyrillic\";i:1;s:10:\"vietnamese\";i:2;s:9:\"greek-ext\";i:3;s:5:\"greek\";i:4;s:9:\"latin-ext\";i:5;s:12:\"cyrillic-ext\";i:6;s:5:\"latin\";}s:7:\"weights\";a:12:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"400\";i:5;s:9:\"400italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"900\";i:11;s:9:\"900italic\";}}s:10:\"Montserrat\";a:3:{s:8:\"category\";s:10:\"sans-serif\";s:7:\"subsets\";a:3:{i:0;s:10:\"vietnamese\";i:1;s:9:\"latin-ext\";i:2;s:5:\"latin\";}s:7:\"weights\";a:18:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"200\";i:3;s:9:\"200italic\";i:4;s:3:\"300\";i:5;s:9:\"300italic\";i:6;s:3:\"400\";i:7;s:9:\"400italic\";i:8;s:3:\"500\";i:9;s:9:\"500italic\";i:10;s:3:\"600\";i:11;s:9:\"600italic\";i:12;s:3:\"700\";i:13;s:9:\"700italic\";i:14;s:3:\"800\";i:15;s:9:\"800italic\";i:16;s:3:\"900\";i:17;s:9:\"900italic\";}}s:15:\"Source Code Pro\";a:3:{s:8:\"category\";s:9:\"monospace\";s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"weights\";a:7:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"400\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";i:6;s:3:\"900\";}}}}s:6:\"colors\";a:6:{i:0;s:7:\"#03a9f4\";i:1;s:7:\"#f79007\";i:2;s:7:\"#00bf87\";i:3;s:7:\"#6632ff\";i:4;s:7:\"#FFFFFF\";i:5;s:7:\"#000000\";}s:11:\"dummyChange\";s:0:\"\";s:10:\"typography\";a:1:{s:7:\"holders\";a:10:{s:2:\"h1\";a:2:{s:6:\"family\";s:15:\"Source Sans Pro\";s:6:\"weight\";s:3:\"700\";}s:2:\"h2\";a:2:{s:6:\"family\";s:15:\"Source Sans Pro\";s:6:\"weight\";s:3:\"600\";}s:2:\"h3\";a:3:{s:6:\"family\";s:15:\"Source Sans Pro\";s:6:\"weight\";s:3:\"600\";s:5:\"color\";s:17:\"${theme.colors.0}\";}s:2:\"h4\";a:1:{s:6:\"family\";s:15:\"Source Sans Pro\";}s:2:\"h5\";a:1:{s:6:\"family\";s:15:\"Source Sans Pro\";}s:2:\"h6\";a:1:{s:6:\"family\";s:15:\"Source Sans Pro\";}s:1:\"p\";a:3:{s:6:\"weight\";s:3:\"400\";s:6:\"family\";s:15:\"Source Sans Pro\";s:5:\"color\";s:17:\"${theme.colors.5}\";}s:4:\"lead\";a:4:{s:6:\"weight\";s:3:\"600\";s:6:\"family\";s:15:\"Source Sans Pro\";s:4:\"size\";a:2:{s:4:\"unit\";s:2:\"em\";s:5:\"value\";s:3:\"1.1\";}s:5:\"color\";s:17:\"${theme.colors.0}\";}s:1:\"a\";a:3:{s:6:\"weight\";s:3:\"400\";s:6:\"family\";s:15:\"Source Sans Pro\";s:5:\"color\";s:17:\"${theme.colors.0}\";}s:10:\"blockquote\";a:2:{s:6:\"weight\";s:3:\"400\";s:6:\"family\";s:15:\"Source Sans Pro\";}}}s:6:\"global\";a:9:{s:7:\"content\";a:2:{s:8:\"template\";s:0:\"\";s:10:\"collection\";s:0:\"\";}s:6:\"titles\";a:10:{s:16:\"normalPageFormat\";s:7:\"{TITLE}\";s:17:\"normalResultsPage\";s:27:\"Search results for: {TITLE}\";s:9:\"errorPage\";s:22:\"Sorry! Page Not Found!\";s:10:\"singlePost\";s:7:\"{TITLE}\";s:15:\"categoryArchive\";s:16:\"Posts in {TITLE}\";s:13:\"authorArchive\";s:16:\"Posts in {TITLE}\";s:10:\"tagArchive\";s:16:\"Posts in {TITLE}\";s:11:\"yearArchive\";s:16:\"Posts in {TITLE}\";s:12:\"monthArchive\";s:16:\"Posts in {TITLE}\";s:10:\"dayArchive\";s:16:\"Posts in {TITLE}\";}s:6:\"vSpace\";a:2:{s:5:\"value\";i:10;s:4:\"unit\";s:2:\"px\";}s:6:\"hSpace\";a:2:{s:5:\"value\";i:20;s:4:\"unit\";s:2:\"px\";}s:14:\"sectionSpacing\";a:2:{s:5:\"value\";i:63;s:4:\"unit\";s:2:\"px\";}s:10:\"transition\";a:1:{s:8:\"duration\";a:2:{s:5:\"value\";s:3:\"0.5\";s:4:\"unit\";s:1:\"s\";}}s:9:\"templates\";a:2:{s:4:\"blog\";a:2:{s:5:\"style\";a:0:{}s:5:\"props\";a:1:{s:11:\"descendants\";a:2:{s:7:\"section\";a:2:{s:5:\"width\";s:10:\"full-width\";s:8:\"sidebars\";a:1:{s:5:\"right\";b:1;}}s:3:\"row\";a:2:{s:14:\"layout-classes\";a:3:{s:5:\"unset\";b:1;s:11:\"outer_class\";a:1:{i:0;s:16:\"gutters-row-lg-1\";}s:11:\"inner_class\";a:1:{i:0;s:16:\"gutters-col-lg-1\";}}s:6:\"layout\";a:2:{s:13:\"horizontalGap\";i:1;s:11:\"verticalGap\";i:1;}}}}}s:11:\"woocommerce\";a:2:{s:5:\"props\";a:1:{s:11:\"descendants\";a:1:{s:7:\"section\";a:1:{s:8:\"sidebars\";a:1:{s:4:\"left\";b:1;}}}}s:5:\"style\";a:1:{s:11:\"descendants\";a:1:{s:12:\"sidebar-left\";a:1:{s:11:\"columnWidth\";a:1:{s:6:\"custom\";a:2:{s:4:\"unit\";s:1:\"%\";s:5:\"value\";i:25;}}}}}}}s:13:\"multilanguage\";a:2:{s:5:\"props\";a:2:{s:7:\"enabled\";b:1;s:4:\"type\";s:8:\"dropdown\";}s:5:\"style\";a:4:{s:11:\"descendants\";a:2:{s:9:\"container\";a:3:{s:10:\"background\";a:1:{s:5:\"color\";s:5:\"white\";}s:3:\"top\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:80;}s:6:\"border\";a:2:{s:3:\"top\";a:1:{s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:4;}s:5:\"right\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:0;}}}s:6:\"bottom\";a:1:{s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:4;}s:5:\"right\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:0;}}}}}s:5:\"flags\";a:1:{s:7:\"padding\";a:4:{s:3:\"top\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:14;}s:5:\"right\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:18;}s:6:\"bottom\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:14;}s:4:\"left\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:18;}}}}s:10:\"background\";a:1:{s:5:\"color\";s:5:\"white\";}s:3:\"top\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:80;}s:6:\"border\";a:2:{s:3:\"top\";a:1:{s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:4;}s:5:\"right\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:0;}}}s:6:\"bottom\";a:1:{s:6:\"radius\";a:2:{s:4:\"left\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:4;}s:5:\"right\";a:2:{s:4:\"unit\";s:2:\"px\";s:5:\"value\";i:0;}}}}}}s:5:\"media\";a:2:{s:6:\"mobile\";a:1:{s:14:\"sectionSpacing\";a:2:{s:5:\"value\";i:30;s:4:\"unit\";s:2:\"px\";}}s:6:\"tablet\";a:1:{s:14:\"sectionSpacing\";a:2:{s:5:\"value\";i:60;s:4:\"unit\";s:2:\"px\";}}}}s:4:\"menu\";a:2:{s:16:\"defaultLocations\";a:3:{s:6:\"header\";a:2:{i:0;a:3:{s:2:\"id\";s:11:\"header-menu\";s:5:\"label\";s:19:\"Header primary menu\";s:8:\"priority\";i:1;}i:1;a:3:{s:2:\"id\";s:13:\"header-menu-1\";s:5:\"label\";s:21:\"Header secondary menu\";s:8:\"priority\";i:2;}}s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:12:\"content-menu\";s:5:\"label\";s:12:\"In Page Menu\";s:8:\"priority\";i:1;}}s:6:\"footer\";a:2:{i:0;a:3:{s:2:\"id\";s:11:\"footer-menu\";s:5:\"label\";s:19:\"Footer primary menu\";s:8:\"priority\";i:1;}i:1;a:3:{s:2:\"id\";s:13:\"footer-menu-1\";s:5:\"label\";s:21:\"Footer secondary menu\";s:8:\"priority\";i:2;}}}s:9:\"locations\";a:5:{i:0;a:2:{s:2:\"id\";s:11:\"header-menu\";s:5:\"label\";s:19:\"Header primary menu\";}i:1;a:2:{s:2:\"id\";s:13:\"header-menu-1\";s:5:\"label\";s:21:\"Header secondary menu\";}i:2;a:2:{s:2:\"id\";s:12:\"content-menu\";s:5:\"label\";s:12:\"In Page Menu\";}i:3;a:2:{s:2:\"id\";s:11:\"footer-menu\";s:5:\"label\";s:19:\"Footer primary menu\";}i:4;a:2:{s:2:\"id\";s:13:\"footer-menu-1\";s:5:\"label\";s:21:\"Footer secondary menu\";}}}s:3:\"css\";s:24979:\"\r\n.h-y-container > *:not(:last-child), .h-x-container-inner > * {\n  margin-bottom: 10px;\n}\n.h-x-container-inner, .h-column__content > .h-x-container > *:last-child {\n  margin-bottom: -10px;\n}\n.h-x-container-inner > * {\n  padding-left: 10px;\n  padding-right: 10px;\n}\n.h-x-container-inner {\n  margin-left: -10px;\n  margin-right: -10px;\n}\n[class*=style-], [class*=local-style-], .h-global-transition, .h-global-transition-all, .h-global-transition-all * {\n  transition-duration: 0.5s;\n}\n.wp-block-button .wp-block-button__link:not(.has-background),.wp-block-file .wp-block-file__button {\n  background-color: #03a9f4;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link:not(.has-background):hover,.wp-block-button .wp-block-button__link:not(.has-background):focus,.wp-block-button .wp-block-button__link:not(.has-background):active,.wp-block-file .wp-block-file__button:hover,.wp-block-file .wp-block-file__button:focus,.wp-block-file .wp-block-file__button:active {\n  background-color: rgb(2, 110, 159);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link:not(.has-background) {\n  color: #03a9f4;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link:not(.has-background):hover,.wp-block-button.is-style-outline .wp-block-button__link:not(.has-background):focus,.wp-block-button.is-style-outline .wp-block-button__link:not(.has-background):active {\n  color: #fff;\n  background-color: #03a9f4;\n  background-image: none;\n}\n.has-background-color,*[class^=\"wp-block-\"].is-style-solid-color {\n  background-color: #03a9f4;\n  background-image: none;\n}\n.has-colibri-color-1-background-color {\n  background-color: #03a9f4;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-1-background-color {\n  background-color: #03a9f4;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-1-background-color:hover,.wp-block-button .wp-block-button__link.has-colibri-color-1-background-color:focus,.wp-block-button .wp-block-button__link.has-colibri-color-1-background-color:active {\n  background-color: rgb(2, 110, 159);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-1-background-color {\n  color: #03a9f4;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-1-background-color:hover,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-1-background-color:focus,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-1-background-color:active {\n  color: #fff;\n  background-color: #03a9f4;\n  background-image: none;\n}\n*[class^=\"wp-block-\"].has-colibri-color-1-background-color,*[class^=\"wp-block-\"] .has-colibri-color-1-background-color,*[class^=\"wp-block-\"].is-style-solid-color.has-colibri-color-1-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-1-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-1-color p {\n  background-color: #03a9f4;\n  background-image: none;\n}\n.has-colibri-color-1-color {\n  color: #03a9f4;\n}\n.has-colibri-color-2-background-color {\n  background-color: #f79007;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-2-background-color {\n  background-color: #f79007;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-2-background-color:hover,.wp-block-button .wp-block-button__link.has-colibri-color-2-background-color:focus,.wp-block-button .wp-block-button__link.has-colibri-color-2-background-color:active {\n  background-color: rgb(162, 94, 5);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-2-background-color {\n  color: #f79007;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-2-background-color:hover,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-2-background-color:focus,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-2-background-color:active {\n  color: #fff;\n  background-color: #f79007;\n  background-image: none;\n}\n*[class^=\"wp-block-\"].has-colibri-color-2-background-color,*[class^=\"wp-block-\"] .has-colibri-color-2-background-color,*[class^=\"wp-block-\"].is-style-solid-color.has-colibri-color-2-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-2-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-2-color p {\n  background-color: #f79007;\n  background-image: none;\n}\n.has-colibri-color-2-color {\n  color: #f79007;\n}\n.has-colibri-color-3-background-color {\n  background-color: #00bf87;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-3-background-color {\n  background-color: #00bf87;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-3-background-color:hover,.wp-block-button .wp-block-button__link.has-colibri-color-3-background-color:focus,.wp-block-button .wp-block-button__link.has-colibri-color-3-background-color:active {\n  background-color: rgb(0, 106, 75);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-3-background-color {\n  color: #00bf87;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #00bf87;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #00bf87;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #00bf87;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #00bf87;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-3-background-color:hover,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-3-background-color:focus,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-3-background-color:active {\n  color: #fff;\n  background-color: #00bf87;\n  background-image: none;\n}\n*[class^=\"wp-block-\"].has-colibri-color-3-background-color,*[class^=\"wp-block-\"] .has-colibri-color-3-background-color,*[class^=\"wp-block-\"].is-style-solid-color.has-colibri-color-3-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-3-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-3-color p {\n  background-color: #00bf87;\n  background-image: none;\n}\n.has-colibri-color-3-color {\n  color: #00bf87;\n}\n.has-colibri-color-4-background-color {\n  background-color: #6632ff;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-4-background-color {\n  background-color: #6632ff;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-4-background-color:hover,.wp-block-button .wp-block-button__link.has-colibri-color-4-background-color:focus,.wp-block-button .wp-block-button__link.has-colibri-color-4-background-color:active {\n  background-color: rgb(68, 33, 170);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-4-background-color {\n  color: #6632ff;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #6632ff;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #6632ff;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #6632ff;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #6632ff;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-4-background-color:hover,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-4-background-color:focus,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-4-background-color:active {\n  color: #fff;\n  background-color: #6632ff;\n  background-image: none;\n}\n*[class^=\"wp-block-\"].has-colibri-color-4-background-color,*[class^=\"wp-block-\"] .has-colibri-color-4-background-color,*[class^=\"wp-block-\"].is-style-solid-color.has-colibri-color-4-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-4-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-4-color p {\n  background-color: #6632ff;\n  background-image: none;\n}\n.has-colibri-color-4-color {\n  color: #6632ff;\n}\n.has-colibri-color-5-background-color {\n  background-color: #FFFFFF;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-5-background-color {\n  background-color: #FFFFFF;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-5-background-color:hover,.wp-block-button .wp-block-button__link.has-colibri-color-5-background-color:focus,.wp-block-button .wp-block-button__link.has-colibri-color-5-background-color:active {\n  background-color: rgb(102, 102, 102);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-5-background-color {\n  color: #FFFFFF;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #FFFFFF;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #FFFFFF;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-5-background-color:hover,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-5-background-color:focus,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-5-background-color:active {\n  color: #fff;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n*[class^=\"wp-block-\"].has-colibri-color-5-background-color,*[class^=\"wp-block-\"] .has-colibri-color-5-background-color,*[class^=\"wp-block-\"].is-style-solid-color.has-colibri-color-5-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-5-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-5-color p {\n  background-color: #FFFFFF;\n  background-image: none;\n}\n.has-colibri-color-5-color {\n  color: #FFFFFF;\n}\n.has-colibri-color-6-background-color {\n  background-color: #000000;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-6-background-color {\n  background-color: #000000;\n  background-image: none;\n}\n.wp-block-button .wp-block-button__link.has-colibri-color-6-background-color:hover,.wp-block-button .wp-block-button__link.has-colibri-color-6-background-color:focus,.wp-block-button .wp-block-button__link.has-colibri-color-6-background-color:active {\n  background-color: rgb(51, 51, 51);\n  background-image: none;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-6-background-color {\n  color: #000000;\n  background-color: transparent;\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #000000;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #000000;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #000000;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #000000;\n  border-left-style: solid;\n}\n.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-6-background-color:hover,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-6-background-color:focus,.wp-block-button.is-style-outline .wp-block-button__link.has-colibri-color-6-background-color:active {\n  color: #fff;\n  background-color: #000000;\n  background-image: none;\n}\n*[class^=\"wp-block-\"].has-colibri-color-6-background-color,*[class^=\"wp-block-\"] .has-colibri-color-6-background-color,*[class^=\"wp-block-\"].is-style-solid-color.has-colibri-color-6-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-6-color,*[class^=\"wp-block-\"].is-style-solid-color blockquote.has-colibri-color-6-color p {\n  background-color: #000000;\n  background-image: none;\n}\n.has-colibri-color-6-color {\n  color: #000000;\n}\n#colibri .woocommerce-store-notice,#colibri.woocommerce .content .h-section input[type=submit],#colibri.woocommerce-page  .content .h-section  input[type=button],#colibri.woocommerce .content .h-section  input[type=button],#colibri.woocommerce-page  .content .h-section .button,#colibri.woocommerce .content .h-section .button,#colibri.woocommerce-page  .content .h-section  a.button,#colibri.woocommerce .content .h-section  a.button,#colibri.woocommerce-page  .content .h-section button.button,#colibri.woocommerce .content .h-section button.button,#colibri.woocommerce-page  .content .h-section input.button,#colibri.woocommerce .content .h-section input.button,#colibri.woocommerce-page  .content .h-section input#submit,#colibri.woocommerce .content .h-section input#submit,#colibri.woocommerce-page  .content .h-section a.added_to_cart,#colibri.woocommerce .content .h-section a.added_to_cart,#colibri.woocommerce-page  .content .h-section .ui-slider-range,#colibri.woocommerce .content .h-section .ui-slider-range,#colibri.woocommerce-page  .content .h-section .ui-slider-handle,#colibri.woocommerce .content .h-section .ui-slider-handle,#colibri.woocommerce-page  .content .h-section .wc-block-cart__submit-button,#colibri.woocommerce .content .h-section .wc-block-cart__submit-button,#colibri.woocommerce-page  .content .h-section .wc-block-components-checkout-place-order-button,#colibri.woocommerce .content .h-section .wc-block-components-checkout-place-order-button {\n  background-color: #03a9f4;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n}\n#colibri .woocommerce-store-notice:hover,#colibri .woocommerce-store-notice:focus,#colibri .woocommerce-store-notice:active,#colibri.woocommerce .content .h-section input[type=submit]:hover,#colibri.woocommerce .content .h-section input[type=submit]:focus,#colibri.woocommerce .content .h-section input[type=submit]:active,#colibri.woocommerce-page  .content .h-section  input[type=button]:hover,#colibri.woocommerce-page  .content .h-section  input[type=button]:focus,#colibri.woocommerce-page  .content .h-section  input[type=button]:active,#colibri.woocommerce .content .h-section  input[type=button]:hover,#colibri.woocommerce .content .h-section  input[type=button]:focus,#colibri.woocommerce .content .h-section  input[type=button]:active,#colibri.woocommerce-page  .content .h-section .button:hover,#colibri.woocommerce-page  .content .h-section .button:focus,#colibri.woocommerce-page  .content .h-section .button:active,#colibri.woocommerce .content .h-section .button:hover,#colibri.woocommerce .content .h-section .button:focus,#colibri.woocommerce .content .h-section .button:active,#colibri.woocommerce-page  .content .h-section  a.button:hover,#colibri.woocommerce-page  .content .h-section  a.button:focus,#colibri.woocommerce-page  .content .h-section  a.button:active,#colibri.woocommerce .content .h-section  a.button:hover,#colibri.woocommerce .content .h-section  a.button:focus,#colibri.woocommerce .content .h-section  a.button:active,#colibri.woocommerce-page  .content .h-section button.button:hover,#colibri.woocommerce-page  .content .h-section button.button:focus,#colibri.woocommerce-page  .content .h-section button.button:active,#colibri.woocommerce .content .h-section button.button:hover,#colibri.woocommerce .content .h-section button.button:focus,#colibri.woocommerce .content .h-section button.button:active,#colibri.woocommerce-page  .content .h-section input.button:hover,#colibri.woocommerce-page  .content .h-section input.button:focus,#colibri.woocommerce-page  .content .h-section input.button:active,#colibri.woocommerce .content .h-section input.button:hover,#colibri.woocommerce .content .h-section input.button:focus,#colibri.woocommerce .content .h-section input.button:active,#colibri.woocommerce-page  .content .h-section input#submit:hover,#colibri.woocommerce-page  .content .h-section input#submit:focus,#colibri.woocommerce-page  .content .h-section input#submit:active,#colibri.woocommerce .content .h-section input#submit:hover,#colibri.woocommerce .content .h-section input#submit:focus,#colibri.woocommerce .content .h-section input#submit:active,#colibri.woocommerce-page  .content .h-section a.added_to_cart:hover,#colibri.woocommerce-page  .content .h-section a.added_to_cart:focus,#colibri.woocommerce-page  .content .h-section a.added_to_cart:active,#colibri.woocommerce .content .h-section a.added_to_cart:hover,#colibri.woocommerce .content .h-section a.added_to_cart:focus,#colibri.woocommerce .content .h-section a.added_to_cart:active,#colibri.woocommerce-page  .content .h-section .ui-slider-range:hover,#colibri.woocommerce-page  .content .h-section .ui-slider-range:focus,#colibri.woocommerce-page  .content .h-section .ui-slider-range:active,#colibri.woocommerce .content .h-section .ui-slider-range:hover,#colibri.woocommerce .content .h-section .ui-slider-range:focus,#colibri.woocommerce .content .h-section .ui-slider-range:active,#colibri.woocommerce-page  .content .h-section .ui-slider-handle:hover,#colibri.woocommerce-page  .content .h-section .ui-slider-handle:focus,#colibri.woocommerce-page  .content .h-section .ui-slider-handle:active,#colibri.woocommerce .content .h-section .ui-slider-handle:hover,#colibri.woocommerce .content .h-section .ui-slider-handle:focus,#colibri.woocommerce .content .h-section .ui-slider-handle:active,#colibri.woocommerce-page  .content .h-section .wc-block-cart__submit-button:hover,#colibri.woocommerce-page  .content .h-section .wc-block-cart__submit-button:focus,#colibri.woocommerce-page  .content .h-section .wc-block-cart__submit-button:active,#colibri.woocommerce .content .h-section .wc-block-cart__submit-button:hover,#colibri.woocommerce .content .h-section .wc-block-cart__submit-button:focus,#colibri.woocommerce .content .h-section .wc-block-cart__submit-button:active,#colibri.woocommerce-page  .content .h-section .wc-block-components-checkout-place-order-button:hover,#colibri.woocommerce-page  .content .h-section .wc-block-components-checkout-place-order-button:focus,#colibri.woocommerce-page  .content .h-section .wc-block-components-checkout-place-order-button:active,#colibri.woocommerce .content .h-section .wc-block-components-checkout-place-order-button:hover,#colibri.woocommerce .content .h-section .wc-block-components-checkout-place-order-button:focus,#colibri.woocommerce .content .h-section .wc-block-components-checkout-place-order-button:active {\n  background-color: rgb(2, 110, 159);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: rgb(2, 110, 159);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(2, 110, 159);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(2, 110, 159);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(2, 110, 159);\n  border-left-style: solid;\n}\n#colibri.woocommerce-page  .content .h-section .star-rating::before,#colibri.woocommerce .content .h-section .star-rating::before,#colibri.woocommerce-page  .content .h-section .star-rating span::before,#colibri.woocommerce .content .h-section .star-rating span::before {\n  color: #03a9f4;\n}\n#colibri.woocommerce-page  .content .h-section .price,#colibri.woocommerce .content .h-section .price {\n  color: #03a9f4;\n}\n#colibri.woocommerce-page  .content .h-section .price del,#colibri.woocommerce .content .h-section .price del {\n  color: rgb(84, 194, 244);\n}\n#colibri.woocommerce-page  .content .h-section .onsale,#colibri.woocommerce .content .h-section .onsale {\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri.woocommerce-page  .content .h-section .onsale:hover,#colibri.woocommerce-page  .content .h-section .onsale:focus,#colibri.woocommerce-page  .content .h-section .onsale:active,#colibri.woocommerce .content .h-section .onsale:hover,#colibri.woocommerce .content .h-section .onsale:focus,#colibri.woocommerce .content .h-section .onsale:active {\n  background-color: rgb(2, 110, 159);\n  background-image: none;\n}\n#colibri.woocommerce ul.products li.product h2:hover {\n  color: #03a9f4;\n}\n#colibri.woocommerce-page  .content .h-section .woocommerce-pagination .page-numbers.current,#colibri.woocommerce .content .h-section .woocommerce-pagination .page-numbers.current,#colibri.woocommerce-page  .content .h-section .woocommerce-pagination a.page-numbers:hover,#colibri.woocommerce .content .h-section .woocommerce-pagination a.page-numbers:hover {\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri.woocommerce-page  .content .h-section .comment-form-rating .stars a,#colibri.woocommerce .content .h-section .comment-form-rating .stars a {\n  color: #03a9f4;\n}\n.h-section-global-spacing {\n  padding-top: 63px;\n  padding-bottom: 63px;\n}\n#colibri .colibri-language-switcher {\n  background-color: white;\n  background-image: none;\n  top: 80px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 4px;\n  border-top-right-radius: 0px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 4px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .colibri-language-switcher .lang-item {\n  padding-top: 14px;\n  padding-right: 18px;\n  padding-bottom: 14px;\n  padding-left: 18px;\n}\nbody {\n  font-family: Source Sans Pro;\n  font-weight: 400;\n  font-size: 16px;\n  line-height: 1.6;\n  color: #000000;\n}\nbody a {\n  font-family: Source Sans Pro;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 1em;\n  line-height: 1.5;\n  color: #03a9f4;\n}\nbody p {\n  margin-bottom: 16px;\n  font-family: Source Sans Pro;\n  font-weight: 400;\n  font-size: 16px;\n  line-height: 1.6;\n  color: #000000;\n}\nbody .h-lead p {\n  margin-bottom: 16px;\n  font-family: Source Sans Pro;\n  font-weight: 600;\n  font-size: 1.1em;\n  line-height: 1.5;\n  color: #03a9f4;\n}\nbody blockquote p {\n  margin-bottom: 16px;\n  font-family: Source Sans Pro;\n  font-weight: 400;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(153, 153, 153);\n}\nbody h1 {\n  margin-bottom: 16px;\n  font-family: Source Sans Pro;\n  font-weight: 700;\n  font-size: 3.375em;\n  line-height: 1.26;\n  color: rgb(51, 51, 51);\n}\nbody h2 {\n  margin-bottom: 16px;\n  font-family: Source Sans Pro;\n  font-weight: 600;\n  font-size: 2.625em;\n  line-height: 1.143;\n  color: rgb(51, 51, 51);\n}\nbody h3 {\n  margin-bottom: 16px;\n  font-family: Source Sans Pro;\n  font-weight: 600;\n  font-size: 2.25em;\n  line-height: 1.25;\n  color: #03a9f4;\n}\nbody h4 {\n  margin-bottom: 16px;\n  font-family: Source Sans Pro;\n  font-weight: 600;\n  font-size: 1.25em;\n  line-height: 1.6;\n  color: rgb(51, 51, 51);\n}\nbody h5 {\n  margin-bottom: 16px;\n  font-family: Source Sans Pro;\n  font-weight: 600;\n  font-size: 1.125em;\n  line-height: 1.55;\n  color: rgb(51, 51, 51);\n}\nbody h6 {\n  margin-bottom: 16px;\n  font-family: Source Sans Pro;\n  font-weight: 600;\n  font-size: 1em;\n  line-height: 1.6;\n  color: rgb(51, 51, 51);\n}\n\r\n\r\n@media (min-width: 768px) and (max-width: 1023px){\r\n.h-section-global-spacing {\n  padding-top: 60px;\n  padding-bottom: 60px;\n}\n\r\n}\n\r\n@media (max-width: 767px){\r\n.h-section-global-spacing {\n  padding-top: 30px;\n  padding-bottom: 30px;\n}\n\r\n}\n\";s:6:\"medias\";a:3:{s:7:\"desktop\";a:6:{s:2:\"id\";s:7:\"desktop\";s:5:\"label\";s:7:\"desktop\";s:4:\"icon\";s:15:\"desktop_windows\";s:4:\"show\";b:1;s:4:\"main\";b:1;s:10:\"gridPrefix\";s:2:\"lg\";}s:6:\"tablet\";a:7:{s:2:\"id\";s:6:\"tablet\";s:5:\"label\";s:6:\"tablet\";s:4:\"icon\";s:14:\"tablet_android\";s:4:\"show\";b:0;s:5:\"width\";i:1024;s:10:\"gridPrefix\";s:2:\"md\";s:5:\"query\";s:49:\"@media (min-width: 768px) and (max-width: 1023px)\";}s:6:\"mobile\";a:6:{s:2:\"id\";s:6:\"mobile\";s:5:\"label\";s:6:\"mobile\";s:4:\"icon\";s:13:\"phone_android\";s:4:\"show\";b:0;s:5:\"width\";i:480;s:5:\"query\";s:25:\"@media (max-width: 767px)\";}}s:8:\"defaults\";a:1:{s:8:\"partials\";a:4:{s:7:\"sidebar\";a:8:{s:10:\"front_page\";i:-1;s:4:\"page\";i:-1;s:4:\"post\";i:2040;s:12:\"archive_post\";i:-1;s:4:\"docs\";i:-1;s:12:\"archive_docs\";i:-1;s:7:\"product\";i:2433;s:15:\"archive_product\";i:-1;}s:6:\"header\";a:8:{s:10:\"front_page\";i:2896;s:4:\"page\";i:-1;s:4:\"post\";i:10;s:12:\"archive_post\";i:-1;s:4:\"docs\";i:-1;s:12:\"archive_docs\";i:-1;s:7:\"product\";i:-1;s:15:\"archive_product\";i:-1;}s:6:\"footer\";a:8:{s:10:\"front_page\";i:-1;s:4:\"page\";i:-1;s:4:\"post\";i:13;s:12:\"archive_post\";i:-1;s:4:\"docs\";i:-1;s:12:\"archive_docs\";i:-1;s:7:\"product\";i:-1;s:15:\"archive_product\";i:-1;}s:4:\"main\";a:6:{i:404;i:2106;s:4:\"post\";i:2034;s:7:\"archive\";i:2037;s:15:\"archive_product\";i:-1;s:7:\"product\";i:-1;s:6:\"search\";i:2109;}}}s:12:\"widget_areas\";a:10:{s:20:\"header-widget-area-1\";a:3:{s:4:\"name\";s:20:\"Header widget area 1\";s:5:\"index\";i:1;s:4:\"type\";s:6:\"header\";}s:20:\"header-widget-area-2\";a:3:{s:4:\"name\";s:20:\"Header widget area 2\";s:5:\"index\";i:2;s:4:\"type\";s:6:\"header\";}s:20:\"header-widget-area-3\";a:3:{s:4:\"name\";s:20:\"Header widget area 3\";s:5:\"index\";i:3;s:4:\"type\";s:6:\"header\";}s:21:\"content-widget-area-1\";a:3:{s:4:\"name\";s:21:\"In page widget area 1\";s:5:\"index\";i:1;s:4:\"type\";s:7:\"content\";}s:21:\"content-widget-area-2\";a:3:{s:4:\"name\";s:21:\"In page widget area 2\";s:5:\"index\";i:2;s:4:\"type\";s:7:\"content\";}s:21:\"content-widget-area-3\";a:3:{s:4:\"name\";s:21:\"In page widget area 3\";s:5:\"index\";i:3;s:4:\"type\";s:7:\"content\";}s:20:\"footer-widget-area-1\";a:3:{s:4:\"name\";s:20:\"Footer widget area 1\";s:5:\"index\";i:1;s:4:\"type\";s:6:\"footer\";}s:20:\"footer-widget-area-2\";a:3:{s:4:\"name\";s:20:\"Footer widget area 2\";s:5:\"index\";i:2;s:4:\"type\";s:6:\"footer\";}s:20:\"footer-widget-area-3\";a:3:{s:4:\"name\";s:20:\"Footer widget area 3\";s:5:\"index\";i:3;s:4:\"type\";s:6:\"footer\";}s:20:\"footer-widget-area-4\";a:3:{s:4:\"name\";s:20:\"Footer widget area 4\";s:5:\"index\";i:4;s:4:\"type\";s:6:\"footer\";}}s:8:\"imported\";a:10:{s:18:\"theme_default_data\";b:1;s:17:\"header/front_page\";b:1;s:11:\"header/post\";b:1;s:11:\"footer/post\";b:1;s:9:\"main/post\";b:1;s:12:\"main/archive\";b:1;s:8:\"main/404\";b:1;s:11:\"main/search\";b:1;s:12:\"sidebar/post\";b:1;s:15:\"sidebar/product\";b:1;}s:13:\"colorVariants\";a:6:{i:0;a:5:{i:0;s:7:\"#a6dcf4\";i:1;s:7:\"#54c2f4\";i:2;s:7:\"#03a9f4\";i:3;s:7:\"#026e9f\";i:4;s:7:\"#01334a\";}i:1;a:5:{i:0;s:7:\"#f7d7ac\";i:1;s:7:\"#f7b359\";i:2;s:7:\"#f79007\";i:3;s:7:\"#a25e05\";i:4;s:7:\"#4d2d02\";}i:2;a:5:{i:0;s:7:\"#7fbfac\";i:1;s:7:\"#40bf9a\";i:2;s:7:\"#00bf87\";i:3;s:7:\"#006a4b\";i:4;s:7:\"#00150f\";}i:3;a:5:{i:0;s:7:\"#e5dcff\";i:1;s:7:\"#a587ff\";i:2;s:7:\"#6632ff\";i:3;s:7:\"#4421aa\";i:4;s:7:\"#221155\";}i:4;a:5:{i:0;s:7:\"#ffffff\";i:1;s:7:\"#cccccc\";i:2;s:7:\"#999999\";i:3;s:7:\"#666666\";i:4;s:7:\"#333333\";}i:5;a:5:{i:0;s:7:\"#cccccc\";i:1;s:7:\"#999999\";i:2;s:7:\"#666666\";i:3;s:7:\"#333333\";i:4;s:7:\"#000000\";}}s:4:\"urls\";a:2:{s:19:\"colibri_uploads_url\";s:40:\"http://localhost/site/wp-content/uploads\";s:16:\"colibri_home_url\";s:22:\"http://localhost/site/\";}s:14:\"cssByPartialId\";a:40:{i:5;a:35:{s:10:\"local-5-c4\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:49:\"#colibri .style-local-5-c4-outer {\n  order: 1;\n}\n\";s:6:\"mobile\";s:105:\"#colibri .style-local-5-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 1;\n}\n\";}s:10:\"local-5-c6\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:49:\"#colibri .style-local-5-c6-outer {\n  order: 2;\n}\n\";s:6:\"mobile\";s:105:\"#colibri .style-local-5-c6-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 2;\n}\n\";}s:10:\"local-5-c8\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:49:\"#colibri .style-local-5-c8-outer {\n  order: 3;\n}\n\";s:6:\"mobile\";s:105:\"#colibri .style-local-5-c8-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}s:11:\"local-5-c10\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:50:\"#colibri .style-local-5-c10-outer {\n  order: 4;\n}\n\";s:6:\"mobile\";s:106:\"#colibri .style-local-5-c10-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 4;\n}\n\";}s:11:\"local-5-c14\";a:3:{s:7:\"desktop\";s:93:\"#colibri .style-local-5-c14-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:54:\"#colibri .style-local-5-c14-outer {\n  width: 100% ;\n}\n\";s:6:\"mobile\";s:54:\"#colibri .style-local-5-c14-outer {\n  width: 100% ;\n}\n\";}s:11:\"local-5-c21\";a:2:{s:7:\"desktop\";s:93:\"#colibri .style-local-5-c21-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:54:\"#colibri .style-local-5-c21-outer {\n  width: 100% ;\n}\n\";}s:11:\"local-5-c22\";a:1:{s:7:\"desktop\";s:0:\"\";}s:11:\"local-5-c17\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-5-c17-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c25\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-5-c25-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c36\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:50:\"#colibri .style-local-5-c36-outer {\n  order: 2;\n}\n\";s:6:\"mobile\";s:106:\"#colibri .style-local-5-c36-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 2;\n}\n\";}s:11:\"local-5-c47\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:50:\"#colibri .style-local-5-c47-outer {\n  order: 2;\n}\n\";s:6:\"mobile\";s:106:\"#colibri .style-local-5-c47-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 2;\n}\n\";}s:11:\"local-5-c59\";a:2:{s:7:\"desktop\";s:93:\"#colibri .style-local-5-c59-outer {\n  width: 80% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:54:\"#colibri .style-local-5-c59-outer {\n  width: 100% ;\n}\n\";}s:11:\"local-5-c31\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-5-c31-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c42\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-5-c42-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c53\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-5-c53-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c65\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-5-c65-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c73\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-5-c73-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c81\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-5-c81-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c89\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-5-c89-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c67\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-5-c67-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c75\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-5-c75-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c83\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-5-c83-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c91\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-5-c91-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c70\";a:1:{s:7:\"desktop\";s:93:\"#colibri .style-local-5-c70-outer {\n  width: 60% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c78\";a:1:{s:7:\"desktop\";s:93:\"#colibri .style-local-5-c78-outer {\n  width: 60% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c86\";a:1:{s:7:\"desktop\";s:93:\"#colibri .style-local-5-c86-outer {\n  width: 60% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c94\";a:1:{s:7:\"desktop\";s:93:\"#colibri .style-local-5-c94-outer {\n  width: 60% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-5-c98\";a:2:{s:7:\"desktop\";s:93:\"#colibri .style-local-5-c98-outer {\n  width: 80% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:54:\"#colibri .style-local-5-c98-outer {\n  width: 100% ;\n}\n\";}s:12:\"local-5-c104\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-5-c104-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-5-c106\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-5-c106-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"dynamic-5-c107\";a:1:{s:7:\"desktop\";s:60:\".site .style-dynamic-5-c107-height {\n  min-height: 300px;\n}\n\";}s:12:\"local-5-c109\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-5-c109-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-5-c114\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-5-c116\";a:1:{s:7:\"desktop\";s:0:\"\";}s:12:\"local-5-c120\";a:2:{s:7:\"desktop\";s:94:\"#colibri .style-local-5-c120-outer {\n  width: 80% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-5-c120-outer {\n  width: 100% ;\n}\n\";}}i:7;a:12:{s:10:\"local-7-h4\";a:3:{s:7:\"desktop\";s:296:\"#colibri .style-local-7-h4-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n#colibri .h-navigation_sticky .style-local-7-h4-outer,#colibri .h-navigation_sticky.style-local-7-h4-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:49:\"#colibri .style-local-7-h4-outer {\n  order: 1;\n}\n\";s:6:\"mobile\";s:230:\"#colibri .style-local-7-h4-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  order: 1;\n}\n#colibri .h-navigation_sticky .style-local-7-h4-outer,#colibri .h-navigation_sticky.style-local-7-h4-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n}\n\";}s:11:\"local-7-h12\";a:3:{s:7:\"desktop\";s:112:\"#colibri .style-local-7-h12-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:50:\"#colibri .style-local-7-h12-outer {\n  order: 5;\n}\n\";s:6:\"mobile\";s:85:\"#colibri .style-local-7-h12-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  order: 5;\n}\n\";}s:11:\"local-7-h39\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:50:\"#colibri .style-local-7-h39-outer {\n  order: 2;\n}\n\";s:6:\"mobile\";s:94:\"#colibri .style-local-7-h39-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-7-h15\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-7-h15-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-7-h21\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-7-h21-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-7-h24\";a:1:{s:7:\"desktop\";s:94:\"#colibri .style-local-7-h24-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:10:\"local-7-h9\";a:3:{s:7:\"desktop\";s:111:\"#colibri .style-local-7-h9-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:49:\"#colibri .style-local-7-h9-outer {\n  order: 4;\n}\n\";s:6:\"mobile\";s:65:\"#colibri .style-local-7-h9-outer {\n  width: 100% ;\n  order: 4;\n}\n\";}s:10:\"local-7-h7\";a:3:{s:7:\"desktop\";s:111:\"#colibri .style-local-7-h7-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:49:\"#colibri .style-local-7-h7-outer {\n  order: 3;\n}\n\";s:6:\"mobile\";s:65:\"#colibri .style-local-7-h7-outer {\n  width: 100% ;\n  order: 3;\n}\n\";}s:10:\"local-7-h6\";a:3:{s:7:\"desktop\";s:91:\"#colibri .style-local-7-h6-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:49:\"#colibri .style-local-7-h6-outer {\n  order: 2;\n}\n\";s:6:\"mobile\";s:105:\"#colibri .style-local-7-h6-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 2;\n}\n\";}s:11:\"local-7-h28\";a:3:{s:7:\"desktop\";s:95:\"#colibri .style-local-7-h28-outer {\n  width: 400px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:67:\"#colibri .style-local-7-h28-outer {\n  width: 300px ;\n  order: 1;\n}\n\";s:6:\"mobile\";s:66:\"#colibri .style-local-7-h28-outer {\n  width: 100% ;\n  order: 2;\n}\n\";}s:11:\"local-7-h34\";a:2:{s:7:\"desktop\";s:94:\"#colibri .style-local-7-h34-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:53:\"#colibri .style-local-7-h34-outer {\n  width: 50% ;\n}\n\";}s:11:\"local-7-h37\";a:2:{s:7:\"desktop\";s:94:\"#colibri .style-local-7-h37-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:53:\"#colibri .style-local-7-h37-outer {\n  width: 50% ;\n}\n\";}}i:10;a:11:{s:11:\"local-10-h4\";a:3:{s:7:\"desktop\";s:299:\"#colibri .style-local-10-h4-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n#colibri .h-navigation_sticky .style-local-10-h4-outer,#colibri .h-navigation_sticky.style-local-10-h4-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:50:\"#colibri .style-local-10-h4-outer {\n  order: 1;\n}\n\";s:6:\"mobile\";s:233:\"#colibri .style-local-10-h4-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  order: 1;\n}\n#colibri .h-navigation_sticky .style-local-10-h4-outer,#colibri .h-navigation_sticky.style-local-10-h4-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n}\n\";}s:12:\"local-10-h12\";a:3:{s:7:\"desktop\";s:113:\"#colibri .style-local-10-h12-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:51:\"#colibri .style-local-10-h12-outer {\n  order: 5;\n}\n\";s:6:\"mobile\";s:86:\"#colibri .style-local-10-h12-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  order: 5;\n}\n\";}s:12:\"local-10-h15\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-10-h15-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-10-h21\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-10-h21-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-10-h24\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-10-h24-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-10-h9\";a:3:{s:7:\"desktop\";s:112:\"#colibri .style-local-10-h9-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:50:\"#colibri .style-local-10-h9-outer {\n  order: 4;\n}\n\";s:6:\"mobile\";s:66:\"#colibri .style-local-10-h9-outer {\n  width: 100% ;\n  order: 4;\n}\n\";}s:11:\"local-10-h7\";a:3:{s:7:\"desktop\";s:112:\"#colibri .style-local-10-h7-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:50:\"#colibri .style-local-10-h7-outer {\n  order: 3;\n}\n\";s:6:\"mobile\";s:66:\"#colibri .style-local-10-h7-outer {\n  width: 100% ;\n  order: 3;\n}\n\";}s:11:\"local-10-h6\";a:3:{s:7:\"desktop\";s:92:\"#colibri .style-local-10-h6-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:50:\"#colibri .style-local-10-h6-outer {\n  order: 2;\n}\n\";s:6:\"mobile\";s:106:\"#colibri .style-local-10-h6-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 2;\n}\n\";}s:12:\"local-10-h27\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-10-h27-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-10-h33\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-10-h33-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-10-h36\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-10-h36-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:13;a:5:{s:11:\"local-13-f4\";a:3:{s:7:\"desktop\";s:93:\"#colibri .style-local-13-f4-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:65:\"#colibri .style-local-13-f4-outer {\n  width: 25% ;\n  order: 1;\n}\n\";s:6:\"mobile\";s:66:\"#colibri .style-local-13-f4-outer {\n  width: 100% ;\n  order: 1;\n}\n\";}s:11:\"local-13-f9\";a:3:{s:7:\"desktop\";s:93:\"#colibri .style-local-13-f9-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:65:\"#colibri .style-local-13-f9-outer {\n  width: 25% ;\n  order: 2;\n}\n\";s:6:\"mobile\";s:66:\"#colibri .style-local-13-f9-outer {\n  width: 100% ;\n  order: 2;\n}\n\";}s:12:\"local-13-f20\";a:3:{s:7:\"desktop\";s:94:\"#colibri .style-local-13-f20-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:67:\"#colibri .style-local-13-f20-outer {\n  width: 100% ;\n  order: 5;\n}\n\";s:6:\"mobile\";s:67:\"#colibri .style-local-13-f20-outer {\n  width: 100% ;\n  order: 5;\n}\n\";}s:12:\"local-13-f28\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-13-f28-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-13-f36\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-13-f36-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:22;a:1:{s:11:\"local-22-m3\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-22-m3-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:25;a:5:{s:11:\"local-25-m3\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-25-m3-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:11:\"local-25-m5\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:94:\"#colibri .style-local-25-m5-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-25-m14\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:51:\"#colibri .style-local-25-m14-outer {\n  order: 3;\n}\n\";s:6:\"mobile\";s:107:\"#colibri .style-local-25-m14-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}s:12:\"local-25-m16\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:51:\"#colibri .style-local-25-m16-outer {\n  order: 2;\n}\n\";s:6:\"mobile\";s:107:\"#colibri .style-local-25-m16-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 2;\n}\n\";}s:12:\"local-25-m18\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:51:\"#colibri .style-local-25-m18-outer {\n  order: 3;\n}\n\";s:6:\"mobile\";s:107:\"#colibri .style-local-25-m18-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}}i:148;a:12:{s:12:\"local-148-c4\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-148-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-148-c15\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-148-c15-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-148-c26\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-148-c26-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-148-c37\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-148-c37-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-148-c48\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-148-c48-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-148-c59\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-148-c59-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-148-c10\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-148-c10-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-148-c21\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-148-c21-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-148-c32\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-148-c32-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-148-c43\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-148-c43-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-148-c54\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-148-c54-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-148-c65\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-148-c65-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:149;a:9:{s:12:\"local-149-c4\";a:2:{s:7:\"desktop\";s:94:\"#colibri .style-local-149-c4-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-149-c4-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-149-c10\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-149-c10-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-149-c10-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-149-c13\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-149-c13-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-149-c19\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:52:\"#colibri .style-local-149-c19-outer {\n  order: 5;\n}\n\";s:6:\"mobile\";s:108:\"#colibri .style-local-149-c19-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 5;\n}\n\";}s:13:\"local-149-c25\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:52:\"#colibri .style-local-149-c25-outer {\n  order: 6;\n}\n\";s:6:\"mobile\";s:108:\"#colibri .style-local-149-c25-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 6;\n}\n\";}s:13:\"local-149-c32\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-149-c32-outer {\n  width: 80% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-149-c32-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-149-c14\";a:1:{s:7:\"desktop\";s:0:\"\";}s:13:\"local-149-c20\";a:1:{s:7:\"desktop\";s:0:\"\";}s:13:\"local-149-c26\";a:1:{s:7:\"desktop\";s:0:\"\";}}i:150;a:2:{s:12:\"local-150-c4\";a:3:{s:7:\"desktop\";s:94:\"#colibri .style-local-150-c4-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:51:\"#colibri .style-local-150-c4-outer {\n  order: 1;\n}\n\";s:6:\"mobile\";s:67:\"#colibri .style-local-150-c4-outer {\n  width: 100% ;\n  order: 1;\n}\n\";}s:12:\"local-150-c8\";a:3:{s:7:\"desktop\";s:94:\"#colibri .style-local-150-c8-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:51:\"#colibri .style-local-150-c8-outer {\n  order: 2;\n}\n\";s:6:\"mobile\";s:67:\"#colibri .style-local-150-c8-outer {\n  width: 100% ;\n  order: 2;\n}\n\";}}i:151;a:4:{s:12:\"local-151-c4\";a:2:{s:7:\"desktop\";s:94:\"#colibri .style-local-151-c4-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:67:\"#colibri .style-local-151-c4-outer {\n  width: 100% ;\n  order: 2;\n}\n\";}s:12:\"local-151-c9\";a:2:{s:7:\"desktop\";s:94:\"#colibri .style-local-151-c9-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:67:\"#colibri .style-local-151-c9-outer {\n  width: 100% ;\n  order: 1;\n}\n\";}s:13:\"local-151-c12\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-151-c12-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-151-c12-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-151-c13\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-151-c13-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-151-c13-outer {\n  width: 100% ;\n}\n\";}}i:170;a:1:{s:12:\"local-170-c4\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-170-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:171;a:18:{s:12:\"local-171-c4\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:107:\"#colibri .style-local-171-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 1;\n}\n\";}s:13:\"local-171-c15\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:53:\"#colibri .style-local-171-c15-outer {\n  order: 11;\n}\n\";s:6:\"mobile\";s:108:\"#colibri .style-local-171-c15-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 2;\n}\n\";}s:13:\"local-171-c26\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:53:\"#colibri .style-local-171-c26-outer {\n  order: 10;\n}\n\";s:6:\"mobile\";s:108:\"#colibri .style-local-171-c26-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}s:13:\"local-171-c37\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:52:\"#colibri .style-local-171-c37-outer {\n  order: 9;\n}\n\";s:6:\"mobile\";s:108:\"#colibri .style-local-171-c37-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 4;\n}\n\";}s:13:\"local-171-c48\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:52:\"#colibri .style-local-171-c48-outer {\n  order: 8;\n}\n\";s:6:\"mobile\";s:108:\"#colibri .style-local-171-c48-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 5;\n}\n\";}s:13:\"local-171-c59\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:52:\"#colibri .style-local-171-c59-outer {\n  order: 7;\n}\n\";s:6:\"mobile\";s:108:\"#colibri .style-local-171-c59-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 6;\n}\n\";}s:12:\"local-171-c6\";a:3:{s:7:\"desktop\";s:96:\"#colibri .style-local-171-c6-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:55:\"#colibri .style-local-171-c6-outer {\n  width: 80px ;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-171-c6-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-171-c17\";a:3:{s:7:\"desktop\";s:97:\"#colibri .style-local-171-c17-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:56:\"#colibri .style-local-171-c17-outer {\n  width: 80px ;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-171-c17-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-171-c28\";a:3:{s:7:\"desktop\";s:97:\"#colibri .style-local-171-c28-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:56:\"#colibri .style-local-171-c28-outer {\n  width: 80px ;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-171-c28-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-171-c39\";a:3:{s:7:\"desktop\";s:97:\"#colibri .style-local-171-c39-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:56:\"#colibri .style-local-171-c39-outer {\n  width: 80px ;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-171-c39-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-171-c50\";a:3:{s:7:\"desktop\";s:97:\"#colibri .style-local-171-c50-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:56:\"#colibri .style-local-171-c50-outer {\n  width: 80px ;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-171-c50-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-171-c61\";a:3:{s:7:\"desktop\";s:97:\"#colibri .style-local-171-c61-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:56:\"#colibri .style-local-171-c61-outer {\n  width: 50px ;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-171-c61-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-171-c11\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-171-c11-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-171-c22\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-171-c22-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-171-c33\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-171-c33-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-171-c44\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-171-c44-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-171-c55\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-171-c55-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-171-c66\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-171-c66-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:172;a:24:{s:12:\"local-172-c4\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-172-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c19\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-172-c19-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c34\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-172-c34-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c49\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-172-c49-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c21\";a:2:{s:7:\"desktop\";s:97:\"#colibri .style-local-172-c21-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-172-c21-outer {\n  width: 100% ;\n}\n\";}s:12:\"local-172-c7\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-172-c7-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c22\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-172-c22-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c37\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-172-c37-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c52\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-172-c52-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c15\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:92:\"#colibri .style-local-172-c15-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";s:6:\"mobile\";s:108:\"#colibri .style-local-172-c15-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}s:13:\"local-172-c30\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:92:\"#colibri .style-local-172-c30-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";s:6:\"mobile\";s:108:\"#colibri .style-local-172-c30-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}s:13:\"local-172-c45\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:92:\"#colibri .style-local-172-c45-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";s:6:\"mobile\";s:108:\"#colibri .style-local-172-c45-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}s:13:\"local-172-c60\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:92:\"#colibri .style-local-172-c60-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";s:6:\"mobile\";s:108:\"#colibri .style-local-172-c60-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}s:13:\"local-172-c10\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-172-c10-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c25\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-172-c25-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c40\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-172-c40-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c55\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:95:\"#colibri .style-local-172-c55-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c12\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-172-c12-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c27\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-172-c27-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c42\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-172-c42-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-172-c57\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-172-c57-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:12:\"local-172-c6\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-172-c6-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-172-c6-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-172-c36\";a:2:{s:7:\"desktop\";s:97:\"#colibri .style-local-172-c36-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-172-c36-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-172-c51\";a:2:{s:7:\"desktop\";s:97:\"#colibri .style-local-172-c51-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-172-c51-outer {\n  width: 100% ;\n}\n\";}}i:173;a:1:{s:12:\"local-173-c4\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-173-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:174;a:1:{s:12:\"local-174-c4\";a:1:{s:7:\"desktop\";s:95:\"#colibri .style-local-174-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:951;a:5:{s:12:\"local-951-c4\";a:2:{s:7:\"desktop\";s:94:\"#colibri .style-local-951-c4-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-951-c4-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-951-c10\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-951-c10-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-951-c10-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-951-c19\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-951-c19-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-951-c19-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-951-c13\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-951-c13-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-951-c13-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-951-c16\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-951-c16-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2034;a:10:{s:13:\"local-2034-m4\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-2034-m4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:15:\"dynamic-2034-m5\";a:1:{s:7:\"desktop\";s:61:\".site .style-dynamic-2034-m5-height {\n  min-height: 300px;\n}\n\";}s:13:\"local-2034-m7\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2034-m7-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2034-m11\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2034-m13\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2034-m16\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2034-m18\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2034-m21\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2034-m21-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2034-m23\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2034-m23-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2034-m31\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2034-m31-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2037;a:8:{s:13:\"local-2037-m4\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-2037-m4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:15:\"dynamic-2037-m5\";a:1:{s:7:\"desktop\";s:61:\".site .style-dynamic-2037-m5-height {\n  min-height: 300px;\n}\n\";}s:13:\"local-2037-m7\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2037-m7-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2037-m13\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2037-m13-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2037-m15\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2037-m15-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2037-m19\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2037-m21\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2037-m23\";a:1:{s:7:\"desktop\";s:0:\"\";}}i:2040;a:1:{s:13:\"local-2040-s4\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2040-s4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2106;a:1:{s:13:\"local-2106-m3\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-2106-m3-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2109;a:7:{s:13:\"local-2109-m3\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-2109-m3-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-2109-m5\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2109-m5-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2109-m13\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2109-m14\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2109-m16\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2109-m18\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2109-m21\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2109-m21-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2433;a:1:{s:13:\"local-2433-s4\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2433-s4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2896;a:14:{s:13:\"local-2896-h4\";a:3:{s:7:\"desktop\";s:305:\"#colibri .style-local-2896-h4-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n#colibri .h-navigation_sticky .style-local-2896-h4-outer,#colibri .h-navigation_sticky.style-local-2896-h4-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:52:\"#colibri .style-local-2896-h4-outer {\n  order: 1;\n}\n\";s:6:\"mobile\";s:239:\"#colibri .style-local-2896-h4-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  order: 1;\n}\n#colibri .h-navigation_sticky .style-local-2896-h4-outer,#colibri .h-navigation_sticky.style-local-2896-h4-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n}\n\";}s:14:\"local-2896-h12\";a:3:{s:7:\"desktop\";s:115:\"#colibri .style-local-2896-h12-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:53:\"#colibri .style-local-2896-h12-outer {\n  order: 5;\n}\n\";s:6:\"mobile\";s:88:\"#colibri .style-local-2896-h12-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  order: 5;\n}\n\";}s:14:\"local-2896-h30\";a:3:{s:7:\"desktop\";s:99:\"#colibri .style-local-2896-h30-outer {\n  width: 52.12% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:53:\"#colibri .style-local-2896-h30-outer {\n  order: 2;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2896-h30-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2896-h15\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2896-h15-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2896-h21\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2896-h21-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2896-h24\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2896-h24-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-2896-h9\";a:3:{s:7:\"desktop\";s:114:\"#colibri .style-local-2896-h9-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:52:\"#colibri .style-local-2896-h9-outer {\n  order: 4;\n}\n\";s:6:\"mobile\";s:68:\"#colibri .style-local-2896-h9-outer {\n  width: 100% ;\n  order: 4;\n}\n\";}s:13:\"local-2896-h7\";a:3:{s:7:\"desktop\";s:114:\"#colibri .style-local-2896-h7-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  width: auto;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:52:\"#colibri .style-local-2896-h7-outer {\n  order: 3;\n}\n\";s:6:\"mobile\";s:68:\"#colibri .style-local-2896-h7-outer {\n  width: 100% ;\n  order: 3;\n}\n\";}s:13:\"local-2896-h6\";a:3:{s:7:\"desktop\";s:94:\"#colibri .style-local-2896-h6-outer {\n  flex: 1 1 0;\n  -ms-flex: 1 1 0%;\n  max-width: 100%;\n}\n\";s:6:\"tablet\";s:52:\"#colibri .style-local-2896-h6-outer {\n  order: 2;\n}\n\";s:6:\"mobile\";s:108:\"#colibri .style-local-2896-h6-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 2;\n}\n\";}s:14:\"local-2896-h28\";a:3:{s:7:\"desktop\";s:99:\"#colibri .style-local-2896-h28-outer {\n  width: 18.27% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:70:\"#colibri .style-local-2896-h28-outer {\n  width: 300px ;\n  order: 1;\n}\n\";s:6:\"mobile\";s:69:\"#colibri .style-local-2896-h28-outer {\n  width: 100% ;\n  order: 2;\n}\n\";}s:14:\"local-2896-h37\";a:2:{s:7:\"desktop\";s:97:\"#colibri .style-local-2896-h37-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:56:\"#colibri .style-local-2896-h37-outer {\n  width: 50% ;\n}\n\";}s:14:\"local-2896-h40\";a:2:{s:7:\"desktop\";s:97:\"#colibri .style-local-2896-h40-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:56:\"#colibri .style-local-2896-h40-outer {\n  width: 50% ;\n}\n\";}s:14:\"local-2896-h31\";a:2:{s:7:\"desktop\";s:99:\"#colibri .style-local-2896-h31-outer {\n  width: 22.74% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2896-h31-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2896-h29\";a:1:{s:7:\"desktop\";s:82:\"#colibri .style-local-2896-h29-image {\n  max-width: 195px;\n  max-height: 300px;\n}\n\";}}i:2901;a:14:{s:13:\"local-2901-c6\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-2901-c6-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:15:\"dynamic-2901-c7\";a:1:{s:7:\"desktop\";s:61:\".site .style-dynamic-2901-c7-height {\n  min-height: 300px;\n}\n\";}s:13:\"local-2901-c9\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:95:\"#colibri .style-local-2901-c9-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:96:\"#colibri .style-local-2901-c9-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2901-c13\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2901-c15\";a:1:{s:7:\"desktop\";s:0:\"\";}s:13:\"local-2901-c4\";a:3:{s:7:\"desktop\";s:95:\"#colibri .style-local-2901-c4-outer {\n  width: 73% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:55:\"#colibri .style-local-2901-c4-outer {\n  width: 50% ;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-2901-c4-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2901-c18\";a:3:{s:7:\"desktop\";s:96:\"#colibri .style-local-2901-c18-outer {\n  width: 26% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:56:\"#colibri .style-local-2901-c18-outer {\n  width: 50% ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2901-c18-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2901-c36\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2901-c36-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2901-c37\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2901-c37-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2901-c21\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2901-c21-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2901-c23\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2901-c23-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2901-c25\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2901-c25-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2901-c29\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2901-c31\";a:1:{s:7:\"desktop\";s:0:\"\";}}i:2903;a:12:{s:13:\"local-2903-c4\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-2903-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2903-c15\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2903-c15-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2903-c26\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2903-c26-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2903-c37\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2903-c37-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2903-c48\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2903-c48-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2903-c59\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2903-c59-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2903-c10\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2903-c10-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2903-c21\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2903-c21-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2903-c32\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2903-c32-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2903-c43\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2903-c43-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2903-c54\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2903-c54-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2903-c65\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2903-c65-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2904;a:9:{s:13:\"local-2904-c4\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-2904-c4-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-2904-c4-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2904-c10\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-2904-c10-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2904-c10-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2904-c13\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2904-c13-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2904-c19\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:53:\"#colibri .style-local-2904-c19-outer {\n  order: 5;\n}\n\";s:6:\"mobile\";s:109:\"#colibri .style-local-2904-c19-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 5;\n}\n\";}s:14:\"local-2904-c25\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:53:\"#colibri .style-local-2904-c25-outer {\n  order: 6;\n}\n\";s:6:\"mobile\";s:109:\"#colibri .style-local-2904-c25-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 6;\n}\n\";}s:14:\"local-2904-c32\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-2904-c32-outer {\n  width: 80% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2904-c32-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2904-c14\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2904-c20\";a:1:{s:7:\"desktop\";s:0:\"\";}s:14:\"local-2904-c26\";a:1:{s:7:\"desktop\";s:0:\"\";}}i:2905;a:2:{s:13:\"local-2905-c4\";a:3:{s:7:\"desktop\";s:95:\"#colibri .style-local-2905-c4-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:52:\"#colibri .style-local-2905-c4-outer {\n  order: 1;\n}\n\";s:6:\"mobile\";s:68:\"#colibri .style-local-2905-c4-outer {\n  width: 100% ;\n  order: 1;\n}\n\";}s:13:\"local-2905-c8\";a:3:{s:7:\"desktop\";s:95:\"#colibri .style-local-2905-c8-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:52:\"#colibri .style-local-2905-c8-outer {\n  order: 2;\n}\n\";s:6:\"mobile\";s:68:\"#colibri .style-local-2905-c8-outer {\n  width: 100% ;\n  order: 2;\n}\n\";}}i:2906;a:4:{s:13:\"local-2906-c4\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-2906-c4-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:68:\"#colibri .style-local-2906-c4-outer {\n  width: 100% ;\n  order: 2;\n}\n\";}s:13:\"local-2906-c9\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-2906-c9-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:68:\"#colibri .style-local-2906-c9-outer {\n  width: 100% ;\n  order: 1;\n}\n\";}s:14:\"local-2906-c12\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-2906-c12-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2906-c12-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2906-c13\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-2906-c13-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2906-c13-outer {\n  width: 100% ;\n}\n\";}}i:2911;a:1:{s:13:\"local-2911-c4\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2911-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2919;a:18:{s:13:\"local-2919-c4\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:108:\"#colibri .style-local-2919-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 1;\n}\n\";}s:14:\"local-2919-c15\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:54:\"#colibri .style-local-2919-c15-outer {\n  order: 11;\n}\n\";s:6:\"mobile\";s:109:\"#colibri .style-local-2919-c15-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 2;\n}\n\";}s:14:\"local-2919-c26\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:54:\"#colibri .style-local-2919-c26-outer {\n  order: 10;\n}\n\";s:6:\"mobile\";s:109:\"#colibri .style-local-2919-c26-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}s:14:\"local-2919-c37\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:53:\"#colibri .style-local-2919-c37-outer {\n  order: 9;\n}\n\";s:6:\"mobile\";s:109:\"#colibri .style-local-2919-c37-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 4;\n}\n\";}s:14:\"local-2919-c48\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:53:\"#colibri .style-local-2919-c48-outer {\n  order: 8;\n}\n\";s:6:\"mobile\";s:109:\"#colibri .style-local-2919-c48-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 5;\n}\n\";}s:14:\"local-2919-c59\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:53:\"#colibri .style-local-2919-c59-outer {\n  order: 7;\n}\n\";s:6:\"mobile\";s:109:\"#colibri .style-local-2919-c59-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 6;\n}\n\";}s:13:\"local-2919-c6\";a:3:{s:7:\"desktop\";s:97:\"#colibri .style-local-2919-c6-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:56:\"#colibri .style-local-2919-c6-outer {\n  width: 80px ;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-2919-c6-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2919-c17\";a:3:{s:7:\"desktop\";s:98:\"#colibri .style-local-2919-c17-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:57:\"#colibri .style-local-2919-c17-outer {\n  width: 80px ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2919-c17-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2919-c28\";a:3:{s:7:\"desktop\";s:98:\"#colibri .style-local-2919-c28-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:57:\"#colibri .style-local-2919-c28-outer {\n  width: 80px ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2919-c28-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2919-c39\";a:3:{s:7:\"desktop\";s:98:\"#colibri .style-local-2919-c39-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:57:\"#colibri .style-local-2919-c39-outer {\n  width: 80px ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2919-c39-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2919-c50\";a:3:{s:7:\"desktop\";s:98:\"#colibri .style-local-2919-c50-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:57:\"#colibri .style-local-2919-c50-outer {\n  width: 80px ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2919-c50-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2919-c61\";a:3:{s:7:\"desktop\";s:98:\"#colibri .style-local-2919-c61-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:57:\"#colibri .style-local-2919-c61-outer {\n  width: 50px ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2919-c61-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2919-c11\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2919-c11-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2919-c22\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2919-c22-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2919-c33\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2919-c33-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2919-c44\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2919-c44-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2919-c55\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2919-c55-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2919-c66\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2919-c66-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2920;a:24:{s:13:\"local-2920-c4\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2920-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c19\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2920-c19-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c34\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2920-c34-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c49\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2920-c49-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c21\";a:2:{s:7:\"desktop\";s:98:\"#colibri .style-local-2920-c21-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2920-c21-outer {\n  width: 100% ;\n}\n\";}s:13:\"local-2920-c7\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-2920-c7-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c22\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2920-c22-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c37\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2920-c37-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c52\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2920-c52-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c15\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:93:\"#colibri .style-local-2920-c15-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";s:6:\"mobile\";s:109:\"#colibri .style-local-2920-c15-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}s:14:\"local-2920-c30\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:93:\"#colibri .style-local-2920-c30-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";s:6:\"mobile\";s:109:\"#colibri .style-local-2920-c30-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}s:14:\"local-2920-c45\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:93:\"#colibri .style-local-2920-c45-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";s:6:\"mobile\";s:109:\"#colibri .style-local-2920-c45-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}s:14:\"local-2920-c60\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:93:\"#colibri .style-local-2920-c60-outer {\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";s:6:\"mobile\";s:109:\"#colibri .style-local-2920-c60-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n  order: 3;\n}\n\";}s:14:\"local-2920-c10\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-2920-c10-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c25\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-2920-c25-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c40\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-2920-c40-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c55\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-2920-c55-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c12\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2920-c12-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c27\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2920-c27-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c42\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2920-c42-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-2920-c57\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-2920-c57-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-2920-c6\";a:2:{s:7:\"desktop\";s:97:\"#colibri .style-local-2920-c6-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-2920-c6-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2920-c36\";a:2:{s:7:\"desktop\";s:98:\"#colibri .style-local-2920-c36-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2920-c36-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2920-c51\";a:2:{s:7:\"desktop\";s:98:\"#colibri .style-local-2920-c51-outer {\n  width: 150px ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2920-c51-outer {\n  width: 100% ;\n}\n\";}}i:2921;a:1:{s:13:\"local-2921-c4\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2921-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2922;a:1:{s:13:\"local-2922-c4\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-2922-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2923;a:5:{s:13:\"local-2923-c4\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-2923-c4-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-2923-c4-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2923-c10\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-2923-c10-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2923-c10-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2923-c19\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-2923-c19-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2923-c19-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2923-c13\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-2923-c13-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-2923-c13-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-2923-c16\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-2923-c16-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:2993;a:16:{s:15:\"local-2993-c174\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:98:\"#colibri .style-local-2993-c174-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:15:\"local-2993-c168\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:98:\"#colibri .style-local-2993-c168-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:15:\"local-2993-c180\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:98:\"#colibri .style-local-2993-c180-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:15:\"local-2993-c186\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:98:\"#colibri .style-local-2993-c186-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:15:\"local-2993-c169\";a:1:{s:7:\"desktop\";s:0:\"\";}s:15:\"local-2993-c196\";a:1:{s:7:\"desktop\";s:0:\"\";}s:15:\"local-2993-c175\";a:1:{s:7:\"desktop\";s:0:\"\";}s:15:\"local-2993-c181\";a:1:{s:7:\"desktop\";s:0:\"\";}s:15:\"local-2993-c187\";a:1:{s:7:\"desktop\";s:0:\"\";}s:15:\"local-2993-c193\";a:2:{s:7:\"desktop\";s:97:\"#colibri .style-local-2993-c193-outer {\n  width: 80% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:58:\"#colibri .style-local-2993-c193-outer {\n  width: 100% ;\n}\n\";}s:15:\"local-2993-c246\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:98:\"#colibri .style-local-2993-c246-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:15:\"local-2993-c240\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:98:\"#colibri .style-local-2993-c240-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:15:\"local-2993-c228\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:98:\"#colibri .style-local-2993-c228-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:15:\"local-2993-c234\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:98:\"#colibri .style-local-2993-c234-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:15:\"local-2993-c229\";a:1:{s:7:\"desktop\";s:0:\"\";}s:15:\"local-2993-c235\";a:1:{s:7:\"desktop\";s:0:\"\";}}i:3265;a:4:{s:14:\"local-3265-c65\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-3265-c65-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3265-c71\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-3265-c71-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3265-c53\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-3265-c53-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3265-c59\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-3265-c59-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:3282;a:17:{s:13:\"local-3282-c4\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-3282-c7\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-3282-c7-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-3282-c7-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c23\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c23-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c23-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c53\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c53-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c53-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c10\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c10-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c10-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c13\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c13-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c13-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c16\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c16-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c16-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c19\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c19-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c19-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c50\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c50-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c50-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c47\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c47-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c47-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c44\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c44-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c44-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c41\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c41-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c41-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c38\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c38-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c38-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c35\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c35-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c35-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c32\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c32-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c32-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c29\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c29-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c29-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3282-c26\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3282-c26-outer {\n  width: 20% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3282-c26-outer {\n  width: 100% ;\n}\n\";}}i:3327;a:10:{s:13:\"local-3327-c4\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-3327-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3327-c22\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-3327-c22-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-3327-c8\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:96:\"#colibri .style-local-3327-c8-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3327-c15\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-3327-c15-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3327-c24\";a:3:{s:7:\"desktop\";s:96:\"#colibri .style-local-3327-c24-outer {\n  width: 30% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:57:\"#colibri .style-local-3327-c24-outer {\n  width: 100% ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3327-c24-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3327-c10\";a:3:{s:7:\"desktop\";s:96:\"#colibri .style-local-3327-c10-outer {\n  width: 30% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:57:\"#colibri .style-local-3327-c10-outer {\n  width: 100% ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3327-c10-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3327-c17\";a:3:{s:7:\"desktop\";s:96:\"#colibri .style-local-3327-c17-outer {\n  width: 30% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:57:\"#colibri .style-local-3327-c17-outer {\n  width: 100% ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3327-c17-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3327-c12\";a:3:{s:7:\"desktop\";s:96:\"#colibri .style-local-3327-c12-outer {\n  width: 70% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:57:\"#colibri .style-local-3327-c12-outer {\n  width: 100% ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3327-c12-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3327-c26\";a:3:{s:7:\"desktop\";s:96:\"#colibri .style-local-3327-c26-outer {\n  width: 70% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:57:\"#colibri .style-local-3327-c26-outer {\n  width: 100% ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3327-c26-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3327-c19\";a:3:{s:7:\"desktop\";s:96:\"#colibri .style-local-3327-c19-outer {\n  width: 70% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:57:\"#colibri .style-local-3327-c19-outer {\n  width: 100% ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3327-c19-outer {\n  width: 100% ;\n}\n\";}}i:3336;a:8:{s:13:\"local-3336-c4\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-3336-c4-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3336-c11\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-3336-c11-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3336-c14\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:99:\"#colibri .style-local-3336-c14-outer {\n  width: 16.66% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:97:\"#colibri .style-local-3336-c14-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3336-c18\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:99:\"#colibri .style-local-3336-c18-outer {\n  width: 16.66% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:97:\"#colibri .style-local-3336-c18-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3336-c22\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:99:\"#colibri .style-local-3336-c22-outer {\n  width: 16.66% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:97:\"#colibri .style-local-3336-c22-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3336-c26\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:99:\"#colibri .style-local-3336-c26-outer {\n  width: 16.66% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:97:\"#colibri .style-local-3336-c26-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3336-c30\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:99:\"#colibri .style-local-3336-c30-outer {\n  width: 16.66% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:97:\"#colibri .style-local-3336-c30-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-3336-c8\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-3336-c8-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}}i:3491;a:17:{s:13:\"local-3491-c4\";a:3:{s:7:\"desktop\";s:95:\"#colibri .style-local-3491-c4-outer {\n  width: 25% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:55:\"#colibri .style-local-3491-c4-outer {\n  width: 50% ;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-3491-c4-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3491-c12\";a:3:{s:7:\"desktop\";s:96:\"#colibri .style-local-3491-c12-outer {\n  width: 25% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:56:\"#colibri .style-local-3491-c12-outer {\n  width: 50% ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3491-c12-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3491-c20\";a:3:{s:7:\"desktop\";s:96:\"#colibri .style-local-3491-c20-outer {\n  width: 24% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"tablet\";s:56:\"#colibri .style-local-3491-c20-outer {\n  width: 50% ;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3491-c20-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3491-c28\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:96:\"#colibri .style-local-3491-c28-outer {\n  width: 50% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:97:\"#colibri .style-local-3491-c28-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3491-c41\";a:2:{s:7:\"desktop\";s:99:\"#colibri .style-local-3491-c41-outer {\n  width: 66.66% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-3491-c41-outer {\n  width: 60% ;\n}\n\";}s:14:\"local-3491-c43\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-3491-c43-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3491-c44\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3491-c44-outer {\n  width: 60% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:97:\"#colibri .style-local-3491-c44-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-3491-c6\";a:1:{s:7:\"desktop\";s:96:\"#colibri .style-local-3491-c6-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3491-c14\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3491-c14-outer {\n  width: 94% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3491-c14-outer {\n  width: 100% ;\n}\n\";}s:14:\"local-3491-c22\";a:1:{s:7:\"desktop\";s:97:\"#colibri .style-local-3491-c22-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:14:\"local-3491-c30\";a:2:{s:7:\"desktop\";s:0:\"\";s:6:\"mobile\";s:97:\"#colibri .style-local-3491-c30-outer {\n  width: 100% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";}s:13:\"local-3491-c9\";a:2:{s:7:\"desktop\";s:95:\"#colibri .style-local-3491-c9-outer {\n  width: 66% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:55:\"#colibri .style-local-3491-c9-outer {\n  width: 60% ;\n}\n\";}s:14:\"local-3491-c25\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3491-c25-outer {\n  width: 80% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-3491-c25-outer {\n  width: 60% ;\n}\n\";}s:14:\"local-3491-c42\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3491-c42-outer {\n  width: 75% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-3491-c42-outer {\n  width: 60% ;\n}\n\";}s:14:\"local-3491-c17\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3491-c17-outer {\n  width: 76% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-3491-c17-outer {\n  width: 60% ;\n}\n\";}s:14:\"local-3491-c33\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3491-c33-outer {\n  width: 64% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:56:\"#colibri .style-local-3491-c33-outer {\n  width: 60% ;\n}\n\";}s:14:\"local-3491-c37\";a:2:{s:7:\"desktop\";s:96:\"#colibri .style-local-3491-c37-outer {\n  width: 80% ;\n  flex: 0 0 auto;\n  -ms-flex: 0 0 auto;\n}\n\";s:6:\"mobile\";s:57:\"#colibri .style-local-3491-c37-outer {\n  width: 100% ;\n}\n\";}}}s:7:\"cssById\";a:668:{i:1;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:2;a:3:{s:7:\"desktop\";s:265:\"#colibri .style-2 {\n  animation-duration: 0.5s;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n#colibri .h-navigation_sticky .style-2,#colibri .h-navigation_sticky.style-2 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n  box-shadow: 0px 0px 4px 0px rgba(0,0,0,0.5) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:3;a:3:{s:7:\"desktop\";s:122:\"#colibri .style-3 {\n  padding-right: 30px;\n  padding-left: 30px;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:65:\"#colibri .style-3 {\n  padding-right: 0px;\n  padding-left: 0px;\n}\n\";s:6:\"mobile\";s:0:\"\";}i:4;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-4 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:5;a:3:{s:7:\"desktop\";s:488:\"#colibri .style-5-image {\n  max-height: 120px;\n}\n#colibri .style-5 a,#colibri .style-5  .logo-text {\n  color: #ffffff;\n  text-decoration: none;\n}\n#colibri .h-navigation_sticky .style-5-image,#colibri .h-navigation_sticky.style-5-image {\n  max-height: 70px;\n}\n#colibri .h-navigation_sticky .style-5 a,#colibri .h-navigation_sticky .style-5  .logo-text,#colibri .h-navigation_sticky.style-5 a,#colibri .h-navigation_sticky.style-5  .logo-text {\n  color: #000000;\n  text-decoration: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:6;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-6 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:19;a:3:{s:7:\"desktop\";s:321:\"#colibri .style-19 {\n  height: auto;\n  min-height: unset;\n  background-position: top center;\n  background-size: cover;\n  background-image: url(\"http://localhost/site/wp-content/uploads/2025/01/ALCADO.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  padding-top: 150px;\n  padding-bottom: 100px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:68:\"#colibri .style-19 {\n  padding-top: 50px;\n  padding-bottom: 50px;\n}\n\";}i:20;a:3:{s:7:\"desktop\";s:152:\"#colibri .style-20 {\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  margin-top: -61px;\n  margin-bottom: 3px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:21;a:3:{s:7:\"desktop\";s:696:\"#colibri .style-21 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-top-left-radius: 9px;\n  border-top-right-radius: 9px;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 9px;\n  border-bottom-right-radius: 9px;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n#colibri .style-21 h1 {\n  color: #FFFFFF;\n}\n#colibri .style-21 h2 {\n  color: #FFFFFF;\n}\n#colibri .style-21 h3 {\n  color: #FFFFFF;\n}\n#colibri .style-21 h4 {\n  color: #FFFFFF;\n}\n#colibri .style-21 h5 {\n  color: #FFFFFF;\n}\n#colibri .style-21 h6 {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:45:\"#colibri .style-21 {\n  text-align: center;\n}\n\";}i:22;a:3:{s:7:\"desktop\";s:465:\"#colibri .style-22 p,#colibri .style-22  h1,#colibri .style-22  h2,#colibri .style-22  h3,#colibri .style-22  h4,#colibri .style-22  h5,#colibri .style-22  h6 {\n  background-color: rgba(17, 31, 51, 0.8);\n  background-image: none;\n  padding-top: 36px;\n  padding-right: 20px;\n  padding-bottom: 36px;\n  padding-left: 20px;\n}\n#colibri .style-22 .text-wrapper-fancy svg path {\n  stroke: #FFFFFF;\n  stroke-linejoin: round;\n  stroke-linecap: round;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:24;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:25;a:3:{s:7:\"desktop\";s:1375:\"#colibri .style-25-outer {\n  width: 50% ;\n}\n#colibri .style-25-icon {\n  width: 20px;\n  height: 20px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-25 {\n  background-color: rgb(236, 82, 55);\n  background-image: none;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1em;\n  letter-spacing: 1px;\n  color: white;\n  border-top-width: 2px;\n  border-top-color: rgb(236, 82, 55);\n  border-top-style: solid;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-color: rgb(236, 82, 55);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(236, 82, 55);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-color: rgb(236, 82, 55);\n  border-left-style: solid;\n  padding-top: 15px;\n  padding-right: 24px;\n  padding-bottom: 15px;\n  padding-left: 24px;\n  text-align: center;\n}\n#colibri .style-25:hover,#colibri .style-25:focus {\n  background-color: rgb(212, 74, 49);\n  border-top-color: rgb(212, 74, 49);\n  border-right-color: rgb(212, 74, 49);\n  border-bottom-color: rgb(212, 74, 49);\n  border-left-color: rgb(212, 74, 49);\n}\n#colibri .style-25:active .style-25-icon {\n  width: 20px;\n  height: 20px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:26;a:3:{s:7:\"desktop\";s:1350:\"#colibri .style-26-outer {\n  width: 50% ;\n}\n#colibri .style-26-icon {\n  width: 20px;\n  height: 20px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-26 {\n  background-color: #FFFFFF;\n  background-image: none;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1em;\n  letter-spacing: 1px;\n  color: rgb(34, 41, 51);\n  border-top-width: 2px;\n  border-top-color: white;\n  border-top-style: solid;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-color: white;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: white;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-color: white;\n  border-left-style: solid;\n  padding-top: 15px;\n  padding-right: 24px;\n  padding-bottom: 15px;\n  padding-left: 24px;\n  text-align: center;\n}\n#colibri .style-26:hover,#colibri .style-26:focus {\n  background-color: rgb(212, 74, 49);\n  color: #FFFFFF;\n  border-top-color: rgb(212, 74, 49);\n  border-right-color: rgb(212, 74, 49);\n  border-bottom-color: rgb(212, 74, 49);\n  border-left-color: rgb(212, 74, 49);\n}\n#colibri .style-26:active .style-26-icon {\n  width: 20px;\n  height: 20px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:27;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:45;a:3:{s:7:\"desktop\";s:483:\"#colibri .style-45 {\n  height: auto;\n  min-height: unset;\n  color: #FFFFFF;\n  background-color: #03a9f4;\n  background-image: none;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n#colibri .style-45 h1 {\n  color: #FFFFFF;\n}\n#colibri .style-45 h2 {\n  color: #FFFFFF;\n}\n#colibri .style-45 h3 {\n  color: #FFFFFF;\n}\n#colibri .style-45 h4 {\n  color: #FFFFFF;\n}\n#colibri .style-45 h5 {\n  color: #FFFFFF;\n}\n#colibri .style-45 h6 {\n  color: #FFFFFF;\n}\n#colibri .style-45 p {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:46;a:3:{s:7:\"desktop\";s:76:\"#colibri .style-46 {\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:47;a:3:{s:7:\"desktop\";s:80:\"#colibri .style-47 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:48;a:3:{s:7:\"desktop\";s:159:\"#colibri .style-48 h1,#colibri .style-48  h2,#colibri .style-48  h3,#colibri .style-48  h4,#colibri .style-48  h5,#colibri .style-48  h6 {\n  font-size: 2em;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:141;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:159;a:3:{s:7:\"desktop\";s:79:\"#colibri .style-159 {\n  background-color: #03a9f4;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:160;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-160 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:163;a:3:{s:7:\"desktop\";s:6612:\"#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu {\n  justify-content: center;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu > li {\n  margin-top: 0px;\n  margin-right: 20px;\n  margin-bottom: 0px;\n  margin-left: 20px;\n  padding-top: 10px;\n  padding-right: 0px;\n  padding-bottom: 10px;\n  padding-left: 0px;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item,#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover {\n  margin-top: 0px;\n  margin-right: 20px;\n  margin-bottom: 0px;\n  margin-left: 20px;\n  padding-top: 10px;\n  padding-right: 0px;\n  padding-bottom: 10px;\n  padding-left: 0px;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1.5em;\n  letter-spacing: 0px;\n  color: #FFFFFF;\n}\n#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  color: #000000;\n}\n#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu > li:hover > a,#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  color: #000000;\n}\n#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1.5em;\n  letter-spacing: 0px;\n  color: #000000;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li > ul {\n  background-color: #ffffff;\n  background-image: none;\n  margin-right: 5px;\n  margin-left: 5px;\n  box-shadow: 0px 0px 5px 2px rgba(0, 0, 0, 0.04) ;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(128,128,128,.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: #6632ff;\n  background-image: none;\n}\n#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #FFFFFF;\n}\n#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover,#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #FFFFFF;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item,#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(128,128,128,.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  font-size: 14px;\n  color: #FFFFFF;\n}\n#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: #6632ff;\n}\n#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover > a,#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: #6632ff;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-163  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  font-size: 14px;\n  color: rgb(255, 255, 255);\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu.bordered-active-item > li::after,#colibri .style-163 \n      ul.colibri-menu.bordered-active-item > li::before {\n  background-color: #03a9f4;\n  background-image: none;\n  height: 3px;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu.solid-active-item > li::after,#colibri .style-163 \n      ul.colibri-menu.solid-active-item > li::before {\n  background-color: white;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 0%;\n  border-top-right-radius: 0%;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0%;\n  border-bottom-right-radius: 0%;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu > li > ul {\n  margin-top: 0px;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu > li > ul::before {\n  height: 0px;\n  width: 100% ;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 5px;\n  padding-left: 5px;\n  color: #000000;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 5px;\n  padding-left: 5px;\n  color: #000000;\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-163 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: rgb(255, 255, 255);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:164;a:3:{s:7:\"desktop\";s:931:\"#colibri .style-164-offscreen {\n  background-color: #222B34;\n  background-image: none;\n  width: 300px !important;\n}\n#colibri .style-164-offscreenOverlay {\n  background-color: rgba(0,0,0,0.5);\n  background-image: none;\n}\n#colibri .style-164  .h-hamburger-icon {\n  background-color: rgba(0, 0, 0, 0.1);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-top-left-radius: 100%;\n  border-top-right-radius: 100%;\n  border-right-width: 0px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 100%;\n  border-bottom-right-radius: 100%;\n  border-left-width: 0px;\n  border-left-color: black;\n  border-left-style: solid;\n  fill: white;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n  width: 24px;\n  height: 24px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:63:\"#colibri .style-164-offscreen {\n  background-color: #000000;\n}\n\";}i:165;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:166;a:3:{s:7:\"desktop\";s:4477:\"#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(236, 82, 55, 0.3);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  text-transform: capitalize;\n  font-size: 14px;\n  color: #FFFFFF;\n}\n#colibri .style-166  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-166  >  div > .colibri-menu-container > ul.colibri-menu > li:hover > a,#colibri .style-166  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-166  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-166  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(236, 82, 55, 0.3);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  background-color: #03a9f4;\n  background-image: none;\n  text-transform: capitalize;\n  font-size: 14px;\n  color: #FFFFFF;\n}\n#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-166  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: black;\n}\n#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: black;\n}\n#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-166 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:167;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:168;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-168 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:169;a:3:{s:7:\"desktop\";s:505:\"#colibri .style-169-image {\n  max-height: 70px;\n}\n#colibri .style-169 a,#colibri .style-169  .logo-text {\n  color: #ffffff;\n  text-decoration: none;\n}\n#colibri .h-navigation_sticky .style-169-image,#colibri .h-navigation_sticky.style-169-image {\n  max-height: 70px;\n}\n#colibri .h-navigation_sticky .style-169 a,#colibri .h-navigation_sticky .style-169  .logo-text,#colibri .h-navigation_sticky.style-169 a,#colibri .h-navigation_sticky.style-169  .logo-text {\n  color: #000000;\n  text-decoration: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:170;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:171;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-171 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:174;a:3:{s:7:\"desktop\";s:1340:\"#colibri .style-174 .colibri_search_button {\n  width: 60px ;\n  color: #ffffff;\n  background-color: #03a9f4;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n  font-weight: 400;\n}\n#colibri .style-174 .colibri_search_button:hover {\n  background-color: #f79007;\n}\n#colibri .style-174 .colibri_search_button:hover {\n  background-color: #f79007;\n}\n#colibri .style-174 .colibri_search_button svg {\n  width: 18px ;\n  fill: #ffffff;\n}\n#colibri .style-174 .colibri_search_input {\n  border-top-width: 1px;\n  border-top-color: rgb(222, 222, 222);\n  border-top-style: none;\n  border-right-width: 1px;\n  border-right-color: rgb(222, 222, 222);\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(222, 222, 222);\n  border-bottom-style: none;\n  border-left-width: 1px;\n  border-left-color: rgb(222, 222, 222);\n  border-left-style: none;\n  font-family: Source Sans Pro;\n  font-weight: 400;\n  font-style: italic;\n  font-size: 16px;\n  color: rgb(153, 153, 153);\n  padding-top: 6px;\n  padding-right: 12px;\n  padding-bottom: 7px;\n  padding-left: 12px;\n}\n#colibri .style-174 .fancybox-slide .colibri_search_input {\n  height: 50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:175;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-175 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:179;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-179 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:180;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:181;a:3:{s:7:\"desktop\";s:1406:\"#colibri .style-181-icon {\n  fill: #03a9f4;\n  width: 30px;\n  height: 30px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-181 {\n  border-top-width: 0px;\n  border-top-color: #FFFFFF;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 0px;\n  border-right-color: #FFFFFF;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 0px;\n  border-left-color: #FFFFFF;\n  border-left-style: none;\n  background-color: #FFFFFF;\n  background-image: none;\n  font-family: Source Sans Pro;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 16px;\n  line-height: 1em;\n  letter-spacing: 1px;\n  color: #000000;\n  padding-top: 5px;\n  padding-right: 22px;\n  padding-bottom: 5px;\n  padding-left: 22px;\n  text-align: center;\n}\n#colibri .style-181:hover,#colibri .style-181:focus {\n  border-top-color: #03a9f4;\n  border-right-color: #03a9f4;\n  border-bottom-color: #03a9f4;\n  border-left-color: #03a9f4;\n  background-color: #03a9f4;\n  color: #FFFFFF;\n}\n#colibri .style-181:hover .style-181-icon,#colibri .style-181:focus .style-181-icon {\n  fill: #FFFFFF;\n}\n#colibri .style-181:active .style-181-icon {\n  fill: #03a9f4;\n  width: 30px;\n  height: 30px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:182;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-182 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:184;a:3:{s:7:\"desktop\";s:553:\"#colibri .style-184 {\n  background-color: #FFFFFF;\n  background-image: none;\n  padding-top: 3px;\n  padding-right: 17px;\n  padding-bottom: 3px;\n  padding-left: 17px;\n}\n#colibri .style-184 .social-icon-container {\n  margin-right: 5px;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n}\n#colibri .style-184 .icon-container {\n  fill: rgba(153, 153, 153, 0.8);\n  width: 25px ;\n  height: 25px;\n}\n#colibri .style-184 .icon-container:hover {\n  fill: #03a9f4;\n}\n#colibri .style-184 .icon-container:hover {\n  fill: #03a9f4;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:185;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-185 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:187;a:3:{s:7:\"desktop\";s:6161:\"#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu {\n  justify-content: flex-start;\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu > li {\n  background-color: #03a9f4;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: white;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: white;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(255, 255, 255, 0.1);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: white;\n  border-left-style: solid;\n  padding-top: 12px;\n  padding-right: 20px;\n  padding-bottom: 12px;\n  padding-left: 25px;\n}\n#colibri .style-187  >  div > .colibri-menu-container > ul.colibri-menu > li.hover {\n  background-color: #6632ff;\n  color: #363636;\n}\n#colibri .style-187  >  div > .colibri-menu-container > ul.colibri-menu > li:hover,#colibri .style-187  >  div > .colibri-menu-container > ul.colibri-menu > li.hover {\n  background-color: #6632ff;\n  color: #363636;\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item,#colibri .style-187  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover {\n  background-color: #6632ff;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: white;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: white;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(255, 255, 255, 0.1);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: white;\n  border-left-style: solid;\n  padding-top: 12px;\n  padding-right: 20px;\n  padding-bottom: 12px;\n  padding-left: 25px;\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  text-transform: capitalize;\n  font-size: 15px;\n  color: #FFFFFF;\n}\n#colibri .style-187  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-187  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  text-transform: capitalize;\n  font-size: 15px;\n  color: #FFFFFF;\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li > ul {\n  margin-right: 5px;\n  margin-left: 5px;\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li {\n  background-color: #03a9f4;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: white;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: white;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(255, 255, 255, 0.7);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 2px;\n  border-bottom-right-radius: 2px;\n  border-left-width: 0px;\n  border-left-color: white;\n  border-left-style: solid;\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n}\n#colibri .style-187  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: rgb(2, 110, 159);\n  color: #363636;\n}\n#colibri .style-187  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover,#colibri .style-187  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: rgb(2, 110, 159);\n  color: #363636;\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item,#colibri .style-187  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover {\n  background-color: rgb(2, 110, 159);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: white;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: white;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(255, 255, 255, 0.7);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 2px;\n  border-bottom-right-radius: 2px;\n  border-left-width: 0px;\n  border-left-color: white;\n  border-left-style: solid;\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  font-size: 14px;\n  color: #FFFFFF;\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-187  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  font-size: 14px;\n  color: #FFFFFF;\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu > li > ul::before {\n  width: 5px ;\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 5px;\n  padding-left: 5px;\n  color: rgba(255, 255, 255, 0.7);\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 5px;\n  padding-left: 5px;\n  color: rgba(255, 255, 255, 0.7);\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: rgba(255, 255, 255, 0.7);\n}\n#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-187 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: rgba(255, 255, 255, 0.7);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:188;a:3:{s:7:\"desktop\";s:931:\"#colibri .style-188-offscreen {\n  background-color: #222B34;\n  background-image: none;\n  width: 300px !important;\n}\n#colibri .style-188-offscreenOverlay {\n  background-color: rgba(0,0,0,0.5);\n  background-image: none;\n}\n#colibri .style-188  .h-hamburger-icon {\n  background-color: rgba(0, 0, 0, 0.1);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-top-left-radius: 100%;\n  border-top-right-radius: 100%;\n  border-right-width: 0px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 100%;\n  border-bottom-right-radius: 100%;\n  border-left-width: 0px;\n  border-left-color: black;\n  border-left-style: solid;\n  fill: white;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n  width: 24px;\n  height: 24px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:189;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:190;a:3:{s:7:\"desktop\";s:3947:\"#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-190  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-190  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-190  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: black;\n}\n#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: black;\n}\n#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-190 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:191;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:192;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-192 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:193;a:3:{s:7:\"desktop\";s:151:\"#colibri .style-193-image {\n  max-height: 70px;\n}\n#colibri .style-193 a,#colibri .style-193  .logo-text {\n  color: #ffffff;\n  text-decoration: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:194;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:195;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-195 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:197;a:3:{s:7:\"desktop\";s:159:\"#colibri .style-197 {\n  height: auto;\n  min-height: unset;\n  background-color: #FFFFFF;\n  background-image: none;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:198;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:199;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-199 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:204;a:3:{s:7:\"desktop\";s:709:\"#colibri .style-204 .h-svg-icon {\n  fill: rgb(153, 153, 153);\n  width: 50px ;\n  height: 50px;\n  margin-right: 10px;\n}\n#colibri .style-204 .bar-counter {\n  font-weight: 600;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-204 .circle-counter {\n  font-size: 3em;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-204 .simple-counter {\n  font-family: Montserrat;\n  font-size: 3em;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-204 .title-number {\n  font-family: Source Sans Pro;\n  text-transform: lowercase;\n  font-size: 21px;\n  color: rgb(34, 41, 51);\n}\n#colibri .style-204 .title-circle {\n  font-size: 21px;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-204 .title-bar {\n  font-weight: 600;\n  color: rgb(236, 82, 55);\n}\n\";s:6:\"tablet\";s:60:\"#colibri .style-204 .simple-counter {\n  font-size: 2.5em;\n}\n\";s:6:\"mobile\";s:58:\"#colibri .style-204 .simple-counter {\n  font-size: 2em;\n}\n\";}i:205;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:216;a:3:{s:7:\"desktop\";s:515:\"#colibri .style-216 {\n  height: auto;\n  min-height: unset;\n  background-color: #000000;\n  background-image: none;\n  color: rgb(153, 153, 153);\n  padding-top: 30px;\n  padding-bottom: 30px;\n}\n#colibri .style-216 p {\n  color: rgb(153, 153, 153);\n}\n#colibri .style-216 h1 {\n  color: #FFFFFF;\n}\n#colibri .style-216 h2 {\n  color: #FFFFFF;\n}\n#colibri .style-216 h3 {\n  color: #FFFFFF;\n}\n#colibri .style-216 h4 {\n  color: #FFFFFF;\n}\n#colibri .style-216 h5 {\n  color: #FFFFFF;\n}\n#colibri .style-216 h6 {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:217;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:218;a:3:{s:7:\"desktop\";s:156:\".style-218 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 5px;\n}\n#colibri .style-218 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:46:\"#colibri .style-218 {\n  text-align: center;\n}\n\";}i:219;a:3:{s:7:\"desktop\";s:151:\"#colibri .style-219-image {\n  max-height: 70px;\n}\n#colibri .style-219 a,#colibri .style-219  .logo-text {\n  color: #ffffff;\n  text-decoration: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:220;a:3:{s:7:\"desktop\";s:156:\".style-220 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-220 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:46:\"#colibri .style-220 {\n  text-align: center;\n}\n\";}i:221;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-221 ol {\n  list-style-type: decimal;\n}\n#colibri .style-221 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:222;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-222 ol {\n  list-style-type: decimal;\n}\n#colibri .style-222 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:223;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-223 ol {\n  list-style-type: decimal;\n}\n#colibri .style-223 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:224;a:3:{s:7:\"desktop\";s:158:\".style-224 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-224 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:225;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:226;a:3:{s:7:\"desktop\";s:376:\"#colibri .style-226-icon {\n  width: 18px ;\n  height: 18px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-226-icon:visited {\n  width: 18px ;\n  height: 18px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-226 {\n  color: rgb(153, 153, 153);\n}\n#colibri .style-226:visited {\n  color: rgb(153, 153, 153);\n}\n#colibri .style-226:hover {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:227;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:228;a:3:{s:7:\"desktop\";s:376:\"#colibri .style-228-icon {\n  width: 18px ;\n  height: 18px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-228-icon:visited {\n  width: 18px ;\n  height: 18px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-228 {\n  color: rgb(153, 153, 153);\n}\n#colibri .style-228:visited {\n  color: rgb(153, 153, 153);\n}\n#colibri .style-228:hover {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:229;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-229 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:231;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-231 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:234;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:235;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:236;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:237;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:238;a:3:{s:7:\"desktop\";s:178:\"#colibri .style-238 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n#colibri .style-238  > .h-section-grid-container {\n  margin-top: -25px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:239;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:240;a:3:{s:7:\"desktop\";s:136:\"#colibri .style-240 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:45:\"#colibri .style-240 {\n  text-align: right;\n}\n\";}i:241;a:3:{s:7:\"desktop\";s:659:\"#colibri .style-241-icon {\n  fill: #FFFFFF;\n  width: 20px ;\n  height: 20px;\n  border-top-width: 1px;\n  border-top-color: rgb(125, 79, 79);\n  border-top-style: none;\n  border-right-width: 1px;\n  border-right-color: rgb(125, 79, 79);\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(125, 79, 79);\n  border-bottom-style: none;\n  border-left-width: 1px;\n  border-left-color: rgb(125, 79, 79);\n  border-left-style: none;\n  background-color: #03a9f4;\n  background-image: none;\n  padding-top: 5px;\n  padding-right: 10px;\n  padding-bottom: 0px;\n  padding-left: 10px;\n}\n#colibri .style-241-icon:hover {\n  background-color: #f79007;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:242;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:243;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:244;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:245;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:246;a:3:{s:7:\"desktop\";s:379:\"#colibri .style-246 {\n  height: auto;\n  min-height: unset;\n  padding-top: 15px;\n  padding-bottom: 15px;\n  background-position: bottom center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/aerial-view-architecture-cars-280221-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:247;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:248;a:3:{s:7:\"desktop\";s:158:\".style-248 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-248 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:250;a:3:{s:7:\"desktop\";s:479:\"#colibri .style-250 {\n  height: auto;\n  min-height: unset;\n  background-color: rgb(34, 41, 51);\n  background-image: none;\n  padding-bottom: 0px;\n  color: #FFFFFF;\n}\n#colibri .style-250 h1 {\n  color: #FFFFFF;\n}\n#colibri .style-250 h2 {\n  color: #FFFFFF;\n}\n#colibri .style-250 h3 {\n  color: #FFFFFF;\n}\n#colibri .style-250 h4 {\n  color: #FFFFFF;\n}\n#colibri .style-250 h5 {\n  color: #FFFFFF;\n}\n#colibri .style-250 h6 {\n  color: #FFFFFF;\n}\n#colibri .style-250 p {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:251;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:252;a:3:{s:7:\"desktop\";s:494:\".style-252 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-252 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  border-top-width: 2px;\n  border-top-color: #FFFFFF;\n  border-top-style: none;\n  border-right-width: 2px;\n  border-right-color: #FFFFFF;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: none;\n  border-left-width: 2px;\n  border-left-color: #FFFFFF;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:253;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-253 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:254;a:3:{s:7:\"desktop\";s:649:\"#colibri .style-254-image {\n  opacity: 1;\n}\n#colibri .style-254-caption {\n  margin-top: 10px;\n}\n#colibri .style-254-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:255;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-255 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:256;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-256 ol {\n  list-style-type: decimal;\n}\n#colibri .style-256 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:260;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:261;a:3:{s:7:\"desktop\";s:589:\".style-261 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 20px;\n}\n#colibri .style-261 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  padding-top: 3rem;\n  padding-right: 3rem;\n  padding-bottom: 3rem;\n  padding-left: 3rem;\n  border-top-width: 2px;\n  border-top-color: #FFFFFF;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #FFFFFF;\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:136:\"#colibri .style-261 {\n  text-align: center;\n  padding-top: 2rem;\n  padding-right: 2rem;\n  padding-bottom: 2rem;\n  padding-left: 2rem;\n}\n\";}i:263;a:3:{s:7:\"desktop\";s:40:\"#colibri .style-263 {\n  height: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:264;a:3:{s:7:\"desktop\";s:296:\"#colibri .style-264 {\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(120deg,  rgba(253, 251, 251, 0.8) 0%, rgba(235, 237, 238, 0.8) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:265;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:267;a:3:{s:7:\"desktop\";s:265:\".style-267 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-267 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: #FFFFFF;\n  background-image: none;\n  box-shadow: 1px 1px 0px 0px rgba(0, 0, 0, 0.05) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:272;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:273;a:3:{s:7:\"desktop\";s:158:\".style-273 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 5px;\n}\n#colibri .style-273 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:274;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-274 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:275;a:3:{s:7:\"desktop\";s:269:\"#colibri .style-275 {\n  text-transform: uppercase;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-275 p {\n  text-transform: uppercase;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-275 ol {\n  list-style-type: decimal;\n}\n#colibri .style-275 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:277;a:3:{s:7:\"desktop\";s:503:\"#colibri .style-277-line {\n  width: 90px ;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(236, 82, 55);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n#colibri .style-277-icon {\n  fill: rgb(236, 82, 55);\n  width: 50px ;\n  height: 50px;\n  margin-right: 10px;\n  margin-left: 10px;\n}\n#colibri .style-277 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:278;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-278 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:279;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-279 ol {\n  list-style-type: decimal;\n}\n#colibri .style-279 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:280;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:281;a:3:{s:7:\"desktop\";s:214:\"#colibri .style-281-icon {\n  width: 18px ;\n  height: 18px;\n  margin-right: 0px;\n  margin-left: 10px;\n}\n#colibri .style-281-icon:visited {\n  width: 18px ;\n  height: 18px;\n  margin-right: 0px;\n  margin-left: 10px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:303;a:3:{s:7:\"desktop\";s:1185:\"#colibri .style-303 {\n  text-align: center;\n  box-shadow: none;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/bookcase-books-bookshelves-256541.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n#colibri .style-303 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-image: none;\n  color: #FFFFFF;\n  padding-right: 50px;\n  padding-left: 50px;\n}\n#colibri .style-303 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-303 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-303 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-303 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-303 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-303 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-303 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-303 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.6);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:304;a:3:{s:7:\"desktop\";s:67:\"#colibri .style-304 {\n  min-height: 250px;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:307;a:3:{s:7:\"desktop\";s:101:\"#colibri .style-307 {\n  height: 100%;\n  width: 100% ;\n  top: 0%;\n  left: 0%;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:310;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:311;a:3:{s:7:\"desktop\";s:159:\".style-311 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 20px;\n}\n#colibri .style-311 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:314;a:3:{s:7:\"desktop\";s:581:\"#colibri .style-314-icon {\n  fill: #FFFFFF;\n  width: 50px ;\n  height: 50px;\n  border-top-width: 1px;\n  border-top-color: rgb(125, 79, 79);\n  border-top-style: none;\n  border-right-width: 1px;\n  border-right-color: rgb(125, 79, 79);\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(125, 79, 79);\n  border-bottom-style: none;\n  border-left-width: 1px;\n  border-left-color: rgb(125, 79, 79);\n  border-left-style: none;\n}\n#colibri .style-314-icon:hover {\n  fill: rgb(236, 82, 55);\n  background-color: rgba(45, 45, 134, 0);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:315;a:3:{s:7:\"desktop\";s:1171:\"#colibri .style-315 {\n  text-align: center;\n  box-shadow: none;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/portrayal-89193_640.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n#colibri .style-315 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-image: none;\n  color: #FFFFFF;\n  padding-right: 50px;\n  padding-left: 50px;\n}\n#colibri .style-315 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-315 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-315 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-315 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-315 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-315 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-315 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-315 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.6);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:316;a:3:{s:7:\"desktop\";s:1199:\"#colibri .style-316 {\n  text-align: center;\n  box-shadow: none;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/architecture-cobblestone-street-daylight-772177.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n#colibri .style-316 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-image: none;\n  color: #FFFFFF;\n  padding-right: 50px;\n  padding-left: 50px;\n}\n#colibri .style-316 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-316 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-316 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-316 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-316 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-316 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-316 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-316 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.6);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:318;a:3:{s:7:\"desktop\";s:746:\"#colibri .style-318-icon {\n  fill: rgba(255, 255, 255, 0.3);\n  width: 100px ;\n  height: 100px;\n  border-top-width: 1px;\n  border-top-color: rgb(125, 79, 79);\n  border-top-style: none;\n  border-right-width: 1px;\n  border-right-color: rgb(125, 79, 79);\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(125, 79, 79);\n  border-bottom-style: none;\n  border-left-width: 1px;\n  border-left-color: rgb(125, 79, 79);\n  border-left-style: none;\n  transform: rotate(0deg);\n  transform-origin: center center 0px;\n  background-color: rgb(34, 41, 51);\n  background-image: none;\n}\n#colibri .style-318-icon:hover {\n  fill: rgb(236, 82, 55);\n}\n#colibri .style-318 {\n  margin-bottom: -110px;\n  margin-left: -35px;\n  z-index: 2;\n}\n\";s:6:\"tablet\";s:61:\"#colibri .style-318-icon {\n  width: 80px ;\n  height: 80px;\n}\n\";s:6:\"mobile\";s:132:\"#colibri .style-318-icon {\n  width: 70px ;\n  height: 70px;\n}\n#colibri .style-318 {\n  margin-bottom: -100px;\n  margin-left: -15px;\n}\n\";}i:319;a:3:{s:7:\"desktop\";s:727:\"#colibri .style-319 {\n  height: auto;\n  min-height: unset;\n  background-color: rgb(34, 41, 51);\n  background-position: 49.54748664267801% 64.57311089303238%;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/aerial-view-architecture-cars-280221-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n}\n#colibri .style-319 h1 {\n  color: #FFFFFF;\n}\n#colibri .style-319 h2 {\n  color: #FFFFFF;\n}\n#colibri .style-319 h3 {\n  color: #FFFFFF;\n}\n#colibri .style-319 h4 {\n  color: #FFFFFF;\n}\n#colibri .style-319 h5 {\n  color: #FFFFFF;\n}\n#colibri .style-319 h6 {\n  color: #FFFFFF;\n}\n#colibri .style-319 p {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:320;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:321;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-321 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:322;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:323;a:3:{s:7:\"desktop\";s:594:\".style-323 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 10px;\n}\n#colibri .style-323 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 1px;\n  border-top-color: #FFFFFF;\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-left-width: 1px;\n  border-left-color: #FFFFFF;\n  border-left-style: solid;\n}\n#colibri .style-323:hover {\n  background-color: rgb(34, 41, 51);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:324;a:3:{s:7:\"desktop\";s:156:\"#colibri .style-324-icon {\n  fill: rgba(255, 255, 255, 0.3);\n  width: 40px ;\n  height: 40px;\n}\n#colibri .style-324-icon:hover {\n  fill: rgb(236, 82, 55);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:325;a:3:{s:7:\"desktop\";s:155:\"#colibri .style-325 {\n  padding-bottom: 35px;\n}\n#colibri .style-325 ol {\n  list-style-type: decimal;\n}\n#colibri .style-325 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:326;a:3:{s:7:\"desktop\";s:397:\".style-326 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-326 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: rgb(236, 82, 55);\n  background-image: none;\n  padding-top: 10px;\n  padding-right: 10px;\n  padding-bottom: 10px;\n  padding-left: 10px;\n  transform: translateX(0%) translateY(-50%);\n  transform-origin: center center 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:327;a:3:{s:7:\"desktop\";s:336:\"#colibri .style-327 p,#colibri .style-327  h1,#colibri .style-327  h2,#colibri .style-327  h3,#colibri .style-327  h4,#colibri .style-327  h5,#colibri .style-327  h6 {\n  color: #FFFFFF;\n}\n#colibri .style-327 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:328;a:3:{s:7:\"desktop\";s:237:\"#colibri .style-328 {\n  font-style: italic;\n  color: #FFFFFF;\n}\n#colibri .style-328 p {\n  font-style: italic;\n  color: #FFFFFF;\n}\n#colibri .style-328 ol {\n  list-style-type: decimal;\n}\n#colibri .style-328 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:329;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:330;a:3:{s:7:\"desktop\";s:158:\".style-330 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 5px;\n}\n#colibri .style-330 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:331;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-331 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:332;a:3:{s:7:\"desktop\";s:215:\"#colibri .style-332 {\n  text-transform: uppercase;\n}\n#colibri .style-332 p {\n  text-transform: uppercase;\n}\n#colibri .style-332 ol {\n  list-style-type: decimal;\n}\n#colibri .style-332 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:334;a:3:{s:7:\"desktop\";s:503:\"#colibri .style-334-line {\n  width: 90px ;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(236, 82, 55);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n#colibri .style-334-icon {\n  fill: rgb(236, 82, 55);\n  width: 50px ;\n  height: 50px;\n  margin-right: 10px;\n  margin-left: 10px;\n}\n#colibri .style-334 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:345;a:3:{s:7:\"desktop\";s:378:\"#colibri .style-345 {\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/aerial-view-architecture-cars-280221-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  padding-top: 0px;\n  padding-bottom: 42px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:346;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:347;a:3:{s:7:\"desktop\";s:311:\".style-347 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 20px;\n}\n#colibri .style-347 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: rgb(241, 238, 235);\n  background-image: none;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:348;a:3:{s:7:\"desktop\";s:110:\"#colibri .style-348 {\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:349;a:3:{s:7:\"desktop\";s:790:\"#colibri .style-349 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: #03a9f4;\n  background-image: none;\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 1px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 1px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: none;\n  box-shadow: 1px 1px 0px 0px rgba(4, 4, 4, 0.05) ;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:350;a:3:{s:7:\"desktop\";s:771:\"#colibri .style-350 {\n  background-color: rgba(255,255,255,0);\n  background-image: none;\n  text-align: left;\n  border-top-width: 3px;\n  border-top-color: #f79007;\n  border-top-style: none;\n  border-right-width: 3px;\n  border-right-color: #f79007;\n  border-right-style: none;\n  border-bottom-width: 3px;\n  border-bottom-color: #f79007;\n  border-bottom-style: none;\n  border-left-width: 3px;\n  border-left-color: #f79007;\n  border-left-style: none;\n  box-shadow: none;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-bottom: 0px;\n  margin-left: 0px;\n}\n#colibri .style-350 .colibri-post-thumbnail-shortcode img {\n  height: 300px;\n  object-position: center center;\n  object-fit: cover;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:351;a:3:{s:7:\"desktop\";s:176:\"#colibri .style-351 {\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-bottom: 0px;\n  margin-left: 0px;\n  background-color: rgba(201, 239, 251, 0);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:352;a:3:{s:7:\"desktop\";s:65:\"#colibri .style-352 {\n  text-align: left;\n  min-height: 211px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:353;a:3:{s:7:\"desktop\";s:453:\"#colibri .style-353 {\n  margin-bottom: 20px;\n}\n#colibri .style-353 a,#colibri .style-353  .colibri-post-category {\n  margin-right: 10px;\n  color: rgb(204, 204, 204);\n}\n#colibri .style-353 a:hover,#colibri .style-353  .colibri-post-category:hover {\n  color: rgb(236, 203, 55);\n}\n#colibri .style-353 a:hover,#colibri .style-353  .colibri-post-category:hover {\n  color: rgb(236, 203, 55);\n}\n#colibri .style-353 .categories-prefix {\n  margin-right: 16px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:354;a:3:{s:7:\"desktop\";s:589:\"#colibri .style-354 h1,#colibri .style-354  h2,#colibri .style-354  h3,#colibri .style-354  h4,#colibri .style-354  h5,#colibri .style-354  h6 {\n  margin-bottom: 0px;\n  color: #FFFFFF;\n}\n#colibri .style-354 h1:hover,#colibri .style-354  h2:hover,#colibri .style-354  h3:hover,#colibri .style-354  h4:hover,#colibri .style-354  h5:hover,#colibri .style-354  h6:hover {\n  color: #f79007;\n}\n#colibri .style-354 h1:hover,#colibri .style-354  h2:hover,#colibri .style-354  h3:hover,#colibri .style-354  h4:hover,#colibri .style-354  h5:hover,#colibri .style-354  h6:hover {\n  color: #f79007;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:355;a:3:{s:7:\"desktop\";s:64:\"#colibri .style-355 .colibri-post-excerpt {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:356;a:3:{s:7:\"desktop\";s:366:\"#colibri .style-356 {\n  border-top-width: 1px;\n  border-top-color: #6632ff;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #6632ff;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: #6632ff;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #6632ff;\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:357;a:3:{s:7:\"desktop\";s:488:\".style-357 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-357 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  color: #FFFFFF;\n}\n#colibri .style-357 h1 {\n  color: #FFFFFF;\n}\n#colibri .style-357 h2 {\n  color: #FFFFFF;\n}\n#colibri .style-357 h3 {\n  color: #FFFFFF;\n}\n#colibri .style-357 h4 {\n  color: #FFFFFF;\n}\n#colibri .style-357 h5 {\n  color: #FFFFFF;\n}\n#colibri .style-357 h6 {\n  color: #FFFFFF;\n}\n#colibri .style-357 p {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:358;a:3:{s:7:\"desktop\";s:439:\"#colibri .style-358 a {\n  font-size: 14px;\n  color: #FFFFFF;\n  margin-right: 5px;\n}\n#colibri .style-358 a:hover {\n  color: #f79007;\n}\n#colibri .style-358 a:hover {\n  color: #f79007;\n}\n#colibri .style-358 .metadata-prefix {\n  font-size: 14px;\n  color: rgb(204, 204, 204);\n}\n#colibri .style-358 .metadata-suffix {\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-358 svg {\n  width: 20px ;\n  height: 20px;\n  display: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:359;a:3:{s:7:\"desktop\";s:157:\".style-359 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-359 {\n  text-align: right;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:360;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:361;a:3:{s:7:\"desktop\";s:1320:\"#colibri .style-361-icon {\n  margin-right: 0px;\n  margin-left: 3px;\n  width: 16px;\n  height: 16px;\n}\n#colibri .style-361 {\n  background-color: rgba(3, 169, 244, 0);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: #03a9f4;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 0px;\n  border-right-color: #03a9f4;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 0px;\n  border-left-color: #03a9f4;\n  border-left-style: none;\n  font-family: Source Sans Pro;\n  font-weight: 600;\n  text-transform: none;\n  font-size: 14px;\n  line-height: 1em;\n  letter-spacing: 0px;\n  color: #FFFFFF;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  text-align: center;\n}\n#colibri .style-361:hover,#colibri .style-361:focus {\n  background-color: rgba(2, 110, 159, 0);\n  border-top-color: rgb(2, 110, 159);\n  border-right-color: rgb(2, 110, 159);\n  border-bottom-color: rgb(2, 110, 159);\n  border-left-color: rgb(2, 110, 159);\n  color: #f79007;\n}\n#colibri .style-361:active .style-361-icon {\n  margin-right: 0px;\n  margin-left: 3px;\n  width: 16px;\n  height: 16px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:362;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:363;a:3:{s:7:\"desktop\";s:158:\".style-363 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 5px;\n}\n#colibri .style-363 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:364;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-364 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:365;a:3:{s:7:\"desktop\";s:215:\"#colibri .style-365 {\n  text-transform: uppercase;\n}\n#colibri .style-365 p {\n  text-transform: uppercase;\n}\n#colibri .style-365 ol {\n  list-style-type: decimal;\n}\n#colibri .style-365 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:367;a:3:{s:7:\"desktop\";s:503:\"#colibri .style-367-line {\n  width: 90px ;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(236, 82, 55);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n#colibri .style-367-icon {\n  fill: rgb(236, 82, 55);\n  width: 50px ;\n  height: 50px;\n  margin-right: 10px;\n  margin-left: 10px;\n}\n#colibri .style-367 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:368;a:3:{s:7:\"desktop\";s:41:\"#colibri .style-368 {\n  height: 250px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:369;a:3:{s:7:\"desktop\";s:1372:\"#colibri .style-369 .widget {\n  text-align: left;\n}\n#colibri .style-369 .widget h1,#colibri .style-369 .widget h2,#colibri .style-369 .widget h3,#colibri .style-369 .widget h4,#colibri .style-369 .widget h5,#colibri .style-369 .widget h6 {\n  text-transform: uppercase;\n  color: #FFFFFF;\n}\n#colibri .style-369 .widget ul li,#colibri .style-369 .widget ol li,#colibri .style-369 .widget  .textwidget p,#colibri .style-369 .widget  .calendar_wrap td ,#colibri .style-369  .widget  .calendar_wrap th ,#colibri .style-369  .widget  .calendar_wrap caption {\n  text-decoration: none;\n  text-transform: capitalize;\n  color: #FFFFFF;\n}\n#colibri .style-369 .widget ul li a:not(.wp-block-button__link) {\n  text-decoration: none;\n  text-transform: capitalize;\n  color: rgb(153, 153, 153);\n}\n#colibri .style-369 .widget ul li a:not(.wp-block-button__link):hover {\n  color: #FFFFFF;\n}\n#colibri .style-369 .widget ul li a:not(.wp-block-button__link):hover {\n  color: #FFFFFF;\n}\n#colibri .style-369 .widget input:not([type=\"submit\"]) {\n  color: black;\n  border-top-width: 1px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-left-width: 1px;\n  border-left-color: black;\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:54:\"#colibri .style-369 .widget {\n  text-align: center;\n}\n\";}i:370;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:371;a:3:{s:7:\"desktop\";s:365:\"#colibri .style-371 p,#colibri .style-371  h1,#colibri .style-371  h2,#colibri .style-371  h3,#colibri .style-371  h4,#colibri .style-371  h5,#colibri .style-371  h6 {\n  text-transform: uppercase;\n  color: #FFFFFF;\n}\n#colibri .style-371 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:372;a:3:{s:7:\"desktop\";s:365:\"#colibri .style-372 p,#colibri .style-372  h1,#colibri .style-372  h2,#colibri .style-372  h3,#colibri .style-372  h4,#colibri .style-372  h5,#colibri .style-372  h6 {\n  text-transform: uppercase;\n  color: #FFFFFF;\n}\n#colibri .style-372 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:373;a:3:{s:7:\"desktop\";s:40:\"#colibri .style-373 {\n  height: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:374;a:3:{s:7:\"desktop\";s:1372:\"#colibri .style-374 .widget {\n  text-align: left;\n}\n#colibri .style-374 .widget h1,#colibri .style-374 .widget h2,#colibri .style-374 .widget h3,#colibri .style-374 .widget h4,#colibri .style-374 .widget h5,#colibri .style-374 .widget h6 {\n  text-transform: uppercase;\n  color: #FFFFFF;\n}\n#colibri .style-374 .widget ul li,#colibri .style-374 .widget ol li,#colibri .style-374 .widget  .textwidget p,#colibri .style-374 .widget  .calendar_wrap td ,#colibri .style-374  .widget  .calendar_wrap th ,#colibri .style-374  .widget  .calendar_wrap caption {\n  text-decoration: none;\n  text-transform: capitalize;\n  color: #FFFFFF;\n}\n#colibri .style-374 .widget ul li a:not(.wp-block-button__link) {\n  text-decoration: none;\n  text-transform: capitalize;\n  color: rgb(153, 153, 153);\n}\n#colibri .style-374 .widget ul li a:not(.wp-block-button__link):hover {\n  color: #FFFFFF;\n}\n#colibri .style-374 .widget ul li a:not(.wp-block-button__link):hover {\n  color: #FFFFFF;\n}\n#colibri .style-374 .widget input:not([type=\"submit\"]) {\n  color: black;\n  border-top-width: 1px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-left-width: 1px;\n  border-left-color: black;\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:54:\"#colibri .style-374 .widget {\n  text-align: center;\n}\n\";}i:375;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:376;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-376 ol {\n  list-style-type: decimal;\n}\n#colibri .style-376 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:377;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-377 ol {\n  list-style-type: decimal;\n}\n#colibri .style-377 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:378;a:3:{s:7:\"desktop\";s:40:\"#colibri .style-378 {\n  height: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:379;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:380;a:3:{s:7:\"desktop\";s:271:\"#colibri .style-380 {\n  animation-duration: 0.5s;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n#colibri .h-navigation_sticky .style-380,#colibri .h-navigation_sticky.style-380 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n  box-shadow: 0px 0px 4px 0px rgba(0,0,0,0.5) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:381;a:3:{s:7:\"desktop\";s:79:\"#colibri .style-381 {\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:382;a:3:{s:7:\"desktop\";s:7589:\"#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu {\n  justify-content: center;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu > li {\n  margin-top: 0px;\n  margin-right: 20px;\n  margin-bottom: 0px;\n  margin-left: 20px;\n  padding-top: 10px;\n  padding-right: 0px;\n  padding-bottom: 10px;\n  padding-left: 0px;\n}\n#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu > li.hover {\n  border-top-width: 0px;\n  border-top-color: #03a9f4;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-color: #03a9f4;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-color: #03a9f4;\n  border-left-style: none;\n}\n#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu > li:hover,#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu > li.hover {\n  border-top-width: 0px;\n  border-top-color: #03a9f4;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-color: #03a9f4;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-color: #03a9f4;\n  border-left-style: none;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item,#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover {\n  margin-top: 0px;\n  margin-right: 20px;\n  margin-bottom: 0px;\n  margin-left: 20px;\n  padding-top: 10px;\n  padding-right: 0px;\n  padding-bottom: 10px;\n  padding-left: 0px;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1.5em;\n  letter-spacing: 0px;\n  color: #000000;\n}\n#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  color: #03a9f4;\n}\n#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu > li:hover > a,#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  color: #03a9f4;\n}\n#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1.5em;\n  letter-spacing: 0px;\n  color: #03a9f4;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li > ul {\n  background-color: #ffffff;\n  background-image: none;\n  margin-right: 5px;\n  margin-left: 5px;\n  box-shadow: 0px 0px 5px 2px rgba(0, 0, 0, 0.04) ;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(128,128,128,.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: rgb(255, 255, 255);\n  background-image: none;\n}\n#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #03a9f4;\n}\n#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover,#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #03a9f4;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item,#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(128,128,128,.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover > a,#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-382  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  font-size: 14px;\n  color: rgb(255, 255, 255);\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu.bordered-active-item > li::after,#colibri .style-382 \n      ul.colibri-menu.bordered-active-item > li::before {\n  background-color: #03a9f4;\n  background-image: none;\n  height: 3px;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu.solid-active-item > li::after,#colibri .style-382 \n      ul.colibri-menu.solid-active-item > li::before {\n  background-color: white;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 0%;\n  border-top-right-radius: 0%;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0%;\n  border-bottom-right-radius: 0%;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu > li > ul {\n  margin-top: 0px;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu > li > ul::before {\n  height: 0px;\n  width: 100% ;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 5px;\n  padding-left: 5px;\n  color: #000000;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 5px;\n  padding-left: 5px;\n  color: #000000;\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-382 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: rgb(255, 255, 255);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:383;a:3:{s:7:\"desktop\";s:1320:\"#colibri .style-383 .colibri_search_button {\n  width: 60px ;\n  color: #ffffff;\n  background-color: #000000;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n#colibri .style-383 .colibri_search_button:hover {\n  background-color: #f79007;\n}\n#colibri .style-383 .colibri_search_button:hover {\n  background-color: #f79007;\n}\n#colibri .style-383 .colibri_search_button svg {\n  width: 16px ;\n  fill: #ffffff;\n}\n#colibri .style-383 .colibri_search_input {\n  border-top-width: 1px;\n  border-top-color: rgb(222, 222, 222);\n  border-top-style: none;\n  border-right-width: 1px;\n  border-right-color: rgb(222, 222, 222);\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(222, 222, 222);\n  border-bottom-style: none;\n  border-left-width: 1px;\n  border-left-color: rgb(222, 222, 222);\n  border-left-style: none;\n  font-family: Source Sans Pro;\n  font-weight: 400;\n  font-style: italic;\n  font-size: 16px;\n  color: rgb(153, 153, 153);\n  padding-top: 6px;\n  padding-right: 12px;\n  padding-bottom: 7px;\n  padding-left: 12px;\n}\n#colibri .style-383 .fancybox-slide .colibri_search_input {\n  height: 50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:384;a:3:{s:7:\"desktop\";s:1283:\"#colibri .style-384-icon {\n  fill: #03a9f4;\n  width: 30px;\n  height: 30px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-384 {\n  border-top-width: 0px;\n  border-top-color: #FFFFFF;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 0px;\n  border-right-color: #FFFFFF;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 0px;\n  border-left-color: #FFFFFF;\n  border-left-style: none;\n  background-color: #FFFFFF;\n  background-image: none;\n  font-family: Source Sans Pro;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 16px;\n  line-height: 1em;\n  letter-spacing: 1px;\n  color: #000000;\n  padding-top: 5px;\n  padding-right: 22px;\n  padding-bottom: 5px;\n  padding-left: 22px;\n  text-align: center;\n}\n#colibri .style-384:hover,#colibri .style-384:focus {\n  border-top-color: #03a9f4;\n  border-right-color: #03a9f4;\n  border-bottom-color: #03a9f4;\n  border-left-color: #03a9f4;\n  background-color: #f79007;\n}\n#colibri .style-384:active .style-384-icon {\n  fill: #03a9f4;\n  width: 30px;\n  height: 30px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:385;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:386;a:3:{s:7:\"desktop\";s:309:\"#colibri .style-386 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(90deg,  #FFFFFF 50%, rgb(6, 4, 5) 50%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:387;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:388;a:3:{s:7:\"desktop\";s:157:\".style-388 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 10px;\n}\n#colibri .style-388 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:101:\"#colibri .style-388 {\n  text-align: center;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";}i:389;a:3:{s:7:\"desktop\";s:338:\"#colibri .style-389 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-position: top center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/business-1042706_1280-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:45:\"#colibri .style-389 {\n  min-height: 400px;\n}\n\";}i:391;a:3:{s:7:\"desktop\";s:4853:\"#colibri .style-391 .h-contact-form-shortcode label,#colibri .style-391 .h-contact-form-shortcode p label,#colibri .style-391 .h-contact-form-shortcode .wpcf7-not-valid-tip,#colibri .style-391 .h-contact-form-shortcode .forminator-row .forminator-col label {\n  text-align: left;\n  line-height: 2em;\n}\n#colibri .style-391 .h-contact-form-shortcode  textarea,#colibri .style-391 .h-contact-form-shortcode  form.forminator-ui textarea.forminator-textarea,#colibri .style-391 .h-contact-form-shortcode  select,#colibri .style-391 .h-contact-form-shortcode  input:not([type=\"file\"]):not([type=\"radio\"]):not([type=\"checkbox\"]):not([type=\"submit\"]) {\n  margin-top: 4px;\n  margin-bottom: 16px;\n  background-color: #ffffff;\n  background-image: none;\n  border-top-width: 1px;\n  border-top-color: rgba(34, 41, 51, 0.2);\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: rgba(34, 41, 51, 0.2);\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(34, 41, 51, 0.2);\n  border-bottom-style: solid;\n  border-left-width: 1px;\n  border-left-color: rgba(34, 41, 51, 0.2);\n  border-left-style: solid;\n  padding-top: 10px;\n  padding-right: 10px;\n  padding-bottom: 10px;\n  padding-left: 10px;\n  color: rgb(102, 102, 102);\n  font-size: 16px;\n  letter-spacing: 0px;\n}\n#colibri .style-391 .h-contact-form-shortcode [type=\"submit\"],#colibri .style-391 .h-contact-form-shortcode .forminator-row .forminator-col .forminator-button-submit {\n  background-color: rgb(236, 82, 55);\n  background-image: none;\n  color: #FFFFFF;\n  padding-top: 15px;\n  padding-right: 30px;\n  padding-bottom: 15px;\n  padding-left: 30px;\n  margin-left: 0;\n  margin-right: auto;\n  text-transform: uppercase;\n  font-size: 14px;\n  letter-spacing: 1px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-391 .h-contact-form-shortcode [type=\"submit\"]:hover,#colibri .style-391 .h-contact-form-shortcode .forminator-row .forminator-col .forminator-button-submit:hover {\n  background-color: rgb(236, 203, 55);\n}\n#colibri .style-391 .h-contact-form-shortcode [type=\"submit\"]:hover,#colibri .style-391 .h-contact-form-shortcode .forminator-row .forminator-col .forminator-button-submit:hover {\n  background-color: rgb(236, 203, 55);\n}\n#colibri .style-391 .h-contact-form-shortcode .wpcf7-mail-sent-ng,#colibri .style-391 .h-contact-form-shortcode .wpcf7-aborted,#colibri .style-391 .h-contact-form-shortcode .wpcf7 form.failed .wpcf7-response-output,#colibri .style-391 .h-contact-form-shortcode .wpcf7 form.aborted .wpcf7-response-output,#colibri .style-391 .h-contact-form-shortcode form.forminator-ui  .forminator-response-message.forminator-error {\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n  background-color: rgb(255, 0, 0);\n  background-image: none;\n  color: rgb(255, 255, 255);\n}\n#colibri .style-391 .h-contact-form-shortcode .wpcf7-validation-errors,#colibri .style-391 .h-contact-form-shortcode .wpcf7 form.invalid .wpcf7-response-output,#colibri .style-391 .h-contact-form-shortcode .wpcf7 form.unaccepted .wpcf7-response-output,#colibri .style-391 .h-contact-form-shortcode form.forminator-ui  .forminator-response-message.forminator-loading {\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n  background-color: rgba(255, 233, 76, 0.52);\n  background-image: none;\n}\n#colibri .style-391 .h-contact-form-shortcode .wpcf7-mail-sent-ok,#colibri .style-391 .h-contact-form-shortcode .wpcf7 form.sent .wpcf7-response-output,#colibri .style-391 .h-contact-form-shortcode .wpforms-confirmation-container-full,#colibri .style-391 .h-contact-form-shortcode .wpforms-confirmation-container,#colibri .style-391 .h-contact-form-shortcode form.forminator-ui  .forminator-response-message.forminator-success {\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n  background-color: rgb(177, 250, 159);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:392;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-392 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:393;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-393 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:394;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-394 ol {\n  list-style-type: decimal;\n}\n#colibri .style-394 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:395;a:3:{s:7:\"desktop\";s:40:\"#colibri .style-395 {\n  height: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:396;a:3:{s:7:\"desktop\";s:296:\"#colibri .style-396 {\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(120deg,  rgba(253, 251, 251, 0.8) 0%, rgba(235, 237, 238, 0.8) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:397;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:398;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-398 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:399;a:3:{s:7:\"desktop\";s:530:\".style-399 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-399 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  border-top-width: 2px;\n  border-top-color: rgb(236, 82, 55);\n  border-top-style: none;\n  border-right-width: 2px;\n  border-right-color: rgb(236, 82, 55);\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(236, 82, 55);\n  border-bottom-style: none;\n  border-left-width: 2px;\n  border-left-color: rgb(236, 82, 55);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:400;a:3:{s:7:\"desktop\";s:1288:\"#colibri .style-400 .widget {\n  text-align: left;\n}\n#colibri .style-400 .widget h1,#colibri .style-400 .widget h2,#colibri .style-400 .widget h3,#colibri .style-400 .widget h4,#colibri .style-400 .widget h5,#colibri .style-400 .widget h6 {\n  font-size: 24px;\n}\n#colibri .style-400 .widget ul li,#colibri .style-400 .widget ol li,#colibri .style-400 .widget  .textwidget p,#colibri .style-400 .widget  .calendar_wrap td ,#colibri .style-400  .widget  .calendar_wrap th ,#colibri .style-400  .widget  .calendar_wrap caption {\n  font-size: 16px;\n  color: black;\n}\n#colibri .style-400 .widget ul li a:not(.wp-block-button__link) {\n  font-size: 16px;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-400 .widget ul li a:not(.wp-block-button__link):hover {\n  color: rgb(236, 203, 55);\n}\n#colibri .style-400 .widget ul li a:not(.wp-block-button__link):hover {\n  color: rgb(236, 203, 55);\n}\n#colibri .style-400 .widget input:not([type=\"submit\"]) {\n  color: black;\n  border-top-width: 1px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-left-width: 1px;\n  border-left-color: black;\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:401;a:3:{s:7:\"desktop\";s:312:\"#colibri .style-400 .widget.widget_calendar h1,#colibri .style-400 .widget.widget_calendar h2,#colibri .style-400 .widget.widget_calendar h3,#colibri .style-400 .widget.widget_calendar h4,#colibri .style-400 .widget.widget_calendar h5,#colibri .style-400 .widget.widget_calendar h6 {\n  color: rgb(34, 41, 51);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:402;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-402 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:404;a:3:{s:7:\"desktop\";s:909:\"#colibri .style-404-icon {\n  fill: rgb(236, 82, 55);\n  width: 16px ;\n  height: 16px;\n  padding-left: 0px;\n}\n#colibri .style-404-icon:hover {\n  fill: rgb(236, 203, 55);\n}\n#colibri .style-404 .list-item-text-wrapper {\n  horizontal-align: start;\n  padding-bottom: 0px;\n}\n#colibri .style-404 .list-text {\n  margin-left: 10px;\n  color: rgb(34, 41, 51);\n  text-transform: capitalize;\n}\n#colibri .style-404 .list-divider {\n  color: rgb(0,0,0);\n  width: 100% ;\n  height: 0%;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n  margin-left: 0px;\n}\n#colibri .style-404 .list-container-divider {\n  width: 100% ;\n  padding-top: 2px;\n  padding-right: 0px;\n  padding-bottom: 2px;\n  padding-left: 0px;\n  height: 1px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:406;a:3:{s:7:\"desktop\";s:676:\"#colibri .style-406-icon {\n  fill: rgb(204, 204, 204);\n  width: 100px ;\n  height: 100px;\n  border-top-width: 1px;\n  border-top-color: rgb(125, 79, 79);\n  border-top-style: none;\n  border-right-width: 1px;\n  border-right-color: rgb(125, 79, 79);\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(125, 79, 79);\n  border-bottom-style: none;\n  border-left-width: 1px;\n  border-left-color: rgb(125, 79, 79);\n  border-left-style: none;\n  background-color: rgb(250, 249, 249);\n  background-image: none;\n}\n#colibri .style-406-icon:hover {\n  fill: rgb(236, 82, 55);\n}\n#colibri .style-406 {\n  margin-bottom: -55px;\n  margin-left: -32px;\n  z-index: 2;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:46:\"#colibri .style-406 {\n  margin-left: -15px;\n}\n\";}i:407;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:408;a:3:{s:7:\"desktop\";s:624:\".style-408 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 5px;\n}\n#colibri .style-408 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  border-top-width: 2px;\n  border-top-color: rgb(236, 82, 55);\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: rgb(236, 82, 55);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(236, 82, 55);\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: rgb(236, 82, 55);\n  border-left-style: solid;\n  padding-top: 2rem;\n  padding-right: 2rem;\n  padding-bottom: 2rem;\n  padding-left: 2rem;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:410;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:412;a:3:{s:7:\"desktop\";s:7585:\"#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu {\n  justify-content: center;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu > li {\n  margin-top: 0px;\n  margin-right: 20px;\n  margin-bottom: 0px;\n  margin-left: 20px;\n  padding-top: 10px;\n  padding-right: 0px;\n  padding-bottom: 10px;\n  padding-left: 0px;\n}\n#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu > li.hover {\n  border-top-width: 0px;\n  border-top-color: #03a9f4;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-color: #03a9f4;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-color: #03a9f4;\n  border-left-style: none;\n}\n#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu > li:hover,#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu > li.hover {\n  border-top-width: 0px;\n  border-top-color: #03a9f4;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-color: #03a9f4;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-color: #03a9f4;\n  border-left-style: none;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item,#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover {\n  margin-top: 0px;\n  margin-right: 20px;\n  margin-bottom: 0px;\n  margin-left: 20px;\n  padding-top: 10px;\n  padding-right: 0px;\n  padding-bottom: 10px;\n  padding-left: 0px;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1.5em;\n  letter-spacing: 0px;\n  color: #FFFFFF;\n}\n#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  color: #000000;\n}\n#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu > li:hover > a,#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  color: #000000;\n}\n#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 14px;\n  line-height: 1.5em;\n  letter-spacing: 0px;\n  color: #000000;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li > ul {\n  background-color: #ffffff;\n  background-image: none;\n  margin-right: 5px;\n  margin-left: 5px;\n  box-shadow: 0px 0px 5px 2px rgba(0, 0, 0, 0.04) ;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(128,128,128,.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: rgb(255, 255, 255);\n  background-image: none;\n}\n#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #03a9f4;\n}\n#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover,#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover {\n  background-color: #03a9f4;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item,#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover {\n  padding-top: 10px;\n  padding-right: 20px;\n  padding-bottom: 10px;\n  padding-left: 20px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(128,128,128,.2);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: none;\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li:hover > a,#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.hover  > a {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-412  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  font-size: 14px;\n  color: rgb(255, 255, 255);\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu.bordered-active-item > li::after,#colibri .style-412 \n      ul.colibri-menu.bordered-active-item > li::before {\n  background-color: #03a9f4;\n  background-image: none;\n  height: 3px;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu.solid-active-item > li::after,#colibri .style-412 \n      ul.colibri-menu.solid-active-item > li::before {\n  background-color: white;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 0%;\n  border-top-right-radius: 0%;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0%;\n  border-bottom-right-radius: 0%;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu > li > ul {\n  margin-top: 0px;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu > li > ul::before {\n  height: 0px;\n  width: 100% ;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 5px;\n  padding-left: 5px;\n  color: black;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 5px;\n  padding-left: 5px;\n  color: black;\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: rgb(255, 255, 255);\n}\n#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-412 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: rgb(255, 255, 255);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:413;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:414;a:3:{s:7:\"desktop\";s:138:\"#colibri .style-414 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: #6632ff;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:415;a:3:{s:7:\"desktop\";s:931:\"#colibri .style-415-offscreen {\n  background-color: #222B34;\n  background-image: none;\n  width: 300px !important;\n}\n#colibri .style-415-offscreenOverlay {\n  background-color: rgba(0,0,0,0.5);\n  background-image: none;\n}\n#colibri .style-415  .h-hamburger-icon {\n  background-color: rgba(0, 0, 0, 0.1);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-top-left-radius: 100%;\n  border-top-right-radius: 100%;\n  border-right-width: 0px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 100%;\n  border-bottom-right-radius: 100%;\n  border-left-width: 0px;\n  border-left-color: black;\n  border-left-style: solid;\n  fill: white;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n  width: 24px;\n  height: 24px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:416;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:417;a:3:{s:7:\"desktop\";s:4477:\"#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(236, 82, 55, 0.3);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  text-transform: capitalize;\n  font-size: 14px;\n  color: #FFFFFF;\n}\n#colibri .style-417  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-417  >  div > .colibri-menu-container > ul.colibri-menu > li:hover > a,#colibri .style-417  >  div > .colibri-menu-container > ul.colibri-menu > li.hover  > a {\n  background-color: #03a9f4;\n  background-image: none;\n}\n#colibri .style-417  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a,#colibri .style-417  >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgba(236, 82, 55, 0.3);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  background-color: #03a9f4;\n  background-image: none;\n  text-transform: capitalize;\n  font-size: 14px;\n  color: #FFFFFF;\n}\n#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li > a {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a,#colibri .style-417  >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item > a:hover {\n  padding-top: 12px;\n  padding-bottom: 12px;\n  padding-left: 40px;\n  border-top-width: 0px;\n  border-top-color: #808080;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #808080;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #808080;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #808080;\n  border-left-style: solid;\n  font-size: 14px;\n  color: white;\n}\n#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu  li > a > svg,#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu  li > a >  .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: black;\n}\n#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > svg,#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > svg,#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu li.current_page_item > a > .arrow-wrapper,#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu > li.current_page_item:hover > a > .arrow-wrapper {\n  padding-right: 20px;\n  padding-left: 20px;\n  color: black;\n}\n#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a > svg,#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu li > ul  li > a >  .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > svg,#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > svg,#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu li > ul li.current_page_item > a > .arrow-wrapper,#colibri .style-417 >  div > .colibri-menu-container > ul.colibri-menu li > ul > li.current_page_item:hover > a > .arrow-wrapper {\n  color: white;\n  padding-right: 20px;\n  padding-left: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:418;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:419;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-419 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:420;a:3:{s:7:\"desktop\";s:151:\"#colibri .style-420-image {\n  max-height: 70px;\n}\n#colibri .style-420 a,#colibri .style-420  .logo-text {\n  color: #ffffff;\n  text-decoration: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:421;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:422;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-422 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:424;a:3:{s:7:\"desktop\";s:296:\"#colibri .style-424 {\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(120deg,  rgba(253, 251, 251, 0.8) 0%, rgba(235, 237, 238, 0.8) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:425;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:426;a:3:{s:7:\"desktop\";s:190:\"#colibri .style-426 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: #FFFFFF;\n  background-image: none;\n  box-shadow: 1px 1px 0px 0px rgba(0, 0, 0, 0.05) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:428;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:429;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-429 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:430;a:3:{s:7:\"desktop\";s:156:\".style-430 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 5px;\n}\n#colibri .style-430 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:46:\"#colibri .style-430 {\n  text-align: center;\n}\n\";}i:432;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-432 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:433;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-433 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:435;a:3:{s:7:\"desktop\";s:879:\"#colibri .style-435-icon {\n  fill: rgb(236, 82, 55);\n  width: 20px ;\n  height: 20px;\n  padding-left: 0px;\n}\n#colibri .style-435-icon:hover {\n  fill: rgb(236, 203, 55);\n}\n#colibri .style-435 .list-item-text-wrapper {\n  horizontal-align: start;\n  padding-bottom: 0px;\n}\n#colibri .style-435 .list-text {\n  margin-left: 10px;\n  color: rgb(34, 41, 51);\n}\n#colibri .style-435 .list-divider {\n  color: rgb(0,0,0);\n  width: 100% ;\n  height: 0%;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n  margin-left: 0px;\n}\n#colibri .style-435 .list-container-divider {\n  width: 100% ;\n  padding-top: 2px;\n  padding-right: 0px;\n  padding-bottom: 2px;\n  padding-left: 0px;\n  height: 1px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:76:\"#colibri .style-435 .list-item-text-wrapper {\n  horizontal-align: center;\n}\n\";}i:436;a:3:{s:7:\"desktop\";s:1098:\"#colibri .style-436 {\n  text-align: center;\n  box-shadow: none;\n}\n#colibri .style-436 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/model-2911329_640.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n}\n#colibri .style-436 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-436 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-436 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-436 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-436 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-436 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-436 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-436 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:437;a:3:{s:7:\"desktop\";s:67:\"#colibri .style-437 {\n  min-height: 150px;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:44:\"#colibri .style-437 {\n  min-height: 80px;\n}\n\";s:6:\"mobile\";s:45:\"#colibri .style-437 {\n  min-height: 300px;\n}\n\";}i:440;a:3:{s:7:\"desktop\";s:101:\"#colibri .style-440 {\n  height: 100%;\n  width: 100% ;\n  top: 0%;\n  left: 0%;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:444;a:3:{s:7:\"desktop\";s:581:\"#colibri .style-444-icon {\n  fill: #FFFFFF;\n  width: 40px ;\n  height: 40px;\n  border-top-width: 1px;\n  border-top-color: rgb(125, 79, 79);\n  border-top-style: none;\n  border-right-width: 1px;\n  border-right-color: rgb(125, 79, 79);\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(125, 79, 79);\n  border-bottom-style: none;\n  border-left-width: 1px;\n  border-left-color: rgb(125, 79, 79);\n  border-left-style: none;\n}\n#colibri .style-444-icon:hover {\n  fill: rgb(236, 82, 55);\n  background-color: rgba(45, 45, 134, 0);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:445;a:3:{s:7:\"desktop\";s:1095:\"#colibri .style-445 {\n  text-align: center;\n  box-shadow: none;\n}\n#colibri .style-445 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/man-537136_640.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n}\n#colibri .style-445 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-445 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-445 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-445 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-445 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-445 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-445 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-445 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:446;a:3:{s:7:\"desktop\";s:1108:\"#colibri .style-446 {\n  text-align: center;\n  box-shadow: none;\n}\n#colibri .style-446 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/business-woman-2071342_1920.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n}\n#colibri .style-446 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-446 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-446 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-446 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-446 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-446 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-446 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-446 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:447;a:3:{s:7:\"desktop\";s:1097:\"#colibri .style-447 {\n  text-align: center;\n  box-shadow: none;\n}\n#colibri .style-447 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/man-1209494_1280.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n}\n#colibri .style-447 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-447 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-447 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-447 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-447 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-447 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-447 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-447 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:448;a:3:{s:7:\"desktop\";s:1103:\"#colibri .style-448 {\n  text-align: center;\n  box-shadow: none;\n}\n#colibri .style-448 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/businessman-805769_640.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n}\n#colibri .style-448 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-448 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-448 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-448 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-448 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-448 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-448 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-448 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:449;a:3:{s:7:\"desktop\";s:1105:\"#colibri .style-449 {\n  text-align: center;\n  box-shadow: none;\n}\n#colibri .style-449 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/business-man-1125324_640.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n}\n#colibri .style-449 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-449 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-449 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-449 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-449 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-449 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-449 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-449 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:450;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:451;a:3:{s:7:\"desktop\";s:296:\"#colibri .style-451 {\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(120deg,  rgba(253, 251, 251, 0.8) 0%, rgba(235, 237, 238, 0.8) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:452;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:453;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-453 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:454;a:3:{s:7:\"desktop\";s:551:\"#colibri .style-454 {\n  box-shadow: none;\n}\n#colibri .style-454 .gallery-item img {\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n  box-shadow: none;\n}\n#colibri .style-454 .gallery-caption {\n  background-color: white;\n  background-image: none;\n  padding-top: 5px;\n  padding-bottom: 5px;\n  margin-top: 0px;\n  margin-right: 5px;\n  margin-bottom: 5px;\n  margin-left: 5px;\n  font-family: Source Sans Pro;\n  color: rgb(34, 41, 51);\n}\n#colibri .style-454 .gallery-element-image-overlay {\n  transition-duration: 1s;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:455;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:456;a:3:{s:7:\"desktop\";s:296:\"#colibri .style-456 {\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(120deg,  rgba(253, 251, 251, 0.8) 0%, rgba(235, 237, 238, 0.8) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:457;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:458;a:3:{s:7:\"desktop\";s:190:\"#colibri .style-458 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  box-shadow: 1px 1px 0px 0px rgba(0, 0, 0, 0.05) ;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:460;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:461;a:3:{s:7:\"desktop\";s:318:\"#colibri .style-461 {\n  text-align: center;\n  min-height: 150px;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/race-4186517_640.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:45:\"#colibri .style-461 {\n  min-height: 250px;\n}\n\";}i:462;a:3:{s:7:\"desktop\";s:156:\".style-462 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 5px;\n}\n#colibri .style-462 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:46:\"#colibri .style-462 {\n  text-align: center;\n}\n\";}i:463;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-463 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:464;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:465;a:3:{s:7:\"desktop\";s:1360:\"#colibri .style-465-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-465 {\n  border-top-width: 2px;\n  border-top-color: rgb(236, 82, 55);\n  border-top-style: solid;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-color: rgb(236, 82, 55);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(236, 82, 55);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-color: rgb(236, 82, 55);\n  border-left-style: solid;\n  background-color: rgba(236, 82, 55, 0);\n  background-image: none;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1em;\n  letter-spacing: 1px;\n  color: rgb(34, 41, 51);\n  text-align: center;\n  padding-top: 12px;\n  padding-right: 24px;\n  padding-bottom: 12px;\n  padding-left: 24px;\n}\n#colibri .style-465:hover,#colibri .style-465:focus {\n  border-top-color: rgb(236, 203, 55);\n  border-right-color: rgb(236, 203, 55);\n  border-bottom-color: rgb(236, 203, 55);\n  border-left-color: rgb(236, 203, 55);\n  background-color: rgba(236, 203, 55, 0);\n}\n#colibri .style-465:active .style-465-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:466;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-466 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:468;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:469;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-469 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:470;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-470 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:46:\"#colibri .style-470 {\n  text-align: center;\n}\n\";}i:471;a:3:{s:7:\"desktop\";s:490:\"#colibri .style-471 p,#colibri .style-471  h1,#colibri .style-471  h2,#colibri .style-471  h3,#colibri .style-471  h4,#colibri .style-471  h5,#colibri .style-471  h6 {\n  background-color: rgb(236, 82, 55);\n  background-image: none;\n  padding-top: 10px;\n  padding-right: 10px;\n  padding-bottom: 10px;\n  padding-left: 10px;\n  color: #FFFFFF;\n}\n#colibri .style-471 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:474;a:3:{s:7:\"desktop\";s:880:\"#colibri .style-474-icon {\n  fill: rgb(236, 82, 55);\n  width: 20px ;\n  height: 20px;\n  padding-left: 10px;\n}\n#colibri .style-474-icon:hover {\n  fill: rgb(126, 176, 59);\n}\n#colibri .style-474 .list-item-text-wrapper {\n  horizontal-align: start;\n  padding-bottom: 0px;\n}\n#colibri .style-474 .list-text {\n  margin-left: 10px;\n  color: rgb(34, 41, 51);\n}\n#colibri .style-474 .list-divider {\n  color: rgb(0,0,0);\n  width: 100% ;\n  height: 0%;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n  margin-left: 0px;\n}\n#colibri .style-474 .list-container-divider {\n  width: 100% ;\n  padding-top: 2px;\n  padding-right: 0px;\n  padding-bottom: 2px;\n  padding-left: 0px;\n  height: 1px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:76:\"#colibri .style-474 .list-item-text-wrapper {\n  horizontal-align: center;\n}\n\";}i:475;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-475 ol {\n  list-style-type: decimal;\n}\n#colibri .style-475 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:476;a:3:{s:7:\"desktop\";s:337:\"#colibri .style-476 {\n  text-align: center;\n  min-height: 150px;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/bookcase-books-bookshelves-256541-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:45:\"#colibri .style-476 {\n  min-height: 250px;\n}\n\";}i:477;a:3:{s:7:\"desktop\";s:318:\"#colibri .style-477 {\n  text-align: center;\n  min-height: 150px;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/dog-644111_640-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:45:\"#colibri .style-477 {\n  min-height: 250px;\n}\n\";}i:478;a:3:{s:7:\"desktop\";s:333:\"#colibri .style-478 {\n  text-align: center;\n  min-height: 150px;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/hands-holding-plate-2110438_640.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:45:\"#colibri .style-478 {\n  min-height: 250px;\n}\n\";}i:479;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:485;a:3:{s:7:\"desktop\";s:1138:\"#colibri .style-485-icon {\n  fill: rgb(236, 82, 55);\n  width: 20px ;\n  height: 20px;\n  padding-left: 10px;\n}\n#colibri .style-485-icon:hover {\n  fill: rgb(236, 203, 55);\n}\n#colibri .style-485 .list-item-text-wrapper {\n  horizontal-align: start;\n  padding-bottom: 0px;\n}\n#colibri .style-485 a:hover,#colibri .style-485  a span.list-text:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-485 a:hover,#colibri .style-485  a span.list-text:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-485 .list-text {\n  margin-left: 10px;\n  color: rgb(153, 153, 153);\n  text-decoration: underline;\n  font-size: 18px;\n}\n#colibri .style-485 .list-divider {\n  color: rgb(0,0,0);\n  width: 100% ;\n  height: 0%;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n  margin-left: 0px;\n}\n#colibri .style-485 .list-container-divider {\n  width: 100% ;\n  padding-top: 5px;\n  padding-right: 0px;\n  padding-bottom: 5px;\n  padding-left: 0px;\n  height: 1px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:488;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:489;a:3:{s:7:\"desktop\";s:61:\"#colibri .style-489 {\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:490;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:491;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-491 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:46:\"#colibri .style-491 {\n  text-align: center;\n}\n\";}i:492;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-492 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:493;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-493 ol {\n  list-style-type: decimal;\n}\n#colibri .style-493 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:494;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-494 ol {\n  list-style-type: decimal;\n}\n#colibri .style-494 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:497;a:3:{s:7:\"desktop\";s:104:\"#colibri .style-497 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:498;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:499;a:3:{s:7:\"desktop\";s:172:\"#colibri .style-499 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  padding-top: 8rem;\n  padding-right: 8rem;\n  padding-bottom: 8rem;\n  padding-left: 12rem;\n}\n\";s:6:\"tablet\";s:114:\"#colibri .style-499 {\n  padding-top: 2rem;\n  padding-right: 2rem;\n  padding-bottom: 2rem;\n  padding-left: 2rem;\n}\n\";s:6:\"mobile\";s:136:\"#colibri .style-499 {\n  text-align: center;\n  padding-top: 2rem;\n  padding-right: 2rem;\n  padding-bottom: 2rem;\n  padding-left: 2rem;\n}\n\";}i:500;a:3:{s:7:\"desktop\";s:356:\"#colibri .style-500 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/aerial-view-architecture-cars-280221-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:45:\"#colibri .style-500 {\n  min-height: 300px;\n}\n\";}i:501;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-501 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:502;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-502 ol {\n  list-style-type: decimal;\n}\n#colibri .style-502 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:503;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-503 ol {\n  list-style-type: decimal;\n}\n#colibri .style-503 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:504;a:3:{s:7:\"desktop\";s:209:\"#colibri .style-504 {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-504 p {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-504 ol {\n  list-style-type: decimal;\n}\n#colibri .style-504 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:505;a:3:{s:7:\"desktop\";s:104:\"#colibri .style-505 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:506;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:507;a:3:{s:7:\"desktop\";s:351:\"#colibri .style-507 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/livestock-london-mammal-1717085-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:45:\"#colibri .style-507 {\n  min-height: 300px;\n}\n\";}i:508;a:3:{s:7:\"desktop\";s:247:\".style-508 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-508 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  padding-top: 8rem;\n  padding-right: 12rem;\n  padding-bottom: 8rem;\n  padding-left: 8rem;\n}\n\";s:6:\"tablet\";s:114:\"#colibri .style-508 {\n  padding-top: 2rem;\n  padding-right: 2rem;\n  padding-bottom: 2rem;\n  padding-left: 2rem;\n}\n\";s:6:\"mobile\";s:136:\"#colibri .style-508 {\n  text-align: center;\n  padding-top: 2rem;\n  padding-right: 2rem;\n  padding-bottom: 2rem;\n  padding-left: 2rem;\n}\n\";}i:509;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-509 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:510;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-510 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:511;a:3:{s:7:\"desktop\";s:345:\"#colibri .style-511 p,#colibri .style-511  h1,#colibri .style-511  h2,#colibri .style-511  h3,#colibri .style-511  h4,#colibri .style-511  h5,#colibri .style-511  h6 {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-511 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:512;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-512 ol {\n  list-style-type: decimal;\n}\n#colibri .style-512 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:513;a:3:{s:7:\"desktop\";s:40:\"#colibri .style-513 {\n  height: 30px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:514;a:3:{s:7:\"desktop\";s:40:\"#colibri .style-514 {\n  height: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:515;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-515 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:516;a:3:{s:7:\"desktop\";s:345:\"#colibri .style-516 p,#colibri .style-516  h1,#colibri .style-516  h2,#colibri .style-516  h3,#colibri .style-516  h4,#colibri .style-516  h5,#colibri .style-516  h6 {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-516 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:517;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-517 ol {\n  list-style-type: decimal;\n}\n#colibri .style-517 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:518;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-518 ol {\n  list-style-type: decimal;\n}\n#colibri .style-518 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:519;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:520;a:3:{s:7:\"desktop\";s:296:\"#colibri .style-520 {\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(120deg,  rgba(253, 251, 251, 0.8) 0%, rgba(235, 237, 238, 0.8) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:521;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:522;a:3:{s:7:\"desktop\";s:265:\".style-522 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-522 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: #FFFFFF;\n  background-image: none;\n  box-shadow: 1px 1px 0px 0px rgba(0, 0, 0, 0.05) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:525;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-525 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:526;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-526 ol {\n  list-style-type: decimal;\n}\n#colibri .style-526 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:527;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:528;a:3:{s:7:\"desktop\";s:214:\"#colibri .style-528-icon {\n  width: 18px ;\n  height: 18px;\n  margin-right: 0px;\n  margin-left: 10px;\n}\n#colibri .style-528-icon:visited {\n  width: 18px ;\n  height: 18px;\n  margin-right: 0px;\n  margin-left: 10px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:529;a:3:{s:7:\"desktop\";s:1141:\"#colibri .style-529 {\n  text-align: center;\n  box-shadow: none;\n}\n#colibri .style-529 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/bus-2531578_640.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n  padding-right: 50px;\n  padding-left: 50px;\n}\n#colibri .style-529 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-529 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-529 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-529 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-529 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-529 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-529 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-529 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:530;a:3:{s:7:\"desktop\";s:67:\"#colibri .style-530 {\n  min-height: 250px;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:533;a:3:{s:7:\"desktop\";s:101:\"#colibri .style-533 {\n  height: 100%;\n  width: 100% ;\n  top: 0%;\n  left: 0%;\n  text-align: center;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:536;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:537;a:3:{s:7:\"desktop\";s:159:\".style-537 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 20px;\n}\n#colibri .style-537 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:540;a:3:{s:7:\"desktop\";s:581:\"#colibri .style-540-icon {\n  fill: #FFFFFF;\n  width: 50px ;\n  height: 50px;\n  border-top-width: 1px;\n  border-top-color: rgb(125, 79, 79);\n  border-top-style: none;\n  border-right-width: 1px;\n  border-right-color: rgb(125, 79, 79);\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(125, 79, 79);\n  border-bottom-style: none;\n  border-left-width: 1px;\n  border-left-color: rgb(125, 79, 79);\n  border-left-style: none;\n}\n#colibri .style-540-icon:hover {\n  fill: rgb(236, 82, 55);\n  background-color: rgba(45, 45, 134, 0);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:541;a:3:{s:7:\"desktop\";s:1140:\"#colibri .style-541 {\n  text-align: center;\n  box-shadow: none;\n}\n#colibri .style-541 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/dog-644111_640.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n  padding-right: 50px;\n  padding-left: 50px;\n}\n#colibri .style-541 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-541 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-541 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-541 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-541 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-541 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-541 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-541 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:542;a:3:{s:7:\"desktop\";s:1145:\"#colibri .style-542 {\n  text-align: center;\n  box-shadow: none;\n}\n#colibri .style-542 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/speed-4216828_640-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n  padding-right: 50px;\n  padding-left: 50px;\n}\n#colibri .style-542 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-542 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-542 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-542 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-542 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-542 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-542 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-542 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:543;a:3:{s:7:\"desktop\";s:1147:\"#colibri .style-543 {\n  text-align: center;\n  box-shadow: none;\n}\n#colibri .style-543 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/bodyworn-794111_640-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n  padding-right: 50px;\n  padding-left: 50px;\n}\n#colibri .style-543 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-543 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-543 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-543 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-543 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-543 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-543 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-543 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:544;a:3:{s:7:\"desktop\";s:1144:\"#colibri .style-544 {\n  text-align: center;\n  box-shadow: none;\n}\n#colibri .style-544 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/park-3089907_640-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n  padding-right: 50px;\n  padding-left: 50px;\n}\n#colibri .style-544 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-544 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-544 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-544 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-544 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-544 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-544 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-544 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:545;a:3:{s:7:\"desktop\";s:1145:\"#colibri .style-545 {\n  text-align: center;\n  box-shadow: none;\n}\n#colibri .style-545 .h-content-swap__normal {\n  animation-duration: 500ms;\n  width: 100% ;\n  background-color: rgba(236, 82, 55, 0);\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/hands-2906458_640-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n  color: #FFFFFF;\n  padding-right: 50px;\n  padding-left: 50px;\n}\n#colibri .style-545 .h-content-swap__normal h1 {\n  color: #FFFFFF;\n}\n#colibri .style-545 .h-content-swap__normal h2 {\n  color: #FFFFFF;\n}\n#colibri .style-545 .h-content-swap__normal h3 {\n  color: #FFFFFF;\n}\n#colibri .style-545 .h-content-swap__normal h4 {\n  color: #FFFFFF;\n}\n#colibri .style-545 .h-content-swap__normal h5 {\n  color: #FFFFFF;\n}\n#colibri .style-545 .h-content-swap__normal h6 {\n  color: #FFFFFF;\n}\n#colibri .style-545 .h-content-swap__normal p {\n  color: #FFFFFF;\n}\n#colibri .style-545 .h-content-swap__hover {\n  animation-duration: 500ms;\n  background-color: rgba(34, 41, 51, 0.7);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:546;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:547;a:3:{s:7:\"desktop\";s:104:\"#colibri .style-547 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:548;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:549;a:3:{s:7:\"desktop\";s:407:\"#colibri .style-549 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  padding-top: 8rem;\n  padding-right: 8rem;\n  padding-bottom: 8rem;\n  padding-left: 12rem;\n  background-position: center center;\n  background-size: cover;\n  background-image: linear-gradient(120deg,  rgba(253, 251, 251, 0.8) 0%, rgba(235, 237, 238, 0.8) 100%);\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:114:\"#colibri .style-549 {\n  padding-top: 2rem;\n  padding-right: 2rem;\n  padding-bottom: 2rem;\n  padding-left: 2rem;\n}\n\";s:6:\"mobile\";s:136:\"#colibri .style-549 {\n  text-align: center;\n  padding-top: 2rem;\n  padding-right: 2rem;\n  padding-bottom: 2rem;\n  padding-left: 2rem;\n}\n\";}i:550;a:3:{s:7:\"desktop\";s:344:\"#colibri .style-550 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"https://colibriwp-work.colibriwp.com/city-pro/wp-content/uploads/2020/01/soccer-field-219812_1280-1.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:45:\"#colibri .style-550 {\n  min-height: 300px;\n}\n\";}i:551;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-551 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:552;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-552 ol {\n  list-style-type: decimal;\n}\n#colibri .style-552 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:555;a:3:{s:7:\"desktop\";s:613:\"#colibri .style-555 .h-svg-icon {\n  fill: #000000;\n  width: 12px ;\n  height: 12px;\n  margin-right: 10px;\n}\n#colibri .style-555 .bar-counter {\n  font-weight: 600;\n  color: rgb(126, 176, 59);\n}\n#colibri .style-555 .circle-counter {\n  font-size: 3em;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-555 .simple-counter {\n  font-size: 3em;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-555 .title-number {\n  font-size: 21px;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-555 .title-circle {\n  font-size: 21px;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-555 .title-bar {\n  font-weight: 600;\n  color: rgb(126, 176, 59);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:556;a:3:{s:7:\"desktop\";s:61:\"#colibri .style-556 {\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:557;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:558;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-558 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:561;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:562;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-562 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:563;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-563 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:564;a:3:{s:7:\"desktop\";s:215:\"#colibri .style-564 {\n  text-transform: uppercase;\n}\n#colibri .style-564 p {\n  text-transform: uppercase;\n}\n#colibri .style-564 ol {\n  list-style-type: decimal;\n}\n#colibri .style-564 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:566;a:3:{s:7:\"desktop\";s:503:\"#colibri .style-566-line {\n  width: 90px ;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(236, 82, 55);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n#colibri .style-566-icon {\n  fill: rgb(236, 82, 55);\n  width: 50px ;\n  height: 50px;\n  margin-right: 10px;\n  margin-left: 10px;\n}\n#colibri .style-566 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:567;a:3:{s:7:\"desktop\";s:611:\"#colibri .style-567 .h-svg-icon {\n  fill: #000000;\n  width: 12px ;\n  height: 12px;\n  margin-right: 10px;\n}\n#colibri .style-567 .bar-counter {\n  font-weight: 600;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-567 .circle-counter {\n  font-size: 3em;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-567 .simple-counter {\n  font-size: 3em;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-567 .title-number {\n  font-size: 21px;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-567 .title-circle {\n  font-size: 21px;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-567 .title-bar {\n  font-weight: 600;\n  color: rgb(236, 82, 55);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:568;a:3:{s:7:\"desktop\";s:613:\"#colibri .style-568 .h-svg-icon {\n  fill: #000000;\n  width: 12px ;\n  height: 12px;\n  margin-right: 10px;\n}\n#colibri .style-568 .bar-counter {\n  font-weight: 600;\n  color: rgb(236, 203, 55);\n}\n#colibri .style-568 .circle-counter {\n  font-size: 3em;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-568 .simple-counter {\n  font-size: 3em;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-568 .title-number {\n  font-size: 21px;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-568 .title-circle {\n  font-size: 21px;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-568 .title-bar {\n  font-weight: 600;\n  color: rgb(236, 203, 55);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:569;a:3:{s:7:\"desktop\";s:649:\"#colibri .style-569-image {\n  opacity: 1;\n}\n#colibri .style-569-caption {\n  margin-top: 10px;\n}\n#colibri .style-569-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:570;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-570 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:571;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-571 ol {\n  list-style-type: decimal;\n}\n#colibri .style-571 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:572;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:573;a:3:{s:7:\"desktop\";s:214:\"#colibri .style-573-icon {\n  width: 18px ;\n  height: 18px;\n  margin-right: 0px;\n  margin-left: 10px;\n}\n#colibri .style-573-icon:visited {\n  width: 18px ;\n  height: 18px;\n  margin-right: 0px;\n  margin-left: 10px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:575;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:582;a:3:{s:7:\"desktop\";s:61:\"#colibri .style-582 {\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:583;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:586;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-586 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:587;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-587 ol {\n  list-style-type: decimal;\n}\n#colibri .style-587 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:589;a:3:{s:7:\"desktop\";s:503:\"#colibri .style-589-line {\n  width: 90px ;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(236, 82, 55);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n}\n#colibri .style-589-icon {\n  fill: rgb(236, 82, 55);\n  width: 50px ;\n  height: 50px;\n  margin-right: 10px;\n  margin-left: 10px;\n}\n#colibri .style-589 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:590;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-590 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:46:\"#colibri .style-590 {\n  text-align: center;\n}\n\";}i:591;a:3:{s:7:\"desktop\";s:493:\"#colibri .style-591 {\n  height: auto;\n  min-height: unset;\n  padding-top: 20px;\n  padding-bottom: 20px;\n  background-color: #6632ff;\n  background-image: none;\n  color: #FFFFFF;\n}\n#colibri .style-591 h1 {\n  color: #FFFFFF;\n}\n#colibri .style-591 h2 {\n  color: #FFFFFF;\n}\n#colibri .style-591 h3 {\n  color: #FFFFFF;\n}\n#colibri .style-591 h4 {\n  color: #FFFFFF;\n}\n#colibri .style-591 h5 {\n  color: #FFFFFF;\n}\n#colibri .style-591 h6 {\n  color: #FFFFFF;\n}\n#colibri .style-591 p {\n  color: #FFFFFF;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:592;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:593;a:3:{s:7:\"desktop\";s:500:\".style-593 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 2px;\n}\n#colibri .style-593 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 2px;\n  border-top-color: #FFFFFF;\n  border-top-style: solid;\n  border-right-width: 2px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-left-width: 2px;\n  border-left-color: #FFFFFF;\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:595;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:596;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:597;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:598;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:601;a:3:{s:7:\"desktop\";s:572:\"#colibri .style-601-icon {\n  fill: #000000;\n  width: 60px ;\n  height: 60px;\n  border-top-width: 1px;\n  border-top-color: rgb(125, 79, 79);\n  border-top-style: none;\n  border-right-width: 1px;\n  border-right-color: rgb(125, 79, 79);\n  border-right-style: none;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(125, 79, 79);\n  border-bottom-style: none;\n  border-left-width: 1px;\n  border-left-color: rgb(125, 79, 79);\n  border-left-style: none;\n}\n#colibri .style-601-icon:hover {\n  fill: #FFFFFF;\n  background-color: rgba(45, 45, 134, 0);\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:602;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-602 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:603;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-603 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:604;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:605;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-605 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:606;a:3:{s:7:\"desktop\";s:157:\".style-606 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 10px;\n}\n#colibri .style-606 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:607;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:608;a:3:{s:7:\"desktop\";s:59:\"#colibri .style-608 {\n  color: rgba(255, 255, 255, 0.5);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:611;a:3:{s:7:\"desktop\";s:1962:\"#colibri .style-611  > .h-accordion-item > .h-accordion-item-title {\n  text-align: left;\n  text-decoration: none;\n  font-size: 18px;\n  color: rgb(153, 153, 153);\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  transition-duration: 0.5s;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 0px;\n}\n#colibri .style-611  > .h-accordion-item > .h-accordion-item-title:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-611  > .h-accordion-item > .h-accordion-item-title:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-611  > .h-accordion-item > .h-accordion-item-title.h-custom-active-state {\n  text-align: left;\n  text-decoration: none;\n  font-size: 18px;\n  color: rgb(236, 82, 55);\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  transition-duration: 0.5s;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 0px;\n}\n#colibri .style-611 > .h-accordion-item > .h-accordion-item-content__container > .h-accordion-item-content {\n  padding-top: 12px;\n  padding-right: 24px;\n  padding-bottom: 12px;\n  padding-left: 24px;\n  text-align: left;\n}\n#colibri .style-611  > .h-accordion-item > .h-accordion-item-title .h-accordion-item-title-icon svg {\n  width: 18px;\n  height: 18px;\n  margin-right: 10px;\n  fill: rgb(34, 41, 51);\n}\n#colibri .style-611  > .h-accordion-item > .h-accordion-item-title:hover .h-accordion-item-title-icon svg {\n  fill: rgb(236, 82, 55);\n}\n#colibri .style-611  > .h-accordion-item > .h-accordion-item-title.h-custom-active-state .h-accordion-item-title-icon svg {\n  width: 18px;\n  height: 18px;\n  margin-right: 10px;\n  fill: rgb(236, 82, 55);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:612;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:613;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-613 ol {\n  list-style-type: decimal;\n}\n#colibri .style-613 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:614;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:615;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-615 ol {\n  list-style-type: decimal;\n}\n#colibri .style-615 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:616;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:617;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-617 ol {\n  list-style-type: decimal;\n}\n#colibri .style-617 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:618;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:619;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-619 ol {\n  list-style-type: decimal;\n}\n#colibri .style-619 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:620;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:621;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-621 ol {\n  list-style-type: decimal;\n}\n#colibri .style-621 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:622;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:623;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-623 ol {\n  list-style-type: decimal;\n}\n#colibri .style-623 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:624;a:3:{s:7:\"desktop\";s:483:\"#colibri .style-624 {\n  background-color: #FFFFFF;\n  background-image: none;\n  box-shadow: 0px 10px 40px 0px rgba(1, 51, 74, 0.15) ;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:110:\"#colibri .style-624 {\n  margin-top: 10px;\n  margin-right: 10px;\n  margin-bottom: 10px;\n  margin-left: 10px;\n}\n\";}i:625;a:3:{s:7:\"desktop\";s:104:\"#colibri .style-625 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:626;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:627;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:628;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:629;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:630;a:3:{s:7:\"desktop\";s:77:\"#colibri .style-630 {\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:631;a:3:{s:7:\"desktop\";s:211:\".style-631 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-631 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:632;a:3:{s:7:\"desktop\";s:244:\"#colibri .style-632 {\n  background-color: rgb(236, 82, 55);\n  background-image: none;\n  text-align: center;\n}\n#colibri .style-632 .colibri-post-thumbnail-shortcode img {\n  height: 300px;\n  object-position: center center;\n  object-fit: cover;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:633;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:634;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-634 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:635;a:3:{s:7:\"desktop\";s:654:\"#colibri .style-635 a {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 14px;\n  color: rgb(91, 109, 136);\n}\n#colibri .style-635 a:hover {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-635 a:hover {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-635 .metadata-prefix {\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-635 .metadata-suffix {\n  font-size: 14px;\n}\n#colibri .style-635 .metadata-suffix:hover {\n  color: rgb(91, 109, 136);\n}\n#colibri .style-635 .metadata-suffix:hover {\n  color: rgb(91, 109, 136);\n}\n#colibri .style-635 svg {\n  width: 18px ;\n  height: 18px;\n  display: none;\n  margin-right: 5px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:636;a:3:{s:7:\"desktop\";s:168:\"#colibri .style-636 .colibri-post-content {\n  margin-bottom: 0px;\n  color: rgb(34, 41, 51);\n}\n#colibri .style-636 .colibri-post-content p {\n  color: rgb(51, 51, 51);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:637;a:3:{s:7:\"desktop\";s:46:\"#colibri .style-637 {\n  margin-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:638;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-638 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:639;a:3:{s:7:\"desktop\";s:308:\"#colibri .style-639 {\n  font-size: 14px;\n  line-height: 1.6;\n  color: rgb(51, 51, 51);\n  margin-right: 5px;\n}\n#colibri .style-639 p {\n  font-size: 14px;\n  line-height: 1.6;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-639 ol {\n  list-style-type: decimal;\n}\n#colibri .style-639 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:640;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-640 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:641;a:3:{s:7:\"desktop\";s:485:\"#colibri .style-641 a,#colibri .style-641  .colibri-post-category {\n  margin-right: 5px;\n  margin-left: 5px;\n  text-decoration: none;\n  font-size: 14px;\n  line-height: 1.6;\n  color: rgb(153, 153, 153);\n}\n#colibri .style-641 a:hover,#colibri .style-641  .colibri-post-category:hover {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-641 a:hover,#colibri .style-641  .colibri-post-category:hover {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-641 .categories-prefix {\n  margin-right: 16px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:642;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:643;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-643 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:644;a:3:{s:7:\"desktop\";s:348:\"#colibri .style-644 {\n  font-weight: 400;\n  font-size: 14px;\n  line-height: 1.6;\n  color: rgb(51, 51, 51);\n  margin-right: 5px;\n}\n#colibri .style-644 p {\n  font-weight: 400;\n  font-size: 14px;\n  line-height: 1.6;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-644 ol {\n  list-style-type: decimal;\n}\n#colibri .style-644 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:645;a:3:{s:7:\"desktop\";s:157:\".style-645 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 23px;\n}\n#colibri .style-645 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:646;a:3:{s:7:\"desktop\";s:510:\"#colibri .style-646 a,#colibri .style-646  .colibri-post-tag {\n  margin-right: 5px;\n  margin-left: 5px;\n  text-decoration: none;\n  font-size: 14px;\n  line-height: 1.6;\n  color: rgb(153, 153, 153);\n}\n#colibri .style-646 a:hover,#colibri .style-646  .colibri-post-tag:hover {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-646 a:hover,#colibri .style-646  .colibri-post-tag:hover {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-646 .tags-prefix {\n  margin-right: 5px;\n  font-size: 14px;\n  color: rgb(91, 109, 136);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:647;a:3:{s:7:\"desktop\";s:453:\"#colibri .style-647 {\n  margin-right: 30px;\n  margin-left: 30px;\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:67:\"#colibri .style-647 {\n  margin-right: 15px;\n  margin-left: 15px;\n}\n\";s:6:\"mobile\";s:67:\"#colibri .style-647 {\n  margin-right: 15px;\n  margin-left: 15px;\n}\n\";}i:648;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-648 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:649;a:3:{s:7:\"desktop\";s:783:\"#colibri .style-649 .nav-previous a,#colibri .style-649 .nav-next a {\n  text-decoration: none;\n  color: rgb(34, 41, 51);\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n  background-color: unset;\n  background-image: none;\n}\n#colibri .style-649 .nav-previous a:hover,#colibri .style-649 .nav-next a:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-649 .nav-previous a:hover,#colibri .style-649 .nav-next a:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-649 .post-title {\n  max-width: 40ch;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:650;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-650 {\n  text-align: right;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:651;a:3:{s:7:\"desktop\";s:675:\"#colibri .style-651 .nav-previous a,#colibri .style-651 .nav-next a {\n  text-decoration: none;\n  color: rgb(34, 41, 51);\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n}\n#colibri .style-651 .nav-previous a:hover,#colibri .style-651 .nav-next a:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-651 .nav-previous a:hover,#colibri .style-651 .nav-next a:hover {\n  color: rgb(236, 82, 55);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:652;a:3:{s:7:\"desktop\";s:104:\"#colibri .style-652 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:653;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:654;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:655;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:656;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:657;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:658;a:3:{s:7:\"desktop\";s:125:\"#colibri .style-658 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 15px;\n}\n\";s:6:\"tablet\";s:47:\"#colibri .style-658 {\n  padding-bottom: 5px;\n}\n\";s:6:\"mobile\";s:47:\"#colibri .style-658 {\n  padding-bottom: 5px;\n}\n\";}i:659;a:3:{s:7:\"desktop\";s:3610:\"#colibri .style-659 .blog-post-comments {\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n  padding-top: 15px;\n}\n#colibri .style-659 .comment.even {\n  background-color: #FFFFFF;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-style: none;\n  padding-top: 12px;\n  padding-right: 12px;\n  padding-bottom: 12px;\n  padding-left: 12px;\n}\n#colibri .style-659 .comment.odd {\n  background-color: rgba(166, 220, 244, 0.1);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-style: none;\n  padding-top: 12px;\n  padding-right: 12px;\n  padding-bottom: 12px;\n  padding-left: 12px;\n}\n#colibri .style-659 .comments-title {\n  font-family: Open Sans;\n  font-weight: 600;\n  text-decoration: none;\n  font-size: 1.25em;\n  color: rgb(34, 41, 51);\n}\n#colibri .style-659 .comment-meta {\n  color: rgb(153, 153, 153);\n  margin-bottom: 16px;\n}\n#colibri .style-659 .comment-author img {\n  width: 30px ;\n  height: 30px;\n  background-color: unset;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-659 .comment-author .url {\n  font-weight: 600;\n  font-style: normal;\n  text-decoration: none;\n  color: rgb(34, 41, 51);\n  background-color: unset;\n  background-image: none;\n  margin-left: 5px;\n}\n#colibri .style-659 .comment-metadata {\n  text-decoration: none;\n  font-size: 14px;\n  color: rgb(91, 109, 136);\n  background-color: unset;\n  background-image: none;\n  transition-duration: 0.5s;\n}\n#colibri .style-659 .comment-metadata:hover {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-659 .comment-metadata:hover {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-659 .comment-content {\n  text-decoration: none;\n  font-size: 16px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-659 .comment-content p {\n  color: rgb(51, 51, 51);\n}\n#colibri .style-659 .comment-content a:hover {\n  color: rgb(151, 52, 35);\n}\n#colibri .style-659 .comment-body .reply a {\n  margin-bottom: 10px;\n  font-weight: 400;\n  text-transform: lowercase;\n  font-size: 1em;\n  line-height: 1.5;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-659 .comment-body .reply a:hover {\n  color: rgb(151, 52, 35);\n}\n#colibri .style-659 .comment-body .reply a:hover {\n  color: rgb(151, 52, 35);\n}\n#colibri .style-659 .children {\n  margin-left: 12px;\n}\n#colibri .style-659 .comments-disabled {\n  text-align: center;\n  margin-bottom: 0px;\n  text-decoration: none;\n  color: rgb(51, 51, 51);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:660;a:3:{s:7:\"desktop\";s:4130:\"#colibri .comment-respond {\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n  padding-top: 15px;\n}\n#colibri .comment-respond .comment-reply-title {\n  font-family: Open Sans;\n  font-weight: 600;\n  font-size: 1.25em;\n  color: rgb(34, 41, 51);\n}\n#colibri .comment-respond label {\n  color: rgb(51, 51, 51);\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .comment-respond input:not([type=\"submit\"]),#colibri .comment-respond textarea {\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 1px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 1px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 16px;\n  color: rgb(51, 51, 51);\n  background-color: rgba(0,0,0,0);\n  background-image: none;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n}\n#colibri .comment-respond .comment-form [type=\"submit\"] {\n  background-color: rgb(236, 82, 55);\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: rgb(236, 82, 55);\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 2px;\n  border-right-color: rgb(236, 82, 55);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(236, 82, 55);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 2px;\n  border-left-color: rgb(236, 82, 55);\n  border-left-style: solid;\n  padding-top: 12px;\n  padding-right: 24px;\n  padding-bottom: 12px;\n  padding-left: 24px;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #FFFFFF;\n}\n#colibri .comment-respond .comment-form [type=\"submit\"]:hover {\n  background-color: rgb(151, 52, 35);\n  border-top-color: rgb(151, 52, 35);\n  border-right-color: rgb(151, 52, 35);\n  border-bottom-color: rgb(151, 52, 35);\n  border-left-color: rgb(151, 52, 35);\n}\n#colibri .comment-respond .comment-form [type=\"submit\"]:hover {\n  background-color: rgb(151, 52, 35);\n  border-top-color: rgb(151, 52, 35);\n  border-right-color: rgb(151, 52, 35);\n  border-bottom-color: rgb(151, 52, 35);\n  border-left-color: rgb(151, 52, 35);\n}\n#colibri .comment-respond .comment-form [type=\"submit\"]:active {\n  background-color: rgb(236, 82, 55);\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: rgb(236, 82, 55);\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 2px;\n  border-right-color: rgb(236, 82, 55);\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(236, 82, 55);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 2px;\n  border-left-color: rgb(236, 82, 55);\n  border-left-style: solid;\n  padding-top: 12px;\n  padding-right: 24px;\n  padding-bottom: 12px;\n  padding-left: 24px;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #FFFFFF;\n}\n#colibri .comment-respond .comment-notes {\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 14px;\n  color: rgb(91, 109, 136);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:661;a:3:{s:7:\"desktop\";s:45:\"#colibri .style-661 {\n  margin-top: -30px;\n}\n\";s:6:\"tablet\";s:45:\"#colibri .style-661 {\n  margin-top: -15px;\n}\n\";s:6:\"mobile\";s:0:\"\";}i:662;a:3:{s:7:\"desktop\";s:104:\"#colibri .style-662 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:663;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:664;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:665;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:666;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:667;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:668;a:3:{s:7:\"desktop\";s:542:\"#colibri .style-668 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: #FFFFFF;\n  background-image: none;\n  box-shadow: 0px 10px 40px 0px rgba(1, 51, 74, 0.15) ;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:669;a:3:{s:7:\"desktop\";s:269:\"#colibri .style-669 {\n  background-color: rgba(255,255,255,0);\n  background-image: none;\n  text-align: center;\n  margin-bottom: 0px;\n}\n#colibri .style-669 .colibri-post-thumbnail-shortcode img {\n  height: 300px;\n  object-position: center center;\n  object-fit: cover;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:670;a:3:{s:7:\"desktop\";s:46:\"#colibri .style-670 {\n  margin-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:671;a:3:{s:7:\"desktop\";s:543:\".style-671 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 10px;\n}\n#colibri .style-671 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  border-top-width: 0px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:46:\"#colibri .style-671 {\n  text-align: center;\n}\n\";}i:672;a:3:{s:7:\"desktop\";s:524:\"#colibri .style-672 {\n  margin-bottom: 0px;\n}\n#colibri .style-672 a {\n  text-decoration: none;\n  font-size: 14px;\n  color: rgb(91, 109, 136);\n}\n#colibri .style-672 a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-672 a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-672 .metadata-prefix {\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-672 .metadata-suffix {\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-672 svg {\n  width: 18px ;\n  height: 18px;\n  display: none;\n  margin-right: 5px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:673;a:3:{s:7:\"desktop\";s:478:\"#colibri .style-673 a {\n  text-decoration: none;\n  font-size: 14px;\n  color: rgb(91, 109, 136);\n}\n#colibri .style-673 a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-673 a:hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-673 .metadata-prefix {\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-673 .metadata-suffix {\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-673 svg {\n  width: 18px ;\n  height: 18px;\n  display: none;\n  margin-right: 5px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:674;a:3:{s:7:\"desktop\";s:198:\"#colibri .style-674 h1,#colibri .style-674  h2,#colibri .style-674  h3,#colibri .style-674  h4,#colibri .style-674  h5,#colibri .style-674  h6 {\n  margin-bottom: 0px;\n  transition-duration: 0.5s;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:675;a:3:{s:7:\"desktop\";s:72:\"#colibri .style-675 .colibri-post-excerpt {\n  color: rgb(51, 51, 51);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:676;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:677;a:3:{s:7:\"desktop\";s:157:\".style-677 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 10px;\n}\n#colibri .style-677 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:678;a:3:{s:7:\"desktop\";s:302:\"#colibri .style-678 a {\n  text-decoration: none;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-678 a:hover {\n  color: rgb(151, 52, 35);\n}\n#colibri .style-678 a:hover {\n  color: rgb(151, 52, 35);\n}\n#colibri .style-678 svg {\n  width: 24px ;\n  height: 24px;\n  display: inline-block;\n  margin-right: 5px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:679;a:3:{s:7:\"desktop\";s:158:\".style-679 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 10px;\n}\n#colibri .style-679 {\n  text-align: right;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:680;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:681;a:3:{s:7:\"desktop\";s:809:\"#colibri .style-681-icon {\n  width: 16px;\n  height: 16px;\n  margin-right: 0px;\n  margin-left: 5px;\n}\n#colibri .style-681 {\n  text-align: center;\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(236, 82, 55);\n  border-top-width: 2px;\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 2px;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 2px;\n  border-left-style: none;\n}\n#colibri .style-681:hover,#colibri .style-681:focus {\n  color: rgb(151, 52, 35);\n}\n#colibri .style-681:active .style-681-icon {\n  width: 16px;\n  height: 16px;\n  margin-right: 0px;\n  margin-left: 5px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:682;a:3:{s:7:\"desktop\";s:473:\"#colibri .style-682 {\n  border-top-width: 1px;\n  border-top-color: rgb(224, 224, 224);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(224, 224, 224);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(224, 224, 224);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(224, 224, 224);\n  border-left-style: solid;\n  margin-top: 45px;\n  margin-right: 30px;\n  margin-left: 30px;\n}\n\";s:6:\"tablet\";s:67:\"#colibri .style-682 {\n  margin-right: 10px;\n  margin-left: 10px;\n}\n\";s:6:\"mobile\";s:67:\"#colibri .style-682 {\n  margin-right: 10px;\n  margin-left: 10px;\n}\n\";}i:683;a:3:{s:7:\"desktop\";s:106:\"#colibri .style-683 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  padding-right: 15px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:684;a:3:{s:7:\"desktop\";s:903:\"#colibri .style-684 .nav-links .prev-navigation a,#colibri .style-684 .nav-links .next-navigation a {\n  text-decoration: none;\n  color: rgb(34, 41, 51);\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n}\n#colibri .style-684 .nav-links .prev-navigation a:hover,#colibri .style-684 .nav-links .next-navigation a:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-684 .nav-links .prev-navigation a:hover,#colibri .style-684 .nav-links .next-navigation a:hover {\n  color: rgb(236, 82, 55);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:685;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-685 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:686;a:3:{s:7:\"desktop\";s:323:\"#colibri .style-686 .page-numbers.current {\n  margin-right: 10px;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-686 .page-numbers {\n  margin-right: 10px;\n  color: rgb(34, 41, 51);\n}\n#colibri .style-686 .page-numbers:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-686 .page-numbers:hover {\n  color: rgb(236, 82, 55);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:687;a:3:{s:7:\"desktop\";s:105:\"#colibri .style-687 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  padding-left: 15px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:688;a:3:{s:7:\"desktop\";s:943:\"#colibri .style-688 .nav-links .prev-navigation a,#colibri .style-688 .nav-links .next-navigation a {\n  text-decoration: none;\n  color: rgb(34, 41, 51);\n  border-top-width: 2px;\n  border-top-color: rgb(34, 41, 51);\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 0px;\n  border-right-width: 2px;\n  border-right-color: rgb(34, 41, 51);\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(34, 41, 51);\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 2px;\n  border-left-color: rgb(34, 41, 51);\n  border-left-style: none;\n}\n#colibri .style-688 .nav-links .prev-navigation a:hover,#colibri .style-688 .nav-links .next-navigation a:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-688 .nav-links .prev-navigation a:hover,#colibri .style-688 .nav-links .next-navigation a:hover {\n  color: rgb(236, 82, 55);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:689;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:690;a:3:{s:7:\"desktop\";s:104:\"#colibri .style-690 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:691;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:692;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:693;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:694;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:695;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:696;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-696 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:697;a:3:{s:7:\"desktop\";s:2447:\"#colibri .style-697 {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-697 .widget {\n  text-align: left;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  margin-bottom: 20px;\n}\n#colibri .style-697 .widget h1,#colibri .style-697 .widget h2,#colibri .style-697 .widget h3,#colibri .style-697 .widget h4,#colibri .style-697 .widget h5,#colibri .style-697 .widget h6 {\n  font-family: Open Sans;\n  font-weight: 600;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(34, 41, 51);\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  margin-bottom: 10px;\n}\n#colibri .style-697 .widget ul,#colibri .style-697 .widget ol {\n  list-style-type: none;\n}\n#colibri .style-697 .widget ul li,#colibri .style-697 .widget ol li,#colibri .style-697 .widget  .textwidget p,#colibri .style-697 .widget  .calendar_wrap td ,#colibri .style-697  .widget  .calendar_wrap th ,#colibri .style-697  .widget  .calendar_wrap caption {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n  padding-top: 4px;\n  padding-bottom: 4px;\n}\n#colibri .style-697 .widget ul li a:not(.wp-block-button__link) {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-697 .widget ul li a:not(.wp-block-button__link):hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-697 .widget ul li a:not(.wp-block-button__link):hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-697 .widget input:not([type=\"submit\"]) {\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 16px;\n  color: rgb(51, 51, 51);\n  border-top-width: 0px;\n  border-top-color: black;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-color: black;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:54:\"#colibri .style-697 .widget {\n  text-align: center;\n}\n\";}i:698;a:3:{s:7:\"desktop\";s:3609:\"#colibri .style-697 .widget.widget_search {\n  background-color: unset;\n  background-image: none;\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 1px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 1px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  margin-bottom: 15px;\n}\n#colibri .style-697 .widget.widget_search h1,#colibri .style-697 .widget.widget_search h2,#colibri .style-697 .widget.widget_search h3,#colibri .style-697 .widget.widget_search h4,#colibri .style-697 .widget.widget_search h5,#colibri .style-697 .widget.widget_search h6 {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  font-size: 16px;\n  color: rgb(34, 41, 51);\n}\n#colibri .style-697 .widget.widget_search input:not([type=\"submit\"]) {\n  padding-top: 10px;\n  padding-right: 12px;\n  padding-bottom: 10px;\n  padding-left: 12px;\n  font-size: 16px;\n  color: rgb(51, 51, 51);\n  background-color: rgb(249, 250, 251);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: rgb(222, 222, 222);\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 0px;\n  border-right-width: 0px;\n  border-right-color: rgb(222, 222, 222);\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(222, 222, 222);\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 0px;\n  border-left-color: rgb(222, 222, 222);\n  border-left-style: none;\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-bottom: 0px;\n  margin-left: 0px;\n}\n#colibri .style-697 .widget.widget_search input:not([type=\"submit\"])::placeholder {\n  color: rgb(51, 51, 51);\n}\n#colibri .style-697 .widget.widget_search input[type=\"submit\"],#colibri .style-697 .widget.widget_search button[type=\"submit\"] {\n  background-color: rgb(249, 250, 251);\n  background-image: none;\n  font-size: 16px;\n  line-height: 1;\n  color: rgb(34, 41, 51);\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-style: none;\n  width: auto;\n  padding-top: 10px;\n  padding-right: 12px;\n  padding-bottom: 10px;\n  padding-left: 12px;\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-bottom: 0px;\n  margin-left: 0px;\n  transition-duration: 0.5s;\n  display: inline-block;\n}\n#colibri .style-697 .widget.widget_search input[type=\"submit\"]:hover,#colibri .style-697 .widget.widget_search button[type=\"submit\"]:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-697 .widget.widget_search input[type=\"submit\"]:hover,#colibri .style-697 .widget.widget_search button[type=\"submit\"]:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-697 .widget.widget_search input[type=\"submit\"] {\n  display: none;\n}\n#colibri .style-697 .widget.widget_search button[type=\"submit\"] {\n  display: inline-block;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:699;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:700;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:701;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:702;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:703;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:704;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:705;a:3:{s:7:\"desktop\";s:59:\"#colibri .style-705 {\n  color: rgba(255, 255, 255, 0.5);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:708;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:709;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:710;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-710 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:711;a:3:{s:7:\"desktop\";s:363:\"#colibri .style-711 p,#colibri .style-711  h1,#colibri .style-711  h2,#colibri .style-711  h3,#colibri .style-711  h4,#colibri .style-711  h5,#colibri .style-711  h6 {\n  font-size: 10em;\n  color: rgb(34, 41, 51);\n}\n#colibri .style-711 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:712;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-712 ol {\n  list-style-type: decimal;\n}\n#colibri .style-712 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:713;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:714;a:3:{s:7:\"desktop\";s:1345:\"#colibri .style-714-icon {\n  width: 16px;\n  height: 16px;\n  margin-right: 0px;\n  margin-left: 10px;\n}\n#colibri .style-714 {\n  background-color: rgba(3, 169, 244, 0);\n  background-image: none;\n  font-family: Open Sans;\n  font-weight: 400;\n  text-transform: none;\n  font-size: 16px;\n  line-height: 1.5em;\n  letter-spacing: 1px;\n  color: rgb(236, 82, 55);\n  border-top-width: 2px;\n  border-top-color: rgb(236, 82, 55);\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 2px;\n  border-right-color: rgb(236, 82, 55);\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: rgb(236, 82, 55);\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 2px;\n  border-left-color: rgb(236, 82, 55);\n  border-left-style: none;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  text-align: center;\n}\n#colibri .style-714:hover,#colibri .style-714:focus {\n  background-color: rgba(2, 110, 159, 0);\n  border-top-color: rgb(151, 52, 35);\n  border-right-color: rgb(151, 52, 35);\n  border-bottom-color: rgb(151, 52, 35);\n  border-left-color: rgb(151, 52, 35);\n}\n#colibri .style-714:active .style-714-icon {\n  width: 16px;\n  height: 16px;\n  margin-right: 0px;\n  margin-left: 10px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:715;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:716;a:3:{s:7:\"desktop\";s:67:\"#colibri .style-716 {\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:717;a:3:{s:7:\"desktop\";s:540:\"#colibri .style-717 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  background-color: #FFFFFF;\n  background-image: none;\n  box-shadow: 0px 10px 40px 0px rgba(1, 51, 74, 0.15) ;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:718;a:3:{s:7:\"desktop\";s:46:\"#colibri .style-718 {\n  margin-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:719;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-719 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:720;a:3:{s:7:\"desktop\";s:449:\"#colibri .style-720 a,#colibri .style-720  .colibri-post-category {\n  margin-right: 10px;\n  text-transform: lowercase;\n  font-size: 14px;\n  color: rgb(91, 109, 136);\n}\n#colibri .style-720 a:hover,#colibri .style-720  .colibri-post-category:hover {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-720 a:hover,#colibri .style-720  .colibri-post-category:hover {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-720 .categories-prefix {\n  margin-right: 16px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:721;a:3:{s:7:\"desktop\";s:169:\"#colibri .style-721 h1,#colibri .style-721  h2,#colibri .style-721  h3,#colibri .style-721  h4,#colibri .style-721  h5,#colibri .style-721  h6 {\n  margin-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:722;a:3:{s:7:\"desktop\";s:583:\"#colibri .style-722 a {\n  text-decoration: none;\n  text-transform: lowercase;\n  font-size: 14px;\n  color: rgb(91, 109, 136);\n}\n#colibri .style-722 a:hover {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-722 a:hover {\n  color: rgb(34, 41, 51);\n}\n#colibri .style-722 .metadata-prefix {\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-722 .metadata-suffix {\n  font-size: 14px;\n  color: rgb(91, 109, 136);\n}\n#colibri .style-722 svg {\n  width: 24px ;\n  height: 24px;\n  margin-right: 5px;\n  display: none;\n}\n#colibri .style-722 .meta-separator {\n  color: rgb(91, 109, 136);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:723;a:3:{s:7:\"desktop\";s:72:\"#colibri .style-723 .colibri-post-excerpt {\n  color: rgb(51, 51, 51);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:724;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:725;a:3:{s:7:\"desktop\";s:571:\"#colibri .style-725-icon {\n  width: 16px;\n  height: 16px;\n  margin-right: 0px;\n  margin-left: 5px;\n}\n#colibri .style-725 {\n  text-align: center;\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(236, 82, 55);\n  border-top-style: none;\n  border-right-style: none;\n  border-bottom-style: none;\n  border-left-style: none;\n}\n#colibri .style-725:hover,#colibri .style-725:focus {\n  color: rgb(151, 52, 35);\n}\n#colibri .style-725:active .style-725-icon {\n  width: 16px;\n  height: 16px;\n  margin-right: 0px;\n  margin-left: 5px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:726;a:3:{s:7:\"desktop\";s:473:\"#colibri .style-726 {\n  border-top-width: 1px;\n  border-top-color: rgb(224, 224, 224);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(224, 224, 224);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(224, 224, 224);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(224, 224, 224);\n  border-left-style: solid;\n  margin-top: 45px;\n  margin-right: 30px;\n  margin-left: 30px;\n}\n\";s:6:\"tablet\";s:67:\"#colibri .style-726 {\n  margin-right: 15px;\n  margin-left: 15px;\n}\n\";s:6:\"mobile\";s:67:\"#colibri .style-726 {\n  margin-right: 10px;\n  margin-left: 10px;\n}\n\";}i:727;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-727 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:728;a:3:{s:7:\"desktop\";s:106:\"#colibri .style-728 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  padding-right: 15px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:729;a:3:{s:7:\"desktop\";s:907:\"#colibri .style-729 .nav-links .prev-navigation a,#colibri .style-729 .nav-links .next-navigation a {\n  text-decoration: none;\n  color: rgb(34, 41, 51);\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-top-left-radius: 10px;\n  border-top-right-radius: 10px;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-bottom-left-radius: 10px;\n  border-bottom-right-radius: 10px;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n}\n#colibri .style-729 .nav-links .prev-navigation a:hover,#colibri .style-729 .nav-links .next-navigation a:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-729 .nav-links .prev-navigation a:hover,#colibri .style-729 .nav-links .next-navigation a:hover {\n  color: rgb(236, 82, 55);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:730;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-730 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:731;a:3:{s:7:\"desktop\";s:401:\"#colibri .style-731 .page-numbers.current {\n  margin-right: 10px;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(236, 82, 55);\n}\n#colibri .style-731 .page-numbers {\n  margin-right: 10px;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(34, 41, 51);\n}\n#colibri .style-731 .page-numbers:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-731 .page-numbers:hover {\n  color: rgb(236, 82, 55);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:732;a:3:{s:7:\"desktop\";s:105:\"#colibri .style-732 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  padding-left: 15px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:733;a:3:{s:7:\"desktop\";s:907:\"#colibri .style-733 .nav-links .prev-navigation a,#colibri .style-733 .nav-links .next-navigation a {\n  text-decoration: none;\n  color: rgb(34, 41, 51);\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-top-left-radius: 10px;\n  border-top-right-radius: 10px;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-bottom-left-radius: 10px;\n  border-bottom-right-radius: 10px;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n}\n#colibri .style-733 .nav-links .prev-navigation a:hover,#colibri .style-733 .nav-links .next-navigation a:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-733 .nav-links .prev-navigation a:hover,#colibri .style-733 .nav-links .next-navigation a:hover {\n  color: rgb(236, 82, 55);\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:734;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:735;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-735 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:736;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:737;a:3:{s:7:\"desktop\";s:61:\"#colibri .style-737 {\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:738;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:739;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-739 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:748;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:749;a:3:{s:7:\"desktop\";s:104:\"#colibri .style-749 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:750;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:751;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:752;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:753;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:754;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:755;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-755 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:756;a:3:{s:7:\"desktop\";s:2447:\"#colibri .style-756 {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-756 .widget {\n  text-align: left;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  margin-bottom: 20px;\n}\n#colibri .style-756 .widget h1,#colibri .style-756 .widget h2,#colibri .style-756 .widget h3,#colibri .style-756 .widget h4,#colibri .style-756 .widget h5,#colibri .style-756 .widget h6 {\n  font-family: Open Sans;\n  font-weight: 600;\n  font-size: 16px;\n  line-height: 1.6;\n  color: rgb(34, 41, 51);\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  margin-bottom: 10px;\n}\n#colibri .style-756 .widget ul,#colibri .style-756 .widget ol {\n  list-style-type: none;\n}\n#colibri .style-756 .widget ul li,#colibri .style-756 .widget ol li,#colibri .style-756 .widget  .textwidget p,#colibri .style-756 .widget  .calendar_wrap td ,#colibri .style-756  .widget  .calendar_wrap th ,#colibri .style-756  .widget  .calendar_wrap caption {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n  padding-top: 4px;\n  padding-bottom: 4px;\n}\n#colibri .style-756 .widget ul li a:not(.wp-block-button__link) {\n  font-family: Open Sans;\n  font-weight: 400;\n  text-decoration: none;\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-756 .widget ul li a:not(.wp-block-button__link):hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-756 .widget ul li a:not(.wp-block-button__link):hover {\n  color: rgb(0, 0, 0);\n}\n#colibri .style-756 .widget input:not([type=\"submit\"]) {\n  font-family: Open Sans;\n  font-weight: 400;\n  font-size: 16px;\n  color: rgb(51, 51, 51);\n  border-top-width: 0px;\n  border-top-color: black;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-color: black;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:54:\"#colibri .style-756 .widget {\n  text-align: center;\n}\n\";}i:757;a:3:{s:7:\"desktop\";s:3609:\"#colibri .style-756 .widget.widget_search {\n  background-color: unset;\n  background-image: none;\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 1px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 1px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  margin-bottom: 15px;\n}\n#colibri .style-756 .widget.widget_search h1,#colibri .style-756 .widget.widget_search h2,#colibri .style-756 .widget.widget_search h3,#colibri .style-756 .widget.widget_search h4,#colibri .style-756 .widget.widget_search h5,#colibri .style-756 .widget.widget_search h6 {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-left-width: 0px;\n  border-left-style: none;\n  font-size: 16px;\n  color: rgb(34, 41, 51);\n}\n#colibri .style-756 .widget.widget_search input:not([type=\"submit\"]) {\n  padding-top: 10px;\n  padding-right: 12px;\n  padding-bottom: 10px;\n  padding-left: 12px;\n  font-size: 16px;\n  color: rgb(51, 51, 51);\n  background-color: rgb(249, 250, 251);\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: rgb(222, 222, 222);\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 0px;\n  border-right-width: 0px;\n  border-right-color: rgb(222, 222, 222);\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(222, 222, 222);\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 0px;\n  border-left-width: 0px;\n  border-left-color: rgb(222, 222, 222);\n  border-left-style: none;\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-bottom: 0px;\n  margin-left: 0px;\n}\n#colibri .style-756 .widget.widget_search input:not([type=\"submit\"])::placeholder {\n  color: rgb(51, 51, 51);\n}\n#colibri .style-756 .widget.widget_search input[type=\"submit\"],#colibri .style-756 .widget.widget_search button[type=\"submit\"] {\n  background-color: rgb(249, 250, 251);\n  background-image: none;\n  font-size: 16px;\n  line-height: 1;\n  color: rgb(34, 41, 51);\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 0px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 0px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-style: none;\n  width: auto;\n  padding-top: 10px;\n  padding-right: 12px;\n  padding-bottom: 10px;\n  padding-left: 12px;\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-bottom: 0px;\n  margin-left: 0px;\n  transition-duration: 0.5s;\n  display: inline-block;\n}\n#colibri .style-756 .widget.widget_search input[type=\"submit\"]:hover,#colibri .style-756 .widget.widget_search button[type=\"submit\"]:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-756 .widget.widget_search input[type=\"submit\"]:hover,#colibri .style-756 .widget.widget_search button[type=\"submit\"]:hover {\n  color: rgb(236, 82, 55);\n}\n#colibri .style-756 .widget.widget_search input[type=\"submit\"] {\n  display: none;\n}\n#colibri .style-756 .widget.widget_search button[type=\"submit\"] {\n  display: inline-block;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:758;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:759;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:760;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:761;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:762;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:763;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:764;a:3:{s:7:\"desktop\";s:158:\".style-764 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 15px;\n}\n#colibri .style-764 {\n  text-align: right;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:765;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:766;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-766 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:767;a:3:{s:7:\"desktop\";s:586:\"#colibri .style-767 .nav-previous a,#colibri .style-767 .nav-next a {\n  text-decoration: underline;\n  color: #03a9f4;\n  border-top-width: 2px;\n  border-top-color: black;\n  border-top-style: none;\n  border-top-left-radius: 10px;\n  border-top-right-radius: 10px;\n  border-right-width: 2px;\n  border-right-color: black;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: black;\n  border-bottom-style: none;\n  border-bottom-left-radius: 10px;\n  border-bottom-right-radius: 10px;\n  border-left-width: 2px;\n  border-left-color: black;\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:786;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-786 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:787;a:3:{s:7:\"desktop\";s:828:\"#colibri .style-787 .widget {\n  text-align: left;\n}\n#colibri .style-787 .widget ul li,#colibri .style-787 .widget ol li,#colibri .style-787 .widget  .textwidget p,#colibri .style-787 .widget  .calendar_wrap td ,#colibri .style-787  .widget  .calendar_wrap th ,#colibri .style-787  .widget  .calendar_wrap caption {\n  color: black;\n}\n#colibri .style-787 .widget ul li a:not(.wp-block-button__link) {\n  color: #1989fa;\n}\n#colibri .style-787 .widget input:not([type=\"submit\"]) {\n  color: black;\n  border-top-width: 1px;\n  border-top-color: black;\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: black;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: black;\n  border-bottom-style: solid;\n  border-left-width: 1px;\n  border-left-color: black;\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:788;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:789;a:3:{s:7:\"desktop\";s:40:\"#colibri .style-789 {\n  bottom: 20px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:790;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:791;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:792;a:3:{s:7:\"desktop\";s:78:\"#colibri .style-792-icon {\n  fill: #FFFFFF;\n  width: 40px ;\n  height: 40px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:794;a:3:{s:7:\"desktop\";s:337:\"#colibri .style-794 {\n  min-height: 100vh;\n  background-position: center center;\n  background-size: cover;\n  background-image: url(\"http://localhost/site/wp-content/uploads/2025/01/ALCADO.jpg\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n#colibri .style-794  > .h-section-grid-container {\n  margin-top: -150px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:795;a:3:{s:7:\"desktop\";s:110:\"#colibri .style-795 {\n  margin-top: 33px;\n  margin-right: 33px;\n  margin-bottom: 33px;\n  margin-left: 33px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:796;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-796 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:797;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-797 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:798;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-798 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:801;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:803;a:3:{s:7:\"desktop\";s:158:\".style-803 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 5px;\n}\n#colibri .style-803 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:806;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:807;a:3:{s:7:\"desktop\";s:102:\"#colibri .style-807-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:808;a:3:{s:7:\"desktop\";s:797:\"#colibri .style-808 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  background-color: #FFFFFF;\n  background-image: none;\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 1px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 1px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n  box-shadow: 0px 0px 3px 0px rgba(204, 204, 204, 0.5) ;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:810;a:3:{s:7:\"desktop\";s:106:\"#colibri .style-810 {\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-bottom: 0px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:811;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-811 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:812;a:3:{s:7:\"desktop\";s:524:\"#colibri .style-812-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-812 {\n  margin-bottom: 20px;\n}\n#colibri .style-812 a,#colibri .style-812  .colibri-post-category {\n  margin-right: 10px;\n  color: #03a9f4;\n}\n#colibri .style-812 a:hover,#colibri .style-812  .colibri-post-category:hover {\n  color: #f79007;\n}\n#colibri .style-812 a:hover,#colibri .style-812  .colibri-post-category:hover {\n  color: #f79007;\n}\n#colibri .style-812 .categories-prefix {\n  margin-right: 16px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:813;a:3:{s:7:\"desktop\";s:571:\"#colibri .style-813 h1,#colibri .style-813  h2,#colibri .style-813  h3,#colibri .style-813  h4,#colibri .style-813  h5,#colibri .style-813  h6 {\n  margin-bottom: 0px;\n}\n#colibri .style-813 h1:hover,#colibri .style-813  h2:hover,#colibri .style-813  h3:hover,#colibri .style-813  h4:hover,#colibri .style-813  h5:hover,#colibri .style-813  h6:hover {\n  color: #f79007;\n}\n#colibri .style-813 h1:hover,#colibri .style-813  h2:hover,#colibri .style-813  h3:hover,#colibri .style-813  h4:hover,#colibri .style-813  h5:hover,#colibri .style-813  h6:hover {\n  color: #f79007;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:814;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:815;a:3:{s:7:\"desktop\";s:512:\"#colibri .style-815-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-815 {\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:816;a:3:{s:7:\"desktop\";s:156:\".style-816 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-816 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:817;a:3:{s:7:\"desktop\";s:447:\"#colibri .style-817 a {\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n  margin-right: 5px;\n}\n#colibri .style-817 a:hover {\n  color: #f79007;\n}\n#colibri .style-817 a:hover {\n  color: #f79007;\n}\n#colibri .style-817 .metadata-prefix {\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-817 .metadata-suffix {\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-817 svg {\n  width: 20px ;\n  height: 20px;\n  display: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:818;a:3:{s:7:\"desktop\";s:157:\".style-818 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-818 {\n  text-align: right;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:819;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:820;a:3:{s:7:\"desktop\";s:1312:\"#colibri .style-820-icon {\n  margin-right: 0px;\n  margin-left: 3px;\n  width: 16px;\n  height: 16px;\n}\n#colibri .style-820 {\n  background-color: rgba(3, 169, 244, 0);\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #03a9f4;\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 2px;\n  border-right-color: #03a9f4;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 2px;\n  border-left-color: #03a9f4;\n  border-left-style: none;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: none;\n  font-size: 14px;\n  line-height: 1;\n  letter-spacing: 0px;\n  color: #03a9f4;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  text-align: center;\n}\n#colibri .style-820:hover,#colibri .style-820:focus {\n  background-color: rgba(2, 110, 159, 0);\n  border-top-color: rgb(2, 110, 159);\n  border-right-color: rgb(2, 110, 159);\n  border-bottom-color: rgb(2, 110, 159);\n  border-left-color: rgb(2, 110, 159);\n  color: #f79007;\n}\n#colibri .style-820:active .style-820-icon {\n  margin-right: 0px;\n  margin-left: 3px;\n  width: 16px;\n  height: 16px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:822;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-822 ol {\n  list-style-type: decimal;\n}\n#colibri .style-822 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:823;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:824;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-824 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:825;a:3:{s:7:\"desktop\";s:649:\"#colibri .style-825-image {\n  opacity: 1;\n}\n#colibri .style-825-caption {\n  margin-top: 10px;\n}\n#colibri .style-825-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:826;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:827;a:3:{s:7:\"desktop\";s:1289:\"#colibri .style-827-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n#colibri .style-827 {\n  text-align: center;\n  background-color: #03a9f4;\n  background-image: none;\n  font-family: Open Sans;\n  font-weight: 600;\n  text-transform: uppercase;\n  font-size: 12px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #fff;\n  border-top-width: 2px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 2px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 2px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n  padding-top: 12px;\n  padding-right: 24px;\n  padding-bottom: 12px;\n  padding-left: 24px;\n}\n#colibri .style-827:hover,#colibri .style-827:focus {\n  background-color: rgb(2, 110, 159);\n  border-top-color: rgb(2, 110, 159);\n  border-right-color: rgb(2, 110, 159);\n  border-bottom-color: rgb(2, 110, 159);\n  border-left-color: rgb(2, 110, 159);\n}\n#colibri .style-827:active .style-827-icon {\n  width: 12px;\n  height: 12px;\n  margin-right: 10px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:828;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:829;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-829 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:830;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-830 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:831;a:3:{s:7:\"desktop\";s:193:\"#colibri .style-831 {\n  color: #03a9f4;\n}\n#colibri .style-831 p {\n  color: #03a9f4;\n}\n#colibri .style-831 ol {\n  list-style-type: decimal;\n}\n#colibri .style-831 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:834;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:835;a:3:{s:7:\"desktop\";s:159:\".style-835 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 16px;\n}\n#colibri .style-835 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:852;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:853;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:854;a:3:{s:7:\"desktop\";s:799:\"#colibri .style-854 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: #FFFFFF;\n  background-image: none;\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 1px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 1px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n  box-shadow: 0px 0px 3px 0px rgba(204, 204, 204, 0.5) ;\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:856;a:3:{s:7:\"desktop\";s:106:\"#colibri .style-856 {\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-bottom: 0px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:857;a:3:{s:7:\"desktop\";s:81:\"#colibri .style-857 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:859;a:3:{s:7:\"desktop\";s:571:\"#colibri .style-859 h1,#colibri .style-859  h2,#colibri .style-859  h3,#colibri .style-859  h4,#colibri .style-859  h5,#colibri .style-859  h6 {\n  margin-bottom: 0px;\n}\n#colibri .style-859 h1:hover,#colibri .style-859  h2:hover,#colibri .style-859  h3:hover,#colibri .style-859  h4:hover,#colibri .style-859  h5:hover,#colibri .style-859  h6:hover {\n  color: #f79007;\n}\n#colibri .style-859 h1:hover,#colibri .style-859  h2:hover,#colibri .style-859  h3:hover,#colibri .style-859  h4:hover,#colibri .style-859  h5:hover,#colibri .style-859  h6:hover {\n  color: #f79007;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:860;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:861;a:3:{s:7:\"desktop\";s:410:\"#colibri .style-861 {\n  border-top-width: 1px;\n  border-top-color: rgb(238, 238, 238);\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: rgb(238, 238, 238);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(238, 238, 238);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(238, 238, 238);\n  border-left-style: solid;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:862;a:3:{s:7:\"desktop\";s:156:\".style-862 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-862 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:863;a:3:{s:7:\"desktop\";s:447:\"#colibri .style-863 a {\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n  margin-right: 5px;\n}\n#colibri .style-863 a:hover {\n  color: #f79007;\n}\n#colibri .style-863 a:hover {\n  color: #f79007;\n}\n#colibri .style-863 .metadata-prefix {\n  font-size: 14px;\n  color: rgb(51, 51, 51);\n}\n#colibri .style-863 .metadata-suffix {\n  font-size: 14px;\n  color: rgb(102, 102, 102);\n}\n#colibri .style-863 svg {\n  width: 20px ;\n  height: 20px;\n  display: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:864;a:3:{s:7:\"desktop\";s:157:\".style-864 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-864 {\n  text-align: right;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:865;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:866;a:3:{s:7:\"desktop\";s:1290:\"#colibri .style-866-icon {\n  margin-right: 0px;\n  margin-left: 3px;\n  width: 11px;\n  height: 11px;\n}\n#colibri .style-866 {\n  background-color: rgba(3, 169, 244, 0);\n  background-image: none;\n  border-top-width: 2px;\n  border-top-color: #03a9f4;\n  border-top-style: none;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 2px;\n  border-right-color: #03a9f4;\n  border-right-style: none;\n  border-bottom-width: 2px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: none;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 2px;\n  border-left-color: #03a9f4;\n  border-left-style: none;\n  font-family: Open Sans;\n  font-weight: 600;\n  font-size: 11px;\n  line-height: 1;\n  letter-spacing: 1px;\n  color: #03a9f4;\n  padding-top: 8px;\n  padding-right: 20px;\n  padding-bottom: 8px;\n  padding-left: 20px;\n  text-align: center;\n}\n#colibri .style-866:hover,#colibri .style-866:focus {\n  background-color: rgba(2, 110, 159, 0);\n  border-top-color: rgb(2, 110, 159);\n  border-right-color: rgb(2, 110, 159);\n  border-bottom-color: rgb(2, 110, 159);\n  border-left-color: rgb(2, 110, 159);\n  color: #f79007;\n}\n#colibri .style-866:active .style-866-icon {\n  margin-right: 0px;\n  margin-left: 3px;\n  width: 11px;\n  height: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:867;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:868;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:869;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:870;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:871;a:3:{s:7:\"desktop\";s:649:\"#colibri .style-871-image {\n  opacity: 1;\n}\n#colibri .style-871-caption {\n  margin-top: 10px;\n}\n#colibri .style-871-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:872;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:876;a:3:{s:7:\"desktop\";s:157:\"#colibri .style-876 {\n  height: auto;\n  min-height: unset;\n  background-color: unset;\n  background-image: none;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:877;a:3:{s:7:\"desktop\";s:77:\"#colibri .style-877 {\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:878;a:3:{s:7:\"desktop\";s:290:\"#colibri .style-878 {\n  text-align: center;\n  min-height: 369px;\n  background-position: top left;\n  background-size: cover;\n  background-image: url(\"http://localhost/site/wp-content/uploads/2025/01/colibri-image-219.png\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:81:\"#colibri .style-878 {\n  min-height: 300px;\n  background-position: center left;\n}\n\";}i:879;a:3:{s:7:\"desktop\";s:226:\"#colibri .style-879 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  background-color: #03a9f4;\n  background-image: none;\n  padding-top: 7rem;\n  padding-right: 7rem;\n  padding-bottom: 7rem;\n  padding-left: 4rem;\n}\n\";s:6:\"tablet\";s:114:\"#colibri .style-879 {\n  padding-top: 4rem;\n  padding-right: 2rem;\n  padding-bottom: 4rem;\n  padding-left: 2rem;\n}\n\";s:6:\"mobile\";s:136:\"#colibri .style-879 {\n  text-align: center;\n  padding-top: 2rem;\n  padding-right: 2rem;\n  padding-bottom: 2rem;\n  padding-left: 2rem;\n}\n\";}i:880;a:3:{s:7:\"desktop\";s:336:\"#colibri .style-880 p,#colibri .style-880  h1,#colibri .style-880  h2,#colibri .style-880  h3,#colibri .style-880  h4,#colibri .style-880  h5,#colibri .style-880  h6 {\n  color: #FFFFFF;\n}\n#colibri .style-880 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:881;a:3:{s:7:\"desktop\";s:193:\"#colibri .style-881 {\n  color: #FFFFFF;\n}\n#colibri .style-881 p {\n  color: #FFFFFF;\n}\n#colibri .style-881 ol {\n  list-style-type: decimal;\n}\n#colibri .style-881 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:882;a:3:{s:7:\"desktop\";s:1046:\"#colibri .style-882-icon {\n  fill: #FFFFFF;\n  width: 40px ;\n  height: 40px;\n  padding-left: 0px;\n}\n#colibri .style-882 .list-item-text-wrapper {\n  horizontal-align: start;\n  padding-right: 0px;\n  padding-bottom: 0px;\n}\n#colibri .style-882 a:hover,#colibri .style-882  a span.list-text:hover {\n  color: rgba(255, 255, 255, 0.8);\n}\n#colibri .style-882 a:hover,#colibri .style-882  a span.list-text:hover {\n  color: rgba(255, 255, 255, 0.8);\n}\n#colibri .style-882 .list-text {\n  margin-left: 10px;\n  color: #FFFFFF;\n}\n#colibri .style-882 .list-divider {\n  color: rgb(0,0,0);\n  width: 100% ;\n  height: 0%;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n  margin-left: 0px;\n}\n#colibri .style-882 .list-container-divider {\n  width: 100% ;\n  padding-top: 10px;\n  padding-right: 0px;\n  padding-bottom: 10px;\n  padding-left: 0px;\n  height: 1px;\n}\n\";s:6:\"tablet\";s:61:\"#colibri .style-882-icon {\n  width: 30px ;\n  height: 30px;\n}\n\";s:6:\"mobile\";s:76:\"#colibri .style-882 .list-item-text-wrapper {\n  horizontal-align: center;\n}\n\";}i:883;a:3:{s:7:\"desktop\";s:157:\"#colibri .style-883 {\n  height: auto;\n  min-height: unset;\n  background-color: unset;\n  background-image: none;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:884;a:3:{s:7:\"desktop\";s:77:\"#colibri .style-884 {\n  background-color: unset;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:885;a:3:{s:7:\"desktop\";s:306:\"#colibri .style-885 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-position: top left;\n  background-size: cover;\n  background-image: url(\"http://localhost/site/wp-content/uploads/2025/01/colibri-image-219.png\");\n  background-attachment: scroll;\n  background-repeat: no-repeat;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:81:\"#colibri .style-885 {\n  min-height: 300px;\n  background-position: center left;\n}\n\";}i:886;a:3:{s:7:\"desktop\";s:226:\"#colibri .style-886 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  background-color: #03a9f4;\n  background-image: none;\n  padding-top: 7rem;\n  padding-right: 7rem;\n  padding-bottom: 7rem;\n  padding-left: 4rem;\n}\n\";s:6:\"tablet\";s:114:\"#colibri .style-886 {\n  padding-top: 4rem;\n  padding-right: 2rem;\n  padding-bottom: 4rem;\n  padding-left: 2rem;\n}\n\";s:6:\"mobile\";s:136:\"#colibri .style-886 {\n  text-align: center;\n  padding-top: 2rem;\n  padding-right: 2rem;\n  padding-bottom: 2rem;\n  padding-left: 2rem;\n}\n\";}i:887;a:3:{s:7:\"desktop\";s:336:\"#colibri .style-887 p,#colibri .style-887  h1,#colibri .style-887  h2,#colibri .style-887  h3,#colibri .style-887  h4,#colibri .style-887  h5,#colibri .style-887  h6 {\n  color: #FFFFFF;\n}\n#colibri .style-887 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:888;a:3:{s:7:\"desktop\";s:193:\"#colibri .style-888 {\n  color: #FFFFFF;\n}\n#colibri .style-888 p {\n  color: #FFFFFF;\n}\n#colibri .style-888 ol {\n  list-style-type: decimal;\n}\n#colibri .style-888 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:889;a:3:{s:7:\"desktop\";s:1046:\"#colibri .style-889-icon {\n  fill: #FFFFFF;\n  width: 40px ;\n  height: 40px;\n  padding-left: 0px;\n}\n#colibri .style-889 .list-item-text-wrapper {\n  horizontal-align: start;\n  padding-right: 0px;\n  padding-bottom: 0px;\n}\n#colibri .style-889 a:hover,#colibri .style-889  a span.list-text:hover {\n  color: rgba(255, 255, 255, 0.8);\n}\n#colibri .style-889 a:hover,#colibri .style-889  a span.list-text:hover {\n  color: rgba(255, 255, 255, 0.8);\n}\n#colibri .style-889 .list-text {\n  margin-left: 10px;\n  color: #FFFFFF;\n}\n#colibri .style-889 .list-divider {\n  color: rgb(0,0,0);\n  width: 100% ;\n  height: 0%;\n  border-top-width: 0px;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-style: solid;\n  margin-left: 0px;\n}\n#colibri .style-889 .list-container-divider {\n  width: 100% ;\n  padding-top: 10px;\n  padding-right: 0px;\n  padding-bottom: 10px;\n  padding-left: 0px;\n  height: 1px;\n}\n\";s:6:\"tablet\";s:61:\"#colibri .style-889-icon {\n  width: 30px ;\n  height: 30px;\n}\n\";s:6:\"mobile\";s:76:\"#colibri .style-889 .list-item-text-wrapper {\n  horizontal-align: center;\n}\n\";}i:978;a:3:{s:7:\"desktop\";s:140:\"#colibri .style-978 {\n  height: auto;\n  min-height: unset;\n  background-color: #F5FAFD;\n  background-image: none;\n  padding-bottom: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:979;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:980;a:3:{s:7:\"desktop\";s:159:\".style-980 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 10px;\n}\n#colibri .style-980 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:981;a:3:{s:7:\"desktop\";s:1393:\"#colibri .style-981-image {\n  opacity: 1;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-981-overlay {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-981-caption {\n  margin-top: 10px;\n}\n#colibri .style-981-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:982;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-982 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:983;a:3:{s:7:\"desktop\";s:201:\"#colibri .style-983 {\n  font-style: italic;\n}\n#colibri .style-983 p {\n  font-style: italic;\n}\n#colibri .style-983 ol {\n  list-style-type: decimal;\n}\n#colibri .style-983 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:984;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-984 ol {\n  list-style-type: decimal;\n}\n#colibri .style-984 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:985;a:3:{s:7:\"desktop\";s:380:\"#colibri .style-985 .social-icon-container {\n  margin-right: 5px;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n}\n#colibri .style-985 .icon-container {\n  fill: rgb(204, 204, 204);\n  width: 20px ;\n  height: 20px;\n}\n#colibri .style-985 .icon-container:hover {\n  fill: #03a9f4;\n}\n#colibri .style-985 .icon-container:hover {\n  fill: #03a9f4;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:986;a:3:{s:7:\"desktop\";s:1393:\"#colibri .style-986-image {\n  opacity: 1;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-986-overlay {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-986-caption {\n  margin-top: 10px;\n}\n#colibri .style-986-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:987;a:3:{s:7:\"desktop\";s:380:\"#colibri .style-987 .social-icon-container {\n  margin-right: 5px;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n}\n#colibri .style-987 .icon-container {\n  fill: rgb(204, 204, 204);\n  width: 20px ;\n  height: 20px;\n}\n#colibri .style-987 .icon-container:hover {\n  fill: #03a9f4;\n}\n#colibri .style-987 .icon-container:hover {\n  fill: #03a9f4;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:988;a:3:{s:7:\"desktop\";s:1393:\"#colibri .style-988-image {\n  opacity: 1;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-988-overlay {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-988-caption {\n  margin-top: 10px;\n}\n#colibri .style-988-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:989;a:3:{s:7:\"desktop\";s:380:\"#colibri .style-989 .social-icon-container {\n  margin-right: 5px;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n}\n#colibri .style-989 .icon-container {\n  fill: rgb(204, 204, 204);\n  width: 20px ;\n  height: 20px;\n}\n#colibri .style-989 .icon-container:hover {\n  fill: #03a9f4;\n}\n#colibri .style-989 .icon-container:hover {\n  fill: #03a9f4;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:990;a:3:{s:7:\"desktop\";s:1393:\"#colibri .style-990-image {\n  opacity: 1;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-990-overlay {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-990-caption {\n  margin-top: 10px;\n}\n#colibri .style-990-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:991;a:3:{s:7:\"desktop\";s:380:\"#colibri .style-991 .social-icon-container {\n  margin-right: 5px;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n}\n#colibri .style-991 .icon-container {\n  fill: rgb(204, 204, 204);\n  width: 20px ;\n  height: 20px;\n}\n#colibri .style-991 .icon-container:hover {\n  fill: #03a9f4;\n}\n#colibri .style-991 .icon-container:hover {\n  fill: #03a9f4;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:992;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:993;a:3:{s:7:\"desktop\";s:83:\"#colibri .style-993 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:994;a:3:{s:7:\"desktop\";s:148:\"#colibri .style-994 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:995;a:3:{s:7:\"desktop\";s:107:\"#colibri .style-995 ol {\n  list-style-type: decimal;\n}\n#colibri .style-995 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1014;a:3:{s:7:\"desktop\";s:117:\"#colibri .style-1014 {\n  height: auto;\n  min-height: unset;\n  background-color: #F5FAFD;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1015;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1016;a:3:{s:7:\"desktop\";s:161:\".style-1016 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 10px;\n}\n#colibri .style-1016 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1017;a:3:{s:7:\"desktop\";s:1397:\"#colibri .style-1017-image {\n  opacity: 1;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-1017-overlay {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-1017-caption {\n  margin-top: 10px;\n}\n#colibri .style-1017-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1018;a:3:{s:7:\"desktop\";s:149:\"#colibri .style-1018 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1019;a:3:{s:7:\"desktop\";s:205:\"#colibri .style-1019 {\n  font-style: italic;\n}\n#colibri .style-1019 p {\n  font-style: italic;\n}\n#colibri .style-1019 ol {\n  list-style-type: decimal;\n}\n#colibri .style-1019 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1020;a:3:{s:7:\"desktop\";s:109:\"#colibri .style-1020 ol {\n  list-style-type: decimal;\n}\n#colibri .style-1020 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1021;a:3:{s:7:\"desktop\";s:384:\"#colibri .style-1021 .social-icon-container {\n  margin-right: 5px;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n}\n#colibri .style-1021 .icon-container {\n  fill: rgb(204, 204, 204);\n  width: 20px ;\n  height: 20px;\n}\n#colibri .style-1021 .icon-container:hover {\n  fill: #03a9f4;\n}\n#colibri .style-1021 .icon-container:hover {\n  fill: #03a9f4;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1022;a:3:{s:7:\"desktop\";s:1397:\"#colibri .style-1022-image {\n  opacity: 1;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-1022-overlay {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-1022-caption {\n  margin-top: 10px;\n}\n#colibri .style-1022-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1023;a:3:{s:7:\"desktop\";s:384:\"#colibri .style-1023 .social-icon-container {\n  margin-right: 5px;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n}\n#colibri .style-1023 .icon-container {\n  fill: rgb(204, 204, 204);\n  width: 20px ;\n  height: 20px;\n}\n#colibri .style-1023 .icon-container:hover {\n  fill: #03a9f4;\n}\n#colibri .style-1023 .icon-container:hover {\n  fill: #03a9f4;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1024;a:3:{s:7:\"desktop\";s:1397:\"#colibri .style-1024-image {\n  opacity: 1;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-1024-overlay {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-1024-caption {\n  margin-top: 10px;\n}\n#colibri .style-1024-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1025;a:3:{s:7:\"desktop\";s:384:\"#colibri .style-1025 .social-icon-container {\n  margin-right: 5px;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n}\n#colibri .style-1025 .icon-container {\n  fill: rgb(204, 204, 204);\n  width: 20px ;\n  height: 20px;\n}\n#colibri .style-1025 .icon-container:hover {\n  fill: #03a9f4;\n}\n#colibri .style-1025 .icon-container:hover {\n  fill: #03a9f4;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1026;a:3:{s:7:\"desktop\";s:1397:\"#colibri .style-1026-image {\n  opacity: 1;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-1026-overlay {\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n}\n#colibri .style-1026-caption {\n  margin-top: 10px;\n}\n#colibri .style-1026-frameImage {\n  z-index: -1;\n  transform: translateX(10%) translateY(10%);\n  transform-origin: center center 0px;\n  background-color: rgb(0,0,0);\n  height: 100%;\n  width: 100% ;\n  border-top-width: 10px;\n  border-top-color: rgb(0,0,0);\n  border-top-style: none;\n  border-right-width: 10px;\n  border-right-color: rgb(0,0,0);\n  border-right-style: none;\n  border-bottom-width: 10px;\n  border-bottom-color: rgb(0,0,0);\n  border-bottom-style: none;\n  border-left-width: 10px;\n  border-left-color: rgb(0,0,0);\n  border-left-style: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1027;a:3:{s:7:\"desktop\";s:384:\"#colibri .style-1027 .social-icon-container {\n  margin-right: 5px;\n  padding-top: 5px;\n  padding-right: 5px;\n  padding-bottom: 5px;\n  padding-left: 5px;\n}\n#colibri .style-1027 .icon-container {\n  fill: rgb(204, 204, 204);\n  width: 20px ;\n  height: 20px;\n}\n#colibri .style-1027 .icon-container:hover {\n  fill: #03a9f4;\n}\n#colibri .style-1027 .icon-container:hover {\n  fill: #03a9f4;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1028;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1029;a:3:{s:7:\"desktop\";s:62:\"#colibri .style-1029 {\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1030;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1031;a:3:{s:7:\"desktop\";s:84:\"#colibri .style-1031 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1032;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1046;a:3:{s:7:\"desktop\";s:212:\"#colibri .style-1046 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  background-color: #F5FAFD;\n  background-image: none;\n}\n#colibri .style-1046  > .h-section-grid-container {\n  margin-top: -50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:44:\"#colibri .style-1046 {\n  margin-top: 0px;\n}\n\";}i:1047;a:3:{s:7:\"desktop\";s:135:\"#colibri .style-1047 {\n  box-shadow: 0px 4px 10px 2px rgba(74, 74, 74, 0.3) ;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:111:\"#colibri .style-1047 {\n  margin-top: 15px;\n  margin-right: 15px;\n  margin-bottom: 15px;\n  margin-left: 15px;\n}\n\";}i:1048;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-1048 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:47:\"#colibri .style-1048 {\n  text-align: center;\n}\n\";}i:1049;a:3:{s:7:\"desktop\";s:651:\"#colibri .style-1049-icon {\n  fill: #f79007;\n  width: 50px ;\n  height: 50px;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: solid;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: solid;\n  padding-top: 11px;\n  padding-right: 11px;\n  padding-bottom: 11px;\n  padding-left: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1050;a:3:{s:7:\"desktop\";s:378:\"#colibri .style-1050 p,#colibri .style-1050  h1,#colibri .style-1050  h2,#colibri .style-1050  h3,#colibri .style-1050  h4,#colibri .style-1050  h5,#colibri .style-1050  h6 {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n}\n#colibri .style-1050 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1051;a:3:{s:7:\"desktop\";s:109:\"#colibri .style-1051 ol {\n  list-style-type: decimal;\n}\n#colibri .style-1051 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1067;a:3:{s:7:\"desktop\";s:158:\"#colibri .style-1067 {\n  height: auto;\n  min-height: unset;\n  padding-top: 92px;\n}\n#colibri .style-1067  > .h-section-grid-container {\n  margin-top: -50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:44:\"#colibri .style-1067 {\n  margin-top: 0px;\n}\n\";}i:1068;a:3:{s:7:\"desktop\";s:135:\"#colibri .style-1068 {\n  box-shadow: 0px 4px 10px 2px rgba(74, 74, 74, 0.3) ;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:111:\"#colibri .style-1068 {\n  margin-top: 15px;\n  margin-right: 15px;\n  margin-bottom: 15px;\n  margin-left: 15px;\n}\n\";}i:1069;a:3:{s:7:\"desktop\";s:82:\"#colibri .style-1069 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:47:\"#colibri .style-1069 {\n  text-align: center;\n}\n\";}i:1070;a:3:{s:7:\"desktop\";s:651:\"#colibri .style-1070-icon {\n  fill: #f79007;\n  width: 50px ;\n  height: 50px;\n  border-top-width: 2px;\n  border-top-color: #f79007;\n  border-top-style: solid;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #f79007;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #f79007;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #f79007;\n  border-left-style: solid;\n  padding-top: 11px;\n  padding-right: 11px;\n  padding-bottom: 11px;\n  padding-left: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1071;a:3:{s:7:\"desktop\";s:378:\"#colibri .style-1071 p,#colibri .style-1071  h1,#colibri .style-1071  h2,#colibri .style-1071  h3,#colibri .style-1071  h4,#colibri .style-1071  h5,#colibri .style-1071  h6 {\n  text-transform: uppercase;\n  letter-spacing: 1px;\n}\n#colibri .style-1071 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1072;a:3:{s:7:\"desktop\";s:109:\"#colibri .style-1072 ol {\n  list-style-type: decimal;\n}\n#colibri .style-1072 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1073;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1074;a:3:{s:7:\"desktop\";s:117:\"#colibri .style-1074 {\n  height: auto;\n  min-height: unset;\n  background-color: #F5FAFD;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1075;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1076;a:3:{s:7:\"desktop\";s:84:\"#colibri .style-1076 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1077;a:3:{s:7:\"desktop\";s:180:\"#colibri .style-1077 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  padding-bottom: 0px;\n}\n#colibri .style-1077  > .h-section-grid-container {\n  margin-top: -70px;\n}\n\";s:6:\"tablet\";s:75:\"#colibri .style-1077  > .h-section-grid-container {\n  margin-top: -90px;\n}\n\";s:6:\"mobile\";s:124:\"#colibri .style-1077 {\n  padding-bottom: 10px;\n}\n#colibri .style-1077  > .h-section-grid-container {\n  margin-top: -30px;\n}\n\";}i:1078;a:3:{s:7:\"desktop\";s:506:\"#colibri .style-1078 {\n  background-color: unset;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-right-width: 0px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 5px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n  margin-top: 38px;\n  margin-right: 38px;\n  margin-bottom: 38px;\n  margin-left: 38px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:68:\"#colibri .style-1078 {\n  margin-right: 10px;\n  margin-left: 10px;\n}\n\";}i:1079;a:3:{s:7:\"desktop\";s:599:\".style-1079 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-1079 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  border-top-width: 1px;\n  border-top-color: rgb(204, 204, 204);\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: rgb(204, 204, 204);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(204, 204, 204);\n  border-bottom-style: solid;\n  border-left-width: 1px;\n  border-left-color: rgb(204, 204, 204);\n  border-left-style: solid;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:47:\"#colibri .style-1079 {\n  text-align: center;\n}\n\";}i:1080;a:3:{s:7:\"desktop\";s:413:\"#colibri .style-1080 p,#colibri .style-1080  h1,#colibri .style-1080  h2,#colibri .style-1080  h3,#colibri .style-1080  h4,#colibri .style-1080  h5,#colibri .style-1080  h6 {\n  font-weight: 400;\n  text-transform: uppercase;\n  font-size: 1.2em;\n  color: #03a9f4;\n}\n#colibri .style-1080 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1081;a:3:{s:7:\"desktop\";s:375:\"#colibri .style-1081 p,#colibri .style-1081  h1,#colibri .style-1081  h2,#colibri .style-1081  h3,#colibri .style-1081  h4,#colibri .style-1081  h5,#colibri .style-1081  h6 {\n  text-transform: uppercase;\n  font-size: 0.9em;\n}\n#colibri .style-1081 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1082;a:3:{s:7:\"desktop\";s:599:\".style-1082 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-1082 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  border-top-width: 1px;\n  border-top-color: rgb(204, 204, 204);\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: rgb(204, 204, 204);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(204, 204, 204);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(204, 204, 204);\n  border-left-style: solid;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:73:\"#colibri .style-1082 {\n  text-align: center;\n  border-left-width: 1px;\n}\n\";}i:1083;a:3:{s:7:\"desktop\";s:599:\".style-1083 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-1083 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n  border-top-width: 1px;\n  border-top-color: rgb(204, 204, 204);\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: rgb(204, 204, 204);\n  border-right-style: solid;\n  border-bottom-width: 0px;\n  border-bottom-color: rgb(204, 204, 204);\n  border-bottom-style: solid;\n  border-left-width: 0px;\n  border-left-color: rgb(204, 204, 204);\n  border-left-style: solid;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:73:\"#colibri .style-1083 {\n  text-align: center;\n  border-left-width: 1px;\n}\n\";}i:1084;a:3:{s:7:\"desktop\";s:441:\"#colibri .style-1084 {\n  font-weight: 700;\n  text-decoration: none;\n  font-size: 35px;\n  line-height: 1.2;\n  margin-top: -42px;\n  margin-right: -42px;\n  margin-bottom: -42px;\n  margin-left: -42px;\n  text-align: center;\n}\n#colibri .style-1084 p {\n  font-weight: 700;\n  text-decoration: none;\n  font-size: 35px;\n  line-height: 1.2;\n}\n#colibri .style-1084 ol {\n  list-style-type: decimal;\n}\n#colibri .style-1084 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1085;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1086;a:3:{s:7:\"desktop\";s:117:\"#colibri .style-1086 {\n  height: auto;\n  min-height: unset;\n  background-color: #F5FAFD;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1087;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1088;a:3:{s:7:\"desktop\";s:84:\"#colibri .style-1088 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1089;a:3:{s:7:\"desktop\";s:232:\"#colibri .style-1089 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  box-shadow: none;\n  background-color: #FFFFFF;\n  background-image: none;\n}\n#colibri .style-1089  > .h-section-grid-container {\n  margin-top: -50px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:44:\"#colibri .style-1089 {\n  margin-top: 0px;\n}\n\";}i:1090;a:3:{s:7:\"desktop\";s:135:\"#colibri .style-1090 {\n  box-shadow: 0px 4px 10px 2px rgba(74, 74, 74, 0.3) ;\n  background-color: #f79007;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:111:\"#colibri .style-1090 {\n  margin-top: 15px;\n  margin-right: 15px;\n  margin-bottom: 15px;\n  margin-left: 15px;\n}\n\";}i:1091;a:3:{s:7:\"desktop\";s:139:\"#colibri .style-1091 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: #00bf87;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:52:\"#colibri .style-1091 {\n  background-color: unset;\n}\n\";}i:1092;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1093;a:3:{s:7:\"desktop\";s:84:\"#colibri .style-1093 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:45:\"#colibri .style-1093 {\n  text-align: left;\n}\n\";s:6:\"mobile\";s:0:\"\";}i:1094;a:3:{s:7:\"desktop\";s:651:\"#colibri .style-1094-icon {\n  fill: #FFFFFF;\n  width: 50px ;\n  height: 50px;\n  border-top-width: 2px;\n  border-top-color: #FFFFFF;\n  border-top-style: solid;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 2px;\n  border-right-color: #FFFFFF;\n  border-right-style: solid;\n  border-bottom-width: 2px;\n  border-bottom-color: #FFFFFF;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 2px;\n  border-left-color: #FFFFFF;\n  border-left-style: solid;\n  padding-top: 11px;\n  padding-right: 11px;\n  padding-bottom: 11px;\n  padding-left: 11px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1095;a:3:{s:7:\"desktop\";s:159:\".style-1095 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 10px;\n}\n#colibri .style-1095 {\n  text-align: left;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:47:\"#colibri .style-1095 {\n  text-align: center;\n}\n\";}i:1096;a:3:{s:7:\"desktop\";s:396:\"#colibri .style-1096 p,#colibri .style-1096  h1,#colibri .style-1096  h2,#colibri .style-1096  h3,#colibri .style-1096  h4,#colibri .style-1096  h5,#colibri .style-1096  h6 {\n  color: #FFFFFF;\n  text-transform: uppercase;\n  letter-spacing: 1px;\n}\n#colibri .style-1096 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1097;a:3:{s:7:\"desktop\";s:197:\"#colibri .style-1097 {\n  color: #FFFFFF;\n}\n#colibri .style-1097 p {\n  color: #FFFFFF;\n}\n#colibri .style-1097 ol {\n  list-style-type: decimal;\n}\n#colibri .style-1097 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1098;a:3:{s:7:\"desktop\";s:109:\"#colibri .style-1098 ol {\n  list-style-type: decimal;\n}\n#colibri .style-1098 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1099;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1118;a:3:{s:7:\"desktop\";s:117:\"#colibri .style-1118 {\n  height: auto;\n  min-height: unset;\n  background-color: #F5FAFD;\n  background-image: none;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1119;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1120;a:3:{s:7:\"desktop\";s:174:\"#colibri .style-1120 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  margin-top: -43px;\n  margin-right: -43px;\n  margin-bottom: -43px;\n  margin-left: -43px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1121;a:3:{s:7:\"desktop\";s:156:\"#colibri .style-1121 {\n  text-align: center;\n}\n#colibri .style-1121 ol {\n  list-style-type: decimal;\n}\n#colibri .style-1121 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1122;a:3:{s:7:\"desktop\";s:62:\"#colibri .style-1122 {\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1123;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1124;a:3:{s:7:\"desktop\";s:170:\"#colibri .style-1124 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  margin-top: 14px;\n  margin-right: 14px;\n  margin-bottom: 14px;\n  margin-left: 14px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1125;a:3:{s:7:\"desktop\";s:303:\"#colibri .style-1125 {\n  height: auto;\n  min-height: unset;\n  padding-top: 0px;\n  background-color: #F5FAFD;\n  background-image: none;\n  margin-top: -13px;\n  margin-right: -13px;\n  margin-bottom: -13px;\n  margin-left: -13px;\n}\n#colibri .style-1125  > .h-section-grid-container {\n  margin-top: -100px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1126;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1127;a:3:{s:7:\"desktop\";s:741:\".style-1127 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 10px;\n}\n#colibri .style-1127 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: #FFFFFF;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 3px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n  box-shadow: 0px 2px 5px 2px rgba(0, 0, 0, 0.1) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:48:\"#colibri .style-1127 {\n  margin-bottom: 30px;\n}\n\";}i:1128;a:3:{s:7:\"desktop\";s:697:\"#colibri .style-1128-icon {\n  fill: #FFFFFF;\n  width: 40px ;\n  height: 40px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n  padding-top: 20px;\n  padding-right: 20px;\n  padding-bottom: 20px;\n  padding-left: 20px;\n  background-color: #03a9f4;\n  background-image: none;\n  box-shadow: 0px 2px 5px 2px rgba(0, 0, 0, 0.1) ;\n}\n#colibri .style-1128 {\n  margin-top: -70px;\n  box-shadow: none;\n}\n\";s:6:\"tablet\";s:46:\"#colibri .style-1128 {\n  margin-top: -55px;\n}\n\";s:6:\"mobile\";s:46:\"#colibri .style-1128 {\n  margin-top: -55px;\n}\n\";}i:1129;a:3:{s:7:\"desktop\";s:149:\"#colibri .style-1129 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1130;a:3:{s:7:\"desktop\";s:154:\"#colibri .style-1130 {\n  text-align: left;\n}\n#colibri .style-1130 ol {\n  list-style-type: decimal;\n}\n#colibri .style-1130 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1131;a:3:{s:7:\"desktop\";s:741:\".style-1131 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 10px;\n}\n#colibri .style-1131 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: #FFFFFF;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: #f79007;\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-color: #f79007;\n  border-right-style: solid;\n  border-bottom-width: 3px;\n  border-bottom-color: #f79007;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-color: #f79007;\n  border-left-style: solid;\n  box-shadow: 0px 2px 5px 2px rgba(0, 0, 0, 0.1) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:48:\"#colibri .style-1131 {\n  margin-bottom: 30px;\n}\n\";}i:1132;a:3:{s:7:\"desktop\";s:697:\"#colibri .style-1132-icon {\n  fill: #FFFFFF;\n  width: 40px ;\n  height: 40px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n  padding-top: 20px;\n  padding-right: 20px;\n  padding-bottom: 20px;\n  padding-left: 20px;\n  background-color: #f79007;\n  background-image: none;\n  box-shadow: 0px 2px 5px 2px rgba(0, 0, 0, 0.1) ;\n}\n#colibri .style-1132 {\n  margin-top: -70px;\n  box-shadow: none;\n}\n\";s:6:\"tablet\";s:46:\"#colibri .style-1132 {\n  margin-top: -55px;\n}\n\";s:6:\"mobile\";s:46:\"#colibri .style-1132 {\n  margin-top: -55px;\n}\n\";}i:1133;a:3:{s:7:\"desktop\";s:741:\".style-1133 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 10px;\n}\n#colibri .style-1133 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: #FFFFFF;\n  background-image: none;\n  border-top-width: 0px;\n  border-top-color: #03a9f4;\n  border-top-style: solid;\n  border-top-left-radius: 5px;\n  border-top-right-radius: 5px;\n  border-right-width: 0px;\n  border-right-color: #03a9f4;\n  border-right-style: solid;\n  border-bottom-width: 3px;\n  border-bottom-color: #03a9f4;\n  border-bottom-style: solid;\n  border-bottom-left-radius: 5px;\n  border-bottom-right-radius: 5px;\n  border-left-width: 0px;\n  border-left-color: #03a9f4;\n  border-left-style: solid;\n  box-shadow: 0px 2px 5px 2px rgba(0, 0, 0, 0.1) ;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:48:\"#colibri .style-1133 {\n  margin-bottom: 30px;\n}\n\";}i:1134;a:3:{s:7:\"desktop\";s:697:\"#colibri .style-1134-icon {\n  fill: #FFFFFF;\n  width: 40px ;\n  height: 40px;\n  border-top-width: 0px;\n  border-top-style: none;\n  border-top-left-radius: 300px;\n  border-top-right-radius: 300px;\n  border-right-width: 0px;\n  border-right-style: none;\n  border-bottom-width: 0px;\n  border-bottom-style: none;\n  border-bottom-left-radius: 300px;\n  border-bottom-right-radius: 300px;\n  border-left-width: 0px;\n  border-left-style: none;\n  padding-top: 20px;\n  padding-right: 20px;\n  padding-bottom: 20px;\n  padding-left: 20px;\n  background-color: #00bf87;\n  background-image: none;\n  box-shadow: 0px 2px 5px 2px rgba(0, 0, 0, 0.1) ;\n}\n#colibri .style-1134 {\n  margin-top: -70px;\n  box-shadow: none;\n}\n\";s:6:\"tablet\";s:46:\"#colibri .style-1134 {\n  margin-top: -55px;\n}\n\";s:6:\"mobile\";s:46:\"#colibri .style-1134 {\n  margin-top: -55px;\n}\n\";}i:1135;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1136;a:3:{s:7:\"desktop\";s:84:\"#colibri .style-1136 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1137;a:3:{s:7:\"desktop\";s:314:\"#colibri .style-1137 {\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n  margin-top: -125px;\n  margin-right: -125px;\n  margin-bottom: -125px;\n  margin-left: -125px;\n}\n#colibri .style-1137 ol {\n  list-style-type: decimal;\n}\n#colibri .style-1137 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1138;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1139;a:3:{s:7:\"desktop\";s:147:\"#colibri .style-1139 {\n  min-height: 100vh;\n  background-color: #F5FAFD;\n  background-image: none;\n  padding-top: 25px;\n  padding-bottom: 127px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1140;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1141;a:3:{s:7:\"desktop\";s:84:\"#colibri .style-1141 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1142;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1143;a:3:{s:7:\"desktop\";s:593:\".style-1143 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 12px;\n}\n#colibri .style-1143 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  border-top-width: 1px;\n  border-top-color: #000000;\n  border-top-style: solid;\n  border-right-width: 1px;\n  border-right-color: #000000;\n  border-right-style: solid;\n  border-bottom-width: 1px;\n  border-bottom-color: #000000;\n  border-bottom-style: solid;\n  border-left-width: 1px;\n  border-left-color: #000000;\n  border-left-style: solid;\n  margin-top: -44px;\n  margin-right: -57px;\n  margin-bottom: -116px;\n  margin-left: -2px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1145;a:3:{s:7:\"desktop\";s:331:\"#colibri .style-1145 {\n  color: #000000;\n  padding-bottom: 35px;\n  margin-top: -22px;\n  margin-right: -22px;\n  margin-bottom: -22px;\n  margin-left: -22px;\n  text-align: left;\n}\n#colibri .style-1145 p {\n  color: #000000;\n}\n#colibri .style-1145 ol {\n  list-style-type: decimal;\n}\n#colibri .style-1145 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1146;a:3:{s:7:\"desktop\";s:472:\".style-1146 > .h-y-container > *:not(:last-child) {\n  margin-bottom: 0px;\n}\n#colibri .style-1146 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n  background-color: #03a9f4;\n  background-image: none;\n  padding-top: 10px;\n  padding-right: 10px;\n  padding-bottom: 10px;\n  padding-left: 10px;\n  transform: translateX(0%) translateY(-50%);\n  transform-origin: center center 0px;\n  margin-top: 0px;\n  margin-right: 0px;\n  margin-bottom: 0px;\n  margin-left: 0px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1147;a:3:{s:7:\"desktop\";s:344:\"#colibri .style-1147 p,#colibri .style-1147  h1,#colibri .style-1147  h2,#colibri .style-1147  h3,#colibri .style-1147  h4,#colibri .style-1147  h5,#colibri .style-1147  h6 {\n  color: #FFFFFF;\n}\n#colibri .style-1147 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1149;a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1150;a:3:{s:7:\"desktop\";s:158:\"#colibri .style-1150 {\n  text-align: center;\n  min-height: 199.625px;\n  padding-top: 1px;\n  padding-right: 1px;\n  padding-bottom: 1px;\n  padding-left: 1px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1151;a:3:{s:7:\"desktop\";s:412:\"#colibri .style-1151 p,#colibri .style-1151  h1,#colibri .style-1151  h2,#colibri .style-1151  h3,#colibri .style-1151  h4,#colibri .style-1151  h5,#colibri .style-1151  h6 {\n  padding-top: 0px;\n  padding-right: 0px;\n  padding-bottom: 0px;\n  padding-left: 0px;\n}\n#colibri .style-1151 .text-wrapper-fancy svg path {\n  stroke: #000000;\n  stroke-linejoin: initial;\n  stroke-linecap: initial;\n  stroke-width: 8px;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1152;a:3:{s:7:\"desktop\";s:220:\"#colibri .style-1152 {\n  margin-top: 33px;\n  margin-right: 33px;\n  margin-bottom: 33px;\n  margin-left: 33px;\n}\n#colibri .style-1152 ol {\n  list-style-type: decimal;\n}\n#colibri .style-1152 ul {\n  list-style-type: disc;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}i:1153;a:3:{s:7:\"desktop\";s:84:\"#colibri .style-1153 {\n  text-align: center;\n  height: auto;\n  min-height: unset;\n}\n\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}}s:5:\"rules\";s:294828:\"[{\"id\":1,\"type\":\"hop-header\",\"v\":\"1.1\",\"nodes\":[\"7-h1\",\"2896-h1\"]},{\"id\":2,\"style\":{\"ancestor\":{\"sticky\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}}}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"spread\":\"0\",\"blur\":\"4\"}]}}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":0},\"bottom\":{\"path\":\"value\",\"value\":0}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}}}}},\"type\":\"hop-navigation\",\"props\":{\"overlap\":true,\"sticky\":false,\"stickyStartAt\":\"immediately\",\"width\":\"full-width\"},\"v\":\"1.1\",\"nodes\":[\"7-h2\",\"2896-h2\"]},{\"id\":3,\"props\":{\"containerWidth\":\"boxed\",\"layout\":{\"equalWidth\":false,\"itemsPerRow\":1,\"horizontalGap\":1,\"verticalGap\":1,\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}}},\"background\":{\"color\":\"${theme.colors.4}\"}},\"v\":\"1.1\",\"nodes\":[\"7-h3\",\"2896-h3\",\"10-h3\"]},{\"id\":4,\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":1,\"verticalInnerGap\":0}},\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"7-h4\",\"2896-h4\",\"10-h4\"]},{\"id\":5,\"type\":\"hop-logo\",\"props\":{\"horizontalTextAlign\":\"left\",\"media\":{\"mobile\":{\"horizontalTextAlign\":\"center\"}}},\"style\":{\"descendants\":{\"image\":{\"maxHeight\":{\"path\":\"value\",\"value\":\"120\"}}}},\"v\":\"1.1\",\"nodes\":[\"7-h5\",\"2896-h5\",\"10-h5\"]},{\"id\":6,\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}},\"props\":{\"verticalAlign\":\"center\",\"hide\":{\"mobile\":true},\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-column\",\"nodeId\":\"7-h66\",\"v\":\"1.1\",\"nodes\":[\"7-h12\",\"2896-h12\",\"10-h12\"]},{\"id\":19,\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"url\":\"http:\\/\\/localhost\\/site\\/wp-content\\/uploads\\/2025\\/01\\/ALCADO.jpg\"},\"position\":\"top center\"}],\"overlay\":{\"enabled\":false,\"type\":\"gradient\",\"gradient\":{\"angle\":\"0\",\"steps\":[{\"color\":\"${theme.colors.4}\",\"position\":5.91},{\"color\":\"rgba(0, 0, 0, 0.3)\",\"position\":100}]},\"shape\":{\"value\":\"none\",\"isTile\":false}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"150\",\"path\":\"value\"},\"bottom\":{\"unit\":\"px\",\"value\":\"100\",\"path\":\"value\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"50\"},\"bottom\":{\"value\":\"50\"}}}}},\"props\":{\"heroSection\":{\"layout\":\"textWithMediaOnRight\",\"mediaType\":\"hop-image\"},\"attrs\":{\"name\":\"hero\",\"id\":\"hero\"},\"width\":\"full-width\",\"downArrow\":{\"enabled\":true}},\"type\":\"hop-hero\",\"v\":\"1.1\",\"nodes\":[\"7-h26\",\"2896-h26\"]},{\"id\":20,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":1,\"verticalInnerGap\":1}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"7-h27\",\"2896-h27\"],\"style\":{\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"margin\":{\"top\":{\"value\":\"-61\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"3\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},{\"id\":21,\"props\":{\"verticalAlign\":\"center\"},\"type\":\"hop-column\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\"},\"bottom\":{\"style\":\"solid\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\"}},\"textAlign\":\"left\",\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"}}},\"media\":{\"mobile\":{\"textAlign\":\"center\"}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"v\":\"1.1\",\"nodes\":[\"7-h39\",\"2896-h30\"]},{\"id\":22,\"props\":{\"headerType\":\"1\",\"fancy\":{\"typeStyle\":\"highlighted\",\"fancyWord\":\"to live\",\"typeShape\":\"underline\",\"bringToFront\":false,\"useSmallHeader\":true,\"typeAnimation\":\"type\"}},\"type\":\"hop-heading\",\"style\":{\"background\":{\"color\":\"rgba(17, 31, 51, 0.8)\"},\"padding\":{\"top\":{\"value\":\"36\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"36\",\"unit\":\"px\"},\"left\":{\"value\":\"20\",\"unit\":\"px\"}},\"descendants\":{\"svgShape\":{\"stroke\":{\"color\":\"${theme.colors.4}\",\"linejoin\":\"round\",\"linecap\":\"round\"}}}},\"v\":\"1.1\",\"nodes\":[\"7-h40\",\"2896-h40\"]},{\"id\":24,\"type\":\"hop-button-group\",\"v\":\"1.1\",\"nodes\":[\"7-h41\",\"2896-h41\"]},{\"id\":25,\"style\":{\"background\":{\"color\":\"${theme.colors.0}\",\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"angle\":\"0\",\"steps\":[{\"color\":\"#00c6fb\",\"position\":\"0\"},{\"color\":\"#005bea\",\"position\":\"100\"}]}}}]},\"typography\":{\"color\":\"white\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"weight\":\"600\",\"transform\":\"uppercase\",\"lineHeight\":{\"value\":\"1\"},\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"},\"family\":\"Open Sans\",\"margin\":{\"bottom\":\"2rem\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}},\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}},\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"right\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"20\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}},\"outer\":{\"width\":{\"value\":\"50\",\"unit\":\"%\"}}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.3}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.3}\"},\"left\":{\"color\":\"${theme.colors.3}\"},\"right\":{\"color\":\"${theme.colors.3}\"},\"bottom\":{\"color\":\"${theme.colors.3}\"}}}},\"padding\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"24\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"24\",\"unit\":\"px\"}},\"textAlign\":\"center\"},\"type\":\"hop-button\",\"props\":{\"buttonSize\":\"custom\",\"buttonWidth\":\"custom\",\"horizontalAlign\":\"center\",\"showIcon\":true},\"v\":\"1.1\",\"nodes\":[\"7-h42\",\"2896-h42\"]},{\"id\":26,\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"typography\":{\"color\":\"${theme.colors.5}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"weight\":\"600\",\"transform\":\"uppercase\",\"lineHeight\":{\"value\":\"1\"},\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"},\"family\":\"Open Sans\",\"margin\":{\"bottom\":\"2rem\"}},\"border\":{\"top\":{\"color\":\"white\",\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}},\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"bottom\":{\"color\":\"white\",\"radius\":{\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"}},\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"white\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"right\":{\"color\":\"white\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"20\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}},\"outer\":{\"width\":{\"unit\":\"%\",\"value\":\"50\"}}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.3}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.3}\"},\"left\":{\"color\":\"${theme.colors.3}\"},\"right\":{\"color\":\"${theme.colors.3}\"},\"bottom\":{\"color\":\"${theme.colors.3}\"}},\"typography\":{\"color\":\"${theme.colors.4}\"}}},\"padding\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"24\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"24\",\"unit\":\"px\"}},\"textAlign\":\"center\"},\"type\":\"hop-button\",\"props\":{\"buttonSize\":\"custom\",\"buttonWidth\":\"custom\",\"horizontalAlign\":\"center\",\"showIcon\":true},\"v\":\"1.1\",\"nodes\":[\"7-h43\",\"2896-h43\"]},{\"id\":27,\"type\":\"hop-header\",\"nodeId\":\"4443-h1\",\"v\":\"1.1\",\"nodes\":[\"10-h1\"]},{\"id\":45,\"style\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"image\",\"gradient\":{\"angle\":\"90\",\"steps\":[{\"color\":\"rgba(106, 17, 203, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(37, 117, 252, 0.8)\",\"position\":\"100\"}]}}}],\"color\":\"${theme.colors.0}\"},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"0\"},\"bottom\":{\"unit\":\"px\",\"value\":\"0\"}}},\"props\":{\"heroSection\":{\"layout\":\"textWithMediaOnRight\",\"mediaType\":\"hop-image\"},\"attrs\":{\"name\":\"hero\",\"id\":\"hero\"},\"width\":\"full-width\"},\"type\":\"hop-hero\",\"nodeId\":\"7-h32\",\"v\":\"1.1\",\"nodes\":[\"10-h25\"]},{\"id\":46,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"7-h28\",\"style\":{\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"image\"},\"position\":\"center center\"}]}},\"v\":\"1.1\",\"nodes\":[\"10-h37\"]},{\"id\":47,\"type\":\"hop-column\",\"nodeId\":\"7-h29\",\"style\":{\"textAlign\":\"left\"},\"v\":\"1.1\",\"nodes\":[\"10-h38\"]},{\"id\":48,\"type\":\"hop-page-title\",\"nodeId\":\"7-h30\",\"style\":{\"typography\":{\"size\":{\"unit\":\"em\",\"value\":\"2\"}}},\"v\":\"1.1\",\"nodes\":[\"10-h39\"]},{\"id\":141,\"type\":\"hop-content\",\"nodeId\":\"5-c1\",\"v\":\"1.1\",\"nodes\":[\"5-c1\",\"2901-c1\"]},{\"id\":159,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"7-h38\",\"style\":{\"background\":{\"color\":\"${theme.colors.0}\"}},\"v\":\"1.1\",\"nodes\":[\"7-h14\",\"2896-h14\"]},{\"id\":160,\"type\":\"hop-column\",\"nodeId\":\"7-h39\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"props\":{\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"7-h15\",\"2896-h15\",\"10-h15\"]},{\"id\":163,\"type\":\"hop-horizontal-menu\",\"style\":{\"descendants\":{\"item\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"20\",\"unit\":\"px\"}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}}},\"link\":{\"typography\":{\"weight\":\"600\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"transform\":\"uppercase\",\"family\":\"Open Sans\",\"lineHeight\":{\"unit\":\"em\",\"value\":\"1.5\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"0\"},\"color\":\"${theme.colors.4}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"submenu\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"5\",\"color\":\"rgba(0, 0, 0, 0.04)\"}]}},\"submenu-item\":{\"background\":{\"color\":\"${theme.colors.3}\"},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.4}\"}},\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.0}\"}}}},\"submenu-item-link\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.3}\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}}},\"typography\":{\"color\":\"${theme.colors.4}\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}},\"hover-effect-border\":{\"background\":{\"color\":\"${theme.colors.0}\"}},\"innerMenu\":{\"justifyContent\":\"center\"},\"mainMenuIcon\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"props\":{\"hoverEffect\":{\"type\":\"bordered-active-item bordered-active-item--bottom\",\"activeGroup\":\"border\"}},\"v\":\"1.1\",\"nodes\":[\"7-h16\",\"2896-h16\"]},{\"id\":164,\"type\":\"hop-mobile-menu\",\"nodeId\":\"7-h42\",\"style\":{\"descendants\":{\"offscreen\":{\"media\":{\"mobile\":{\"background\":{\"color\":\"${theme.colors.5}\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"7-h17\",\"2896-h17\",\"10-h17\"]},{\"id\":165,\"type\":\"hop-offscreen-panel\",\"nodeId\":\"7-h43\",\"v\":\"1.1\",\"nodes\":[\"7-h18\",\"2896-h18\",\"10-h18\"]},{\"id\":166,\"style\":{\"descendants\":{\"link\":{\"typography\":{\"color\":\"${theme.colors.4}\",\"transform\":\"capitalize\"}},\"submenu-item-link\":{\"typography\":{\"color\":\"white\"}},\"iconOption\":{\"typography\":{\"color\":\"white\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"white\"}},\"item\":{\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"}},\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.0}\"}}},\"border\":{\"bottom\":{\"color\":\"rgba(236, 82, 55, 0.3)\"}}}}},\"props\":{\"layout\":\"accordion\"},\"type\":\"hop-accordion-menu\",\"nodeId\":\"7-h44\",\"v\":\"1.1\",\"nodes\":[\"7-h19\",\"2896-h19\",\"10-h19\"]},{\"id\":167,\"type\":\"hop-row\",\"nodeId\":\"7-h45\",\"v\":\"1.1\",\"nodes\":[\"7-h20\",\"2896-h20\",\"10-h20\"],\"props\":{\"layout\":{\"equalWidth\":false}}},{\"id\":168,\"type\":\"hop-column\",\"nodeId\":\"7-h46\",\"v\":\"1.1\",\"nodes\":[\"7-h21\",\"2896-h21\",\"10-h21\"]},{\"id\":169,\"type\":\"hop-logo\",\"nodeId\":\"7-h47\",\"v\":\"1.1\",\"nodes\":[\"7-h22\",\"2896-h22\",\"10-h22\"]},{\"id\":170,\"type\":\"hop-row\",\"nodeId\":\"7-h48\",\"v\":\"1.1\",\"props\":{\"layout\":{\"equalWidth\":false}},\"nodes\":[\"7-h23\",\"2896-h23\",\"10-h23\"]},{\"id\":171,\"type\":\"hop-column\",\"nodeId\":\"7-h49\",\"v\":\"1.1\",\"nodes\":[\"7-h24\",\"2896-h24\",\"10-h24\"]},{\"id\":174,\"type\":\"hop-search\",\"style\":{\"descendants\":{\"button\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.1}\"}}},\"width\":{\"value\":\"60\"},\"border\":{\"top\":{\"style\":\"solid\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\"},\"bottom\":{\"style\":\"solid\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\"}},\"typography\":{\"weight\":\"400\"}},\"input\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"none\",\"color\":\"rgb(222, 222, 222)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"none\",\"color\":\"rgb(222, 222, 222)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"color\":\"rgb(222, 222, 222)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"color\":\"rgb(222, 222, 222)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}}},\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"color\":\"rgb(153, 153, 153)\",\"style\":\"italic\",\"weight\":\"400\",\"family\":\"Source Sans Pro\"},\"padding\":{\"top\":{\"value\":\"6\",\"unit\":\"px\"},\"right\":{\"value\":\"12\",\"unit\":\"px\"},\"bottom\":{\"value\":\"7\",\"unit\":\"px\"},\"left\":{\"value\":\"12\",\"unit\":\"px\"}}},\"icon\":{\"width\":{\"value\":\"18\"}}}},\"v\":\"1.1\",\"nodes\":[\"7-h13\",\"2896-h13\"]},{\"id\":175,\"type\":\"hop-column\",\"nodeId\":\"7-h52\",\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"7-h9\",\"2896-h9\",\"10-h9\"]},{\"id\":179,\"type\":\"hop-column\",\"nodeId\":\"7-h55\",\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"hide\":{\"mobile\":true}},\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"7-h7\",\"2896-h7\",\"10-h7\"]},{\"id\":180,\"type\":\"hop-button-group\",\"nodeId\":\"7-h56\",\"v\":\"1.1\",\"nodes\":[\"7-h10\",\"2896-h10\",\"10-h10\"]},{\"id\":181,\"type\":\"hop-button\",\"nodeId\":\"7-h57\",\"style\":{\"border\":{\"top\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"},\"left\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"path\":\"value\",\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"bottom\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"},\"left\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"path\":\"value\",\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"left\":{\"style\":\"none\",\"width\":{\"path\":\"value\",\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"right\":{\"style\":\"none\",\"width\":{\"path\":\"value\",\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"}},\"background\":{\"color\":\"${theme.colors.4}\"},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0}\"},\"left\":{\"color\":\"${theme.colors.0}\"},\"right\":{\"color\":\"${theme.colors.0}\"},\"bottom\":{\"color\":\"${theme.colors.0}\"}},\"typography\":{\"color\":\"${theme.colors.4}\"}}},\"typography\":{\"color\":\"${theme.colors.5}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"family\":\"Source Sans Pro\",\"margin\":{\"bottom\":\"2rem\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.0}\",\"size\":{\"value\":\"30\",\"unit\":\"px\"},\"states\":{\"hover\":{\"fill\":\"${theme.colors.4}\"}},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"22\",\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"value\":\"22\",\"unit\":\"px\"}},\"textAlign\":\"center\"},\"props\":{\"showIcon\":true},\"v\":\"1.1\",\"nodes\":[\"7-h11\",\"2896-h11\"]},{\"id\":182,\"type\":\"hop-column\",\"nodeId\":\"7-h58\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"hide\":{\"mobile\":true,\"tablet\":true}},\"v\":\"1.1\",\"nodes\":[\"7-h6\",\"2896-h6\",\"10-h6\"]},{\"id\":184,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon-content\":{\"fill\":\"rgba(153, 153, 153, 0.8)\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.0}\"}},\"width\":{\"value\":\"25\"},\"height\":{\"value\":\"25\"}},\"icon\":{\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},\"background\":{\"color\":\"${theme.colors.4}\"},\"padding\":{\"top\":{\"value\":\"3\",\"unit\":\"px\"},\"right\":{\"value\":\"17\",\"unit\":\"px\"},\"bottom\":{\"value\":\"3\",\"unit\":\"px\"},\"left\":{\"value\":\"17\",\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"7-h8\",\"2896-h8\",\"10-h8\"]},{\"id\":185,\"type\":\"hop-column\",\"nodeId\":\"7-h60\",\"v\":\"1.1\",\"nodes\":[\"7-h28\",\"2896-h28\"],\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},{\"id\":187,\"props\":{\"wordpressThemeLocation\":{\"id\":\"content-menu\",\"label\":\"In Page Menu\",\"priority\":1},\"showOffscreenMenuOn\":\"has-offcanvas-mobile\"},\"type\":\"hop-vertical-menu\",\"style\":{\"descendants\":{\"item\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"border\":{\"bottom\":{\"color\":\"rgba(255, 255, 255, 0.1)\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.3}\"}},\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.3}\"}}},\"padding\":{\"top\":{\"value\":\"12\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"12\",\"unit\":\"px\"},\"left\":{\"value\":\"25\",\"unit\":\"px\"}}},\"link\":{\"typography\":{\"color\":\"${theme.colors.4}\",\"transform\":\"capitalize\",\"size\":{\"unit\":\"px\",\"value\":\"15\"},\"letterSpacing\":{\"unit\":\"px\"}}},\"mainMenuIcon\":{\"typography\":{\"color\":\"rgba(255, 255, 255, 0.7)\"}},\"submenu-item\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"border\":{\"bottom\":{\"color\":\"rgba(255, 255, 255, 0.7)\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0|variant3}\"}},\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"submenu-item-link\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"rgba(255, 255, 255, 0.7)\"}}}},\"v\":\"1.1\",\"nodes\":[\"7-h29\",\"2896-h32\"]},{\"id\":188,\"type\":\"hop-mobile-menu\",\"nodeId\":\"7-h62\",\"v\":\"1.1\",\"nodes\":[\"7-h30\",\"2896-h33\"]},{\"id\":189,\"type\":\"hop-offscreen-panel\",\"nodeId\":\"7-h63\",\"v\":\"1.1\",\"nodes\":[\"7-h31\",\"2896-h34\"]},{\"id\":190,\"style\":{\"descendants\":{\"link\":{\"typography\":{\"color\":\"white\"}},\"submenu-item-link\":{\"typography\":{\"color\":\"white\"}},\"iconOption\":{\"typography\":{\"color\":\"white\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"white\"}}}},\"props\":{\"layout\":\"accordion\"},\"type\":\"hop-accordion-menu\",\"nodeId\":\"7-h64\",\"v\":\"1.1\",\"nodes\":[\"7-h32\",\"2896-h35\"]},{\"id\":191,\"type\":\"hop-row\",\"nodeId\":\"7-h65\",\"v\":\"1.1\",\"nodes\":[\"7-h33\",\"2896-h36\"],\"props\":{\"layout\":{\"equalWidth\":false}}},{\"id\":192,\"type\":\"hop-column\",\"nodeId\":\"7-h66\",\"v\":\"1.1\",\"nodes\":[\"7-h34\",\"2896-h37\"]},{\"id\":193,\"type\":\"hop-logo\",\"nodeId\":\"7-h67\",\"v\":\"1.1\",\"nodes\":[\"7-h35\",\"2896-h38\"]},{\"id\":194,\"type\":\"hop-row\",\"nodeId\":\"7-h68\",\"v\":\"1.1\",\"nodes\":[\"7-h36\",\"2896-h39\"],\"props\":{\"layout\":{\"equalWidth\":false}}},{\"id\":195,\"type\":\"hop-column\",\"nodeId\":\"7-h69\",\"v\":\"1.1\",\"nodes\":[\"7-h37\",\"2896-h40\"]},{\"id\":197,\"type\":\"hop-section\",\"nodeId\":\"5-c8\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}}},\"v\":\"1.1\",\"nodes\":[\"5-c2\",\"2901-c2\"]},{\"id\":198,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4},\"media\":{\"mobile\":{\"layout\":{\"itemsPerRow\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"5-c9\",\"v\":\"1.1\",\"nodes\":[\"5-c3\",\"2901-c3\"]},{\"id\":199,\"type\":\"hop-column\",\"nodeId\":\"5-c10\",\"v\":\"1.1\",\"nodes\":[\"5-c4\",\"5-c6\",\"5-c8\",\"5-c10\",\"2901-c4\",\"2901-c6\",\"2901-c8\",\"2901-c10\"]},{\"id\":204,\"type\":\"hop-counters\",\"style\":{\"descendants\":{\"simpleTitle\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"21\"},\"transform\":\"lowercase\",\"family\":\"Source Sans Pro\",\"color\":\"${theme.colors.5}\"}},\"simpleCounter\":{\"typography\":{\"size\":{\"unit\":\"em\",\"value\":\"3\"},\"family\":\"Montserrat\",\"color\":\"${theme.colors.0}\"},\"media\":{\"tablet\":{\"typography\":{\"size\":{\"unit\":\"em\",\"value\":\"2.5\"}}},\"mobile\":{\"typography\":{\"size\":{\"unit\":\"em\",\"value\":\"2\"}}}}},\"circleTitle\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"px\",\"value\":\"21\"}}},\"circleCounter\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"em\",\"value\":\"3\"}}},\"barTitle\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"weight\":\"600\"}},\"barCounter\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"weight\":\"600\"}},\"icon\":{\"width\":{\"value\":\"50\"},\"height\":{\"value\":\"50\"},\"fill\":\"${theme.colors.4|variant2}\"}}},\"props\":{\"counterType\":\"number\",\"colorOut\":\"rgba(23, 37, 42, 0.1)\",\"colorIn\":\"${theme.colors.0}\",\"width\":{\"value\":\"200\"},\"counterPostion\":\"sameRow\",\"height\":{\"value\":\"10\"},\"showIcon\":true,\"titlePosition\":\"under\"},\"v\":\"1.1\",\"nodes\":[\"5-c5\",\"5-c7\",\"5-c9\",\"5-c11\",\"2901-c5\",\"2901-c7\",\"2901-c9\",\"2901-c11\"]},{\"id\":205,\"type\":\"hop-footer\",\"props\":{\"useFooterParallax\":false},\"v\":\"1.1\",\"nodes\":[\"13-f1\"]},{\"id\":216,\"type\":\"hop-section\",\"style\":{\"background\":{\"color\":\"${theme.colors.5}\"},\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.4|variant2}\"},\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"}}},\"padding\":{\"top\":{\"value\":\"30\"},\"bottom\":{\"value\":\"30\"}}},\"props\":{\"width\":\"boxed\"},\"v\":\"1.1\",\"nodes\":[\"13-f2\"]},{\"id\":217,\"props\":{\"layout\":{\"equalWidth\":false,\"itemsPerRow\":6},\"media\":{\"tablet\":{\"layout\":{\"horizontalGap\":0,\"verticalGap\":0}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"13-f3\"]},{\"id\":218,\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"media\":{\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"center\"}}},\"props\":{\"hide\":{\"tablet\":false},\"layout\":{\"vSpace\":{\"value\":\"5\"}}},\"v\":\"1.1\",\"nodes\":[\"13-f4\"]},{\"id\":219,\"type\":\"hop-logo\",\"style\":{\"descendants\":{\"image\":{\"maxHeight\":{\"path\":\"value\",\"value\":\"70\"}}}},\"props\":{\"horizontalTextAlign\":\"left\",\"media\":{\"mobile\":{\"horizontalTextAlign\":\"center\"}}},\"v\":\"1.1\",\"nodes\":[\"13-f5\"]},{\"id\":220,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"left\",\"descendants\":{\"outer\":{\"media\":{\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"media\":{\"tablet\":{\"textAlign\":\"left\"},\"mobile\":{\"textAlign\":\"center\"}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"0\"}}},\"v\":\"1.1\",\"nodes\":[\"13-f9\"]},{\"id\":221,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"13-f11\"]},{\"id\":222,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"13-f12\"]},{\"id\":223,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"13-f13\"]},{\"id\":224,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"descendants\":{\"outer\":{\"media\":{\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"media\":{\"tablet\":{\"textAlign\":\"center\"},\"mobile\":{\"textAlign\":\"center\"}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"0\"}}},\"v\":\"1.1\",\"nodes\":[\"13-f20\"]},{\"id\":225,\"type\":\"hop-link-group\",\"v\":\"1.1\",\"nodes\":[\"13-f15\"]},{\"id\":226,\"type\":\"hop-link\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4|variant2}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}}},\"v\":\"1.1\",\"nodes\":[\"13-f16\",\"13-f17\"]},{\"id\":227,\"type\":\"hop-link-group\",\"v\":\"1.1\",\"nodes\":[\"13-f18\"]},{\"id\":228,\"type\":\"hop-link\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4|variant2}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}}},\"v\":\"1.1\",\"nodes\":[\"13-f19\"]},{\"id\":229,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"descendants\":{\"outer\":{\"media\":{\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"media\":{\"mobile\":{\"textAlign\":\"center\"}}},\"v\":\"1.1\",\"nodes\":[\"13-f23\"]},{\"id\":231,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"center\",\"media\":{\"tablet\":{\"textAlign\":\"center\"},\"mobile\":{\"textAlign\":\"center\"}},\"descendants\":{\"outer\":{\"media\":{\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"13-f20\"]},{\"id\":234,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"13-f22\"]},{\"id\":235,\"type\":\"hop-column\",\"v\":\"1.1\",\"nodes\":[\"13-f23\"]},{\"id\":236,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"v\":\"1.1\",\"nodes\":[\"13-f24\"]},{\"id\":237,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"13-f25\"]},{\"id\":238,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"value\":0},\"bottom\":{\"value\":0}},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":-25,\"unit\":\"px\",\"path\":\"value\"}}}}},\"props\":{\"width\":\"full-width\"},\"v\":\"1.1\",\"nodes\":[\"13-f26\"]},{\"id\":239,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalAlign\":\"end\"}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"13-f27\"]},{\"id\":240,\"type\":\"hop-column\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":25},\"type\":\"fit-to-content\"},\"media\":{\"mobile\":{\"textAlign\":\"right\"}},\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"image\"}}]}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"13-f28\"]},{\"id\":241,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"fill\":\"${theme.colors.4}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.4}\",\"background\":{\"color\":\"${theme.colors.1}\"}}},\"border\":{\"top\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"right\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"bottom\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"left\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"}},\"width\":{\"path\":\"value\",\"value\":\"20\"},\"height\":{\"path\":\"value\",\"value\":\"20\"},\"background\":{\"color\":\"${theme.colors.0}\"},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"path\":\"value\",\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"path\":\"value\",\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"}}}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"13-f29\"]},{\"id\":242,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"13-f30\"]},{\"id\":243,\"type\":\"hop-column\",\"v\":\"1.1\",\"nodes\":[\"13-f31\"]},{\"id\":244,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"v\":\"1.1\",\"nodes\":[\"13-f32\"]},{\"id\":245,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"13-f33\"]},{\"id\":246,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"15\"},\"bottom\":{\"path\":\"value\",\"value\":\"15\"}},\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/aerial-view-architecture-cars-280221-1.jpg\"},\"position\":\"bottom center\"}],\"overlay\":{\"enabled\":true,\"color\":{\"value\":\"${theme.colors.4}\",\"opacity\":\"0.8\"}}}},\"props\":{\"width\":\"full-width\"},\"v\":\"1.1\",\"nodes\":[\"13-f34\"]},{\"id\":247,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalInnerGap\":1,\"verticalGap\":1,\"horizontalGap\":1},\"media\":{\"mobile\":{\"layout\":{\"verticalGap\":2,\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"13-f35\"]},{\"id\":248,\"type\":\"hop-column\",\"props\":{\"layout\":{\"vSpace\":{\"value\":\"0\"},\"horizontalInnerGap\":1,\"verticalInnerGap\":1},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}}}},\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"textAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"13-f36\"]},{\"id\":250,\"type\":\"hop-section\",\"nodeId\":\"5-c12\",\"style\":{\"background\":{\"color\":\"rgb(34, 41, 51)\"},\"padding\":{\"bottom\":{\"value\":\"0\"}},\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}}},\"v\":\"1.1\",\"nodes\":[\"5-c12\",\"2901-c12\"]},{\"id\":251,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"equalHeight\":true,\"verticalAlign\":\"start\"}},\"type\":\"hop-row\",\"nodeId\":\"5-c13\",\"v\":\"1.1\",\"nodes\":[\"5-c13\",\"2901-c13\"]},{\"id\":252,\"type\":\"hop-column\",\"nodeId\":\"5-c14\",\"style\":{\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"textAlign\":\"left\",\"media\":{\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}},\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3,\"vSpace\":{\"value\":\"0\"}},\"media\":{\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}}},\"v\":\"1.1\",\"nodes\":[\"5-c14\",\"2901-c14\"]},{\"id\":253,\"type\":\"hop-column\",\"nodeId\":\"5-c15\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"textAlign\":\"left\"},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"verticalAlign\":\"end\"},\"v\":\"1.1\",\"nodes\":[\"5-c21\",\"2901-c21\"]},{\"id\":254,\"type\":\"hop-image\",\"nodeId\":\"5-c16\",\"v\":\"1.1\",\"nodes\":[\"5-c22\",\"2901-c22\"]},{\"id\":255,\"type\":\"hop-heading\",\"nodeId\":\"5-c17\",\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"5-c18\",\"2901-c18\"]},{\"id\":256,\"type\":\"hop-text\",\"nodeId\":\"5-c18\",\"v\":\"1.1\",\"nodes\":[\"5-c19\",\"2901-c19\"]},{\"id\":260,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"5-c22\",\"v\":\"1.1\",\"nodes\":[\"5-c16\",\"2901-c16\"]},{\"id\":261,\"type\":\"hop-column\",\"nodeId\":\"5-c23\",\"style\":{\"textAlign\":\"left\",\"padding\":{\"top\":{\"value\":\"3\",\"unit\":\"rem\"},\"right\":{\"value\":\"3\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"3\",\"unit\":\"rem\"},\"left\":{\"value\":\"3\",\"unit\":\"rem\"}},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"2\",\"unit\":\"rem\"},\"right\":{\"value\":\"2\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"2\",\"unit\":\"rem\"},\"left\":{\"value\":\"2\",\"unit\":\"rem\"}},\"textAlign\":\"center\"}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"20\"}},\"media\":{\"mobile\":{\"verticalAlign\":\"center\"}}},\"v\":\"1.1\",\"nodes\":[\"5-c17\",\"2901-c17\"]},{\"id\":263,\"type\":\"hop-spacer\",\"nodeId\":\"5-c25\",\"style\":{\"height\":{\"value\":\"20\"}},\"props\":{\"hide\":{\"mobile\":true,\"tablet\":true}},\"v\":\"1.1\",\"nodes\":[\"5-c20\",\"2901-c20\"]},{\"id\":264,\"type\":\"hop-section\",\"nodeId\":\"5-c22\",\"style\":{\"background\":{\"color\":\"rgb(241, 238, 235)\",\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"angle\":\"120\",\"steps\":[{\"color\":\"rgba(253, 251, 251, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(235, 237, 238, 0.8)\",\"position\":\"100\"}]}}}]}},\"props\":{\"showHeader\":true},\"v\":\"1.1\",\"nodes\":[\"5-c23\",\"2901-c23\"]},{\"id\":265,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":3,\"horizontalGap\":2,\"verticalGap\":2},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}},\"tablet\":{\"layout\":{\"itemsPerRow\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"5-c23\",\"v\":\"1.1\",\"nodes\":[\"5-c24\",\"2901-c24\"]},{\"id\":267,\"type\":\"hop-column\",\"nodeId\":\"5-c25\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"background\":{\"color\":\"${theme.colors.4}\"},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(0, 0, 0, 0.05)\",\"blur\":\"0\",\"spread\":\"0\",\"y\":\"1\",\"x\":\"1\"}]}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"0\"},\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"5-c25\",\"5-c36\",\"5-c47\",\"2901-c25\",\"2901-c36\",\"2901-c47\"]},{\"id\":272,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"5-c30\",\"v\":\"1.1\",\"nodes\":[\"5-c58\",\"2901-c58\"]},{\"id\":273,\"type\":\"hop-column\",\"nodeId\":\"5-c31\",\"props\":{\"layout\":{\"vSpace\":{\"value\":\"5\"}}},\"v\":\"1.1\",\"nodes\":[\"5-c59\",\"2901-c59\"]},{\"id\":274,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"5-c32\",\"v\":\"1.1\",\"nodes\":[\"5-c62\",\"2901-c62\"]},{\"id\":275,\"type\":\"hop-text\",\"nodeId\":\"5-c33\",\"props\":{\"type\":\"lead\"},\"style\":{\"typography\":{\"holders\":{\"p\":{\"transform\":\"uppercase\",\"color\":\"${theme.colors.0}\"}}}},\"v\":\"1.1\",\"nodes\":[\"5-c60\",\"2901-c60\"]},{\"id\":277,\"type\":\"hop-divider\",\"style\":{\"descendants\":{\"line\":{\"border\":{\"bottom\":{\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\"}}},\"width\":{\"value\":\"90\",\"unit\":\"px\"}},\"icon\":{\"fill\":\"${theme.colors.0}\"}},\"padding\":{\"top\":{\"value\":0},\"bottom\":{\"value\":0}}},\"props\":{\"type\":\"line\"},\"v\":\"1.1\",\"nodes\":[\"5-c61\",\"2901-c61\"]},{\"id\":278,\"type\":\"hop-heading\",\"nodeId\":\"5-c35\",\"props\":{\"headerType\":\"3\"},\"v\":\"1.1\",\"nodes\":[\"5-c32\",\"5-c43\",\"5-c54\",\"2901-c32\",\"2901-c43\",\"2901-c54\"]},{\"id\":279,\"type\":\"hop-text\",\"nodeId\":\"5-c36\",\"v\":\"1.1\",\"nodes\":[\"5-c33\",\"5-c44\",\"5-c55\",\"2901-c33\",\"2901-c44\",\"2901-c55\"]},{\"id\":280,\"type\":\"hop-link-group\",\"nodeId\":\"5-c37\",\"v\":\"1.1\",\"nodes\":[\"5-c34\",\"5-c45\",\"5-c56\",\"2901-c34\",\"2901-c45\",\"2901-c56\"]},{\"id\":281,\"type\":\"hop-link\",\"nodeId\":\"5-c38\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"props\":{\"showIcon\":true,\"iconPosition\":\"after\"},\"v\":\"1.1\",\"nodes\":[\"5-c35\",\"5-c46\",\"5-c57\",\"2901-c35\",\"2901-c46\",\"2901-c57\"]},{\"id\":303,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\"},\"padding\":{\"left\":{\"value\":\"50\"},\"right\":{\"value\":\"50\"}},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.6)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false},\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/bookcase-books-bookshelves-256541.jpg\"}}]}},\"props\":{\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}},\"attrs\":{\"overflowOption\":\"hidden\"}},\"v\":\"1.1\",\"nodes\":[\"5-c37\",\"2901-c37\"]},{\"id\":304,\"style\":{\"textAlign\":\"center\",\"minHeight\":{\"value\":\"250\"}},\"type\":\"hop-content-swap-default\",\"props\":{\"horizontalGap\":3},\"v\":\"1.1\",\"nodes\":[\"5-c27\",\"5-c38\",\"5-c49\",\"2901-c27\",\"2901-c38\",\"2901-c49\"]},{\"id\":307,\"style\":{\"textAlign\":\"center\",\"height\":{\"value\":100},\"top\":{\"value\":0,\"unit\":\"%\"},\"left\":{\"value\":0,\"unit\":\"%\"},\"width\":{\"value\":100}},\"type\":\"hop-content-swap-hover\",\"props\":{\"verticalAlign\":\"center\",\"position\":\"topRight\"},\"v\":\"1.1\",\"nodes\":[\"5-c28\",\"5-c39\",\"5-c50\",\"2901-c28\",\"2901-c39\",\"2901-c50\"]},{\"id\":310,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"5-c67\",\"v\":\"1.1\",\"nodes\":[\"5-c30\",\"5-c41\",\"5-c52\",\"2901-c30\",\"2901-c41\",\"2901-c52\"]},{\"id\":311,\"type\":\"hop-column\",\"nodeId\":\"5-c68\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2,\"vSpace\":{\"value\":\"20\"}}},\"v\":\"1.1\",\"nodes\":[\"5-c31\",\"5-c42\",\"5-c53\",\"2901-c31\",\"2901-c42\",\"2901-c53\"]},{\"id\":314,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"fill\":\"${theme.colors.4}\",\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(45, 45, 134, 0)\"},\"fill\":\"${theme.colors.0|mediumLowLuminosity}\"}},\"border\":{\"top\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"right\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"bottom\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"left\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"}},\"width\":{\"path\":\"value\",\"value\":\"50\"},\"height\":{\"path\":\"value\",\"value\":\"50\"}}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"5-c29\",\"5-c40\",\"5-c51\",\"2901-c29\",\"2901-c40\",\"2901-c51\"]},{\"id\":315,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\"},\"padding\":{\"left\":{\"value\":\"50\"},\"right\":{\"value\":\"50\"}},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.6)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false},\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/portrayal-89193_640.jpg\"}}]}},\"props\":{\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}},\"attrs\":{\"overflowOption\":\"hidden\"}},\"nodeId\":\"5-c25\",\"v\":\"1.1\",\"nodes\":[\"5-c26\",\"2901-c26\"]},{\"id\":316,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\"},\"padding\":{\"left\":{\"value\":\"50\"},\"right\":{\"value\":\"50\"}},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.6)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false},\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/architecture-cobblestone-street-daylight-772177.jpg\"}}]}},\"props\":{\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}},\"attrs\":{\"overflowOption\":\"hidden\"}},\"nodeId\":\"5-c52\",\"v\":\"1.1\",\"nodes\":[\"5-c48\",\"2901-c48\"]},{\"id\":318,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"fill\":\"rgba(255, 255, 255, 0.3)\",\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.5}\"},\"fill\":\"${theme.colors.0}\"}},\"border\":{\"top\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"right\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"bottom\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"left\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":\"0\"}}},\"background\":{\"color\":\"${theme.colors.5}\"},\"media\":{\"tablet\":{\"width\":{\"path\":\"value\",\"value\":\"80\"},\"height\":{\"path\":\"value\",\"value\":\"80\"}},\"mobile\":{\"width\":{\"path\":\"value\",\"value\":\"70\"},\"height\":{\"path\":\"value\",\"value\":\"70\"}}}}},\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"-110\",\"unit\":\"px\"},\"left\":{\"value\":\"-35\",\"unit\":\"px\"}},\"zIndex\":\"2\",\"media\":{\"mobile\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"-100\",\"unit\":\"px\"},\"left\":{\"value\":\"-15\",\"unit\":\"px\"}}}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"5-c15\",\"2901-c15\"]},{\"id\":319,\"type\":\"hop-section\",\"props\":{\"showHeader\":true},\"style\":{\"background\":{\"color\":\"${theme.colors.5}\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/aerial-view-architecture-cars-280221-1.jpg\"},\"useParallax\":true,\"position\":{\"x\":49.54748664267801,\"y\":64.57311089303238}}],\"overlay\":{\"enabled\":true,\"color\":{\"value\":\"${theme.colors.5}\",\"opacity\":\"0.9\"}}},\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}}},\"v\":\"1.1\",\"nodes\":[\"5-c63\",\"2901-c63\"]},{\"id\":320,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4},\"media\":{\"tablet\":{\"layout\":{\"itemsPerRow\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"5-c64\",\"2901-c64\"]},{\"id\":321,\"type\":\"hop-column\",\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"5-c65\",\"5-c73\",\"5-c81\",\"5-c89\",\"2901-c65\",\"2901-c73\",\"2901-c81\",\"2901-c89\"]},{\"id\":322,\"props\":{\"layout\":{\"equalWidth\":false,\"verticalGap\":0,\"horizontalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"5-c66\",\"5-c74\",\"5-c82\",\"5-c90\",\"2901-c66\",\"2901-c74\",\"2901-c82\",\"2901-c90\"]},{\"id\":323,\"type\":\"hop-column\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"states\":{\"hover\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}}},\"background\":{\"color\":\"${theme.colors.5}\"}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3,\"vSpace\":{\"path\":\"value\",\"value\":\"10\"}}},\"v\":\"1.1\",\"nodes\":[\"5-c67\",\"5-c75\",\"5-c83\",\"5-c91\",\"2901-c67\",\"2901-c75\",\"2901-c83\",\"2901-c91\"]},{\"id\":324,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"rgba(255, 255, 255, 0.3)\",\"width\":{\"path\":\"value\",\"value\":\"40\"},\"height\":{\"path\":\"value\",\"value\":\"40\"},\"padding\":{\"top\":{\"path\":\"value\"},\"left\":{\"path\":\"value\"},\"right\":{\"path\":\"value\"},\"bottom\":{\"path\":\"value\"}},\"states\":{\"hover\":{\"fill\":\"${theme.colors.0}\"}}}}},\"v\":\"1.1\",\"nodes\":[\"5-c68\",\"5-c76\",\"5-c84\",\"5-c92\",\"2901-c68\",\"2901-c76\",\"2901-c84\",\"2901-c92\"]},{\"id\":325,\"type\":\"hop-text\",\"style\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"35\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"5-c69\",\"5-c77\",\"5-c85\",\"5-c93\",\"2901-c69\",\"2901-c77\",\"2901-c85\",\"2901-c93\"]},{\"id\":326,\"type\":\"hop-column\",\"style\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}},\"transform\":{\"translate\":{\"x\":{\"value\":0,\"unit\":\"%\"},\"y\":{\"value\":\"-50\",\"unit\":\"%\"}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"vSpace\":{\"path\":\"value\",\"value\":\"0\"}}},\"v\":\"1.1\",\"nodes\":[\"5-c70\",\"5-c78\",\"5-c86\",\"5-c94\",\"2901-c70\",\"2901-c78\",\"2901-c86\",\"2901-c94\"]},{\"id\":327,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"5-c71\",\"5-c79\",\"5-c87\",\"5-c95\",\"2901-c71\",\"2901-c79\",\"2901-c87\",\"2901-c95\"]},{\"id\":328,\"type\":\"hop-text\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.4}\",\"style\":\"italic\"}}}},\"props\":{\"type\":\"normal\"},\"v\":\"1.1\",\"nodes\":[\"5-c72\",\"5-c80\",\"5-c88\",\"5-c96\",\"2901-c72\",\"2901-c80\",\"2901-c88\",\"2901-c96\"]},{\"id\":329,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"5-c97\",\"2901-c97\"]},{\"id\":330,\"type\":\"hop-column\",\"props\":{\"layout\":{\"vSpace\":{\"value\":\"5\"}}},\"v\":\"1.1\",\"nodes\":[\"5-c98\",\"2901-c98\"]},{\"id\":331,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"v\":\"1.1\",\"nodes\":[\"5-c101\",\"2901-c101\"]},{\"id\":332,\"type\":\"hop-text\",\"props\":{\"type\":\"lead\"},\"style\":{\"typography\":{\"holders\":{\"p\":{\"transform\":\"uppercase\"}}}},\"v\":\"1.1\",\"nodes\":[\"5-c99\",\"2901-c99\"]},{\"id\":334,\"type\":\"hop-divider\",\"style\":{\"descendants\":{\"line\":{\"border\":{\"bottom\":{\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\"}}},\"width\":{\"value\":\"90\",\"unit\":\"px\"}},\"icon\":{\"fill\":\"${theme.colors.0}\"}},\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}}},\"props\":{\"type\":\"line\"},\"v\":\"1.1\",\"nodes\":[\"5-c100\",\"2901-c100\"]},{\"id\":345,\"type\":\"hop-section\",\"nodeId\":\"5-c112\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/aerial-view-architecture-cars-280221-1.jpg\"}}],\"overlay\":{\"enabled\":true,\"type\":\"gradient\",\"gradient\":{\"steps\":[{\"color\":\"rgba(255, 255, 255, 0.8)\",\"position\":0},{\"color\":\"${theme.colors.4}\",\"position\":\"30\"}]}}},\"padding\":{\"top\":{\"value\":0},\"bottom\":{\"value\":42}}},\"props\":{\"showHeader\":false},\"v\":\"1.1\",\"nodes\":[\"5-c102\",\"2901-c2\"]},{\"id\":346,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalAlign\":\"start\"}},\"type\":\"hop-row\",\"nodeId\":\"5-c113\",\"v\":\"1.1\",\"nodes\":[\"5-c103\",\"2901-c3\"]},{\"id\":347,\"type\":\"hop-column\",\"nodeId\":\"5-c114\",\"v\":\"1.1\",\"nodes\":[\"5-c104\",\"2901-c4\"],\"style\":{\"background\":{\"color\":\"rgb(241, 238, 235)\"},\"padding\":{\"top\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":20}}}},{\"id\":348,\"type\":\"hop-blog-posts\",\"style\":{\"descendants\":{\"metaDataBar\":{\"typography\":{\"color\":\"${theme.colors.4|variant1}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"background\":{\"color\":\"${theme.colors.0|variant0}\"}},\"metaDataBarIconSvg\":{\"height\":{\"path\":\"value\",\"value\":\"12\"},\"width\":{\"path\":\"value\",\"value\":\"12\"}},\"readMoreButton\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.1}\"}}},\"typography\":{\"color\":\"${theme.colors.0}\"},\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\",\"value\":\"30\"},\"bottom\":{\"unit\":\"px\",\"value\":\"15\"},\"left\":{\"unit\":\"px\",\"value\":\"30\"}}},\"postCategory\":{\"typography\":{\"color\":\"rgba(9, 33, 42, 0.7)\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(227, 228, 229)\",\"radius\":{\"left\":{\"value\":\"3\",\"unit\":\"px\"},\"right\":{\"value\":\"3\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(227, 228, 229)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(227, 228, 229)\",\"radius\":{\"left\":{\"value\":\"3\",\"unit\":\"px\"},\"right\":{\"value\":\"3\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(227, 228, 229)\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"typography\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0}\"},\"bottom\":{\"color\":\"${theme.colors.0}\"},\"right\":{\"color\":\"${theme.colors.0}\"},\"left\":{\"color\":\"${theme.colors.0}\"}}}}},\"postTitle\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}}},\"postExcerpt\":{\"typography\":{\"color\":\"rgba(0, 0, 0, 0.8)\"},\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}}},\"metaDataBarIconPath\":{\"fill\":\"${theme.colors.4|variant1}\"},\"postContainer\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"color\":\"rgb(227, 228, 229)\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}},\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"right\":{\"style\":\"solid\",\"color\":\"rgb(227, 228, 229)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"solid\",\"color\":\"rgb(227, 228, 229)\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}},\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"left\":{\"style\":\"solid\",\"color\":\"rgb(227, 228, 229)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}}}},\"blogColumn\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"postImage\":{\"boxShadow\":{\"enabled\":false},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}},\"props\":{\"layout\":{\"horizontalGap\":1,\"verticalGap\":1,\"itemsPerRow\":3,\"horizontalAlign\":\"start\"},\"postOrder\":[{\"id\":\"1\",\"name\":\"image\",\"value\":\"Image\"},{\"id\":\"3\",\"name\":\"title\",\"value\":\"Title\"},{\"id\":\"4\",\"name\":\"excerpt\",\"value\":\"Excerpt\"},{\"id\":\"5\",\"name\":\"metaData\",\"value\":\"Metadata\"},{\"id\":\"2\",\"name\":\"category\",\"value\":\"Category\"},{\"id\":\"6\",\"name\":\"readButton\",\"value\":\"Read More Button\"}],\"titleType\":\"h4\",\"metaDataOrder\":[{\"name\":\"author\",\"value\":\"Author\",\"check\":true},{\"name\":\"date\",\"value\":\"Date\",\"check\":true},{\"name\":\"time\",\"value\":\"Time\",\"check\":false},{\"name\":\"comments\",\"value\":\"Comments\",\"check\":true},{\"name\":\"readButton\",\"value\":\"Read Button\",\"check\":false},{\"name\":\"spacer\",\"value\":\"Spacer\",\"check\":false}],\"metaDataSeparator\":\" - \",\"excerptLength\":\"33\",\"showMetadata\":false,\"showCategory\":false,\"showMasonry\":false,\"media\":{\"tablet\":{\"layout\":{\"itemsPerRow\":2}}}},\"v\":\"1.1\",\"nodes\":[\"5-c105\",\"2901-c5\"]},{\"id\":349,\"type\":\"hop-loop-item\",\"style\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\",\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"0\"},\"right\":{\"unit\":\"px\",\"value\":\"0\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\",\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"0\"},\"right\":{\"unit\":\"px\",\"value\":\"0\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"0\",\"color\":\"rgba(4, 4, 4, 0.05)\",\"spread\":\"0\",\"y\":\"1\",\"x\":\"1\"}]},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"5-c106\",\"2901-c6\"]},{\"id\":350,\"type\":\"hop-post-thumbnail\",\"style\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"3\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"boxShadow\":{\"enabled\":false},\"background\":{\"color\":\"rgba(255,255,255,0)\"},\"textAlign\":\"left\",\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}},\"props\":{\"attrs\":{\"overflowOption\":\"hidden\"}},\"v\":\"1.1\",\"nodes\":[\"5-c107\",\"2901-c7\"]},{\"id\":351,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":2,\"verticalInnerGap\":2,\"equalHeight\":true},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"background\":{\"color\":\"rgba(201, 239, 251, 0)\"}},\"v\":\"1.1\",\"nodes\":[\"5-c108\",\"2901-c8\"]},{\"id\":352,\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"left\"}},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":211},\"type\":\"min-height\"}},\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"v\":\"1.1\",\"nodes\":[\"5-c109\",\"2901-c9\"]},{\"id\":353,\"type\":\"hop-post-categories\",\"style\":{\"descendants\":{\"categoriesLinks\":{\"typography\":{\"color\":\"${theme.colors.4|variant1}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.1}\"}}},\"margin\":{\"right\":{\"value\":\"10\"}}}},\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"20\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"5-c110\",\"2901-c110\"]},{\"id\":354,\"type\":\"hop-post-title\",\"style\":{\"descendants\":{\"title\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.1}\"}}},\"typography\":{\"color\":\"${theme.colors.4}\"}}}},\"v\":\"1.1\",\"nodes\":[\"5-c111\",\"2901-c10\"]},{\"id\":355,\"type\":\"hop-post-excerpt\",\"style\":{\"descendants\":{\"excerpt\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}}},\"v\":\"1.1\",\"nodes\":[\"5-c112\",\"2901-c11\"]},{\"id\":356,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":1,\"verticalInnerGap\":1,\"equalHeight\":true},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.3}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.3}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.3}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.3}\"}}},\"v\":\"1.1\",\"nodes\":[\"5-c113\",\"2901-c12\"]},{\"id\":357,\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"padding\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}},\"textAlign\":\"left\",\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":0},\"horizontalInnerGap\":2,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"5-c114\",\"2901-c13\"]},{\"id\":358,\"type\":\"hop-post-meta\",\"style\":{\"descendants\":{\"icons\":{\"display\":\"none\"},\"metaDataLinks\":{\"typography\":{\"color\":\"${theme.colors.4}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.1}\"}}},\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"metaDataPrefix\":{\"typography\":{\"color\":\"${theme.colors.4|variant1}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}}},\"metaDataSuffix\":{\"typography\":{\"color\":\"${theme.colors.4|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}}}}},\"v\":\"1.1\",\"nodes\":[\"5-c115\",\"2901-c14\"]},{\"id\":359,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"right\",\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"textAlign\":\"right\"}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":0},\"horizontalInnerGap\":2,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"5-c116\",\"2901-c15\"]},{\"id\":360,\"type\":\"hop-post-read-more-group\",\"v\":\"1.1\",\"nodes\":[\"5-c117\",\"2901-c16\"]},{\"id\":361,\"type\":\"hop-post-read-more\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":\"3\",\"unit\":\"px\",\"path\":\"value\"}},\"size\":{\"value\":\"16\",\"unit\":\"px\"}}},\"background\":{\"color\":\"rgba(3, 169, 244, 0)\"},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"},\"radius\":{\"right\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"},\"left\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"}},\"color\":\"${theme.colors.0}\"},\"left\":{\"style\":\"none\",\"width\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"right\":{\"style\":\"none\",\"width\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"bottom\":{\"style\":\"none\",\"width\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"},\"radius\":{\"right\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"},\"left\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"}},\"color\":\"${theme.colors.0}\"}},\"typography\":{\"color\":\"${theme.colors.4}\",\"lineHeight\":{\"value\":\"1\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"0\"},\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"transform\":\"none\",\"family\":\"Source Sans Pro\",\"margin\":{\"bottom\":\"2rem\"},\"weight\":\"600\"},\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(2, 110, 159, 0)\"},\"typography\":{\"color\":\"${theme.colors.1}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"textAlign\":\"center\"},\"props\":{\"showIcon\":true,\"iconPosition\":\"after\"},\"v\":\"1.1\",\"nodes\":[\"5-c118\",\"2901-c17\"]},{\"id\":362,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"5-c129\",\"v\":\"1.1\",\"nodes\":[\"5-c119\",\"2901-c119\"]},{\"id\":363,\"type\":\"hop-column\",\"nodeId\":\"5-c130\",\"props\":{\"layout\":{\"vSpace\":{\"value\":\"5\"}}},\"v\":\"1.1\",\"nodes\":[\"5-c120\",\"2901-c120\"]},{\"id\":364,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"5-c131\",\"v\":\"1.1\",\"nodes\":[\"5-c123\",\"2901-c123\"]},{\"id\":365,\"type\":\"hop-text\",\"nodeId\":\"5-c132\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"transform\":\"uppercase\"}}}},\"props\":{\"type\":\"lead\"},\"v\":\"1.1\",\"nodes\":[\"5-c121\",\"2901-c121\"]},{\"id\":367,\"type\":\"hop-divider\",\"style\":{\"descendants\":{\"line\":{\"border\":{\"bottom\":{\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\"}}},\"width\":{\"value\":\"90\",\"unit\":\"px\"}},\"icon\":{\"fill\":\"${theme.colors.0}\"}},\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}}},\"props\":{\"type\":\"line\"},\"v\":\"1.1\",\"nodes\":[\"5-c122\",\"2901-c122\"]},{\"id\":368,\"type\":\"hop-map\",\"nodeId\":\"13-f48\",\"style\":{\"height\":{\"path\":\"value\",\"value\":\"250\"}},\"v\":\"1.1\",\"nodes\":[\"13-f21\"]},{\"id\":369,\"type\":\"hop-widget-area\",\"nodeId\":\"13-f49\",\"style\":{\"descendants\":{\"widgetTitle\":{\"typography\":{\"color\":\"${theme.colors.4}\",\"transform\":\"uppercase\"}},\"widgetListItemLink\":{\"typography\":{\"color\":\"${theme.colors.4|variant2}\",\"transform\":\"capitalize\",\"decoration\":\"none\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}}},\"widgetListItem\":{\"typography\":{\"transform\":\"capitalize\",\"decoration\":\"none\",\"color\":\"${theme.colors.4}\"}},\"widgetBox\":{\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"center\"}}}}},\"v\":\"1.1\",\"nodes\":[\"13-f24\"]},{\"id\":370,\"type\":\"hop-navigation-menu-widget\",\"nodeId\":\"13-f50\",\"v\":\"1.1\",\"nodes\":[\"13-f25\"]},{\"id\":371,\"type\":\"hop-heading\",\"nodeId\":\"13-f51\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\",\"transform\":\"uppercase\"}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"13-f10\"]},{\"id\":372,\"type\":\"hop-heading\",\"nodeId\":\"13-f52\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\",\"transform\":\"uppercase\"}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"13-f14\"]},{\"id\":373,\"type\":\"hop-spacer\",\"nodeId\":\"13-f53\",\"style\":{\"height\":{\"value\":\"20\"}},\"v\":\"1.1\",\"nodes\":[\"13-f13\"]},{\"id\":374,\"type\":\"hop-widget-area\",\"nodeId\":\"13-f54\",\"style\":{\"descendants\":{\"widgetListItem\":{\"typography\":{\"color\":\"${theme.colors.4}\",\"transform\":\"capitalize\",\"decoration\":\"none\"}},\"widgetListItemLink\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.4}\"}}},\"typography\":{\"color\":\"${theme.colors.4|variant2}\",\"transform\":\"capitalize\",\"decoration\":\"none\"}},\"widgetTitle\":{\"typography\":{\"color\":\"${theme.colors.4}\",\"transform\":\"uppercase\"}},\"widgetBox\":{\"textAlign\":\"left\",\"media\":{\"tablet\":{\"textAlign\":\"left\"},\"mobile\":{\"textAlign\":\"center\"}}}}},\"v\":\"1.1\",\"nodes\":[\"13-f21\"]},{\"id\":375,\"type\":\"hop-navigation-menu-widget\",\"nodeId\":\"13-f55\",\"v\":\"1.1\",\"nodes\":[\"13-f22\"]},{\"id\":376,\"type\":\"hop-text\",\"nodeId\":\"13-f56\",\"v\":\"1.1\",\"nodes\":[\"13-f7\"]},{\"id\":377,\"type\":\"hop-text\",\"nodeId\":\"13-f57\",\"v\":\"1.1\",\"nodes\":[\"13-f8\"]},{\"id\":378,\"type\":\"hop-spacer\",\"nodeId\":\"13-f58\",\"style\":{\"height\":{\"value\":\"20\"}},\"v\":\"1.1\",\"nodes\":[\"13-f6\"]},{\"id\":379,\"type\":\"hop-content\",\"nodeId\":\"151-c1\",\"v\":\"1.1\",\"nodes\":[\"151-c1\",\"2906-c1\"]},{\"id\":380,\"style\":{\"ancestor\":{\"sticky\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}}}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"spread\":\"0\",\"blur\":\"4\"}]}}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":0},\"bottom\":{\"path\":\"value\",\"value\":0}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"},\"bottom\":{\"path\":\"value\",\"value\":\"0\"}}}}},\"type\":\"hop-navigation\",\"props\":{\"overlap\":true,\"sticky\":false,\"stickyStartAt\":\"immediately\",\"width\":\"full-width\"},\"nodeId\":\"10-h2\",\"v\":\"1.1\",\"nodes\":[\"10-h2\"]},{\"id\":381,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"10-h14\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"}},\"v\":\"1.1\",\"nodes\":[\"10-h14\"]},{\"id\":382,\"type\":\"hop-horizontal-menu\",\"style\":{\"descendants\":{\"item\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"20\",\"unit\":\"px\"}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}},\"states\":{\"hover\":{\"border\":{\"top\":{\"color\":\"${theme.colors.0}\"},\"bottom\":{\"color\":\"${theme.colors.0}\"},\"left\":{\"color\":\"${theme.colors.0}\"},\"right\":{\"color\":\"${theme.colors.0}\"}}}}},\"link\":{\"typography\":{\"weight\":\"600\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"transform\":\"uppercase\",\"family\":\"Open Sans\",\"lineHeight\":{\"unit\":\"em\",\"value\":\"1.5\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"0\"},\"color\":\"${theme.colors.5}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}}},\"submenu\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"5\",\"color\":\"rgba(0, 0, 0, 0.04)\"}]}},\"submenu-item\":{\"background\":{\"color\":\"rgb(255, 255, 255)\"},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"}},\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.0}\"}}}},\"submenu-item-link\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}}},\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}},\"hover-effect-border\":{\"background\":{\"color\":\"${theme.colors.0}\"}},\"innerMenu\":{\"justifyContent\":\"center\"},\"mainMenuIcon\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"props\":{\"hoverEffect\":{\"type\":\"none\",\"activeGroup\":\"noGroup\"}},\"nodeId\":\"10-h16\",\"v\":\"1.1\",\"nodes\":[\"10-h16\"]},{\"id\":383,\"type\":\"hop-search\",\"style\":{\"descendants\":{\"button\":{\"background\":{\"color\":\"${theme.colors.5}\"},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.1}\"}}},\"width\":{\"value\":\"60\"},\"border\":{\"top\":{\"style\":\"solid\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\"},\"bottom\":{\"style\":\"solid\",\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\"}}},\"input\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"none\",\"color\":\"rgb(222, 222, 222)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"none\",\"color\":\"rgb(222, 222, 222)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"color\":\"rgb(222, 222, 222)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"color\":\"rgb(222, 222, 222)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}}},\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"color\":\"rgb(153, 153, 153)\",\"style\":\"italic\",\"weight\":\"400\",\"family\":\"Source Sans Pro\"},\"padding\":{\"top\":{\"value\":\"6\",\"unit\":\"px\"},\"right\":{\"value\":\"12\",\"unit\":\"px\"},\"bottom\":{\"value\":\"7\",\"unit\":\"px\"},\"left\":{\"value\":\"12\",\"unit\":\"px\"}}},\"icon\":{\"width\":{\"value\":\"16\"}}}},\"nodeId\":\"10-h13\",\"v\":\"1.1\",\"nodes\":[\"10-h13\"]},{\"id\":384,\"type\":\"hop-button\",\"nodeId\":\"10-h11\",\"style\":{\"border\":{\"top\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"},\"left\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"path\":\"value\",\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"bottom\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"},\"left\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"path\":\"value\",\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"left\":{\"style\":\"none\",\"width\":{\"path\":\"value\",\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"right\":{\"style\":\"none\",\"width\":{\"path\":\"value\",\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"}},\"background\":{\"color\":\"${theme.colors.4}\"},\"states\":{\"hover\":{\"border\":{\"top\":{\"color\":\"${theme.colors.0}\"},\"left\":{\"color\":\"${theme.colors.0}\"},\"right\":{\"color\":\"${theme.colors.0}\"},\"bottom\":{\"color\":\"${theme.colors.0}\"}},\"background\":{\"color\":\"${theme.colors.1}\"}}},\"typography\":{\"color\":\"${theme.colors.5}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"family\":\"Source Sans Pro\",\"margin\":{\"bottom\":\"2rem\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.0}\",\"size\":{\"value\":\"30\",\"unit\":\"px\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"22\",\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"value\":\"22\",\"unit\":\"px\"}},\"textAlign\":\"center\"},\"props\":{\"showIcon\":true},\"v\":\"1.1\",\"nodes\":[\"10-h11\"]},{\"id\":385,\"type\":\"hop-content\",\"nodeId\":\"951-c1\",\"v\":\"1.1\",\"nodes\":[\"951-c1\",\"2923-c1\"]},{\"id\":386,\"type\":\"hop-section\",\"nodeId\":\"951-c2\",\"style\":{\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}},\"background\":{\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"steps\":[{\"color\":\"${theme.colors.4}\",\"position\":\"50\"},{\"color\":\"rgb(6, 4, 5)\",\"position\":\"50\"}],\"angle\":\"90\"}}}]}},\"props\":{\"width\":\"boxed\"},\"v\":\"1.1\",\"nodes\":[\"951-c2\",\"2923-c2\"]},{\"id\":387,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"951-c3\",\"v\":\"1.1\",\"nodes\":[\"951-c3\",\"2923-c3\"]},{\"id\":388,\"type\":\"hop-column\",\"nodeId\":\"951-c4\",\"style\":{\"textAlign\":\"left\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"10\"},\"horizontalInnerGap\":3,\"verticalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}}},\"v\":\"1.1\",\"nodes\":[\"951-c4\",\"2923-c4\"]},{\"id\":389,\"type\":\"hop-column\",\"nodeId\":\"951-c5\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/business-1042706_1280-1.jpg\"},\"position\":\"top center\"}]},\"media\":{\"mobile\":{\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":\"400\"},\"type\":\"min-height\"}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"951-c10\",\"2923-c10\"]},{\"id\":391,\"type\":\"hop-contact-form\",\"style\":{\"descendants\":{\"submit-button\":{\"backgroundColor\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"backgroundColor\":\"${theme.colors.1}\",\"background\":{\"color\":\"${theme.colors.1}\"}}},\"background\":{\"color\":\"${theme.colors.0}\"},\"color\":\"${theme.colors.4}\",\"padding\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}},\"margin-left\":\"0\",\"margin-right\":\"auto\",\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"color\":\"${theme.colors.4}\",\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}},\"inputs\":{\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"color\":\"rgba(34, 41, 51, 0.2)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgba(34, 41, 51, 0.2)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"color\":\"rgba(34, 41, 51, 0.2)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgba(34, 41, 51, 0.2)\"}},\"color\":\"rgb(102, 102, 102)\",\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"0\"}}},\"labels\":{\"textAlign\":\"left\",\"typography\":{\"lineHeight\":{\"unit\":\"em\",\"value\":\"2\"}}},\"notices\":{\"typography\":{\"weight\":\"400\",\"family\":\"Open Sans\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"3\",\"unit\":\"px\"},\"right\":{\"value\":\"3\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"3\",\"unit\":\"px\"},\"right\":{\"value\":\"3\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}},\"error-notice\":{\"background\":{\"color\":\"rgb(255, 0, 0)\"},\"color\":\"rgb(255, 255, 255)\",\"border\":{\"top\":{\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"style\":\"none\",\"color\":\"black\"},\"bottom\":{\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"style\":\"none\",\"color\":\"black\"},\"left\":{\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"style\":\"none\",\"color\":\"black\"},\"right\":{\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"style\":\"none\",\"color\":\"black\"}}},\"info-notice\":{\"background\":{\"color\":\"rgba(255, 233, 76, 0.52)\"},\"border\":{\"top\":{\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"style\":\"none\",\"color\":\"black\"},\"bottom\":{\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"style\":\"none\",\"color\":\"black\"},\"left\":{\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"style\":\"none\",\"color\":\"black\"},\"right\":{\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"style\":\"none\",\"color\":\"black\"}}},\"success-notice\":{\"background\":{\"color\":\"rgb(177, 250, 159)\"},\"border\":{\"top\":{\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"style\":\"none\",\"color\":\"black\"},\"bottom\":{\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"style\":\"none\",\"color\":\"black\"},\"left\":{\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"style\":\"none\",\"color\":\"black\"},\"right\":{\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"style\":\"none\",\"color\":\"black\"}}}}},\"props\":{\"shortcode\":\"[contact-form-7 id=\\\"692\\\" title=\\\"Contact form 1\\\"]\",\"buttonAlign\":\"right\"},\"v\":\"1.1\",\"nodes\":[\"951-c9\",\"2923-c9\"]},{\"id\":392,\"type\":\"hop-heading\",\"nodeId\":\"951-c7\",\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"951-c5\",\"2923-c5\"]},{\"id\":393,\"type\":\"hop-heading\",\"nodeId\":\"951-c8\",\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"951-c6\",\"2923-c6\"]},{\"id\":394,\"type\":\"hop-text\",\"nodeId\":\"951-c9\",\"v\":\"1.1\",\"nodes\":[\"951-c7\",\"2923-c7\"]},{\"id\":395,\"type\":\"hop-spacer\",\"nodeId\":\"951-c10\",\"style\":{\"height\":{\"value\":\"20\"}},\"v\":\"1.1\",\"nodes\":[\"951-c8\",\"2923-c8\"]},{\"id\":396,\"type\":\"hop-section\",\"nodeId\":\"951-c11\",\"style\":{\"background\":{\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"angle\":\"120\",\"steps\":[{\"color\":\"rgba(253, 251, 251, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(235, 237, 238, 0.8)\",\"position\":\"100\"}]}}}]}},\"v\":\"1.1\",\"nodes\":[\"951-c11\",\"2923-c11\"]},{\"id\":397,\"props\":{\"layout\":{\"equalWidth\":false},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"951-c12\",\"v\":\"1.1\",\"nodes\":[\"951-c12\",\"2923-c12\"]},{\"id\":398,\"type\":\"hop-column\",\"nodeId\":\"951-c13\",\"style\":{\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}}},\"props\":{\"verticalAlign\":\"end\"},\"v\":\"1.1\",\"nodes\":[\"951-c19\",\"2923-c19\"]},{\"id\":399,\"type\":\"hop-column\",\"nodeId\":\"951-c14\",\"style\":{\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"}},\"textAlign\":\"left\"},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"0\"}},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"951-c13\",\"2923-c13\"]},{\"id\":400,\"type\":\"hop-widget-area\",\"nodeId\":\"951-c15\",\"style\":{\"descendants\":{\"widgetTitle\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"24\"}}},\"widgetListItem\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"16\"}}},\"widgetListItemLink\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"color\":\"${theme.colors.0}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.1}\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"951-c20\",\"2923-c20\"]},{\"id\":401,\"type\":\"hop-calendar-widget\",\"nodeId\":\"951-c16\",\"style\":{\"descendants\":{\"widget-title\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"v\":\"1.1\",\"nodes\":[\"951-c21\",\"2923-c21\"]},{\"id\":402,\"type\":\"hop-heading\",\"nodeId\":\"951-c17\",\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"951-c17\",\"2923-c17\"]},{\"id\":404,\"type\":\"hop-icon-list\",\"style\":{\"descendants\":{\"li\":{\"padding\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}}},\"divider\":{\"border\":{\"left\":{\"width\":{\"value\":0,\"unit\":\"px\"}},\"bottom\":{\"width\":{\"value\":1,\"unit\":\"px\"}}},\"width\":{\"value\":100,\"unit\":\"%\"}},\"containerDivider\":{\"height\":{\"value\":1,\"unit\":\"px\"},\"width\":{\"value\":100,\"unit\":\"%\"},\"padding\":{\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"top\":{\"value\":\"2\",\"unit\":\"px\",\"path\":\"value\"},\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"bottom\":{\"value\":\"2\",\"unit\":\"px\",\"path\":\"value\"}}},\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"16\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.1}\"}},\"height\":{\"path\":\"value\",\"value\":\"16\"},\"padding\":{\"left\":{\"path\":\"value\",\"value\":0}}},\"text\":{\"margin\":{\"left\":{\"path\":\"value\",\"value\":\"10\"}},\"color\":\"${theme.colors.5}\",\"typography\":{\"transform\":\"capitalize\"}},\"list-item\":{\"horizontalAlign\":\"start\"}}},\"props\":{\"iconList\":[{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #1\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.15907223444395013},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #2\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.34341111083051734},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #3\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.0941660601972718},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #4\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.5295691579821964}],\"iconAndTextAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"951-c18\",\"2923-c18\"]},{\"id\":406,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"fill\":\"${theme.colors.4|variant1}\",\"states\":{\"hover\":{\"background\":{\"color\":\"rgb(250, 249, 249)\"},\"fill\":\"${theme.colors.0|mediumLowLuminosity}\"}},\"border\":{\"top\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"right\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"bottom\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"left\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"}},\"background\":{\"color\":\"rgb(250, 249, 249)\"}}},\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"-55\",\"unit\":\"px\"},\"left\":{\"value\":\"-32\",\"unit\":\"px\"}},\"zIndex\":\"2\",\"media\":{\"mobile\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"-55\",\"unit\":\"px\"},\"left\":{\"value\":\"-15\",\"unit\":\"px\"}}}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"951-c14\",\"2923-c14\"]},{\"id\":407,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"951-c20\",\"v\":\"1.1\",\"nodes\":[\"951-c15\",\"2923-c15\"]},{\"id\":408,\"type\":\"hop-column\",\"nodeId\":\"951-c21\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"}},\"textAlign\":\"left\",\"padding\":{\"top\":{\"value\":\"2\",\"unit\":\"rem\"},\"right\":{\"value\":\"2\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"2\",\"unit\":\"rem\"},\"left\":{\"value\":\"2\",\"unit\":\"rem\"}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"5\"}}},\"v\":\"1.1\",\"nodes\":[\"951-c16\",\"2923-c16\"]},{\"id\":410,\"type\":\"hop-content\",\"nodeId\":\"171-c1\",\"v\":\"1.1\",\"nodes\":[\"171-c1\",\"2919-c1\"]},{\"id\":412,\"type\":\"hop-horizontal-menu\",\"style\":{\"descendants\":{\"item\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"20\",\"unit\":\"px\"}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}},\"states\":{\"hover\":{\"border\":{\"top\":{\"color\":\"${theme.colors.0}\"},\"bottom\":{\"color\":\"${theme.colors.0}\"},\"left\":{\"color\":\"${theme.colors.0}\"},\"right\":{\"color\":\"${theme.colors.0}\"}}}}},\"link\":{\"typography\":{\"weight\":\"600\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"transform\":\"uppercase\",\"family\":\"Open Sans\",\"lineHeight\":{\"unit\":\"em\",\"value\":\"1.5\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"0\"},\"color\":\"${theme.colors.4}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"submenu\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"5\",\"color\":\"rgba(0, 0, 0, 0.04)\"}]}},\"submenu-item\":{\"background\":{\"color\":\"rgb(255, 255, 255)\"},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"}},\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.0}\"}}}},\"submenu-item-link\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}},\"menuButtonActive\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}}},\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"rgb(255, 255, 255)\"}},\"hover-effect-border\":{\"background\":{\"color\":\"${theme.colors.0}\"}},\"innerMenu\":{\"justifyContent\":\"center\"}}},\"props\":{\"hoverEffect\":{\"type\":\"none\",\"activeGroup\":\"noGroup\"},\"showOffscreenMenuOn\":\"has-offcanvas-none\"},\"v\":\"1.1\",\"nodes\":[\"10-h28\"]},{\"id\":413,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"10-h30\",\"v\":\"1.1\",\"nodes\":[\"10-h26\"]},{\"id\":414,\"type\":\"hop-column\",\"nodeId\":\"10-h31\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"background\":{\"color\":\"${theme.colors.3}\"}},\"props\":{\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"10-h27\"]},{\"id\":415,\"type\":\"hop-mobile-menu\",\"nodeId\":\"10-h33\",\"v\":\"1.1\",\"nodes\":[\"10-h29\"]},{\"id\":416,\"type\":\"hop-offscreen-panel\",\"nodeId\":\"10-h34\",\"v\":\"1.1\",\"nodes\":[\"10-h30\"]},{\"id\":417,\"style\":{\"descendants\":{\"link\":{\"typography\":{\"color\":\"${theme.colors.4}\",\"transform\":\"capitalize\"}},\"submenu-item-link\":{\"typography\":{\"color\":\"white\"}},\"iconOption\":{\"typography\":{\"color\":\"white\"}},\"subMenuIcon\":{\"typography\":{\"color\":\"white\"}},\"item\":{\"border\":{\"bottom\":{\"color\":\"rgba(236, 82, 55, 0.3)\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"}},\"menuButtonActive\":{\"background\":{\"color\":\"${theme.colors.0}\"}}}}}},\"props\":{\"layout\":\"accordion\"},\"type\":\"hop-accordion-menu\",\"nodeId\":\"10-h35\",\"v\":\"1.1\",\"nodes\":[\"10-h31\"]},{\"id\":418,\"type\":\"hop-row\",\"nodeId\":\"10-h36\",\"v\":\"1.1\",\"nodes\":[\"10-h32\"],\"props\":{\"layout\":{\"equalWidth\":false}}},{\"id\":419,\"type\":\"hop-column\",\"nodeId\":\"10-h37\",\"v\":\"1.1\",\"nodes\":[\"10-h33\"]},{\"id\":420,\"type\":\"hop-logo\",\"nodeId\":\"10-h38\",\"v\":\"1.1\",\"nodes\":[\"10-h34\"]},{\"id\":421,\"type\":\"hop-row\",\"nodeId\":\"10-h39\",\"v\":\"1.1\",\"nodes\":[\"10-h35\"],\"props\":{\"layout\":{\"equalWidth\":false}}},{\"id\":422,\"type\":\"hop-column\",\"nodeId\":\"10-h40\",\"v\":\"1.1\",\"nodes\":[\"10-h36\"]},{\"id\":424,\"type\":\"hop-section\",\"nodeId\":\"171-c2\",\"style\":{\"background\":{\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"angle\":\"120\",\"steps\":[{\"color\":\"rgba(253, 251, 251, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(235, 237, 238, 0.8)\",\"position\":\"100\"}]}}}]}},\"v\":\"1.1\",\"nodes\":[\"171-c2\",\"2919-c2\"]},{\"id\":425,\"props\":{\"layout\":{\"equalWidth\":true},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"171-c3\",\"v\":\"1.1\",\"nodes\":[\"171-c3\",\"2919-c3\"]},{\"id\":426,\"type\":\"hop-column\",\"nodeId\":\"171-c4\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"gradient\"}}],\"color\":\"${theme.colors.4}\"},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"y\":\"1\",\"x\":\"1\",\"blur\":\"0\",\"spread\":\"0\",\"color\":\"rgba(0, 0, 0, 0.05)\"}]},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}}},\"v\":\"1.1\",\"nodes\":[\"171-c4\",\"171-c15\",\"171-c26\",\"171-c37\",\"171-c48\",\"171-c59\",\"2919-c4\",\"2919-c15\",\"2919-c26\",\"2919-c37\",\"2919-c48\",\"2919-c59\"]},{\"id\":428,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"171-c6\",\"v\":\"1.1\",\"nodes\":[\"171-c5\",\"171-c16\",\"171-c27\",\"171-c38\",\"171-c49\",\"171-c60\",\"2919-c5\",\"2919-c16\",\"2919-c27\",\"2919-c38\",\"2919-c49\",\"2919-c60\"]},{\"id\":429,\"type\":\"hop-column\",\"nodeId\":\"171-c7\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"171-c6\",\"171-c17\",\"171-c28\",\"171-c39\",\"171-c50\",\"171-c61\",\"2919-c6\",\"2919-c17\",\"2919-c28\",\"2919-c39\",\"2919-c50\",\"2919-c61\"]},{\"id\":430,\"type\":\"hop-column\",\"nodeId\":\"171-c8\",\"style\":{\"textAlign\":\"left\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"textAlign\":\"center\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":0,\"vSpace\":{\"value\":\"5\"}},\"verticalAlign\":\"center\",\"media\":{\"mobile\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3}}}},\"v\":\"1.1\",\"nodes\":[\"171-c11\",\"171-c22\",\"171-c33\",\"171-c44\",\"171-c55\",\"171-c66\",\"2919-c11\",\"2919-c22\",\"2919-c33\",\"2919-c44\",\"2919-c55\",\"2919-c66\"]},{\"id\":432,\"type\":\"hop-heading\",\"nodeId\":\"171-c10\",\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"171-c12\",\"171-c23\",\"171-c34\",\"171-c45\",\"171-c56\",\"171-c67\",\"2919-c12\",\"2919-c23\",\"2919-c34\",\"2919-c45\",\"2919-c56\",\"2919-c67\"]},{\"id\":433,\"type\":\"hop-heading\",\"nodeId\":\"171-c11\",\"props\":{\"headerType\":\"6\"},\"v\":\"1.1\",\"nodes\":[\"171-c13\",\"171-c24\",\"171-c35\",\"171-c46\",\"171-c57\",\"171-c68\",\"2919-c13\",\"2919-c24\",\"2919-c35\",\"2919-c46\",\"2919-c57\",\"2919-c68\"]},{\"id\":435,\"type\":\"hop-icon-list\",\"style\":{\"descendants\":{\"li\":{\"padding\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}}},\"divider\":{\"border\":{\"left\":{\"width\":{\"value\":0,\"unit\":\"px\"}},\"bottom\":{\"width\":{\"value\":1,\"unit\":\"px\"}}},\"width\":{\"value\":100,\"unit\":\"%\"}},\"containerDivider\":{\"height\":{\"value\":1,\"unit\":\"px\"},\"width\":{\"value\":100,\"unit\":\"%\"},\"padding\":{\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"top\":{\"value\":\"2\",\"unit\":\"px\",\"path\":\"value\"},\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"bottom\":{\"value\":\"2\",\"unit\":\"px\",\"path\":\"value\"}}},\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"20\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.1}\"}},\"height\":{\"path\":\"value\",\"value\":\"20\"},\"padding\":{\"left\":{\"path\":\"value\",\"value\":0}}},\"text\":{\"margin\":{\"left\":{\"path\":\"value\",\"value\":\"10\"}},\"color\":\"${theme.colors.5}\"},\"list-item\":{\"horizontalAlign\":\"start\",\"media\":{\"mobile\":{\"horizontalAlign\":\"center\"}}}}},\"props\":{\"iconList\":[{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #1\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.15907223444395013},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #2\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.34341111083051734},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #3\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.0941660601972718},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #4\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.5295691579821964}],\"iconAndTextAlign\":\"start\"},\"v\":\"1.1\",\"nodes\":[\"171-c14\",\"171-c25\",\"171-c36\",\"171-c47\",\"171-c58\",\"171-c69\",\"2919-c14\",\"2919-c25\",\"2919-c36\",\"2919-c47\",\"2919-c58\",\"2919-c69\"]},{\"id\":436,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/model-2911329_640.jpg\"},\"position\":\"center center\"}]},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.7)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}},\"attrs\":{\"overflowOption\":\"hidden\"}},\"v\":\"1.1\",\"nodes\":[\"171-c7\",\"2919-c7\"]},{\"id\":437,\"style\":{\"textAlign\":\"center\",\"minHeight\":{\"value\":\"150\"},\"media\":{\"tablet\":{\"minHeight\":{\"value\":\"80\"}},\"mobile\":{\"minHeight\":{\"value\":\"300\"}}}},\"type\":\"hop-content-swap-default\",\"props\":{\"horizontalGap\":3},\"v\":\"1.1\",\"nodes\":[\"171-c8\",\"171-c19\",\"171-c30\",\"171-c41\",\"171-c52\",\"171-c63\",\"2919-c8\",\"2919-c19\",\"2919-c30\",\"2919-c41\",\"2919-c52\",\"2919-c63\"]},{\"id\":440,\"style\":{\"textAlign\":\"center\",\"height\":{\"value\":100},\"top\":{\"value\":0,\"unit\":\"%\"},\"left\":{\"value\":0,\"unit\":\"%\"},\"width\":{\"value\":100}},\"type\":\"hop-content-swap-hover\",\"props\":{\"verticalAlign\":\"center\",\"position\":\"topRight\"},\"v\":\"1.1\",\"nodes\":[\"171-c9\",\"171-c20\",\"171-c31\",\"171-c42\",\"171-c53\",\"171-c64\",\"2919-c9\",\"2919-c20\",\"2919-c31\",\"2919-c42\",\"2919-c53\",\"2919-c64\"]},{\"id\":444,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"fill\":\"${theme.colors.4}\",\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(45, 45, 134, 0)\"},\"fill\":\"${theme.colors.0|mediumLowLuminosity}\"}},\"border\":{\"top\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"right\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"bottom\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"left\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"}},\"width\":{\"path\":\"value\",\"value\":\"40\"},\"height\":{\"path\":\"value\",\"value\":\"40\"}}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"171-c10\",\"171-c21\",\"171-c32\",\"171-c43\",\"171-c54\",\"171-c65\",\"2919-c10\",\"2919-c21\",\"2919-c32\",\"2919-c43\",\"2919-c54\",\"2919-c65\"]},{\"id\":445,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/man-537136_640.jpg\"},\"position\":\"center center\"}]},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.7)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}},\"attrs\":{\"overflowOption\":\"hidden\"}},\"nodeId\":\"171-c108\",\"v\":\"1.1\",\"nodes\":[\"171-c18\",\"2919-c18\"]},{\"id\":446,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/business-woman-2071342_1920.jpg\"},\"position\":\"center center\"}]},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.7)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}},\"attrs\":{\"overflowOption\":\"hidden\"}},\"nodeId\":\"171-c97\",\"v\":\"1.1\",\"nodes\":[\"171-c29\",\"2919-c29\"]},{\"id\":447,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/man-1209494_1280.jpg\"},\"position\":\"center center\"}]},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.7)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}},\"attrs\":{\"overflowOption\":\"hidden\"}},\"nodeId\":\"171-c86\",\"v\":\"1.1\",\"nodes\":[\"171-c40\",\"2919-c40\"]},{\"id\":448,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/businessman-805769_640.jpg\"},\"position\":\"center center\"}]},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.7)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}},\"attrs\":{\"overflowOption\":\"hidden\"}},\"nodeId\":\"171-c75\",\"v\":\"1.1\",\"nodes\":[\"171-c51\",\"2919-c51\"]},{\"id\":449,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/business-man-1125324_640.jpg\"},\"position\":\"center center\"}]},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.7)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}},\"attrs\":{\"overflowOption\":\"hidden\"}},\"nodeId\":\"171-c64\",\"v\":\"1.1\",\"nodes\":[\"171-c62\",\"2919-c62\"]},{\"id\":450,\"type\":\"hop-content\",\"nodeId\":\"170-c1\",\"v\":\"1.1\",\"nodes\":[\"170-c1\",\"2911-c1\"]},{\"id\":451,\"type\":\"hop-section\",\"nodeId\":\"170-c2\",\"style\":{\"background\":{\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"angle\":\"120\",\"steps\":[{\"color\":\"rgba(253, 251, 251, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(235, 237, 238, 0.8)\",\"position\":\"100\"}]}}}]}},\"v\":\"1.1\",\"nodes\":[\"170-c2\",\"2911-c2\"]},{\"id\":452,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"170-c3\",\"v\":\"1.1\",\"nodes\":[\"170-c3\",\"2911-c3\"]},{\"id\":453,\"type\":\"hop-column\",\"nodeId\":\"170-c4\",\"v\":\"1.1\",\"nodes\":[\"170-c4\",\"2911-c4\"]},{\"id\":454,\"type\":\"hop-photo-gallery\",\"nodeId\":\"170-c5\",\"style\":{\"descendants\":{\"images\":{\"padding\":{\"left\":{\"value\":\"5\"},\"top\":{\"value\":\"5\"},\"bottom\":{\"value\":\"5\"},\"right\":{\"value\":\"5\"}},\"boxShadow\":{\"enabled\":false}},\"captions\":{\"typography\":{\"family\":\"Source Sans Pro\",\"color\":\"${theme.colors.5}\"},\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"value\":\"5\",\"unit\":\"px\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"showMasonry\":true,\"clickBehaviour\":\"lightbox\",\"numberOfColumns\":{\"value\":\"3\"},\"caption\":true,\"media\":{\"mobile\":{\"numberOfColumns\":{\"value\":\"1\"}}}},\"v\":\"1.1\",\"nodes\":[\"170-c5\",\"2911-c5\"]},{\"id\":455,\"type\":\"hop-content\",\"nodeId\":\"172-c1\",\"v\":\"1.1\",\"nodes\":[\"172-c1\",\"2920-c1\"]},{\"id\":456,\"type\":\"hop-section\",\"nodeId\":\"172-c2\",\"style\":{\"background\":{\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"angle\":\"120\",\"steps\":[{\"color\":\"rgba(253, 251, 251, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(235, 237, 238, 0.8)\",\"position\":\"100\"}]}}}]}},\"v\":\"1.1\",\"nodes\":[\"172-c2\",\"2920-c2\"]},{\"id\":457,\"props\":{\"layout\":{\"equalWidth\":false},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"172-c3\",\"v\":\"1.1\",\"nodes\":[\"172-c3\",\"172-c18\",\"172-c33\",\"172-c48\",\"2920-c3\",\"2920-c18\",\"2920-c33\",\"2920-c48\"]},{\"id\":458,\"type\":\"hop-column\",\"nodeId\":\"172-c4\",\"style\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"spread\":\"0\",\"blur\":\"0\",\"x\":\"1\",\"y\":\"1\",\"color\":\"rgba(0, 0, 0, 0.05)\"}]},\"background\":{\"color\":\"${theme.colors.4}\"},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}},\"props\":{\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}}},\"v\":\"1.1\",\"nodes\":[\"172-c4\",\"172-c19\",\"172-c34\",\"172-c49\",\"2920-c4\",\"2920-c19\",\"2920-c34\",\"2920-c49\"]},{\"id\":460,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalGap\":0,\"verticalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":0,\"verticalGap\":0}}}},\"type\":\"hop-row\",\"nodeId\":\"172-c6\",\"v\":\"1.1\",\"nodes\":[\"172-c5\",\"172-c20\",\"172-c35\",\"172-c50\",\"2920-c5\",\"2920-c20\",\"2920-c35\",\"2920-c50\"]},{\"id\":461,\"type\":\"hop-column\",\"nodeId\":\"172-c7\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/race-4186517_640.jpg\"}}]},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":\"150\"},\"type\":\"min-height\"},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"media\":{\"mobile\":{\"customHeight\":{\"min-height\":{\"value\":\"250\"}}}}},\"v\":\"1.1\",\"nodes\":[\"172-c21\",\"2920-c21\"]},{\"id\":462,\"type\":\"hop-column\",\"nodeId\":\"172-c8\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"textAlign\":\"left\",\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"textAlign\":\"center\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":0,\"horizontalInnerGap\":2,\"vSpace\":{\"value\":\"5\"}},\"verticalAlign\":\"center\",\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"vSpace\":{\"value\":\"5\"},\"verticalInnerGap\":2}}}},\"v\":\"1.1\",\"nodes\":[\"172-c7\",\"172-c22\",\"172-c37\",\"172-c52\",\"2920-c7\",\"2920-c22\",\"2920-c37\",\"2920-c52\"]},{\"id\":463,\"type\":\"hop-column\",\"nodeId\":\"172-c9\",\"style\":{\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}},\"props\":{\"verticalAlign\":\"center\",\"media\":{\"mobile\":{\"layout\":{\"verticalInnerGap\":2}}}},\"v\":\"1.1\",\"nodes\":[\"172-c15\",\"172-c30\",\"172-c45\",\"172-c60\",\"2920-c15\",\"2920-c30\",\"2920-c45\",\"2920-c60\"]},{\"id\":464,\"type\":\"hop-button-group\",\"nodeId\":\"172-c10\",\"v\":\"1.1\",\"nodes\":[\"172-c16\",\"172-c31\",\"172-c46\",\"172-c61\",\"2920-c16\",\"2920-c31\",\"2920-c46\",\"2920-c61\"]},{\"id\":465,\"type\":\"hop-button\",\"nodeId\":\"172-c11\",\"style\":{\"border\":{\"top\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"},\"left\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"}},\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"right\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"},\"left\":{\"path\":\"value\",\"value\":0,\"unit\":\"px\"}},\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"right\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(236, 203, 55, 0)\"},\"border\":{\"top\":{\"color\":\"${theme.colors.1}\"},\"left\":{\"color\":\"${theme.colors.1}\"},\"right\":{\"color\":\"${theme.colors.1}\"},\"bottom\":{\"color\":\"${theme.colors.1}\"}}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\"},\"typography\":{\"color\":\"${theme.colors.5}\",\"family\":\"Open Sans\",\"margin\":{\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"textAlign\":\"center\",\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"12\"},\"bottom\":{\"unit\":\"px\",\"value\":\"12\"},\"left\":{\"unit\":\"px\",\"value\":\"24\"},\"right\":{\"unit\":\"px\",\"value\":\"24\"}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"172-c17\",\"172-c32\",\"172-c47\",\"172-c62\",\"2920-c17\",\"2920-c32\",\"2920-c47\",\"2920-c62\"]},{\"id\":466,\"type\":\"hop-heading\",\"nodeId\":\"172-c12\",\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"172-c8\",\"172-c23\",\"172-c38\",\"172-c53\",\"2920-c8\",\"2920-c23\",\"2920-c38\",\"2920-c53\"]},{\"id\":468,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalAlign\":\"start\",\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalGap\":0,\"verticalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":1,\"verticalGap\":1,\"horizontalAlign\":\"center\"}}}},\"type\":\"hop-row\",\"nodeId\":\"172-c14\",\"v\":\"1.1\",\"nodes\":[\"172-c9\",\"172-c24\",\"172-c39\",\"172-c54\",\"2920-c9\",\"2920-c24\",\"2920-c39\",\"2920-c54\"]},{\"id\":469,\"type\":\"hop-column\",\"nodeId\":\"172-c15\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}}},\"props\":{\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"172-c10\",\"172-c25\",\"172-c40\",\"172-c55\",\"2920-c10\",\"2920-c25\",\"2920-c40\",\"2920-c55\"]},{\"id\":470,\"type\":\"hop-column\",\"nodeId\":\"172-c16\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}}}},\"textAlign\":\"left\",\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"textAlign\":\"center\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":0,\"horizontalInnerGap\":2},\"verticalAlign\":\"center\",\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2}}}},\"v\":\"1.1\",\"nodes\":[\"172-c12\",\"172-c27\",\"172-c42\",\"172-c57\",\"2920-c12\",\"2920-c27\",\"2920-c42\",\"2920-c57\"]},{\"id\":471,\"type\":\"hop-heading\",\"nodeId\":\"172-c17\",\"style\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}},\"typography\":{\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"172-c11\",\"172-c26\",\"172-c41\",\"172-c56\",\"2920-c11\",\"2920-c26\",\"2920-c41\",\"2920-c56\"]},{\"id\":474,\"type\":\"hop-icon-list\",\"style\":{\"descendants\":{\"li\":{\"padding\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}}},\"divider\":{\"border\":{\"left\":{\"width\":{\"value\":0,\"unit\":\"px\"}},\"bottom\":{\"width\":{\"value\":1,\"unit\":\"px\"}}},\"width\":{\"value\":100,\"unit\":\"%\"}},\"containerDivider\":{\"height\":{\"value\":1,\"unit\":\"px\"},\"width\":{\"value\":100,\"unit\":\"%\"},\"padding\":{\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"top\":{\"value\":\"2\",\"unit\":\"px\",\"path\":\"value\"},\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"bottom\":{\"value\":\"2\",\"unit\":\"px\",\"path\":\"value\"}}},\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"20\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.2}\"}},\"height\":{\"path\":\"value\",\"value\":\"20\"},\"padding\":{\"left\":{\"path\":\"value\",\"value\":\"10\"}}},\"text\":{\"margin\":{\"left\":{\"path\":\"value\",\"value\":\"10\"}},\"color\":\"${theme.colors.5}\"},\"list-item\":{\"horizontalAlign\":\"start\",\"media\":{\"mobile\":{\"horizontalAlign\":\"center\"}}}}},\"props\":{\"iconList\":[{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #1\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.15907223444395013},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #2\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.34341111083051734},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #3\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.0941660601972718},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #4\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.5295691579821964}],\"iconAndTextAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"172-c14\",\"172-c29\",\"172-c44\",\"172-c59\",\"2920-c14\",\"2920-c29\",\"2920-c44\",\"2920-c59\"]},{\"id\":475,\"type\":\"hop-text\",\"nodeId\":\"172-c20\",\"v\":\"1.1\",\"nodes\":[\"172-c13\",\"172-c28\",\"172-c43\",\"172-c58\",\"2920-c13\",\"2920-c28\",\"2920-c43\",\"2920-c58\"]},{\"id\":476,\"type\":\"hop-column\",\"nodeId\":\"172-c7\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/bookcase-books-bookshelves-256541-1.jpg\"}}]},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":\"150\"},\"type\":\"min-height\"},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"media\":{\"mobile\":{\"customHeight\":{\"min-height\":{\"value\":\"250\"}}}}},\"v\":\"1.1\",\"nodes\":[\"172-c6\",\"2920-c6\"]},{\"id\":477,\"type\":\"hop-column\",\"nodeId\":\"172-c39\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/dog-644111_640-1.jpg\"}}]},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":\"150\"},\"type\":\"min-height\"},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"media\":{\"mobile\":{\"customHeight\":{\"min-height\":{\"value\":\"250\"}}}}},\"v\":\"1.1\",\"nodes\":[\"172-c36\",\"2920-c36\"]},{\"id\":478,\"type\":\"hop-column\",\"nodeId\":\"172-c24\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/hands-holding-plate-2110438_640.jpg\"}}]},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":\"150\"},\"type\":\"min-height\"},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"media\":{\"mobile\":{\"customHeight\":{\"min-height\":{\"value\":\"250\"}}}}},\"v\":\"1.1\",\"nodes\":[\"172-c51\",\"2920-c51\"]},{\"id\":479,\"type\":\"hop-content\",\"nodeId\":\"173-c1\",\"v\":\"1.1\",\"nodes\":[\"173-c1\",\"2921-c1\"]},{\"id\":485,\"type\":\"hop-icon-list\",\"style\":{\"descendants\":{\"li\":{\"padding\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}}},\"divider\":{\"border\":{\"left\":{\"width\":{\"value\":0,\"unit\":\"px\"}},\"bottom\":{\"width\":{\"value\":1,\"unit\":\"px\"}}},\"width\":{\"value\":100,\"unit\":\"%\"}},\"containerDivider\":{\"height\":{\"value\":1,\"unit\":\"px\"},\"width\":{\"value\":100,\"unit\":\"%\"},\"padding\":{\"left\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"top\":{\"value\":\"5\",\"unit\":\"px\",\"path\":\"value\"},\"right\":{\"value\":0,\"unit\":\"px\",\"path\":\"value\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\",\"path\":\"value\"}}},\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"20\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.1}\"}},\"height\":{\"path\":\"value\",\"value\":\"20\"},\"padding\":{\"left\":{\"path\":\"value\",\"value\":\"10\"}}},\"text\":{\"margin\":{\"left\":{\"path\":\"value\",\"value\":\"10\"}},\"color\":\"${theme.colors.4|variant2}\",\"typography\":{\"decoration\":\"underline\",\"size\":{\"unit\":\"px\",\"value\":\"18\"}}},\"list-item\":{\"horizontalAlign\":\"start\"},\"links\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}}}}},\"props\":{\"iconList\":[{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #1\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.15907223444395013},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #2\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.34341111083051734},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #3\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.0941660601972718},{\"title\":\"List\",\"link\":{\"newWindow\":false,\"noFollow\":false},\"text\":\"List item #4\",\"allIcons\":false,\"icon\":\"font-awesome\\/check\",\"type\":\"svg\",\"id\":0.5295691579821964}],\"iconAndTextAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"173-c5\",\"2921-c5\"]},{\"id\":488,\"type\":\"hop-content\",\"nodeId\":\"174-c1\",\"v\":\"1.1\",\"nodes\":[\"174-c1\",\"2922-c1\"]},{\"id\":489,\"type\":\"hop-section\",\"nodeId\":\"174-c2\",\"v\":\"1.1\",\"nodes\":[\"174-c2\",\"2922-c2\"]},{\"id\":490,\"props\":{\"layout\":{\"equalWidth\":false},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"174-c3\",\"v\":\"1.1\",\"nodes\":[\"174-c3\",\"2922-c3\"]},{\"id\":491,\"type\":\"hop-column\",\"nodeId\":\"174-c4\",\"style\":{\"textAlign\":\"left\",\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"textAlign\":\"center\"}}},\"props\":{\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}}}},\"v\":\"1.1\",\"nodes\":[\"174-c4\",\"2922-c4\"]},{\"id\":492,\"type\":\"hop-heading\",\"nodeId\":\"174-c5\",\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"174-c5\",\"2922-c5\"]},{\"id\":493,\"type\":\"hop-text\",\"nodeId\":\"174-c6\",\"v\":\"1.1\",\"nodes\":[\"174-c6\",\"2922-c6\"]},{\"id\":494,\"type\":\"hop-text\",\"nodeId\":\"174-c7\",\"v\":\"1.1\",\"nodes\":[\"174-c7\",\"2922-c7\"]},{\"id\":497,\"type\":\"hop-section\",\"nodeId\":\"151-c2\",\"style\":{\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}}},\"props\":{\"width\":\"full-width\"},\"v\":\"1.1\",\"nodes\":[\"151-c2\",\"2906-c2\"]},{\"id\":498,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"151-c3\",\"v\":\"1.1\",\"nodes\":[\"151-c3\",\"2906-c3\"]},{\"id\":499,\"type\":\"hop-column\",\"nodeId\":\"151-c4\",\"style\":{\"padding\":{\"left\":{\"unit\":\"rem\",\"value\":\"12\"},\"right\":{\"unit\":\"rem\",\"value\":\"8\"},\"top\":{\"unit\":\"rem\",\"value\":\"8\"},\"bottom\":{\"unit\":\"rem\",\"value\":\"8\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"textAlign\":\"left\",\"media\":{\"tablet\":{\"padding\":{\"top\":{\"value\":\"2\",\"unit\":\"rem\"},\"right\":{\"value\":\"2\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"2\",\"unit\":\"rem\"},\"left\":{\"value\":\"2\",\"unit\":\"rem\"}}},\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"top\":{\"value\":\"2\",\"unit\":\"rem\"},\"right\":{\"value\":\"2\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"2\",\"unit\":\"rem\"},\"left\":{\"value\":\"2\",\"unit\":\"rem\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"151-c4\",\"2906-c4\"]},{\"id\":500,\"type\":\"hop-column\",\"nodeId\":\"151-c5\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/aerial-view-architecture-cars-280221-1.jpg\"}}]},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":\"300\"},\"type\":\"min-height\"}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"151-c9\",\"2906-c9\"]},{\"id\":501,\"type\":\"hop-heading\",\"nodeId\":\"151-c6\",\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"151-c5\",\"2906-c5\"]},{\"id\":502,\"type\":\"hop-text\",\"nodeId\":\"151-c7\",\"v\":\"1.1\",\"nodes\":[\"151-c8\",\"2906-c8\"]},{\"id\":503,\"type\":\"hop-text\",\"nodeId\":\"151-c8\",\"v\":\"1.1\",\"nodes\":[\"151-c6\",\"2906-c6\"]},{\"id\":504,\"type\":\"hop-text\",\"nodeId\":\"151-c9\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.5}\"}}}},\"v\":\"1.1\",\"nodes\":[\"151-c7\",\"2906-c7\"]},{\"id\":505,\"type\":\"hop-section\",\"nodeId\":\"151-c10\",\"style\":{\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}}},\"props\":{\"width\":\"full-width\"},\"v\":\"1.1\",\"nodes\":[\"151-c10\",\"2906-c10\"]},{\"id\":506,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"151-c11\",\"v\":\"1.1\",\"nodes\":[\"151-c11\",\"2906-c11\"]},{\"id\":507,\"type\":\"hop-column\",\"nodeId\":\"151-c12\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/livestock-london-mammal-1717085-1.jpg\"}}]},\"media\":{\"mobile\":{\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":\"300\"},\"type\":\"min-height\"}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"151-c12\",\"2906-c12\"]},{\"id\":508,\"type\":\"hop-column\",\"nodeId\":\"151-c13\",\"style\":{\"textAlign\":\"left\",\"padding\":{\"top\":{\"value\":\"8\",\"unit\":\"rem\"},\"right\":{\"value\":\"12\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"8\",\"unit\":\"rem\"},\"left\":{\"value\":\"8\",\"unit\":\"rem\"}},\"media\":{\"tablet\":{\"padding\":{\"top\":{\"value\":\"2\",\"unit\":\"rem\"},\"right\":{\"value\":\"2\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"2\",\"unit\":\"rem\"},\"left\":{\"value\":\"2\",\"unit\":\"rem\"}}},\"mobile\":{\"padding\":{\"top\":{\"value\":\"2\",\"unit\":\"rem\"},\"right\":{\"value\":\"2\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"2\",\"unit\":\"rem\"},\"left\":{\"value\":\"2\",\"unit\":\"rem\"}},\"textAlign\":\"center\"}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"0\"}}},\"v\":\"1.1\",\"nodes\":[\"151-c13\",\"2906-c13\"]},{\"id\":509,\"type\":\"hop-heading\",\"nodeId\":\"151-c14\",\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"151-c14\",\"2906-c14\"]},{\"id\":510,\"type\":\"hop-heading\",\"nodeId\":\"151-c15\",\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"151-c20\",\"151-c24\",\"2906-c20\",\"2906-c24\"]},{\"id\":511,\"type\":\"hop-heading\",\"nodeId\":\"151-c16\",\"style\":{\"typography\":{\"color\":\"${theme.colors.0}\"}},\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"151-c21\",\"151-c25\",\"2906-c21\",\"2906-c25\"]},{\"id\":512,\"type\":\"hop-text\",\"nodeId\":\"151-c17\",\"v\":\"1.1\",\"nodes\":[\"151-c22\",\"2906-c22\"]},{\"id\":513,\"type\":\"hop-spacer\",\"nodeId\":\"151-c18\",\"style\":{\"height\":{\"value\":\"30\"}},\"v\":\"1.1\",\"nodes\":[\"151-c15\",\"2906-c15\"]},{\"id\":514,\"type\":\"hop-spacer\",\"nodeId\":\"151-c20\",\"style\":{\"height\":{\"value\":\"20\"}},\"v\":\"1.1\",\"nodes\":[\"151-c19\",\"151-c23\",\"2906-c19\",\"2906-c23\"]},{\"id\":515,\"type\":\"hop-heading\",\"nodeId\":\"151-c15\",\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"151-c16\",\"2906-c16\"]},{\"id\":516,\"type\":\"hop-heading\",\"nodeId\":\"151-c16\",\"style\":{\"typography\":{\"color\":\"${theme.colors.0}\"}},\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"151-c17\",\"2906-c17\"]},{\"id\":517,\"type\":\"hop-text\",\"nodeId\":\"151-c22\",\"v\":\"1.1\",\"nodes\":[\"151-c18\",\"2906-c18\"]},{\"id\":518,\"type\":\"hop-text\",\"nodeId\":\"151-c26\",\"v\":\"1.1\",\"nodes\":[\"151-c26\",\"2906-c26\"]},{\"id\":519,\"type\":\"hop-content\",\"nodeId\":\"148-c1\",\"v\":\"1.1\",\"nodes\":[\"148-c1\",\"2903-c1\"]},{\"id\":520,\"type\":\"hop-section\",\"nodeId\":\"148-c2\",\"style\":{\"background\":{\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"angle\":\"120\",\"steps\":[{\"color\":\"rgba(253, 251, 251, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(235, 237, 238, 0.8)\",\"position\":\"100\"}]}}}]}},\"v\":\"1.1\",\"nodes\":[\"148-c2\",\"2903-c2\"]},{\"id\":521,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":3},\"media\":{\"tablet\":{\"layout\":{\"itemsPerRow\":2}},\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"148-c3\",\"v\":\"1.1\",\"nodes\":[\"148-c3\",\"2903-c3\"]},{\"id\":522,\"type\":\"hop-column\",\"nodeId\":\"148-c4\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"0\",\"spread\":\"0\",\"y\":\"1\",\"x\":\"1\",\"color\":\"rgba(0, 0, 0, 0.05)\"}]},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"vSpace\":{\"value\":\"0\"}}},\"v\":\"1.1\",\"nodes\":[\"148-c4\",\"148-c15\",\"148-c26\",\"148-c37\",\"148-c48\",\"148-c59\",\"2903-c4\",\"2903-c15\",\"2903-c26\",\"2903-c37\",\"2903-c48\",\"2903-c59\"]},{\"id\":525,\"type\":\"hop-heading\",\"nodeId\":\"148-c7\",\"props\":{\"headerType\":\"3\"},\"v\":\"1.1\",\"nodes\":[\"148-c11\",\"148-c22\",\"148-c33\",\"148-c44\",\"148-c55\",\"148-c66\",\"2903-c11\",\"2903-c22\",\"2903-c33\",\"2903-c44\",\"2903-c55\",\"2903-c66\"]},{\"id\":526,\"type\":\"hop-text\",\"nodeId\":\"148-c8\",\"v\":\"1.1\",\"nodes\":[\"148-c12\",\"148-c23\",\"148-c34\",\"148-c45\",\"148-c56\",\"148-c67\",\"2903-c12\",\"2903-c23\",\"2903-c34\",\"2903-c45\",\"2903-c56\",\"2903-c67\"]},{\"id\":527,\"type\":\"hop-link-group\",\"nodeId\":\"148-c9\",\"v\":\"1.1\",\"nodes\":[\"148-c13\",\"148-c24\",\"148-c35\",\"148-c46\",\"148-c57\",\"148-c68\",\"2903-c13\",\"2903-c24\",\"2903-c35\",\"2903-c46\",\"2903-c57\",\"2903-c68\"]},{\"id\":528,\"type\":\"hop-link\",\"nodeId\":\"148-c10\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"props\":{\"showIcon\":true,\"iconPosition\":\"after\"},\"v\":\"1.1\",\"nodes\":[\"148-c14\",\"148-c25\",\"148-c36\",\"148-c47\",\"148-c58\",\"148-c69\",\"2903-c14\",\"2903-c25\",\"2903-c36\",\"2903-c47\",\"2903-c58\",\"2903-c69\"]},{\"id\":529,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/bus-2531578_640.jpg\"}}]},\"padding\":{\"left\":{\"value\":\"50\"},\"right\":{\"value\":\"50\"}},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.7)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"attrs\":{\"overflowOption\":\"hidden\"},\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}}},\"v\":\"1.1\",\"nodes\":[\"148-c5\",\"2903-c5\"]},{\"id\":530,\"style\":{\"textAlign\":\"center\",\"minHeight\":{\"value\":\"250\"}},\"type\":\"hop-content-swap-default\",\"props\":{\"horizontalGap\":3},\"v\":\"1.1\",\"nodes\":[\"148-c6\",\"148-c17\",\"148-c28\",\"148-c39\",\"148-c50\",\"148-c61\",\"2903-c6\",\"2903-c17\",\"2903-c28\",\"2903-c39\",\"2903-c50\",\"2903-c61\"]},{\"id\":533,\"style\":{\"textAlign\":\"center\",\"height\":{\"value\":100},\"top\":{\"value\":0,\"unit\":\"%\"},\"left\":{\"value\":0,\"unit\":\"%\"},\"width\":{\"value\":100}},\"type\":\"hop-content-swap-hover\",\"props\":{\"verticalAlign\":\"center\",\"position\":\"topRight\"},\"v\":\"1.1\",\"nodes\":[\"148-c7\",\"148-c18\",\"148-c29\",\"148-c40\",\"148-c51\",\"148-c62\",\"2903-c7\",\"2903-c18\",\"2903-c29\",\"2903-c40\",\"2903-c51\",\"2903-c62\"]},{\"id\":536,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"148-c18\",\"v\":\"1.1\",\"nodes\":[\"148-c9\",\"148-c20\",\"148-c31\",\"148-c42\",\"148-c53\",\"148-c64\",\"2903-c9\",\"2903-c20\",\"2903-c31\",\"2903-c42\",\"2903-c53\",\"2903-c64\"]},{\"id\":537,\"type\":\"hop-column\",\"nodeId\":\"148-c19\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2,\"vSpace\":{\"value\":\"20\"}}},\"v\":\"1.1\",\"nodes\":[\"148-c10\",\"148-c21\",\"148-c32\",\"148-c43\",\"148-c54\",\"148-c65\",\"2903-c10\",\"2903-c21\",\"2903-c32\",\"2903-c43\",\"2903-c54\",\"2903-c65\"]},{\"id\":540,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"fill\":\"${theme.colors.4}\",\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(45, 45, 134, 0)\"},\"fill\":\"${theme.colors.0|mediumLowLuminosity}\"}},\"border\":{\"top\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"right\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"bottom\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"left\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"}},\"width\":{\"path\":\"value\",\"value\":\"50\"},\"height\":{\"path\":\"value\",\"value\":\"50\"}}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"148-c8\",\"148-c19\",\"148-c30\",\"148-c41\",\"148-c52\",\"148-c63\",\"2903-c8\",\"2903-c19\",\"2903-c30\",\"2903-c41\",\"2903-c52\",\"2903-c63\"]},{\"id\":541,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/dog-644111_640.jpg\"}}]},\"padding\":{\"left\":{\"value\":\"50\"},\"right\":{\"value\":\"50\"}},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.7)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"attrs\":{\"overflowOption\":\"hidden\"},\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}}},\"nodeId\":\"148-c20\",\"v\":\"1.1\",\"nodes\":[\"148-c16\",\"2903-c16\"]},{\"id\":542,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/speed-4216828_640-1.jpg\"}}]},\"padding\":{\"left\":{\"value\":\"50\"},\"right\":{\"value\":\"50\"}},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.7)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"attrs\":{\"overflowOption\":\"hidden\"},\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}}},\"nodeId\":\"148-c31\",\"v\":\"1.1\",\"nodes\":[\"148-c27\",\"2903-c27\"]},{\"id\":543,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/bodyworn-794111_640-1.jpg\"}}]},\"padding\":{\"left\":{\"value\":\"50\"},\"right\":{\"value\":\"50\"}},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.7)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"attrs\":{\"overflowOption\":\"hidden\"},\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}}},\"nodeId\":\"148-c53\",\"v\":\"1.1\",\"nodes\":[\"148-c49\",\"2903-c49\"]},{\"id\":544,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/park-3089907_640-1.jpg\"}}]},\"padding\":{\"left\":{\"value\":\"50\"},\"right\":{\"value\":\"50\"}},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.7)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"attrs\":{\"overflowOption\":\"hidden\"},\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}}},\"nodeId\":\"148-c42\",\"v\":\"1.1\",\"nodes\":[\"148-c38\",\"2903-c38\"]},{\"id\":545,\"type\":\"hop-content-swap\",\"style\":{\"descendants\":{\"normal\":{\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}},\"background\":{\"color\":\"rgba(236, 82, 55, 0)\",\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/hands-2906458_640-1.jpg\"}}]},\"padding\":{\"left\":{\"value\":\"50\"},\"right\":{\"value\":\"50\"}},\"animation\":{\"duration\":{\"value\":\"500\"}}},\"hover\":{\"background\":{\"color\":\"rgba(34, 41, 51, 0.7)\"},\"animation\":{\"duration\":{\"value\":\"500\"}}}},\"boxShadow\":{\"enabled\":false}},\"props\":{\"attrs\":{\"overflowOption\":\"hidden\"},\"hover\":{\"effect\":{\"type\":\"slideIn\",\"direction\":\"Up\"}}},\"nodeId\":\"148-c64\",\"v\":\"1.1\",\"nodes\":[\"148-c60\",\"2903-c60\"]},{\"id\":546,\"type\":\"hop-content\",\"nodeId\":\"149-c1\",\"v\":\"1.1\",\"nodes\":[\"149-c1\",\"2904-c1\"]},{\"id\":547,\"type\":\"hop-section\",\"nodeId\":\"149-c2\",\"style\":{\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}}},\"props\":{\"width\":\"full-width\"},\"v\":\"1.1\",\"nodes\":[\"149-c2\",\"2904-c2\"]},{\"id\":548,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"149-c3\",\"v\":\"1.1\",\"nodes\":[\"149-c3\",\"2904-c3\"]},{\"id\":549,\"type\":\"hop-column\",\"nodeId\":\"149-c4\",\"style\":{\"padding\":{\"left\":{\"unit\":\"rem\",\"value\":\"12\"},\"right\":{\"unit\":\"rem\",\"value\":\"8\"},\"top\":{\"unit\":\"rem\",\"value\":\"8\"},\"bottom\":{\"unit\":\"rem\",\"value\":\"8\"}},\"background\":{\"type\":\"gradient\",\"image\":[{\"source\":{\"type\":\"gradient\",\"gradient\":{\"angle\":\"120\",\"steps\":[{\"color\":\"rgba(253, 251, 251, 0.8)\",\"position\":\"0\"},{\"color\":\"rgba(235, 237, 238, 0.8)\",\"position\":\"100\"}]}}}]},\"textAlign\":\"left\",\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"2\",\"unit\":\"rem\"},\"right\":{\"value\":\"2\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"2\",\"unit\":\"rem\"},\"left\":{\"value\":\"2\",\"unit\":\"rem\"}},\"textAlign\":\"center\"},\"tablet\":{\"padding\":{\"top\":{\"value\":\"2\",\"unit\":\"rem\"},\"right\":{\"value\":\"2\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"2\",\"unit\":\"rem\"},\"left\":{\"value\":\"2\",\"unit\":\"rem\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"verticalAlign\":\"start\"},\"v\":\"1.1\",\"nodes\":[\"149-c4\",\"2904-c4\"]},{\"id\":550,\"type\":\"hop-column\",\"nodeId\":\"149-c5\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"https:\\/\\/colibriwp-work.colibriwp.com\\/city-pro\\/wp-content\\/uploads\\/2020\\/01\\/soccer-field-219812_1280-1.jpg\"}}]},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":\"300\"},\"type\":\"min-height\"}},\"tablet\":{\"padding\":{\"top\":{\"unit\":\"rem\"},\"right\":{\"unit\":\"rem\"},\"bottom\":{\"unit\":\"rem\"},\"left\":{\"unit\":\"rem\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"149-c10\",\"2904-c10\"]},{\"id\":551,\"type\":\"hop-heading\",\"nodeId\":\"149-c6\",\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"149-c5\",\"2904-c5\"]},{\"id\":552,\"type\":\"hop-text\",\"nodeId\":\"149-c7\",\"v\":\"1.1\",\"nodes\":[\"149-c6\",\"2904-c6\"]},{\"id\":555,\"type\":\"hop-counters\",\"style\":{\"descendants\":{\"simpleTitle\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"px\",\"value\":\"21\"}}},\"simpleCounter\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"em\",\"value\":\"3\"}}},\"circleTitle\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"px\",\"value\":\"21\"}}},\"circleCounter\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"em\",\"value\":\"3\"}}},\"barTitle\":{\"typography\":{\"color\":\"${theme.colors.2}\",\"weight\":\"600\"}},\"barCounter\":{\"typography\":{\"color\":\"${theme.colors.2}\",\"weight\":\"600\"}}}},\"props\":{\"counterType\":\"bar\",\"colorOut\":\"rgba(23, 37, 42, 0.1)\",\"colorIn\":\"${theme.colors.2}\",\"width\":{\"value\":300},\"counterPostion\":\"sameRow\",\"height\":{\"value\":\"20\"}},\"v\":\"1.1\",\"nodes\":[\"149-c8\",\"2904-c8\"]},{\"id\":556,\"type\":\"hop-section\",\"nodeId\":\"149-c10\",\"props\":{\"showHeader\":true},\"v\":\"1.1\",\"nodes\":[\"149-c11\",\"2904-c11\"]},{\"id\":557,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":3,\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"tablet\":{\"layout\":{\"itemsPerRow\":2}},\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"149-c11\",\"v\":\"1.1\",\"nodes\":[\"149-c12\",\"2904-c12\"]},{\"id\":558,\"type\":\"hop-column\",\"nodeId\":\"149-c12\",\"style\":{\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"v\":\"1.1\",\"nodes\":[\"149-c13\",\"149-c19\",\"149-c25\",\"2904-c13\",\"2904-c19\",\"2904-c25\"]},{\"id\":561,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"149-c15\",\"v\":\"1.1\",\"nodes\":[\"149-c31\",\"2904-c31\"]},{\"id\":562,\"type\":\"hop-column\",\"nodeId\":\"149-c16\",\"v\":\"1.1\",\"nodes\":[\"149-c32\",\"2904-c32\"]},{\"id\":563,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"149-c17\",\"v\":\"1.1\",\"nodes\":[\"149-c35\",\"2904-c35\"]},{\"id\":564,\"type\":\"hop-text\",\"nodeId\":\"149-c18\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"transform\":\"uppercase\"}}}},\"props\":{\"type\":\"lead\"},\"v\":\"1.1\",\"nodes\":[\"149-c33\",\"2904-c33\"]},{\"id\":566,\"type\":\"hop-divider\",\"style\":{\"descendants\":{\"line\":{\"border\":{\"bottom\":{\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\"}}},\"width\":{\"value\":\"90\",\"unit\":\"px\"}},\"icon\":{\"fill\":\"${theme.colors.0}\"}},\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}}},\"props\":{\"type\":\"line\"},\"v\":\"1.1\",\"nodes\":[\"149-c34\",\"2904-c34\"]},{\"id\":567,\"type\":\"hop-counters\",\"style\":{\"descendants\":{\"simpleTitle\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"px\",\"value\":\"21\"}}},\"simpleCounter\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"em\",\"value\":\"3\"}}},\"circleTitle\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"px\",\"value\":\"21\"}}},\"circleCounter\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"em\",\"value\":\"3\"}}},\"barTitle\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"weight\":\"600\"}},\"barCounter\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"weight\":\"600\"}}}},\"props\":{\"counterType\":\"bar\",\"colorOut\":\"rgba(23, 37, 42, 0.1)\",\"colorIn\":\"${theme.colors.0}\",\"width\":{\"value\":300},\"counterPostion\":\"sameRow\",\"height\":{\"value\":\"20\"}},\"nodeId\":\"149-c9\",\"v\":\"1.1\",\"nodes\":[\"149-c7\",\"2904-c7\"]},{\"id\":568,\"type\":\"hop-counters\",\"style\":{\"descendants\":{\"simpleTitle\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"px\",\"value\":\"21\"}}},\"simpleCounter\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"em\",\"value\":\"3\"}}},\"circleTitle\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"px\",\"value\":\"21\"}}},\"circleCounter\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"em\",\"value\":\"3\"}}},\"barTitle\":{\"typography\":{\"color\":\"${theme.colors.1}\",\"weight\":\"600\"}},\"barCounter\":{\"typography\":{\"color\":\"${theme.colors.1}\",\"weight\":\"600\"}}}},\"props\":{\"counterType\":\"bar\",\"colorOut\":\"rgba(23, 37, 42, 0.1)\",\"colorIn\":\"${theme.colors.1}\",\"width\":{\"value\":300},\"counterPostion\":\"sameRow\",\"height\":{\"value\":\"20\"}},\"nodeId\":\"149-c21\",\"v\":\"1.1\",\"nodes\":[\"149-c9\",\"2904-c9\"]},{\"id\":569,\"type\":\"hop-image\",\"nodeId\":\"149-c22\",\"v\":\"1.1\",\"nodes\":[\"149-c14\",\"149-c20\",\"149-c26\",\"2904-c14\",\"2904-c20\",\"2904-c26\"]},{\"id\":570,\"type\":\"hop-heading\",\"nodeId\":\"149-c23\",\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"149-c15\",\"149-c21\",\"149-c27\",\"2904-c15\",\"2904-c21\",\"2904-c27\"]},{\"id\":571,\"type\":\"hop-text\",\"nodeId\":\"149-c24\",\"v\":\"1.1\",\"nodes\":[\"149-c16\",\"149-c22\",\"149-c28\",\"2904-c16\",\"2904-c22\",\"2904-c28\"]},{\"id\":572,\"type\":\"hop-link-group\",\"nodeId\":\"149-c25\",\"v\":\"1.1\",\"nodes\":[\"149-c17\",\"149-c23\",\"149-c29\",\"2904-c17\",\"2904-c23\",\"2904-c29\"]},{\"id\":573,\"type\":\"hop-link\",\"nodeId\":\"149-c26\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"props\":{\"showIcon\":true,\"iconPosition\":\"after\"},\"v\":\"1.1\",\"nodes\":[\"149-c18\",\"149-c24\",\"149-c30\",\"2904-c18\",\"2904-c24\",\"2904-c30\"]},{\"id\":575,\"type\":\"hop-content\",\"nodeId\":\"150-c1\",\"v\":\"1.1\",\"nodes\":[\"150-c1\",\"2905-c1\"]},{\"id\":582,\"type\":\"hop-section\",\"nodeId\":\"150-c8\",\"v\":\"1.1\",\"nodes\":[\"150-c2\",\"2905-c2\"]},{\"id\":583,\"props\":{\"layout\":{\"equalWidth\":false},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"150-c9\",\"v\":\"1.1\",\"nodes\":[\"150-c3\",\"2905-c3\"]},{\"id\":586,\"type\":\"hop-heading\",\"nodeId\":\"150-c12\",\"props\":{\"headerType\":\"3\"},\"v\":\"1.1\",\"nodes\":[\"150-c5\",\"150-c9\",\"2905-c5\",\"2905-c9\"]},{\"id\":587,\"type\":\"hop-text\",\"nodeId\":\"150-c13\",\"v\":\"1.1\",\"nodes\":[\"150-c7\",\"150-c11\",\"2905-c7\",\"2905-c11\"]},{\"id\":589,\"type\":\"hop-divider\",\"style\":{\"descendants\":{\"line\":{\"border\":{\"bottom\":{\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\"}}},\"width\":{\"value\":\"90\",\"unit\":\"px\"}},\"icon\":{\"fill\":\"${theme.colors.0}\"}},\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}}},\"props\":{\"type\":\"line\"},\"v\":\"1.1\",\"nodes\":[\"150-c6\",\"150-c10\",\"2905-c6\",\"2905-c10\"]},{\"id\":590,\"type\":\"hop-column\",\"nodeId\":\"150-c15\",\"style\":{\"textAlign\":\"left\",\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"textAlign\":\"center\"}}},\"props\":{\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}}}},\"v\":\"1.1\",\"nodes\":[\"150-c4\",\"150-c8\",\"2905-c4\",\"2905-c8\"]},{\"id\":591,\"type\":\"hop-section\",\"nodeId\":\"13-f44\",\"style\":{\"padding\":{\"top\":{\"value\":\"20\"},\"bottom\":{\"value\":\"20\"}},\"background\":{\"color\":\"${theme.colors.3}\"},\"typography\":{\"holders\":{\"h1\":{\"color\":\"${theme.colors.4}\"},\"h2\":{\"color\":\"${theme.colors.4}\"},\"h3\":{\"color\":\"${theme.colors.4}\"},\"h4\":{\"color\":\"${theme.colors.4}\"},\"h5\":{\"color\":\"${theme.colors.4}\"},\"h6\":{\"color\":\"${theme.colors.4}\"},\"p\":{\"color\":\"${theme.colors.4}\"}}}},\"v\":\"1.1\",\"nodes\":[\"13-f2\"]},{\"id\":592,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":3,\"verticalGap\":1},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"13-f45\",\"v\":\"1.1\",\"nodes\":[\"13-f3\"]},{\"id\":593,\"type\":\"hop-column\",\"nodeId\":\"13-f46\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"2\"},\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"13-f4\",\"13-f11\",\"13-f18\"]},{\"id\":595,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"13-f48\",\"v\":\"1.1\",\"nodes\":[\"13-f25\"]},{\"id\":596,\"type\":\"hop-column\",\"nodeId\":\"13-f49\",\"v\":\"1.1\",\"nodes\":[\"13-f26\"]},{\"id\":597,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"13-f50\",\"v\":\"1.1\",\"nodes\":[\"13-f27\"]},{\"id\":598,\"type\":\"hop-text\",\"nodeId\":\"13-f51\",\"v\":\"1.1\",\"nodes\":[\"13-f28\"]},{\"id\":601,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"fill\":\"${theme.colors.5}\",\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(45, 45, 134, 0)\"},\"fill\":\"${theme.colors.4}\"}},\"border\":{\"top\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"right\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"bottom\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"},\"left\":{\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(125, 79, 79)\"}},\"width\":{\"path\":\"value\",\"value\":\"60\"},\"height\":{\"path\":\"value\",\"value\":\"60\"}}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"13-f7\",\"13-f14\",\"13-f21\"]},{\"id\":602,\"type\":\"hop-heading\",\"nodeId\":\"13-f54\",\"props\":{\"headerType\":\"3\"},\"v\":\"1.1\",\"nodes\":[\"13-f9\",\"13-f16\",\"13-f23\"]},{\"id\":603,\"type\":\"hop-heading\",\"nodeId\":\"13-f55\",\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"13-f10\",\"13-f17\",\"13-f24\"]},{\"id\":604,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"13-f64\",\"v\":\"1.1\",\"nodes\":[\"13-f5\",\"13-f12\",\"13-f19\"]},{\"id\":605,\"type\":\"hop-column\",\"nodeId\":\"13-f65\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":1,\"verticalInnerGap\":1}},\"v\":\"1.1\",\"nodes\":[\"13-f6\",\"13-f13\",\"13-f20\"]},{\"id\":606,\"type\":\"hop-column\",\"nodeId\":\"13-f66\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"left\",\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":1,\"verticalInnerGap\":1,\"vSpace\":{\"value\":\"10\"}},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2}}}},\"v\":\"1.1\",\"nodes\":[\"13-f8\",\"13-f15\",\"13-f22\"]},{\"id\":607,\"type\":\"hop-copyright\",\"nodeId\":\"13-f71\",\"v\":\"1.1\",\"nodes\":[\"13-f37\"]},{\"id\":608,\"type\":\"hop-copyright\",\"nodeId\":\"7-h44\",\"v\":\"1.1\",\"style\":{\"typography\":{\"color\":\"rgba(255, 255, 255, 0.5)\"}},\"nodes\":[\"7-h25\",\"2896-h25\"]},{\"id\":611,\"type\":\"hop-accordion\",\"v\":\"1.1\",\"style\":{\"descendants\":{\"title\":{\"typography\":{\"color\":\"${theme.colors.4|variant2}\",\"decoration\":\"none\",\"size\":{\"unit\":\"px\",\"value\":\"18\"}},\"states\":{\"customActive\":{\"typography\":{\"color\":\"${theme.colors.0}\"}},\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}},\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}},\"titleIcon\":{\"size\":{\"value\":\"18\"},\"margin\":{\"right\":{\"value\":\"10\"}},\"fill\":\"${theme.colors.5}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.0}\"},\"customActive\":{\"fill\":\"${theme.colors.0}\"}}},\"content\":{\"padding\":{\"top\":{\"value\":\"12\",\"unit\":\"px\"},\"right\":{\"value\":\"24\",\"unit\":\"px\"},\"bottom\":{\"value\":\"12\",\"unit\":\"px\"},\"left\":{\"value\":\"24\",\"unit\":\"px\"}},\"textAlign\":\"left\"}}},\"props\":{\"accordionItems\":{\"normalIcon\":\"icons8-line-awesome\\/caret-right\",\"activeIcon\":\"icons8-line-awesome\\/caret-down\",\"iconPosition\":\"left\"},\"openMultipleItems\":false},\"nodes\":[\"174-c8\",\"2922-c8\"]},{\"id\":612,\"props\":{\"title\":\"Where should i pay my taxes?\"},\"type\":\"hop-accordion-item\",\"v\":\"1.1\",\"nodes\":[\"174-c9\",\"2922-c9\"]},{\"id\":613,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"174-c10\",\"2922-c10\"]},{\"id\":614,\"props\":{\"title\":\"Does Town Hall have an elevator?\"},\"type\":\"hop-accordion-item\",\"v\":\"1.1\",\"nodes\":[\"174-c11\",\"2922-c11\"]},{\"id\":615,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"174-c12\",\"2922-c12\"]},{\"id\":616,\"props\":{\"title\":\"Do I need a Business Licence if I am located in a Commercial District?\"},\"type\":\"hop-accordion-item\",\"v\":\"1.1\",\"nodes\":[\"174-c13\",\"2922-c13\"]},{\"id\":617,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"174-c14\",\"2922-c14\"]},{\"id\":618,\"props\":{\"title\":\"Can somebody else pay my fees?\"},\"type\":\"hop-accordion-item\",\"v\":\"1.1\",\"nodes\":[\"174-c15\",\"2922-c15\"]},{\"id\":619,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"174-c16\",\"2922-c16\"]},{\"id\":620,\"props\":{\"title\":\"What is the penalty for paying taxes after the deadline?\"},\"type\":\"hop-accordion-item\",\"v\":\"1.1\",\"nodes\":[\"174-c17\",\"2922-c17\"]},{\"id\":621,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"174-c18\",\"2922-c18\"]},{\"id\":622,\"props\":{\"title\":\"Who should I contact if I have a question about abandoned vehicles or RVs\\/trucks\\/trailers parked on my street?\"},\"type\":\"hop-accordion-item\",\"v\":\"1.1\",\"nodes\":[\"174-c19\",\"2922-c19\"]},{\"id\":623,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"174-c20\",\"2922-c20\"]},{\"id\":624,\"type\":\"hop-main\",\"nodeId\":\"71-m1\",\"v\":\"1.1\",\"nodes\":[\"432-m1\",\"2034-m1\"],\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"40\",\"y\":\"10\",\"spread\":\"0\",\"color\":\"rgba(1, 51, 74, 0.15)\"}]},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"props\":{\"attrs\":{\"overflowOption\":\"hidden\"}}},{\"id\":625,\"type\":\"hop-section\",\"nodeId\":\"16-m29\",\"nodes\":[\"432-m2\",\"2034-m2\"],\"style\":{\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"v\":\"1.1\",\"props\":{\"width\":\"boxed\"}},{\"id\":626,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-m33\",\"nodes\":[\"432-m25\",\"2034-m25\"],\"v\":\"1.1\"},{\"id\":627,\"type\":\"hop-column\",\"nodeId\":\"16-m34\",\"nodes\":[\"432-m26\",\"2034-m26\"],\"v\":\"1.1\"},{\"id\":628,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"16-m35\",\"nodes\":[\"432-m27\",\"2034-m27\"],\"v\":\"1.1\"},{\"id\":629,\"type\":\"hop-text\",\"nodeId\":\"16-m36\",\"nodes\":[\"432-m28\",\"2034-m28\"],\"v\":\"1.1\"},{\"id\":630,\"type\":\"hop-post-loop\",\"nodeId\":\"23-m35\",\"style\":{\"background\":{\"color\":\"\"}},\"v\":\"1.1\",\"nodes\":[\"432-m3\",\"2034-m3\"]},{\"id\":631,\"type\":\"hop-loop-item\",\"nodeId\":\"23-m36\",\"v\":\"1.1\",\"nodes\":[\"432-m4\",\"2034-m4\"],\"style\":{\"background\":{\"color\":\"\"},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"0\"},\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}},{\"id\":632,\"type\":\"hop-post-thumbnail\",\"nodeId\":\"23-m37\",\"style\":{\"background\":{\"color\":\"${theme.colors.0}\"}},\"v\":\"1.1\",\"nodes\":[\"432-m5\",\"2034-m5\"]},{\"id\":633,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"itemsPerRow\":1,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}}},\"type\":\"hop-row\",\"nodeId\":\"1723-m26\",\"v\":\"1.1\",\"nodes\":[\"432-m6\",\"2034-m6\"]},{\"id\":634,\"type\":\"hop-column\",\"nodeId\":\"1723-m27\",\"props\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}},\"v\":\"1.1\",\"nodes\":[\"432-m7\",\"2034-m7\"],\"style\":{\"textAlign\":\"left\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},{\"id\":635,\"type\":\"hop-post-meta\",\"nodeId\":\"26-m15\",\"v\":\"1.1\",\"nodes\":[\"432-m8\",\"2034-m8\"],\"style\":{\"descendants\":{\"metaDataLinks\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"decoration\":\"none\",\"color\":\"${theme.colors.5|variant1}\",\"weight\":\"400\",\"family\":\"Open Sans\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"icons\":{\"height\":{\"value\":\"18\"},\"width\":{\"value\":\"18\"},\"display\":\"none\",\"margin\":{\"right\":{\"value\":\"5\"}}},\"metaDataSuffix\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5|variant1}\"}}}},\"metaDataPrefix\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"color\":\"${theme.colors.5|variant2}\"}}}}},{\"id\":636,\"type\":\"hop-post-content\",\"nodeId\":\"23-m40\",\"v\":\"1.1\",\"nodes\":[\"432-m9\",\"2034-m9\"],\"style\":{\"descendants\":{\"content\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\",\"holders\":{\"p\":{\"color\":\"${theme.colors.5|variant2}\"}}}}}}},{\"id\":637,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-post-categories-container\",\"nodeId\":\"16-m34\",\"nodes\":[\"432-m10\",\"2034-m10\"],\"v\":\"1.1\",\"style\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},{\"id\":638,\"type\":\"hop-column\",\"nodeId\":\"16-m38\",\"nodes\":[\"432-m11\",\"2034-m11\"],\"v\":\"1.1\",\"props\":{\"verticalAlign\":\"center\"}},{\"id\":639,\"type\":\"hop-text\",\"nodeId\":\"16-m39\",\"nodes\":[\"432-m12\",\"2034-m12\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"},\"color\":\"${theme.colors.5|variant2}\"}}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},{\"id\":640,\"type\":\"hop-column\",\"nodeId\":\"16-m36\",\"nodes\":[\"432-m13\",\"2034-m13\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\"},\"props\":{\"verticalAlign\":\"center\"}},{\"id\":641,\"type\":\"hop-post-categories\",\"nodeId\":\"16-m37\",\"nodes\":[\"432-m14\",\"2034-m14\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"categoriesLinks\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"5\",\"unit\":\"px\"}},\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"},\"color\":\"${theme.colors.4|variant2}\",\"decoration\":\"none\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}}}}},{\"id\":642,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalGap\":0,\"verticalGap\":0,\"equalHeight\":false}},\"type\":\"hop-post-tags-container\",\"nodeId\":\"16-m30\",\"nodes\":[\"432-m15\",\"2034-m15\"],\"v\":\"1.1\"},{\"id\":643,\"type\":\"hop-column\",\"nodeId\":\"16-m40\",\"nodes\":[\"432-m16\",\"2034-m16\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"}},{\"id\":644,\"type\":\"hop-text\",\"nodeId\":\"16-m41\",\"nodes\":[\"432-m17\",\"2034-m17\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"weight\":\"400\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"},\"color\":\"${theme.colors.5|variant2}\"}}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"props\":{\"type\":\"normal\"}},{\"id\":645,\"type\":\"hop-column\",\"nodeId\":\"16-m32\",\"nodes\":[\"432-m18\",\"2034-m18\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"vSpace\":{\"value\":23}},\"verticalAlign\":\"center\"}},{\"id\":646,\"type\":\"hop-post-tags\",\"nodeId\":\"16-m33\",\"nodes\":[\"432-m19\",\"2034-m19\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"tagsLinks\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}},\"typography\":{\"color\":\"${theme.colors.4|variant2}\",\"decoration\":\"none\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"5\",\"unit\":\"px\"}}},\"tagsPrefix\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"typography\":{\"color\":\"${theme.colors.5|variant1}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}}}}}},{\"id\":647,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-post-nav-container\",\"nodeId\":\"16-m39\",\"nodes\":[\"432-m20\",\"2034-m20\"],\"v\":\"1.1\",\"style\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}}}},{\"id\":648,\"type\":\"hop-column\",\"nodeId\":\"16-m40\",\"nodes\":[\"432-m21\",\"2034-m21\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}},{\"id\":649,\"type\":\"hop-post-nav-button\",\"nodeId\":\"23-m48\",\"v\":\"1.1\",\"nodes\":[\"432-m22\",\"2034-m22\"],\"style\":{\"descendants\":{\"navigationButton\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\",\"decoration\":\"none\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"style\":\"none\",\"color\":\"black\"},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"style\":\"none\",\"color\":\"black\"},\"left\":{\"style\":\"none\",\"color\":\"black\"},\"right\":{\"style\":\"none\",\"color\":\"black\"}},\"background\":{\"color\":\"\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}}},\"navigationTitle\":{\"maxWidth\":{\"value\":\"40\",\"unit\":\"ch\"}}}}},{\"id\":650,\"type\":\"hop-column\",\"nodeId\":\"16-m41\",\"nodes\":[\"432-m23\",\"2034-m23\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"right\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}},{\"id\":651,\"type\":\"hop-post-nav-button\",\"nodeId\":\"23-m49\",\"v\":\"1.1\",\"nodes\":[\"432-m24\",\"2034-m24\"],\"style\":{\"descendants\":{\"navigationButton\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\",\"decoration\":\"none\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}}}}}},{\"id\":652,\"type\":\"hop-section\",\"nodeId\":\"16-m55\",\"nodes\":[\"432-m29\",\"2034-m29\"],\"style\":{\"padding\":{\"top\":{\"value\":0},\"bottom\":{\"value\":0}}},\"v\":\"1.1\"},{\"id\":653,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"16-m59\",\"nodes\":[\"432-m34\",\"2034-m34\"],\"v\":\"1.1\"},{\"id\":654,\"type\":\"hop-column\",\"nodeId\":\"16-m60\",\"nodes\":[\"432-m35\",\"2034-m35\"],\"v\":\"1.1\"},{\"id\":655,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"16-m61\",\"nodes\":[\"432-m36\",\"2034-m36\"],\"v\":\"1.1\"},{\"id\":656,\"type\":\"hop-text\",\"nodeId\":\"16-m62\",\"nodes\":[\"432-m37\",\"2034-m37\"],\"v\":\"1.1\"},{\"id\":657,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalGap\":0,\"verticalGap\":0,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}}},\"type\":\"hop-row\",\"nodeId\":\"16-m56\",\"nodes\":[\"432-m30\",\"2034-m30\"],\"v\":\"1.1\"},{\"id\":658,\"type\":\"hop-column\",\"nodeId\":\"16-m57\",\"nodes\":[\"432-m31\",\"2034-m31\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"0\"},\"bottom\":{\"unit\":\"px\",\"value\":\"15\"}},\"textAlign\":\"left\",\"media\":{\"tablet\":{\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"mobile\":{\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},{\"id\":659,\"type\":\"hop-post-comments\",\"nodeId\":\"1723-m26\",\"v\":\"1.1\",\"nodes\":[\"432-m32\",\"2034-m32\"],\"style\":{\"descendants\":{\"commentsTitle\":{\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.5}\",\"weight\":\"600\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"em\",\"value\":\"1.25\"}}},\"commentInfo\":{\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.5|variant1}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}},\"background\":{\"color\":\"\"},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"transition\":{\"duration\":{\"value\":\"0.5\"}}},\"commentText\":{\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.5|variant2}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"holders\":{\"p\":{\"color\":\"${theme.colors.5|variant2}\"},\"a\":{\"states\":{\"hover\":{\"color\":\"${theme.colors.0|variant3}\"}}}}}},\"commentAuthorName\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\",\"decoration\":\"none\",\"style\":\"normal\",\"weight\":\"600\"},\"background\":{\"color\":\"\"},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"5\",\"unit\":\"px\"}}},\"disabledComments\":{\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.5|variant2}\"}},\"comment\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":\"12\",\"unit\":\"px\"},\"right\":{\"value\":\"12\",\"unit\":\"px\"},\"bottom\":{\"value\":\"12\",\"unit\":\"px\"},\"left\":{\"value\":\"12\",\"unit\":\"px\"}}},\"commentAvatar\":{\"width\":{\"value\":30},\"height\":{\"value\":30},\"background\":{\"color\":\"\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}},\"commentsContainer\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"}},\"padding\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"commentReply\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"size\":{\"unit\":\"em\",\"value\":\"1\"},\"transform\":\"lowercase\",\"weight\":\"400\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.5\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"alternateComment\":{\"background\":{\"color\":\"rgba(166, 220, 244, 0.1)\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":\"12\",\"unit\":\"px\"},\"right\":{\"value\":\"12\",\"unit\":\"px\"},\"bottom\":{\"value\":\"12\",\"unit\":\"px\"},\"left\":{\"value\":\"12\",\"unit\":\"px\"}}},\"commentReplies\":{\"margin\":{\"left\":{\"value\":\"12\"}}},\"commentInfoContainer\":{\"typography\":{\"color\":\"${theme.colors.4|variant2}\"},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"16\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}}}},{\"id\":660,\"type\":\"hop-post-comment-form\",\"nodeId\":\"23-m32\",\"v\":\"1.1\",\"nodes\":[\"432-m33\",\"2034-m33\"],\"style\":{\"descendants\":{\"commentFormTitle\":{\"typography\":{\"color\":\"${theme.colors.5}\",\"size\":{\"unit\":\"em\",\"value\":\"1.25\"},\"weight\":\"600\",\"family\":\"Open Sans\"}},\"commentFormLabels\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}}}},\"commentFormButton\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0|variant3}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\",\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\",\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"}},\"padding\":{\"top\":{\"value\":\"12\",\"unit\":\"px\"},\"right\":{\"value\":\"24\",\"unit\":\"px\"},\"bottom\":{\"value\":\"12\",\"unit\":\"px\"},\"left\":{\"value\":\"24\",\"unit\":\"px\"}},\"typography\":{\"color\":\"${theme.colors.4}\",\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"weight\":\"600\",\"family\":\"Open Sans\",\"transform\":\"uppercase\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}}},\"commentFormInputs\":{\"border\":{\"top\":{\"color\":\"rgb(238, 238, 238)\",\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"right\":{\"color\":\"rgb(238, 238, 238)\"},\"left\":{\"color\":\"rgb(238, 238, 238)\"},\"bottom\":{\"color\":\"rgb(238, 238, 238)\",\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}}},\"typography\":{\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"color\":\"${theme.colors.5|variant2}\"},\"background\":{\"color\":\"rgba(0,0,0,0)\"},\"padding\":{\"top\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"value\":\"5\",\"unit\":\"px\"},\"left\":{\"value\":\"5\",\"unit\":\"px\"}}},\"commentFormNotes\":{\"typography\":{\"color\":\"${theme.colors.5|variant1}\",\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}}}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"bottom\":{\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"}},\"padding\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},{\"id\":661,\"type\":\"hop-main\",\"nodeId\":\"68-m1\",\"v\":\"1.1\",\"nodes\":[\"435-m1\",\"2037-m1\"],\"style\":{\"margin\":{\"top\":{\"value\":\"-30\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"-15\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}}}},{\"id\":662,\"type\":\"hop-section\",\"nodeId\":\"19-m36\",\"nodes\":[\"435-m2\",\"2037-m2\"],\"style\":{\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}}},\"v\":\"1.1\"},{\"id\":663,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"19-m40\",\"nodes\":[\"435-m25\",\"2037-m25\"],\"v\":\"1.1\"},{\"id\":664,\"type\":\"hop-column\",\"nodeId\":\"19-m41\",\"nodes\":[\"435-m26\",\"2037-m26\"],\"v\":\"1.1\"},{\"id\":665,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"19-m42\",\"nodes\":[\"435-m27\",\"2037-m27\"],\"v\":\"1.1\"},{\"id\":666,\"type\":\"hop-text\",\"nodeId\":\"19-m43\",\"nodes\":[\"435-m28\",\"2037-m28\"],\"v\":\"1.1\"},{\"id\":667,\"type\":\"hop-archive-loop\",\"nodeId\":\"26-m6\",\"props\":{\"layout\":{\"horizontalGap\":3,\"verticalGap\":3,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"itemsPerRow\":2,\"horizontalAlign\":\"start\",\"custom\":{\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"media\":{\"tablet\":{\"layout\":{\"itemsPerRow\":1,\"horizontalGap\":2,\"verticalGap\":2}},\"mobile\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalGap\":2}}},\"showMasonry\":true},\"v\":\"1.1\",\"nodes\":[\"435-m3\",\"2037-m3\"]},{\"id\":668,\"type\":\"hop-loop-item\",\"nodeId\":\"26-m7\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(1, 51, 74, 0.15)\",\"spread\":\"0\",\"y\":\"10\",\"blur\":\"40\"}]},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"435-m4\",\"2037-m4\"],\"props\":{\"attrs\":{\"overflowOption\":\"hidden\"}}},{\"id\":669,\"type\":\"hop-post-thumbnail\",\"nodeId\":\"26-m19\",\"style\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}},\"background\":{\"color\":\"rgba(255,255,255,0)\"}},\"v\":\"1.1\",\"nodes\":[\"435-m5\",\"2037-m5\"]},{\"id\":670,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":3,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"media\":{\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3,\"horizontalGap\":3,\"verticalGap\":0,\"custom\":{\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"}}}},\"mobile\":{\"layout\":{\"horizontalGap\":3,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"custom\":{\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"type\":\"hop-row\",\"nodeId\":\"1726-m24\",\"v\":\"1.1\",\"nodes\":[\"435-m6\",\"2037-m6\"],\"style\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},{\"id\":671,\"type\":\"hop-column\",\"nodeId\":\"1726-m25\",\"style\":{\"textAlign\":\"left\",\"border\":{\"top\":{\"style\":\"solid\",\"color\":\"rgb(238, 238, 238)\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"solid\",\"color\":\"rgb(238, 238, 238)\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"solid\",\"color\":\"rgb(238, 238, 238)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"left\":{\"style\":\"solid\",\"color\":\"rgb(238, 238, 238)\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"textAlign\":\"center\"}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"v\":\"1.1\",\"nodes\":[\"435-m7\",\"2037-m7\"],\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":3,\"vSpace\":{\"value\":\"10\"}},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":3}}}}},{\"id\":672,\"type\":\"hop-post-meta\",\"nodeId\":\"1706-c23\",\"style\":{\"descendants\":{\"icons\":{\"display\":\"none\",\"height\":{\"value\":\"18\"},\"width\":{\"value\":\"18\"},\"margin\":{\"right\":{\"value\":\"5\"}}},\"metaDataLinks\":{\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.5|variant1}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"rgb(0, 0, 0)\"}}}},\"metaDataPrefix\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}}},\"metaDataSuffix\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"color\":\"${theme.colors.5|variant2}\"}}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"435-m8\",\"2037-m8\"]},{\"id\":673,\"type\":\"hop-post-meta\",\"nodeId\":\"19-m9\",\"style\":{\"descendants\":{\"icons\":{\"display\":\"none\",\"height\":{\"value\":\"18\"},\"width\":{\"value\":\"18\"},\"margin\":{\"right\":{\"value\":\"5\"}}},\"metaDataLinks\":{\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.5|variant1}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"rgb(0, 0, 0)\"}}}},\"metaDataPrefix\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}}},\"metaDataSuffix\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"color\":\"${theme.colors.5|variant2}\"}}}},\"v\":\"1.1\",\"nodes\":[\"435-m9\",\"2037-m9\"]},{\"id\":674,\"type\":\"hop-post-title\",\"nodeId\":\"26-m10\",\"style\":{\"descendants\":{\"title\":{\"transition\":{\"duration\":{\"value\":\"0.5\"}}}}},\"v\":\"1.1\",\"nodes\":[\"435-m10\",\"2037-m10\"]},{\"id\":675,\"type\":\"hop-post-excerpt\",\"nodeId\":\"26-m11\",\"style\":{\"descendants\":{\"excerpt\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}}},\"v\":\"1.1\",\"nodes\":[\"435-m11\",\"2037-m11\"]},{\"id\":676,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"equalHeight\":true,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"media\":{\"mobile\":{\"layout\":{\"itemsPerRow\":2,\"horizontalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"verticalGap\":0}}}},\"type\":\"hop-row\",\"nodeId\":\"1706-c20\",\"v\":\"1.1\",\"nodes\":[\"435-m12\",\"2037-m12\"]},{\"id\":677,\"type\":\"hop-column\",\"nodeId\":\"1726-m20\",\"style\":{\"textAlign\":\"left\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"},\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":2,\"vSpace\":{\"value\":\"10\"}},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":3}}}},\"v\":\"1.1\",\"nodes\":[\"435-m13\",\"2037-m13\"]},{\"id\":678,\"type\":\"hop-post-meta\",\"nodeId\":\"19-m25\",\"nodes\":[\"435-m14\",\"2037-m14\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"metaDataLinks\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}},\"typography\":{\"color\":\"${theme.colors.0}\",\"decoration\":\"none\"}},\"icons\":{\"display\":\"inline-block\",\"height\":{\"value\":\"24\"},\"width\":{\"value\":\"24\"},\"margin\":{\"right\":{\"value\":\"5\"}}}}}},{\"id\":679,\"type\":\"hop-column\",\"nodeId\":\"1726-m21\",\"style\":{\"textAlign\":\"right\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"},\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":2,\"vSpace\":{\"value\":\"10\"}},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":3}}}},\"v\":\"1.1\",\"nodes\":[\"435-m15\",\"2037-m15\"]},{\"id\":680,\"type\":\"hop-post-read-more-group\",\"nodeId\":\"19-m32\",\"nodes\":[\"435-m16\",\"2037-m16\"],\"v\":\"1.1\"},{\"id\":681,\"type\":\"hop-post-read-more\",\"nodeId\":\"19-m33\",\"nodes\":[\"435-m17\",\"2037-m17\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"center\",\"typography\":{\"color\":\"${theme.colors.0}\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"weight\":\"400\",\"lineHeight\":{\"value\":\"1.6\",\"unit\":\"\"},\"letterSpacing\":{\"value\":\"\",\"unit\":\"px\"}},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"margin\":{\"left\":{\"value\":\"5\",\"unit\":\"px\",\"path\":\"value\"},\"right\":{\"value\":0,\"unit\":\"px\"}}}}},\"props\":{\"showIcon\":true,\"iconPosition\":\"after\"}},{\"id\":682,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalAlign\":\"end\"},\"media\":{\"mobile\":{\"layout\":{\"horizontalAlign\":\"center\"}}}},\"type\":\"hop-post-nav-container\",\"nodeId\":\"19-m36\",\"nodes\":[\"435-m18\",\"2037-m18\"],\"v\":\"1.1\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(224, 224, 224)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(224, 224, 224)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(224, 224, 224)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(224, 224, 224)\"}},\"margin\":{\"top\":{\"value\":\"45\",\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"45\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"45\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}}}}},{\"id\":683,\"type\":\"hop-column\",\"nodeId\":\"19-m37\",\"nodes\":[\"435-m19\",\"2037-m19\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"15\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}},{\"id\":684,\"type\":\"hop-archive-nav-button\",\"nodeId\":\"26-m20\",\"v\":\"1.1\",\"nodes\":[\"435-m20\",\"2037-m20\"],\"style\":{\"descendants\":{\"paginationNavigationButton\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.5|variant3}\"},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":0},\"right\":{\"value\":0}}},\"bottom\":{\"radius\":{\"left\":{\"value\":0},\"right\":{\"value\":0}}}}}}}},{\"id\":685,\"type\":\"hop-column\",\"nodeId\":\"19-m39\",\"nodes\":[\"435-m21\",\"2037-m21\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}},{\"id\":686,\"type\":\"hop-archive-pagination\",\"nodeId\":\"26-m14\",\"style\":{\"descendants\":{\"paginationNumbers\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}}},\"paginationActiveNumber\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"typography\":{\"color\":\"${theme.colors.0}\"}}}},\"v\":\"1.1\",\"nodes\":[\"435-m22\",\"2037-m22\"]},{\"id\":687,\"type\":\"hop-column\",\"nodeId\":\"19-m38\",\"nodes\":[\"435-m23\",\"2037-m23\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"15\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}},{\"id\":688,\"type\":\"hop-archive-nav-button\",\"nodeId\":\"26-m21\",\"style\":{\"descendants\":{\"paginationNavigationButton\":{\"border\":{\"bottom\":{\"color\":\"${theme.colors.5}\",\"radius\":{\"left\":{\"value\":0},\"right\":{\"value\":0}}},\"top\":{\"color\":\"${theme.colors.5}\",\"radius\":{\"left\":{\"value\":0},\"right\":{\"value\":0}}},\"left\":{\"color\":\"${theme.colors.5}\"},\"right\":{\"color\":\"${theme.colors.5}\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"typography\":{\"color\":\"${theme.colors.5|variant3}\",\"decoration\":\"none\"}}}},\"v\":\"1.1\",\"nodes\":[\"435-m24\",\"2037-m24\"]},{\"id\":689,\"type\":\"hop-sidebar\",\"nodeId\":\"4455-s1\",\"props\":{\"attrs\":{\"overflowOption\":\"visible\"}},\"v\":\"1.1\",\"nodes\":[\"438-s1\",\"2040-s1\"]},{\"id\":690,\"type\":\"hop-section\",\"nodeId\":\"28-s9\",\"nodes\":[\"438-s2\",\"2040-s2\"],\"style\":{\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"0\"}}}}},\"v\":\"1.1\"},{\"id\":691,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"28-s13\",\"nodes\":[\"438-s13\",\"2040-s13\"],\"v\":\"1.1\"},{\"id\":692,\"type\":\"hop-column\",\"nodeId\":\"28-s14\",\"nodes\":[\"438-s14\",\"2040-s14\"],\"v\":\"1.1\"},{\"id\":693,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"28-s15\",\"nodes\":[\"438-s15\",\"2040-s15\"],\"v\":\"1.1\"},{\"id\":694,\"type\":\"hop-text\",\"nodeId\":\"28-s16\",\"nodes\":[\"438-s16\",\"2040-s16\"],\"v\":\"1.1\"},{\"id\":695,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"itemsPerRow\":1},\"media\":{\"mobile\":{\"layout\":{\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"28-s10\",\"nodes\":[\"438-s3\",\"2040-s3\"],\"v\":\"1.1\"},{\"id\":696,\"type\":\"hop-column\",\"nodeId\":\"28-s12\",\"nodes\":[\"438-s4\",\"2040-s4\"],\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"v\":\"1.1\",\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}},{\"id\":697,\"type\":\"hop-widget-area\",\"nodeId\":\"1719-s2\",\"style\":{\"descendants\":{\"widgetBox\":{\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"20\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"mobile\":{\"textAlign\":\"center\"}}},\"widgetListItemLink\":{\"typography\":{\"color\":\"${theme.colors.4|variant3}\",\"decoration\":\"none\",\"weight\":\"400\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"family\":\"Open Sans\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"rgb(0, 0, 0)\"}}}},\"widgetListItem\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"decoration\":\"none\",\"weight\":\"400\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"family\":\"Open Sans\"},\"padding\":{\"top\":{\"value\":\"4\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"4\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}}},\"widgetTitle\":{\"typography\":{\"color\":\"${theme.colors.5}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"weight\":\"600\",\"family\":\"Open Sans\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"}},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"widgetList\":{\"listStyleType\":\"none\"},\"widgetInput\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"16\"}},\"states\":{\"focus\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}},\"border\":{\"top\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"bottom\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"}}}},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}}},\"v\":\"1.1\",\"nodes\":[\"438-s5\",\"2040-s5\"]},{\"id\":698,\"type\":\"hop-search-widget\",\"nodeId\":\"1719-s3\",\"style\":{\"descendants\":{\"widget-box\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"color\":\"rgb(238, 238, 238)\",\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"color\":\"rgb(238, 238, 238)\",\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"right\":{\"color\":\"rgb(238, 238, 238)\",\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"left\":{\"color\":\"rgb(238, 238, 238)\",\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},\"background\":{\"color\":\"\"}},\"widget-title\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}},\"typography\":{\"color\":\"${theme.colors.5}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"}}},\"widget-input\":{\"border\":{\"top\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"}},\"style\":\"none\"},\"bottom\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"}},\"style\":\"none\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"12\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"12\",\"unit\":\"px\"}},\"background\":{\"color\":\"rgb(249, 250, 251)\"},\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}},\"widget-button\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"states\":{\"hover\":{\"background\":{\"color\":\"rgb(249, 250, 251)\"},\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}},\"typography\":{\"color\":\"${theme.colors.5}\"},\"display\":\"inline-block\",\"background\":{\"color\":\"rgb(249, 250, 251)\"}},\"widget-button-icon\":{\"display\":\"inline-block\"},\"widget-button-text\":{\"display\":\"none\"},\"widget-input-placeholder\":{\"color\":\"${theme.colors.5|variant2}\"}}},\"v\":\"1.1\",\"nodes\":[\"438-s6\",\"2040-s6\"],\"props\":{\"attrs\":{\"overflowOption\":\"visible\"}}},{\"id\":699,\"type\":\"hop-recent-post-widget\",\"nodeId\":\"1719-s4\",\"v\":\"1.1\",\"nodes\":[\"438-s7\",\"2040-s7\"]},{\"id\":700,\"type\":\"hop-recent-comments-widget\",\"nodeId\":\"1719-s5\",\"v\":\"1.1\",\"nodes\":[\"438-s8\",\"2040-s8\"]},{\"id\":701,\"type\":\"hop-archives-widget\",\"nodeId\":\"1719-s6\",\"v\":\"1.1\",\"props\":{\"frame\":{\"type\":\"border\"},\"enabledFrameOption\":false,\"showFrameOverImage\":false,\"showFrameShadow\":false},\"nodes\":[\"438-s9\",\"2040-s9\"]},{\"id\":702,\"type\":\"hop-categories-widget\",\"nodeId\":\"1719-s7\",\"v\":\"1.1\",\"nodes\":[\"438-s10\",\"2040-s10\"]},{\"id\":703,\"type\":\"hop-meta-widget\",\"nodeId\":\"1719-s8\",\"v\":\"1.1\",\"nodes\":[\"438-s11\",\"2040-s11\"]},{\"id\":704,\"type\":\"hop-text-widget\",\"nodeId\":\"28-s16\",\"nodes\":[\"438-s12\",\"2040-s12\"],\"v\":\"1.1\"},{\"id\":705,\"type\":\"hop-copyright\",\"nodeId\":\"7-h44\",\"nodes\":[\"7-h38\",\"2896-h41\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"color\":\"rgba(255, 255, 255, 0.5)\"}}},{\"id\":708,\"type\":\"hop-main\",\"nodeId\":\"35-m1\",\"v\":\"1.1\",\"nodes\":[\"636-m1\",\"2106-m1\"]},{\"id\":709,\"type\":\"hop-row\",\"nodeId\":\"1735-m2\",\"props\":{\"layout\":{\"itemsPerRow\":2,\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"636-m2\",\"2106-m2\"]},{\"id\":710,\"type\":\"hop-column\",\"nodeId\":\"35-m3\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"636-m3\",\"2106-m3\"]},{\"id\":711,\"type\":\"hop-heading\",\"nodeId\":\"1735-m11\",\"style\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\",\"size\":{\"unit\":\"em\",\"value\":\"10\"}}},\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"636-m4\",\"2106-m4\"]},{\"id\":712,\"type\":\"hop-text\",\"nodeId\":\"1735-m12\",\"v\":\"1.1\",\"nodes\":[\"636-m5\",\"2106-m5\"]},{\"id\":713,\"type\":\"hop-home-button-group\",\"nodeId\":\"22-m8\",\"v\":\"1.1\",\"nodes\":[\"636-m6\",\"2106-m6\"]},{\"id\":714,\"type\":\"hop-home-button\",\"nodeId\":\"22-m9\",\"style\":{\"background\":{\"color\":\"rgba(3, 169, 244, 0)\"},\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(2, 110, 159, 0)\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"typography\":{\"color\":\"${theme.colors.0}\",\"transform\":\"none\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"weight\":\"400\",\"lineHeight\":{\"value\":\"1.5\"},\"family\":\"Open Sans\",\"margin\":{\"bottom\":\"2rem\"},\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"descendants\":{\"icon\":{\"size\":{\"value\":\"16\",\"unit\":\"px\"},\"margin\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}}},\"textAlign\":\"center\"},\"props\":{\"showIcon\":true,\"iconPosition\":\"after\"},\"v\":\"1.1\",\"nodes\":[\"636-m7\",\"2106-m7\"]},{\"id\":715,\"type\":\"hop-main\",\"nodeId\":\"38-m1\",\"v\":\"1.1\",\"nodes\":[\"639-m1\",\"2109-m1\"]},{\"id\":716,\"type\":\"hop-archive-loop\",\"nodeId\":\"1738-m4\",\"props\":{\"layout\":{\"horizontalGap\":3,\"verticalGap\":3,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"itemsPerRow\":1,\"horizontalAlign\":\"start\",\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"}}},\"showMasonry\":false,\"media\":{\"mobile\":{\"layout\":{\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":2}}}},\"v\":\"1.1\",\"nodes\":[\"639-m2\",\"2109-m2\"],\"style\":{\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},{\"id\":717,\"type\":\"hop-loop-item\",\"nodeId\":\"1706-c10\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"y\":\"10\",\"spread\":\"0\",\"blur\":\"40\",\"color\":\"rgba(1, 51, 74, 0.15)\"}]},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}}},\"padding\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"textAlign\":\"left\"},\"v\":\"1.1\",\"nodes\":[\"639-m3\",\"2109-m3\"],\"props\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}},{\"id\":718,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-post-categories-container\",\"nodeId\":\"25-m20\",\"nodes\":[\"639-m4\",\"2109-m4\"],\"v\":\"1.1\",\"style\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},{\"id\":719,\"type\":\"hop-column\",\"nodeId\":\"25-m21\",\"nodes\":[\"639-m5\",\"2109-m5\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\"}},{\"id\":720,\"type\":\"hop-post-categories\",\"nodeId\":\"1738-m11\",\"style\":{\"descendants\":{\"categoriesLinks\":{\"typography\":{\"transform\":\"lowercase\",\"color\":\"${theme.colors.5|variant1}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"639-m6\",\"2109-m6\"]},{\"id\":721,\"type\":\"hop-post-title\",\"nodeId\":\"38-m7\",\"v\":\"1.1\",\"nodes\":[\"639-m7\",\"2109-m7\"]},{\"id\":722,\"type\":\"hop-post-meta\",\"nodeId\":\"1706-c21\",\"style\":{\"descendants\":{\"metaDataLinks\":{\"typography\":{\"color\":\"${theme.colors.5|variant1}\",\"transform\":\"lowercase\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"decoration\":\"none\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5}\"}}}},\"icons\":{\"height\":{\"value\":\"24\"},\"width\":{\"value\":\"24\"},\"margin\":{\"right\":{\"value\":\"5\"}},\"display\":\"none\"},\"metaDataPrefix\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"color\":\"${theme.colors.5|variant2}\"}},\"metaDataSuffix\":{\"typography\":{\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"color\":\"${theme.colors.5|variant1}\"}},\"separators\":{\"typography\":{\"color\":\"${theme.colors.5|variant1}\"}}}},\"v\":\"1.1\",\"nodes\":[\"639-m8\",\"2109-m8\"]},{\"id\":723,\"type\":\"hop-post-excerpt\",\"nodeId\":\"38-m8\",\"v\":\"1.1\",\"nodes\":[\"639-m9\",\"2109-m9\"],\"style\":{\"descendants\":{\"excerpt\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}}}},{\"id\":724,\"type\":\"hop-post-read-more-group\",\"nodeId\":\"25-m20\",\"nodes\":[\"639-m10\",\"2109-m10\"],\"v\":\"1.1\"},{\"id\":725,\"type\":\"hop-post-read-more\",\"nodeId\":\"25-m21\",\"nodes\":[\"639-m11\",\"2109-m11\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"center\",\"typography\":{\"color\":\"${theme.colors.0}\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"weight\":\"400\",\"lineHeight\":{\"value\":\"1.6\",\"unit\":\"\"},\"letterSpacing\":{\"value\":\"\",\"unit\":\"px\"}},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"\",\"unit\":\"px\",\"path\":\"value\"},\"radius\":{\"right\":{\"value\":\"\",\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":\"\",\"unit\":\"px\",\"path\":\"value\"}}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"\",\"unit\":\"px\",\"path\":\"value\"},\"radius\":{\"right\":{\"value\":\"\",\"unit\":\"px\",\"path\":\"value\"},\"left\":{\"value\":\"\",\"unit\":\"px\",\"path\":\"value\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"\",\"unit\":\"px\",\"path\":\"value\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"\",\"unit\":\"px\",\"path\":\"value\"}}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0|variant3}\"}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"margin\":{\"left\":{\"value\":\"5\",\"unit\":\"px\",\"path\":\"value\"},\"right\":{\"value\":0,\"unit\":\"px\"}}}}},\"props\":{\"showIcon\":true,\"iconPosition\":\"after\"}},{\"id\":726,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-post-nav-container\",\"nodeId\":\"25-m22\",\"nodes\":[\"639-m12\",\"2109-m12\"],\"v\":\"1.1\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(224, 224, 224)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(224, 224, 224)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(224, 224, 224)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(224, 224, 224)\"}},\"margin\":{\"top\":{\"value\":\"45\",\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"45\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"45\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}}}}},{\"id\":727,\"type\":\"hop-column\",\"nodeId\":\"25-m22\",\"nodes\":[\"639-m13\",\"2109-m13\"],\"v\":\"1.1\"},{\"id\":728,\"type\":\"hop-column\",\"nodeId\":\"25-m23\",\"nodes\":[\"639-m14\",\"2109-m14\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"15\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}},{\"id\":729,\"type\":\"hop-archive-nav-button\",\"nodeId\":\"1725-m29\",\"style\":{\"descendants\":{\"paginationNavigationButton\":{\"typography\":{\"decoration\":\"none\",\"color\":\"${theme.colors.5|variant3}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"639-m15\",\"2109-m15\"]},{\"id\":730,\"type\":\"hop-column\",\"nodeId\":\"25-m41\",\"nodes\":[\"639-m16\",\"2109-m16\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}},{\"id\":731,\"type\":\"hop-archive-pagination\",\"nodeId\":\"26-m14\",\"style\":{\"descendants\":{\"paginationNumbers\":{\"typography\":{\"color\":\"${theme.colors.5}\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"},\"size\":{\"unit\":\"px\",\"value\":\"16\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}}},\"paginationActiveNumber\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"typography\":{\"color\":\"${theme.colors.0}\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"},\"size\":{\"unit\":\"px\",\"value\":\"16\"}}}}},\"v\":\"1.1\",\"nodes\":[\"639-m17\",\"2109-m17\"]},{\"id\":732,\"type\":\"hop-column\",\"nodeId\":\"25-m24\",\"nodes\":[\"639-m18\",\"2109-m18\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"15\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":2}}},{\"id\":733,\"type\":\"hop-archive-nav-button\",\"nodeId\":\"1725-m27\",\"style\":{\"descendants\":{\"paginationNavigationButton\":{\"typography\":{\"color\":\"${theme.colors.5|variant3}\",\"decoration\":\"none\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"639-m19\",\"2109-m19\"]},{\"id\":734,\"type\":\"hop-row\",\"nodeId\":\"38-m2\",\"props\":{\"layout\":{\"itemsPerRow\":1,\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":1,\"verticalInnerGap\":0,\"custom\":{\"horizontalGap\":{\"unit\":\"px\"},\"verticalGap\":{\"unit\":\"px\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}}}},\"v\":\"1.1\",\"nodes\":[\"639-m20\",\"2109-m20\"]},{\"id\":735,\"type\":\"hop-column\",\"nodeId\":\"38-m3\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"v\":\"1.1\",\"nodes\":[\"639-m21\",\"2109-m21\"],\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}},{\"id\":736,\"type\":\"hop-archive-navigation\",\"nodeId\":\"38-m9\",\"v\":\"1.1\",\"nodes\":[\"639-m22\",\"2109-m22\"]},{\"id\":737,\"type\":\"hop-section\",\"nodeId\":\"173-c6\",\"nodes\":[\"173-c2\",\"2921-c2\"],\"v\":\"1.1\",\"props\":{\"width\":\"boxed\"}},{\"id\":738,\"props\":{\"layout\":{\"equalWidth\":false},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"173-c7\",\"nodes\":[\"173-c3\",\"2921-c3\"],\"v\":\"1.1\"},{\"id\":739,\"type\":\"hop-column\",\"nodeId\":\"173-c8\",\"nodes\":[\"173-c4\",\"2921-c4\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}}}},{\"id\":748,\"type\":\"hop-sidebar\",\"nodeId\":\"4455-s1\",\"props\":{\"attrs\":{\"overflowOption\":\"visible\"}},\"v\":\"1.1\",\"nodes\":[\"438-s1\",\"2433-s1\"]},{\"id\":749,\"type\":\"hop-section\",\"nodeId\":\"28-s9\",\"nodes\":[\"438-s2\",\"2433-s2\"],\"style\":{\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"0\"}}}}},\"v\":\"1.1\"},{\"id\":750,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"28-s13\",\"nodes\":[\"438-s13\",\"2433-s13\"],\"v\":\"1.1\"},{\"id\":751,\"type\":\"hop-column\",\"nodeId\":\"28-s14\",\"nodes\":[\"438-s14\",\"2433-s14\"],\"v\":\"1.1\"},{\"id\":752,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"28-s15\",\"nodes\":[\"438-s15\",\"2433-s15\"],\"v\":\"1.1\"},{\"id\":753,\"type\":\"hop-text\",\"nodeId\":\"28-s16\",\"nodes\":[\"438-s16\",\"2433-s16\"],\"v\":\"1.1\"},{\"id\":754,\"props\":{\"layout\":{\"equalWidth\":false,\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"},\"horizontalInnerGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalInnerGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":0,\"verticalGap\":0,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"itemsPerRow\":1},\"media\":{\"mobile\":{\"layout\":{\"custom\":{\"horizontalGap\":{\"unit\":\"px\",\"value\":\"\"},\"verticalGap\":{\"unit\":\"px\",\"value\":\"\"}},\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"nodeId\":\"28-s10\",\"nodes\":[\"438-s3\",\"2433-s3\"],\"v\":\"1.1\"},{\"id\":755,\"type\":\"hop-column\",\"nodeId\":\"28-s12\",\"nodes\":[\"438-s4\",\"2433-s4\"],\"style\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"v\":\"1.1\",\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}}},{\"id\":756,\"type\":\"hop-widget-area\",\"nodeId\":\"1719-s2\",\"style\":{\"descendants\":{\"widgetBox\":{\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"20\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"mobile\":{\"textAlign\":\"center\"}}},\"widgetListItemLink\":{\"typography\":{\"color\":\"${theme.colors.4|variant3}\",\"decoration\":\"none\",\"weight\":\"400\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"family\":\"Open Sans\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"rgb(0, 0, 0)\"}}}},\"widgetListItem\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"decoration\":\"none\",\"weight\":\"400\",\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"family\":\"Open Sans\"},\"padding\":{\"top\":{\"value\":\"4\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"4\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}}},\"widgetTitle\":{\"typography\":{\"color\":\"${theme.colors.5}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"},\"weight\":\"600\",\"family\":\"Open Sans\",\"lineHeight\":{\"unit\":\"\",\"value\":\"1.6\"}},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"widgetList\":{\"listStyleType\":\"none\"},\"widgetInput\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\",\"weight\":\"400\",\"family\":\"Open Sans\",\"size\":{\"unit\":\"px\",\"value\":\"16\"}},\"states\":{\"focus\":{\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}}},\"border\":{\"top\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"bottom\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"}}}},\"border\":{\"top\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}}},\"v\":\"1.1\",\"nodes\":[\"438-s5\",\"2433-s5\"]},{\"id\":757,\"type\":\"hop-search-widget\",\"nodeId\":\"1719-s3\",\"style\":{\"descendants\":{\"widget-box\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"color\":\"rgb(238, 238, 238)\",\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"color\":\"rgb(238, 238, 238)\",\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"right\":{\"color\":\"rgb(238, 238, 238)\",\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"left\":{\"color\":\"rgb(238, 238, 238)\",\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"\",\"unit\":\"px\"},\"right\":{\"value\":\"\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"\",\"unit\":\"px\"}}}},\"background\":{\"color\":\"\"}},\"widget-title\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"}}}},\"typography\":{\"color\":\"${theme.colors.5}\",\"size\":{\"unit\":\"px\",\"value\":\"16\"}}},\"widget-input\":{\"border\":{\"top\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"}},\"style\":\"none\"},\"bottom\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"}},\"style\":\"none\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"}},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"12\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"12\",\"unit\":\"px\"}},\"background\":{\"color\":\"rgb(249, 250, 251)\"},\"typography\":{\"color\":\"${theme.colors.5|variant2}\"}},\"widget-button\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"none\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"states\":{\"hover\":{\"background\":{\"color\":\"rgb(249, 250, 251)\"},\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"transition\":{\"duration\":{\"value\":\"0.5\"}},\"typography\":{\"color\":\"${theme.colors.5}\"},\"display\":\"inline-block\",\"background\":{\"color\":\"rgb(249, 250, 251)\"}},\"widget-button-icon\":{\"display\":\"inline-block\"},\"widget-button-text\":{\"display\":\"none\"},\"widget-input-placeholder\":{\"color\":\"${theme.colors.5|variant2}\"}}},\"v\":\"1.1\",\"nodes\":[\"438-s6\",\"2433-s6\"],\"props\":{\"attrs\":{\"overflowOption\":\"visible\"}}},{\"id\":758,\"type\":\"hop-recent-post-widget\",\"nodeId\":\"1719-s4\",\"v\":\"1.1\",\"nodes\":[\"438-s7\",\"2433-s7\"]},{\"id\":759,\"type\":\"hop-recent-comments-widget\",\"nodeId\":\"1719-s5\",\"v\":\"1.1\",\"nodes\":[\"438-s8\",\"2433-s8\"]},{\"id\":760,\"type\":\"hop-archives-widget\",\"nodeId\":\"1719-s6\",\"v\":\"1.1\",\"props\":{\"frame\":{\"type\":\"border\"},\"enabledFrameOption\":false,\"showFrameOverImage\":false,\"showFrameShadow\":false},\"nodes\":[\"438-s9\",\"2433-s9\"]},{\"id\":761,\"type\":\"hop-categories-widget\",\"nodeId\":\"1719-s7\",\"v\":\"1.1\",\"nodes\":[\"438-s10\",\"2433-s10\"]},{\"id\":762,\"type\":\"hop-meta-widget\",\"nodeId\":\"1719-s8\",\"v\":\"1.1\",\"nodes\":[\"438-s11\",\"2433-s11\"]},{\"id\":763,\"type\":\"hop-text-widget\",\"nodeId\":\"28-s16\",\"nodes\":[\"438-s12\",\"2433-s12\"],\"v\":\"1.1\"},{\"id\":764,\"type\":\"hop-column\",\"nodeId\":\"2896-h44\",\"nodes\":[\"2896-h31\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"right\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"vSpace\":{\"value\":15}}}},{\"id\":765,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"2901-c103\",\"nodes\":[\"2901-c103\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":766,\"type\":\"hop-column\",\"nodeId\":\"2901-c104\",\"nodes\":[\"2901-c104\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":767,\"type\":\"hop-post-nav-button\",\"nodeId\":\"2901-c105\",\"nodes\":[\"2901-c105\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":786,\"type\":\"hop-column\",\"nodeId\":\"2901-c124\",\"nodes\":[\"2901-c18\"],\"v\":\"1.1\"},{\"id\":787,\"type\":\"hop-widget-area\",\"nodeId\":\"2901-c125\",\"nodes\":[\"2901-c19\"],\"v\":\"1.1\"},{\"id\":788,\"type\":\"hop-calendar-widget\",\"nodeId\":\"2901-c126\",\"nodes\":[\"2901-c20\"],\"v\":\"1.1\"},{\"id\":789,\"type\":\"hop-down-arrow\",\"v\":\"1.1\",\"props\":{\"type\":\"icon\"},\"style\":{\"bottom\":{\"value\":\"20\"}},\"nodes\":[\"2896-h42\"]},{\"id\":790,\"type\":\"hop-down-arrow-scroll-button-group\",\"v\":\"1.1\",\"nodes\":[\"2896-h43\"]},{\"id\":791,\"type\":\"hop-down-arrow-scroll-button\",\"style\":{\"textAlign\":\"center\",\"background\":{\"color\":\"${theme.colors.0}\"},\"typography\":{\"color\":\"#fff\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"bottom\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"right\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"12\"},\"bottom\":{\"unit\":\"px\",\"value\":\"12\"},\"left\":{\"unit\":\"px\",\"value\":\"24\"},\"right\":{\"unit\":\"px\",\"value\":\"24\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0|variant3}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"props\":{\"buttonSize\":\"medium\",\"buttonWidth\":\"fitToContent\"},\"nodes\":[\"2896-h44\"]},{\"id\":792,\"type\":\"hop-down-arrow-scroll-icon\",\"style\":{\"descendants\":{\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"40\"},\"height\":{\"path\":\"value\",\"value\":\"40\"},\"fill\":\"${theme.colors.4}\"}}},\"v\":\"1.1\",\"nodes\":[\"2896-h45\"]},{\"id\":794,\"type\":\"hop-section\",\"nodeId\":\"2901-c22\",\"nodes\":[\"2901-c2\"],\"v\":\"1.1\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"http:\\/\\/localhost\\/site\\/wp-content\\/uploads\\/2025\\/01\\/ALCADO.jpg\",\"useFeaturedImg\":false},\"position\":\"center center\"}],\"overlay\":{\"enabled\":true,\"type\":\"gradient\",\"gradient\":{\"angle\":\"0\",\"steps\":[{\"color\":\"rgba(253, 252, 251, 0.8)\",\"position\":\"0\"},{\"color\":\"${theme.colors.4}\",\"position\":\"100\"}]}}},\"customHeight\":{\"type\":\"full-screen\"},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":-150,\"unit\":\"px\"}}}}},\"props\":{\"verticalAlign\":\"start\",\"showHeader\":false,\"width\":\"full-width\"}},{\"id\":795,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"2901-c23\",\"nodes\":[\"2901-c3\"],\"v\":\"1.1\",\"style\":{\"margin\":{\"top\":{\"value\":\"33\",\"unit\":\"px\"},\"right\":{\"value\":\"33\",\"unit\":\"px\"},\"bottom\":{\"value\":\"33\",\"unit\":\"px\"},\"left\":{\"value\":\"33\",\"unit\":\"px\"}}}},{\"id\":796,\"type\":\"hop-column\",\"nodeId\":\"2901-c24\",\"nodes\":[\"2901-c4\"],\"v\":\"1.1\"},{\"id\":797,\"type\":\"hop-column\",\"nodeId\":\"2901-c25\",\"nodes\":[\"2901-c18\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"left\"}},{\"id\":798,\"type\":\"hop-column\",\"nodeId\":\"2901-c26\",\"nodes\":[\"2901-c18\"],\"v\":\"1.1\"},{\"id\":801,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-post-nav-container\",\"nodeId\":\"2901-c29\",\"nodes\":[\"2901-c21\"],\"v\":\"1.1\"},{\"id\":803,\"type\":\"hop-column\",\"nodeId\":\"2901-c31\",\"nodes\":[\"2901-c37\"],\"v\":\"1.1\",\"props\":{\"layout\":{\"vSpace\":{\"value\":5}}}},{\"id\":806,\"type\":\"hop-text\",\"nodeId\":\"2901-c38\",\"nodes\":[\"2901-c22\"],\"v\":\"1.1\"},{\"id\":807,\"type\":\"hop-blog-posts\",\"style\":{\"descendants\":{\"metaDataBar\":{\"typography\":{\"color\":\"${theme.colors.4|variant1}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"background\":{\"color\":\"${theme.colors.0|variant0}\"}},\"metaDataBarIconSvg\":{\"height\":{\"path\":\"value\",\"value\":\"12\"},\"width\":{\"path\":\"value\",\"value\":\"12\"}},\"readMoreButton\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.1}\"}}},\"typography\":{\"color\":\"${theme.colors.0}\"},\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\",\"value\":\"30\"},\"bottom\":{\"unit\":\"px\",\"value\":\"15\"},\"left\":{\"unit\":\"px\",\"value\":\"30\"}}},\"postCategory\":{\"typography\":{\"color\":\"rgba(9, 33, 42, 0.7)\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(227, 228, 229)\",\"radius\":{\"left\":{\"value\":\"3\",\"unit\":\"px\"},\"right\":{\"value\":\"3\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(227, 228, 229)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(227, 228, 229)\",\"radius\":{\"left\":{\"value\":\"3\",\"unit\":\"px\"},\"right\":{\"value\":\"3\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(227, 228, 229)\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"typography\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0}\"},\"bottom\":{\"color\":\"${theme.colors.0}\"},\"right\":{\"color\":\"${theme.colors.0}\"},\"left\":{\"color\":\"${theme.colors.0}\"}}}}},\"postTitle\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}}},\"postExcerpt\":{\"typography\":{\"color\":\"rgba(0, 0, 0, 0.8)\"},\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}}},\"metaDataBarIconPath\":{\"fill\":\"${theme.colors.4|variant1}\"},\"postContainer\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"color\":\"rgb(227, 228, 229)\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}},\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"right\":{\"style\":\"solid\",\"color\":\"rgb(227, 228, 229)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"solid\",\"color\":\"rgb(227, 228, 229)\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}},\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"left\":{\"style\":\"solid\",\"color\":\"rgb(227, 228, 229)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}}}},\"blogColumn\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"postImage\":{\"boxShadow\":{\"enabled\":false},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}}}},\"props\":{\"layout\":{\"horizontalGap\":1,\"verticalGap\":1,\"itemsPerRow\":1,\"horizontalAlign\":\"start\"},\"postOrder\":[{\"id\":\"1\",\"name\":\"image\",\"value\":\"Image\"},{\"id\":\"3\",\"name\":\"title\",\"value\":\"Title\"},{\"id\":\"4\",\"name\":\"excerpt\",\"value\":\"Excerpt\"},{\"id\":\"5\",\"name\":\"metaData\",\"value\":\"Metadata\"},{\"id\":\"2\",\"name\":\"category\",\"value\":\"Category\"},{\"id\":\"6\",\"name\":\"readButton\",\"value\":\"Read More Button\"}],\"titleType\":\"h4\",\"metaDataOrder\":[{\"name\":\"author\",\"value\":\"Author\",\"check\":true},{\"name\":\"date\",\"value\":\"Date\",\"check\":true},{\"name\":\"time\",\"value\":\"Time\",\"check\":false},{\"name\":\"comments\",\"value\":\"Comments\",\"check\":true},{\"name\":\"readButton\",\"value\":\"Read Button\",\"check\":false},{\"name\":\"spacer\",\"value\":\"Spacer\",\"check\":false}],\"metaDataSeparator\":\" - \",\"excerptLength\":\"33\",\"showMetadata\":false,\"showCategory\":false,\"showMasonry\":true,\"media\":{\"tablet\":{\"layout\":{\"itemsPerRow\":2}}}},\"v\":\"1.1\",\"nodes\":[\"2901-c39\"]},{\"id\":808,\"type\":\"hop-loop-item\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\",\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\",\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"3\",\"color\":\"rgba(204, 204, 204, 0.5)\",\"spread\":\"0\"}]},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"textAlign\":\"left\"},\"v\":\"1.1\",\"nodes\":[\"2901-c40\"]},{\"id\":810,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":2,\"verticalInnerGap\":2},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"2901-c42\"]},{\"id\":811,\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"left\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"v\":\"1.1\",\"nodes\":[\"2901-c43\"]},{\"id\":812,\"type\":\"hop-post-categories\",\"style\":{\"descendants\":{\"categoriesLinks\":{\"typography\":{\"color\":\"${theme.colors.0}\"},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.1}\"}}}}},\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"20\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"2901-c44\"]},{\"id\":813,\"type\":\"hop-post-title\",\"style\":{\"descendants\":{\"title\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.1}\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"2901-c45\"]},{\"id\":814,\"type\":\"hop-post-excerpt\",\"v\":\"1.1\",\"nodes\":[\"2901-c46\"]},{\"id\":815,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":1,\"verticalInnerGap\":1,\"equalHeight\":true},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"}}},\"v\":\"1.1\",\"nodes\":[\"2901-c47\"]},{\"id\":816,\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"padding\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}},\"textAlign\":\"left\"},\"props\":{\"layout\":{\"vSpace\":{\"value\":0},\"horizontalInnerGap\":2,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"2901-c48\"]},{\"id\":817,\"type\":\"hop-post-meta\",\"style\":{\"descendants\":{\"icons\":{\"display\":\"none\"},\"metaDataLinks\":{\"typography\":{\"color\":\"${theme.colors.4|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.1}\"}}},\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"metaDataPrefix\":{\"typography\":{\"color\":\"${theme.colors.4|variant4}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}}},\"metaDataSuffix\":{\"typography\":{\"color\":\"${theme.colors.4|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}}}}},\"v\":\"1.1\",\"nodes\":[\"2901-c49\"]},{\"id\":818,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"right\",\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"textAlign\":\"right\"}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":0},\"horizontalInnerGap\":2,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"2901-c50\"]},{\"id\":819,\"type\":\"hop-post-read-more-group\",\"v\":\"1.1\",\"nodes\":[\"2901-c51\"]},{\"id\":820,\"type\":\"hop-post-read-more\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":\"3\",\"unit\":\"px\",\"path\":\"value\"}},\"size\":{\"value\":\"16\",\"unit\":\"px\"}}},\"background\":{\"color\":\"rgba(3, 169, 244, 0)\"},\"border\":{\"top\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}}},\"typography\":{\"color\":\"${theme.colors.0}\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"0\"},\"size\":{\"unit\":\"px\",\"value\":\"14\"},\"transform\":\"none\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"weight\":\"600\"},\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(2, 110, 159, 0)\"},\"typography\":{\"color\":\"${theme.colors.1}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"textAlign\":\"center\"},\"props\":{\"showIcon\":true,\"iconPosition\":\"after\"},\"v\":\"1.1\",\"nodes\":[\"2901-c52\"]},{\"id\":822,\"type\":\"hop-text\",\"nodeId\":\"2901-c44\",\"nodes\":[\"2901-c20\"],\"v\":\"1.1\"},{\"id\":823,\"type\":\"hop-post-excerpt\",\"nodeId\":\"2901-c45\",\"nodes\":[\"2901-c19\"],\"v\":\"1.1\"},{\"id\":824,\"type\":\"hop-column\",\"nodeId\":\"2901-c28\",\"nodes\":[\"2901-c23\"],\"v\":\"1.1\"},{\"id\":825,\"type\":\"hop-image\",\"nodeId\":\"2901-c29\",\"nodes\":[\"2901-c29\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":826,\"type\":\"hop-button-group\",\"nodeId\":\"2901-c29\",\"nodes\":[\"2901-c29\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":827,\"type\":\"hop-button\",\"nodeId\":\"2901-c30\",\"nodes\":[\"2901-c30\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"center\",\"background\":{\"color\":\"${theme.colors.0}\"},\"typography\":{\"color\":\"#fff\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"weight\":\"600\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"transform\":\"uppercase\",\"letterSpacing\":{\"value\":\"1\",\"unit\":\"px\"}},\"border\":{\"top\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"bottom\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"right\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"left\":{\"color\":\"${theme.colors.0}\",\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}}},\"padding\":{\"top\":{\"unit\":\"px\",\"value\":\"12\"},\"bottom\":{\"unit\":\"px\",\"value\":\"12\"},\"left\":{\"unit\":\"px\",\"value\":\"24\"},\"right\":{\"unit\":\"px\",\"value\":\"24\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0|variant3}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"descendants\":{\"icon\":{\"size\":{\"unit\":\"px\",\"value\":\"12\"},\"margin\":{\"left\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"}}}},\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":828,\"type\":\"hop-row\",\"nodeId\":\"2901-c31\",\"nodes\":[\"2901-c35\"],\"v\":\"1.1\"},{\"id\":829,\"type\":\"hop-column\",\"nodeId\":\"2901-c32\",\"nodes\":[\"2901-c36\"],\"v\":\"1.1\"},{\"id\":830,\"type\":\"hop-column\",\"nodeId\":\"2901-c33\",\"nodes\":[\"2901-c37\"],\"v\":\"1.1\"},{\"id\":831,\"type\":\"hop-text\",\"nodeId\":\"2901-c34\",\"nodes\":[\"2901-c19\",\"2901-c34\"],\"v\":\"1.1\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.0}\"}}}},\"props\":{\"type\":\"lead\",\"hide\":{\"mobile\":true}}},{\"id\":834,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-post-categories-container\",\"nodeId\":\"2901-c38\",\"nodes\":[\"2901-c20\"],\"v\":\"1.1\"},{\"id\":835,\"type\":\"hop-column\",\"nodeId\":\"2901-c39\",\"nodes\":[\"2901-c21\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"vSpace\":{\"value\":16}}}},{\"id\":852,\"type\":\"hop-post-excerpt\",\"nodeId\":\"2901-c56\",\"nodes\":[\"2901-c34\"],\"v\":\"1.1\"},{\"id\":853,\"type\":\"hop-blog-posts\",\"style\":{\"descendants\":{\"metaDataBar\":{\"typography\":{\"color\":\"${theme.colors.4|variant1}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"background\":{\"color\":\"${theme.colors.0|variant0}\"}},\"metaDataBarIconSvg\":{\"height\":{\"path\":\"value\",\"value\":\"12\"},\"width\":{\"path\":\"value\",\"value\":\"12\"}},\"readMoreButton\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.1}\"}}},\"typography\":{\"color\":\"${theme.colors.0}\"},\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\",\"value\":\"30\"},\"bottom\":{\"unit\":\"px\",\"value\":\"15\"},\"left\":{\"unit\":\"px\",\"value\":\"30\"}}},\"postCategory\":{\"typography\":{\"color\":\"rgba(9, 33, 42, 0.7)\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(227, 228, 229)\",\"radius\":{\"left\":{\"value\":\"3\",\"unit\":\"px\"},\"right\":{\"value\":\"3\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(227, 228, 229)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(227, 228, 229)\",\"radius\":{\"left\":{\"value\":\"3\",\"unit\":\"px\"},\"right\":{\"value\":\"3\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(227, 228, 229)\"}},\"states\":{\"hover\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"typography\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0}\"},\"bottom\":{\"color\":\"${theme.colors.0}\"},\"right\":{\"color\":\"${theme.colors.0}\"},\"left\":{\"color\":\"${theme.colors.0}\"}}}}},\"postTitle\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.0}\"}}},\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}}},\"postExcerpt\":{\"typography\":{\"color\":\"rgba(0, 0, 0, 0.8)\"},\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"30\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"30\",\"unit\":\"px\"}}},\"metaDataBarIconPath\":{\"fill\":\"${theme.colors.4|variant1}\"},\"postContainer\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"color\":\"rgb(227, 228, 229)\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}},\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"right\":{\"style\":\"solid\",\"color\":\"rgb(227, 228, 229)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"solid\",\"color\":\"rgb(227, 228, 229)\",\"radius\":{\"left\":{\"value\":\"9\",\"unit\":\"px\"},\"right\":{\"value\":\"9\",\"unit\":\"px\"}},\"width\":{\"value\":\"1\",\"unit\":\"px\"}},\"left\":{\"style\":\"solid\",\"color\":\"rgb(227, 228, 229)\",\"width\":{\"value\":\"1\",\"unit\":\"px\"}}}},\"blogColumn\":{\"padding\":{\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}},\"postImage\":{\"boxShadow\":{\"enabled\":false},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}},\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}}}},\"props\":{\"layout\":{\"horizontalGap\":1,\"verticalGap\":1,\"itemsPerRow\":1,\"horizontalAlign\":\"start\"},\"postOrder\":[{\"id\":\"1\",\"name\":\"image\",\"value\":\"Image\"},{\"id\":\"3\",\"name\":\"title\",\"value\":\"Title\"},{\"id\":\"4\",\"name\":\"excerpt\",\"value\":\"Excerpt\"},{\"id\":\"5\",\"name\":\"metaData\",\"value\":\"Metadata\"},{\"id\":\"2\",\"name\":\"category\",\"value\":\"Category\"},{\"id\":\"6\",\"name\":\"readButton\",\"value\":\"Read More Button\"}],\"titleType\":\"h4\",\"metaDataOrder\":[{\"name\":\"author\",\"value\":\"Author\",\"check\":true},{\"name\":\"date\",\"value\":\"Date\",\"check\":true},{\"name\":\"time\",\"value\":\"Time\",\"check\":false},{\"name\":\"comments\",\"value\":\"Comments\",\"check\":true},{\"name\":\"readButton\",\"value\":\"Read Button\",\"check\":false},{\"name\":\"spacer\",\"value\":\"Spacer\",\"check\":false}],\"metaDataSeparator\":\" - \",\"excerptLength\":\"33\",\"showMetadata\":false,\"showCategory\":false,\"showMasonry\":true,\"media\":{\"tablet\":{\"layout\":{\"itemsPerRow\":2}}},\"hide\":{\"mobile\":true}},\"v\":\"1.1\",\"nodes\":[\"2901-c22\"]},{\"id\":854,\"type\":\"hop-loop-item\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\",\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\",\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"3\",\"color\":\"rgba(204, 204, 204, 0.5)\",\"spread\":\"0\"}]},\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"2901-c23\"]},{\"id\":856,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":2,\"verticalInnerGap\":2},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"2901-c24\"]},{\"id\":857,\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"left\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"v\":\"1.1\",\"nodes\":[\"2901-c25\"]},{\"id\":859,\"type\":\"hop-post-title\",\"style\":{\"descendants\":{\"title\":{\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.1}\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"2901-c26\"]},{\"id\":860,\"type\":\"hop-post-excerpt\",\"v\":\"1.1\",\"nodes\":[\"2901-c27\"]},{\"id\":861,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":1,\"verticalInnerGap\":1,\"equalHeight\":true},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"rgb(238, 238, 238)\"}}},\"v\":\"1.1\",\"nodes\":[\"2901-c28\"]},{\"id\":862,\"type\":\"hop-column\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}}}},\"padding\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}},\"textAlign\":\"left\"},\"props\":{\"layout\":{\"vSpace\":{\"value\":0},\"horizontalInnerGap\":2,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"2901-c29\"]},{\"id\":863,\"type\":\"hop-post-meta\",\"style\":{\"descendants\":{\"icons\":{\"display\":\"none\"},\"metaDataLinks\":{\"typography\":{\"color\":\"${theme.colors.4|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}},\"states\":{\"hover\":{\"typography\":{\"color\":\"${theme.colors.1}\"}}},\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"metaDataPrefix\":{\"typography\":{\"color\":\"${theme.colors.4|variant4}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}}},\"metaDataSuffix\":{\"typography\":{\"color\":\"${theme.colors.4|variant3}\",\"size\":{\"unit\":\"px\",\"value\":\"14\"}}}}},\"v\":\"1.1\",\"nodes\":[\"2901-c30\"]},{\"id\":864,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"right\",\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"media\":{\"mobile\":{\"textAlign\":\"right\"}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":0},\"horizontalInnerGap\":2,\"verticalInnerGap\":0},\"verticalAlign\":\"center\"},\"v\":\"1.1\",\"nodes\":[\"2901-c31\"]},{\"id\":865,\"type\":\"hop-post-read-more-group\",\"v\":\"1.1\",\"nodes\":[\"2901-c32\"]},{\"id\":866,\"type\":\"hop-post-read-more\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":\"3\",\"unit\":\"px\",\"path\":\"value\"}},\"size\":{\"value\":\"11\",\"unit\":\"px\"}}},\"background\":{\"color\":\"rgba(3, 169, 244, 0)\"},\"border\":{\"top\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}},\"left\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"right\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"}},\"bottom\":{\"style\":\"none\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"radius\":{\"right\":{\"value\":5,\"unit\":\"px\"},\"left\":{\"value\":5,\"unit\":\"px\"}}}},\"typography\":{\"color\":\"${theme.colors.0}\",\"lineHeight\":{\"value\":\"1\",\"unit\":\"\"},\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"},\"size\":{\"unit\":\"px\",\"value\":\"11\"},\"transform\":\"\",\"family\":\"Open Sans\",\"margin\":{\"top\":\"\",\"bottom\":\"2rem\"},\"weight\":\"600\"},\"states\":{\"hover\":{\"background\":{\"color\":\"rgba(2, 110, 159, 0)\"},\"typography\":{\"color\":\"${theme.colors.1}\"},\"border\":{\"top\":{\"color\":\"${theme.colors.0|variant3}\"},\"right\":{\"color\":\"${theme.colors.0|variant3}\"},\"bottom\":{\"color\":\"${theme.colors.0|variant3}\"},\"left\":{\"color\":\"${theme.colors.0|variant3}\"}}}},\"padding\":{\"top\":{\"value\":\"8\",\"unit\":\"px\"},\"right\":{\"value\":\"20\",\"unit\":\"px\"},\"bottom\":{\"value\":\"8\",\"unit\":\"px\"},\"left\":{\"value\":\"20\",\"unit\":\"px\"}},\"textAlign\":\"center\"},\"props\":{\"showIcon\":true,\"iconPosition\":\"after\",\"buttonSize\":\"small\",\"buttonWidth\":\"fitToContent\"},\"v\":\"1.1\",\"nodes\":[\"2901-c33\"]},{\"id\":867,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"2901-c71\",\"nodes\":[\"2901-c38\"],\"v\":\"1.1\"},{\"id\":868,\"type\":\"hop-column\",\"nodeId\":\"2901-c72\",\"nodes\":[\"2901-c39\"],\"v\":\"1.1\"},{\"id\":869,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"nodeId\":\"2901-c73\",\"nodes\":[\"2901-c40\"],\"v\":\"1.1\"},{\"id\":870,\"type\":\"hop-text\",\"nodeId\":\"2901-c74\",\"nodes\":[\"2901-c41\"],\"v\":\"1.1\"},{\"id\":871,\"type\":\"hop-image\",\"nodeId\":\"2896-h45\",\"nodes\":[\"2896-h29\"],\"v\":\"1.1\",\"props\":{\"hide\":{\"mobile\":true}}},{\"id\":872,\"type\":\"hop-content\",\"nodeId\":\"2993-c1\",\"nodes\":[\"2993-c1\"],\"v\":\"1.1\"},{\"id\":876,\"type\":\"hop-section\",\"style\":{\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"image\"}}]},\"padding\":{\"top\":{\"path\":\"value\",\"value\":0},\"bottom\":{\"path\":\"value\",\"value\":0}}},\"props\":{\"width\":\"full-width\"},\"v\":\"1.1\",\"nodes\":[\"2993-c5\"]},{\"id\":877,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-row\",\"style\":{\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"image\"}}],\"overlay\":{\"enabled\":false}}},\"v\":\"1.1\",\"nodes\":[\"2993-c6\"]},{\"id\":878,\"type\":\"hop-column\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"http:\\/\\/localhost\\/site\\/wp-content\\/uploads\\/2025\\/01\\/colibri-image-219.png\"},\"position\":\"top left\"}],\"overlay\":{\"enabled\":false,\"color\":{\"opacity\":0.49},\"type\":\"color\"}},\"media\":{\"mobile\":{\"customHeight\":{\"type\":\"min-height\",\"min-height\":{\"value\":\"300\"}},\"background\":{\"image\":[{\"position\":\"center left\"}]}}},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":369},\"type\":\"min-height\"}},\"props\":{\"verticalAlign\":\"center\",\"media\":{\"mobile\":{\"verticalAlign\":\"center\"}},\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"2993-c7\"]},{\"id\":879,\"type\":\"hop-column\",\"style\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"padding\":{\"top\":{\"value\":\"7\",\"unit\":\"rem\"},\"right\":{\"value\":\"7\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"7\",\"unit\":\"rem\"},\"left\":{\"value\":\"4\",\"unit\":\"rem\"}},\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"top\":{\"value\":\"2\",\"unit\":\"rem\"},\"right\":{\"value\":\"2\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"2\",\"unit\":\"rem\"},\"left\":{\"value\":\"2\",\"unit\":\"rem\"}}},\"tablet\":{\"padding\":{\"top\":{\"value\":\"4\",\"unit\":\"rem\"},\"right\":{\"value\":\"2\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"4\",\"unit\":\"rem\"},\"left\":{\"value\":\"2\",\"unit\":\"rem\"}}}},\"textAlign\":\"left\"},\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}},\"v\":\"1.1\",\"nodes\":[\"2993-c8\"]},{\"id\":880,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"2993-c9\"]},{\"id\":881,\"type\":\"hop-text\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.4}\"}}},\"media\":{\"desktop\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.4}\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c10\"]},{\"id\":882,\"type\":\"hop-icon-list\",\"style\":{\"descendants\":{\"li\":{\"horizontalAlign\":\"start\",\"padding\":{\"bottom\":{\"path\":\"value\",\"value\":\"12\"}},\"media\":{\"mobile\":{\"horizontalAlign\":\"center\"}}},\"text\":{\"media\":{\"tablet\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\",\"path\":\"value\"}}},\"mobile\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\",\"path\":\"value\"}}}},\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}},\"color\":\"${theme.colors.4}\"},\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"40\"},\"height\":{\"path\":\"value\",\"value\":\"40\"},\"fill\":\"${theme.colors.4}\",\"media\":{\"tablet\":{\"padding\":{\"left\":{\"path\":\"value\",\"value\":\"0\"}},\"width\":{\"path\":\"value\",\"value\":\"30\"},\"height\":{\"path\":\"value\",\"value\":\"30\"}}},\"padding\":{\"left\":{\"path\":\"value\",\"value\":\"0\"}}},\"list-item\":{\"horizontalAlign\":\"start\",\"padding\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}},\"media\":{\"mobile\":{\"horizontalAlign\":\"center\"}}},\"links\":{\"states\":{\"hover\":{\"color\":\"${theme.colors.1|variant3}\",\"typography\":{\"color\":\"rgba(255, 255, 255, 0.8)\"}}}},\"divider\":{\"border\":{\"left\":{\"width\":{\"value\":0,\"unit\":\"px\"}},\"bottom\":{\"width\":{\"value\":1,\"unit\":\"px\"}}},\"width\":{\"value\":100,\"unit\":\"%\"}},\"containerDivider\":{\"height\":{\"value\":1,\"unit\":\"px\"},\"width\":{\"value\":100,\"unit\":\"%\"},\"padding\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"top\":{\"value\":10,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":10,\"unit\":\"px\"}}}}},\"props\":{\"iconAndTextAlign\":\"center\",\"listLayout\":\"vertical\"},\"v\":\"1.1\",\"nodes\":[\"2993-c11\"]},{\"id\":883,\"type\":\"hop-section\",\"style\":{\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"image\"}}]},\"padding\":{\"top\":{\"path\":\"value\",\"value\":0},\"bottom\":{\"path\":\"value\",\"value\":0}}},\"props\":{\"width\":\"full-width\"},\"v\":\"1.1\",\"nodes\":[\"2993-c12\"]},{\"id\":884,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":0,\"verticalGap\":0}},\"type\":\"hop-row\",\"style\":{\"background\":{\"type\":\"none\",\"image\":[{\"source\":{\"type\":\"image\"}}],\"overlay\":{\"enabled\":false}}},\"v\":\"1.1\",\"nodes\":[\"2993-c13\"]},{\"id\":885,\"type\":\"hop-column\",\"style\":{\"background\":{\"type\":\"image\",\"image\":[{\"source\":{\"type\":\"image\",\"url\":\"http:\\/\\/localhost\\/site\\/wp-content\\/uploads\\/2025\\/01\\/colibri-image-219.png\"},\"position\":\"top left\"}],\"overlay\":{\"enabled\":false,\"color\":{\"opacity\":0.49},\"type\":\"color\"}},\"media\":{\"mobile\":{\"customHeight\":{\"type\":\"min-height\",\"min-height\":{\"value\":\"300\"}},\"background\":{\"image\":[{\"position\":\"center left\"}]}}}},\"props\":{\"verticalAlign\":\"center\",\"media\":{\"mobile\":{\"verticalAlign\":\"center\"}},\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"2993-c14\"]},{\"id\":886,\"type\":\"hop-column\",\"style\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"padding\":{\"top\":{\"value\":\"7\",\"unit\":\"rem\"},\"right\":{\"value\":\"7\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"7\",\"unit\":\"rem\"},\"left\":{\"value\":\"4\",\"unit\":\"rem\"}},\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"top\":{\"value\":\"2\",\"unit\":\"rem\"},\"right\":{\"value\":\"2\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"2\",\"unit\":\"rem\"},\"left\":{\"value\":\"2\",\"unit\":\"rem\"}}},\"tablet\":{\"padding\":{\"top\":{\"value\":\"4\",\"unit\":\"rem\"},\"right\":{\"value\":\"2\",\"unit\":\"rem\"},\"bottom\":{\"value\":\"4\",\"unit\":\"rem\"},\"left\":{\"value\":\"2\",\"unit\":\"rem\"}}}},\"textAlign\":\"left\"},\"props\":{\"verticalAlign\":\"center\",\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}},\"v\":\"1.1\",\"nodes\":[\"2993-c15\"]},{\"id\":887,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\"}},\"props\":{\"headerType\":\"2\"},\"v\":\"1.1\",\"nodes\":[\"2993-c16\"]},{\"id\":888,\"type\":\"hop-text\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.4}\"}}},\"media\":{\"desktop\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.4}\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c17\"]},{\"id\":889,\"type\":\"hop-icon-list\",\"style\":{\"descendants\":{\"li\":{\"horizontalAlign\":\"start\",\"padding\":{\"bottom\":{\"path\":\"value\",\"value\":\"12\"}},\"media\":{\"mobile\":{\"horizontalAlign\":\"center\"}}},\"text\":{\"media\":{\"tablet\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\",\"path\":\"value\"}}},\"mobile\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\",\"path\":\"value\"}}}},\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}},\"color\":\"${theme.colors.4}\"},\"icon\":{\"width\":{\"path\":\"value\",\"value\":\"40\"},\"height\":{\"path\":\"value\",\"value\":\"40\"},\"fill\":\"${theme.colors.4}\",\"media\":{\"tablet\":{\"padding\":{\"left\":{\"path\":\"value\",\"value\":\"0\"}},\"width\":{\"path\":\"value\",\"value\":\"30\"},\"height\":{\"path\":\"value\",\"value\":\"30\"}}},\"padding\":{\"left\":{\"path\":\"value\",\"value\":\"0\"}}},\"list-item\":{\"horizontalAlign\":\"start\",\"padding\":{\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"}},\"media\":{\"mobile\":{\"horizontalAlign\":\"center\"}}},\"links\":{\"states\":{\"hover\":{\"color\":\"${theme.colors.1|variant3}\",\"typography\":{\"color\":\"rgba(255, 255, 255, 0.8)\"}}}},\"divider\":{\"border\":{\"left\":{\"width\":{\"value\":0,\"unit\":\"px\"}},\"bottom\":{\"width\":{\"value\":1,\"unit\":\"px\"}}},\"width\":{\"value\":100,\"unit\":\"%\"}},\"containerDivider\":{\"height\":{\"value\":1,\"unit\":\"px\"},\"width\":{\"value\":100,\"unit\":\"%\"},\"padding\":{\"left\":{\"value\":0,\"unit\":\"px\"},\"top\":{\"value\":10,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":10,\"unit\":\"px\"}}}}},\"props\":{\"iconAndTextAlign\":\"center\",\"listLayout\":\"vertical\"},\"v\":\"1.1\",\"nodes\":[\"2993-c18\"]},{\"id\":978,\"type\":\"hop-section\",\"props\":{\"showHeader\":true},\"v\":\"1.1\",\"nodes\":[\"2993-c166\"],\"style\":{\"background\":{\"color\":\"#F5FAFD\"},\"padding\":{\"bottom\":{\"value\":11}}}},{\"id\":979,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4},\"media\":{\"tablet\":{\"layout\":{\"itemsPerRow\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"2993-c167\"]},{\"id\":980,\"type\":\"hop-column\",\"props\":{\"layout\":{\"vSpace\":{\"path\":\"value\",\"value\":\"10\"},\"verticalInnerGap\":0,\"horizontalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"2993-c168\",\"2993-c174\",\"2993-c180\",\"2993-c186\"]},{\"id\":981,\"type\":\"hop-image\",\"style\":{\"descendants\":{\"image\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}},\"overlay\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c169\"]},{\"id\":982,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"2993-c170\",\"2993-c176\",\"2993-c182\",\"2993-c188\"]},{\"id\":983,\"type\":\"hop-text\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"style\":\"italic\"}}},\"media\":{\"desktop\":{\"typography\":{\"holders\":{\"p\":{\"style\":\"italic\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c183\",\"2993-c189\"]},{\"id\":984,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"2993-c172\",\"2993-c178\",\"2993-c184\",\"2993-c190\"]},{\"id\":985,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":\"5\"}},\"padding\":{\"top\":{\"value\":\"5\"},\"left\":{\"value\":\"5\"},\"bottom\":{\"value\":\"5\"},\"right\":{\"value\":\"5\"}}},\"icon-content\":{\"width\":{\"value\":\"20\"},\"height\":{\"value\":\"20\"},\"fill\":\"${theme.colors.4|variant1}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.0}\"}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c173\"]},{\"id\":986,\"type\":\"hop-image\",\"style\":{\"descendants\":{\"image\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}},\"overlay\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c175\"]},{\"id\":987,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":\"5\"}},\"padding\":{\"top\":{\"value\":\"5\"},\"left\":{\"value\":\"5\"},\"bottom\":{\"value\":\"5\"},\"right\":{\"value\":\"5\"}}},\"icon-content\":{\"width\":{\"value\":\"20\"},\"height\":{\"value\":\"20\"},\"fill\":\"${theme.colors.4|variant1}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.0}\"}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c179\"]},{\"id\":988,\"type\":\"hop-image\",\"style\":{\"descendants\":{\"image\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}},\"overlay\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c181\"]},{\"id\":989,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":\"5\"}},\"padding\":{\"top\":{\"value\":\"5\"},\"left\":{\"value\":\"5\"},\"bottom\":{\"value\":\"5\"},\"right\":{\"value\":\"5\"}}},\"icon-content\":{\"width\":{\"value\":\"20\"},\"height\":{\"value\":\"20\"},\"fill\":\"${theme.colors.4|variant1}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.0}\"}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c185\"]},{\"id\":990,\"type\":\"hop-image\",\"style\":{\"descendants\":{\"image\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}},\"overlay\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c187\"]},{\"id\":991,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":\"5\"}},\"padding\":{\"top\":{\"value\":\"5\"},\"left\":{\"value\":\"5\"},\"bottom\":{\"value\":\"5\"},\"right\":{\"value\":\"5\"}}},\"icon-content\":{\"width\":{\"value\":\"20\"},\"height\":{\"value\":\"20\"},\"fill\":\"${theme.colors.4|variant1}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.0}\"}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c191\"]},{\"id\":992,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"2993-c192\"]},{\"id\":993,\"type\":\"hop-column\",\"v\":\"1.1\",\"nodes\":[\"2993-c193\"]},{\"id\":994,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"v\":\"1.1\",\"nodes\":[\"2993-c194\"]},{\"id\":995,\"type\":\"hop-text\",\"props\":{\"type\":\"lead\"},\"v\":\"1.1\",\"nodes\":[\"2993-c195\"]},{\"id\":1014,\"type\":\"hop-section\",\"props\":{\"showHeader\":false},\"v\":\"1.1\",\"nodes\":[\"2993-c226\"],\"style\":{\"background\":{\"color\":\"#F5FAFD\"}}},{\"id\":1015,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4,\"horizontalGap\":0,\"verticalGap\":0},\"media\":{\"tablet\":{\"layout\":{\"itemsPerRow\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"2993-c227\"]},{\"id\":1016,\"type\":\"hop-column\",\"props\":{\"layout\":{\"vSpace\":{\"path\":\"value\",\"value\":\"10\"},\"verticalInnerGap\":0,\"horizontalInnerGap\":0}},\"v\":\"1.1\",\"nodes\":[\"2993-c228\",\"2993-c234\"],\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},{\"id\":1017,\"type\":\"hop-image\",\"style\":{\"descendants\":{\"image\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}},\"overlay\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c229\"]},{\"id\":1018,\"type\":\"hop-heading\",\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"2993-c230\",\"2993-c236\"]},{\"id\":1019,\"type\":\"hop-text\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"style\":\"italic\"}}},\"media\":{\"desktop\":{\"typography\":{\"holders\":{\"p\":{\"style\":\"italic\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c237\",\"2993-c243\",\"2993-c249\"]},{\"id\":1020,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"2993-c232\",\"2993-c238\"]},{\"id\":1021,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":\"5\"}},\"padding\":{\"top\":{\"value\":\"5\"},\"left\":{\"value\":\"5\"},\"bottom\":{\"value\":\"5\"},\"right\":{\"value\":\"5\"}}},\"icon-content\":{\"width\":{\"value\":\"20\"},\"height\":{\"value\":\"20\"},\"fill\":\"${theme.colors.4|variant1}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.0}\"}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c233\"]},{\"id\":1022,\"type\":\"hop-image\",\"style\":{\"descendants\":{\"image\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}},\"overlay\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c235\"]},{\"id\":1023,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":\"5\"}},\"padding\":{\"top\":{\"value\":\"5\"},\"left\":{\"value\":\"5\"},\"bottom\":{\"value\":\"5\"},\"right\":{\"value\":\"5\"}}},\"icon-content\":{\"width\":{\"value\":\"20\"},\"height\":{\"value\":\"20\"},\"fill\":\"${theme.colors.4|variant1}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.0}\"}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c239\"]},{\"id\":1024,\"type\":\"hop-image\",\"style\":{\"descendants\":{\"image\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}},\"overlay\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c241\"]},{\"id\":1025,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":\"5\"}},\"padding\":{\"top\":{\"value\":\"5\"},\"left\":{\"value\":\"5\"},\"bottom\":{\"value\":\"5\"},\"right\":{\"value\":\"5\"}}},\"icon-content\":{\"width\":{\"value\":\"20\"},\"height\":{\"value\":\"20\"},\"fill\":\"${theme.colors.4|variant1}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.0}\"}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c245\"]},{\"id\":1026,\"type\":\"hop-image\",\"style\":{\"descendants\":{\"image\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}},\"overlay\":{\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c247\"]},{\"id\":1027,\"type\":\"hop-social-icons\",\"style\":{\"descendants\":{\"icon\":{\"margin\":{\"right\":{\"value\":\"5\"}},\"padding\":{\"top\":{\"value\":\"5\"},\"left\":{\"value\":\"5\"},\"bottom\":{\"value\":\"5\"},\"right\":{\"value\":\"5\"}}},\"icon-content\":{\"width\":{\"value\":\"20\"},\"height\":{\"value\":\"20\"},\"fill\":\"${theme.colors.4|variant1}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.0}\"}}}}},\"v\":\"1.1\",\"nodes\":[\"2993-c251\"]},{\"id\":1028,\"type\":\"hop-content\",\"nodeId\":\"3265-c1\",\"nodes\":[\"3265-c1\"],\"v\":\"1.1\"},{\"id\":1029,\"type\":\"hop-section\",\"nodeId\":\"3265-c2\",\"nodes\":[\"3265-c2\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":1030,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"3265-c3\",\"nodes\":[\"3265-c3\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":1031,\"type\":\"hop-column\",\"nodeId\":\"3265-c4\",\"nodes\":[\"3265-c4\"],\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\"},{\"id\":1032,\"type\":\"hop-external\",\"nodeId\":\"3265-c5\",\"nodes\":[\"3265-c5\"],\"style\":[],\"v\":\"1.1\"},{\"id\":1046,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"tablet\":[]},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":-50,\"unit\":\"px\",\"path\":\"value\"}}}},\"background\":{\"color\":\"#F5FAFD\"}},\"v\":\"1.1\",\"nodes\":[\"3265-c57\"]},{\"id\":1047,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4,\"horizontalGap\":0,\"verticalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(74, 74, 74, 0.3)\",\"y\":\"4\"}]},\"background\":{\"color\":\"${theme.colors.4}\"},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}},\"tablet\":[]}},\"v\":\"1.1\",\"nodes\":[\"3265-c58\"]},{\"id\":1048,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}}},\"v\":\"1.1\",\"nodes\":[\"3265-c59\",\"3265-c65\",\"3265-c71\",\"3265-c78\"]},{\"id\":1049,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.1}\",\"width\":{\"path\":\"value\",\"value\":\"50\"},\"height\":{\"path\":\"value\",\"value\":\"50\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"11\"},\"left\":{\"path\":\"value\",\"value\":\"11\"},\"right\":{\"path\":\"value\",\"value\":\"11\"},\"bottom\":{\"path\":\"value\",\"value\":\"11\"}}}},\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\",\"nodes\":[\"3265-c60\",\"3265-c66\",\"3265-c72\",\"3265-c79\"]},{\"id\":1050,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}},\"media\":{\"mobile\":[],\"tablet\":[]}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"3265-c61\",\"3265-c67\",\"3265-c73\",\"3265-c80\"]},{\"id\":1051,\"type\":\"hop-text\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[],\"desktop\":[]}},\"v\":\"1.1\",\"nodes\":[\"3265-c62\",\"3265-c68\",\"3265-c74\",\"3265-c81\"]},{\"id\":1067,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":92}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"tablet\":[]},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":-50,\"unit\":\"px\",\"path\":\"value\"}}}}},\"v\":\"1.1\",\"nodes\":[\"3265-c51\"]},{\"id\":1068,\"props\":{\"layout\":{\"equalWidth\":true,\"itemsPerRow\":4,\"horizontalGap\":0,\"verticalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(74, 74, 74, 0.3)\",\"y\":\"4\"}]},\"background\":{\"color\":\"${theme.colors.4}\"},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}},\"tablet\":[]}},\"v\":\"1.1\",\"nodes\":[\"3265-c52\"]},{\"id\":1069,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"center\",\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":3,\"horizontalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}},\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}}},\"v\":\"1.1\",\"nodes\":[\"3265-c53\",\"3265-c59\",\"3265-c65\",\"3265-c71\"]},{\"id\":1070,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.1}\",\"width\":{\"path\":\"value\",\"value\":\"50\"},\"height\":{\"path\":\"value\",\"value\":\"50\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"11\"},\"left\":{\"path\":\"value\",\"value\":\"11\"},\"right\":{\"path\":\"value\",\"value\":\"11\"},\"bottom\":{\"path\":\"value\",\"value\":\"11\"}}}},\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\",\"nodes\":[\"3265-c54\",\"3265-c60\",\"3265-c66\",\"3265-c72\"]},{\"id\":1071,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}},\"media\":{\"mobile\":[],\"tablet\":[]}},\"props\":{\"headerType\":\"5\"},\"v\":\"1.1\",\"nodes\":[\"3265-c55\",\"3265-c61\",\"3265-c67\",\"3265-c73\"]},{\"id\":1072,\"type\":\"hop-text\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[],\"desktop\":[]}},\"v\":\"1.1\",\"nodes\":[\"3265-c56\",\"3265-c62\",\"3265-c68\",\"3265-c74\"]},{\"id\":1073,\"type\":\"hop-content\",\"nodeId\":\"3282-c1\",\"nodes\":[\"3282-c1\"],\"style\":[],\"v\":\"1.1\"},{\"id\":1074,\"type\":\"hop-section\",\"nodeId\":\"3282-c2\",\"nodes\":[\"3282-c2\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]},\"background\":{\"color\":\"#F5FAFD\"}},\"props\":{\"width\":\"full-width\"}},{\"id\":1075,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"3282-c3\",\"nodes\":[\"3282-c3\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":1076,\"type\":\"hop-column\",\"nodeId\":\"3282-c4\",\"nodes\":[\"3282-c4\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}},{\"id\":1077,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"value\":\"0\"},\"bottom\":{\"value\":\"0\"}},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":-70,\"unit\":\"px\",\"path\":\"value\"}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"path\":\"value\",\"value\":-30}}},\"tablet\":{\"margin\":{\"top\":{\"path\":\"value\",\"value\":-90}}}}}},\"media\":{\"mobile\":{\"padding\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}}},\"props\":{\"width\":\"boxed\"},\"v\":\"1.1\",\"nodes\":[\"3282-c5\"]},{\"id\":1078,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"horizontalGap\":0,\"verticalGap\":0,\"itemsPerRow\":4}},\"type\":\"hop-row\",\"style\":{\"background\":{\"overlay\":{\"enabled\":false}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}}}},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"5\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.0}\"}},\"margin\":{\"top\":{\"value\":\"38\",\"unit\":\"px\"},\"right\":{\"value\":\"38\",\"unit\":\"px\"},\"bottom\":{\"value\":\"38\",\"unit\":\"px\"},\"left\":{\"value\":\"38\",\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"3282-c6\"]},{\"id\":1079,\"type\":\"hop-column\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"textAlign\":\"left\",\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"}},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":141},\"type\":\"fit-to-content\"},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"textAlign\":\"center\",\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"}}},\"tablet\":{\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":181},\"type\":\"fit-to-content\"}}},\"background\":{\"color\":\"${theme.colors.4}\"}},\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2,\"vSpace\":{\"value\":\"0\"}},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}}},\"v\":\"1.1\",\"nodes\":[\"3282-c7\",\"3282-c53\",\"3282-c23\"]},{\"id\":1080,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"color\":\"${theme.colors.0}\",\"weight\":\"400\",\"transform\":\"uppercase\",\"size\":{\"unit\":\"em\",\"value\":1.2}}},\"props\":{\"headerType\":\"1\"},\"v\":\"1.1\",\"nodes\":[\"3282-c8\",\"3282-c54\",\"3282-c24\",\"3282-c11\",\"3282-c14\",\"3282-c17\",\"3282-c20\",\"3282-c51\",\"3282-c48\",\"3282-c45\",\"3282-c42\",\"3282-c39\",\"3282-c36\",\"3282-c33\",\"3282-c30\",\"3282-c27\"]},{\"id\":1081,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"transform\":\"uppercase\",\"size\":{\"unit\":\"em\",\"value\":0.9}}},\"props\":{\"headerType\":\"6\"},\"v\":\"1.1\",\"nodes\":[\"3282-c9\",\"3282-c55\",\"3282-c25\",\"3282-c12\",\"3282-c15\",\"3282-c18\",\"3282-c21\",\"3282-c52\",\"3282-c49\",\"3282-c46\",\"3282-c43\",\"3282-c40\",\"3282-c37\",\"3282-c34\",\"3282-c31\",\"3282-c28\"]},{\"id\":1082,\"type\":\"hop-column\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"textAlign\":\"left\",\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"}},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":142},\"type\":\"fit-to-content\"},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"textAlign\":\"center\",\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"}}}},\"background\":{\"color\":\"${theme.colors.4}\"}},\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2,\"vSpace\":{\"value\":\"0\"}},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}}},\"v\":\"1.1\",\"nodes\":[\"3282-c10\",\"3282-c13\",\"3282-c16\"]},{\"id\":1083,\"type\":\"hop-column\",\"style\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}}}},\"textAlign\":\"left\",\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"}},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":140},\"type\":\"fit-to-content\"},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"top\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"}},\"textAlign\":\"center\",\"border\":{\"top\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"bottom\":{\"radius\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}},\"style\":\"solid\",\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.4|variant1}\"}}}},\"background\":{\"color\":\"${theme.colors.4}\"}},\"props\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2,\"vSpace\":{\"value\":\"0\"}},\"media\":{\"mobile\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}}}},\"v\":\"1.1\",\"nodes\":[\"3282-c19\",\"3282-c50\",\"3282-c47\",\"3282-c44\",\"3282-c41\",\"3282-c38\",\"3282-c35\",\"3282-c32\",\"3282-c29\",\"3282-c26\"]},{\"id\":1084,\"type\":\"hop-text\",\"nodeId\":\"3282-c22\",\"nodes\":[\"3282-c22\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[],\"desktop\":[]},\"typography\":{\"holders\":{\"p\":{\"weight\":\"700\",\"size\":{\"unit\":\"px\",\"value\":35},\"lineHeight\":{\"unit\":\"\",\"value\":1.2},\"decoration\":\"none\"}}},\"textShadow\":{\"enabled\":false},\"margin\":{\"top\":{\"value\":\"-42\",\"unit\":\"px\"},\"right\":{\"value\":\"-42\",\"unit\":\"px\"},\"bottom\":{\"value\":\"-42\",\"unit\":\"px\"},\"left\":{\"value\":\"-42\",\"unit\":\"px\"}},\"textAlign\":\"center\"},\"props\":{\"type\":\"normal\"}},{\"id\":1085,\"type\":\"hop-content\",\"nodeId\":\"3327-c1\",\"nodes\":[\"3327-c1\"],\"v\":\"1.1\"},{\"id\":1086,\"type\":\"hop-section\",\"nodeId\":\"3327-c2\",\"nodes\":[\"3327-c2\"],\"v\":\"1.1\",\"style\":{\"background\":{\"color\":\"#F5FAFD\"}}},{\"id\":1087,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"3327-c3\",\"nodes\":[\"3327-c3\"],\"v\":\"1.1\"},{\"id\":1088,\"type\":\"hop-column\",\"nodeId\":\"3327-c4\",\"nodes\":[\"3327-c4\"],\"v\":\"1.1\"},{\"id\":1089,\"type\":\"hop-section\",\"style\":{\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"0\"}},\"boxShadow\":{\"enabled\":false},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":-50,\"unit\":\"px\",\"path\":\"value\"}}}},\"background\":{\"color\":\"${theme.colors.4}\"}},\"v\":\"1.1\",\"nodes\":[\"3327-c6\"]},{\"id\":1090,\"props\":{\"layout\":{\"equalWidth\":true,\"verticalGap\":0,\"horizontalGap\":0,\"itemsPerRow\":3,\"horizontalInnerGap\":3,\"verticalInnerGap\":3},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2,\"horizontalInnerGap\":2,\"verticalInnerGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(74, 74, 74, 0.3)\",\"y\":\"4\"}]},\"background\":{\"color\":\"${theme.colors.1}\"},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"value\":\"15\",\"unit\":\"px\"},\"right\":{\"value\":\"15\",\"unit\":\"px\"},\"bottom\":{\"value\":\"15\",\"unit\":\"px\"},\"left\":{\"value\":\"15\",\"unit\":\"px\"}}}}},\"v\":\"1.1\",\"nodes\":[\"3327-c7\"]},{\"id\":1091,\"type\":\"hop-column\",\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0},\"media\":{\"tablet\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3}},\"mobile\":{\"layout\":{\"horizontalInnerGap\":2,\"verticalInnerGap\":2}}}},\"style\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"background\":{\"color\":\"\"}},\"tablet\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"background\":{\"color\":\"${theme.colors.2}\"}},\"v\":\"1.1\",\"nodes\":[\"3327-c8\",\"3327-c15\",\"3327-c22\"]},{\"id\":1092,\"props\":{\"layout\":{\"equalWidth\":false,\"verticalInnerGap\":2,\"horizontalInnerGap\":2,\"verticalGap\":2,\"horizontalGap\":2},\"media\":{\"tablet\":{\"layout\":{\"itemsPerRow\":1}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"3327-c9\",\"3327-c16\",\"3327-c23\"]},{\"id\":1093,\"type\":\"hop-column\",\"props\":{\"verticalAlign\":\"start\",\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"style\":{\"media\":{\"tablet\":{\"textAlign\":\"left\"}}},\"v\":\"1.1\",\"nodes\":[\"3327-c10\",\"3327-c17\",\"3327-c24\"]},{\"id\":1094,\"type\":\"hop-icon\",\"style\":{\"descendants\":{\"icon\":{\"fill\":\"${theme.colors.4}\",\"width\":{\"path\":\"value\",\"value\":\"50\"},\"height\":{\"path\":\"value\",\"value\":\"50\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\",\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}}},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"2\",\"unit\":\"px\"},\"color\":\"${theme.colors.4}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"11\"},\"left\":{\"path\":\"value\",\"value\":\"11\"},\"right\":{\"path\":\"value\",\"value\":\"11\"},\"bottom\":{\"path\":\"value\",\"value\":\"11\"}},\"media\":{\"tablet\":{\"width\":{\"path\":\"value\",\"value\":\"50\"},\"height\":{\"path\":\"value\",\"value\":\"50\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"3327-c11\",\"3327-c18\",\"3327-c25\"]},{\"id\":1095,\"type\":\"hop-column\",\"style\":{\"textAlign\":\"left\",\"media\":{\"mobile\":{\"textAlign\":\"center\"}}},\"props\":{\"layout\":{\"verticalInnerGap\":0,\"horizontalInnerGap\":0,\"vSpace\":{\"path\":\"value\",\"value\":\"10\"}}},\"v\":\"1.1\",\"nodes\":[\"3327-c12\",\"3327-c19\",\"3327-c26\"]},{\"id\":1096,\"type\":\"hop-heading\",\"style\":{\"color\":\"${theme.colors.4}\",\"typography\":{\"transform\":\"uppercase\",\"letterSpacing\":{\"unit\":\"px\",\"value\":\"1\"}}},\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"3327-c13\",\"3327-c20\",\"3327-c27\"]},{\"id\":1097,\"type\":\"hop-text\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.4}\"}}},\"media\":{\"desktop\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.4}\"}}}}}},\"v\":\"1.1\",\"nodes\":[\"3327-c14\",\"3327-c21\",\"3327-c28\"]},{\"id\":1098,\"type\":\"hop-text\",\"nodeId\":\"3327-c28\",\"nodes\":[\"3327-c5\"],\"v\":\"1.1\"},{\"id\":1099,\"type\":\"hop-content\",\"nodeId\":\"3336-c1\",\"nodes\":[\"3336-c1\"],\"v\":\"1.1\"},{\"id\":1118,\"type\":\"hop-section\",\"nodeId\":\"3336-c22\",\"nodes\":[\"3336-c2\"],\"v\":\"1.1\",\"style\":{\"background\":{\"color\":\"#F5FAFD\"}}},{\"id\":1119,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"3336-c23\",\"nodes\":[\"3336-c3\"],\"v\":\"1.1\"},{\"id\":1120,\"type\":\"hop-column\",\"nodeId\":\"3336-c24\",\"nodes\":[\"3336-c4\"],\"v\":\"1.1\",\"style\":{\"margin\":{\"top\":{\"value\":\"-43\",\"unit\":\"px\"},\"right\":{\"value\":\"-43\",\"unit\":\"px\"},\"bottom\":{\"value\":\"-43\",\"unit\":\"px\"},\"left\":{\"value\":\"-43\",\"unit\":\"px\"}}}},{\"id\":1121,\"type\":\"hop-text\",\"nodeId\":\"3336-c25\",\"nodes\":[\"3336-c5\"],\"v\":\"1.1\",\"style\":{\"textAlign\":\"center\"}},{\"id\":1122,\"type\":\"hop-section\",\"nodeId\":\"3336-c26\",\"nodes\":[\"3336-c6\"],\"v\":\"1.1\"},{\"id\":1123,\"props\":{\"layout\":{\"equalWidth\":false,\"horizontalGap\":1,\"verticalGap\":1,\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"type\":\"hop-row\",\"nodeId\":\"3336-c27\",\"nodes\":[\"3336-c10\"],\"v\":\"1.1\"},{\"id\":1124,\"type\":\"hop-column\",\"nodeId\":\"3336-c28\",\"nodes\":[\"3336-c11\"],\"v\":\"1.1\",\"style\":{\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"margin\":{\"top\":{\"value\":\"14\",\"unit\":\"px\"},\"right\":{\"value\":\"14\",\"unit\":\"px\"},\"bottom\":{\"value\":\"14\",\"unit\":\"px\"},\"left\":{\"value\":\"14\",\"unit\":\"px\"}}}},{\"id\":1125,\"type\":\"hop-section\",\"v\":\"1.1\",\"style\":{\"padding\":{\"top\":{\"value\":\"0\"}},\"descendants\":{\"inner\":{\"margin\":{\"top\":{\"value\":-100,\"unit\":\"px\",\"path\":\"value\"}}}},\"background\":{\"color\":\"#F5FAFD\"},\"margin\":{\"top\":{\"value\":\"-13\",\"unit\":\"px\"},\"right\":{\"value\":\"-13\",\"unit\":\"px\"},\"bottom\":{\"value\":\"-13\",\"unit\":\"px\"},\"left\":{\"value\":\"-13\",\"unit\":\"px\"}}},\"nodes\":[\"3336-c12\"],\"props\":{\"width\":\"full-width\"}},{\"id\":1126,\"props\":{\"layout\":{\"equalWidth\":false,\"itemsPerRow\":6,\"horizontalInnerGap\":1,\"verticalInnerGap\":1,\"horizontalGap\":1,\"verticalGap\":1},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"v\":\"1.1\",\"nodes\":[\"3336-c13\"]},{\"id\":1127,\"type\":\"hop-column\",\"v\":\"1.1\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"style\":\"solid\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"style\":\"solid\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"3\",\"unit\":\"px\"}},\"right\":{\"style\":\"solid\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"solid\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"5\",\"y\":\"2\",\"color\":\"rgba(0, 0, 0, 0.1)\"}]},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"30\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"10\"},\"horizontalInnerGap\":3,\"verticalInnerGap\":3}},\"nodes\":[\"3336-c14\"]},{\"id\":1128,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"fill\":\"${theme.colors.4}\",\"border\":{\"top\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}},\"style\":\"none\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"bottom\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}},\"style\":\"none\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"}},\"width\":{\"path\":\"value\",\"value\":\"40\"},\"height\":{\"path\":\"value\",\"value\":\"40\"},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"20\"},\"left\":{\"path\":\"value\",\"value\":\"20\"},\"right\":{\"path\":\"value\",\"value\":\"20\"},\"bottom\":{\"path\":\"value\",\"value\":\"20\"}},\"background\":{\"color\":\"${theme.colors.0}\"},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(0, 0, 0, 0.1)\",\"blur\":\"5\",\"y\":\"2\"}]}}},\"margin\":{\"top\":{\"value\":\"-70\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}},\"boxShadow\":{\"enabled\":false},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"-55\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"-55\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"3336-c15\",\"3336-c27\"]},{\"id\":1129,\"type\":\"hop-heading\",\"v\":\"1.1\",\"props\":{\"headerType\":\"4\"},\"nodes\":[\"3336-c16\",\"3336-c20\",\"3336-c24\",\"3336-c28\",\"3336-c32\"]},{\"id\":1130,\"type\":\"hop-text\",\"v\":\"1.1\",\"nodes\":[\"3336-c17\",\"3336-c21\",\"3336-c25\",\"3336-c29\",\"3336-c33\"],\"style\":{\"textAlign\":\"left\"}},{\"id\":1131,\"type\":\"hop-column\",\"v\":\"1.1\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"style\":\"solid\",\"color\":\"${theme.colors.1}\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"style\":\"solid\",\"color\":\"${theme.colors.1}\",\"width\":{\"value\":\"3\",\"unit\":\"px\"}},\"right\":{\"style\":\"solid\",\"color\":\"${theme.colors.1}\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"solid\",\"color\":\"${theme.colors.1}\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"5\",\"y\":\"2\",\"color\":\"rgba(0, 0, 0, 0.1)\"}]},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"30\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"10\"},\"horizontalInnerGap\":3,\"verticalInnerGap\":3}},\"nodes\":[\"3336-c18\"]},{\"id\":1132,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"fill\":\"${theme.colors.4}\",\"border\":{\"top\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}},\"style\":\"none\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"bottom\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}},\"style\":\"none\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"}},\"width\":{\"path\":\"value\",\"value\":\"40\"},\"height\":{\"path\":\"value\",\"value\":\"40\"},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"20\"},\"left\":{\"path\":\"value\",\"value\":\"20\"},\"right\":{\"path\":\"value\",\"value\":\"20\"},\"bottom\":{\"path\":\"value\",\"value\":\"20\"}},\"background\":{\"color\":\"${theme.colors.1}\"},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(0, 0, 0, 0.1)\",\"blur\":\"5\",\"y\":\"2\"}]}}},\"margin\":{\"top\":{\"value\":\"-70\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}},\"boxShadow\":{\"enabled\":false},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"-55\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"-55\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"3336-c19\",\"3336-c31\"]},{\"id\":1133,\"type\":\"hop-column\",\"v\":\"1.1\",\"style\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"border\":{\"top\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"style\":\"solid\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"bottom\":{\"radius\":{\"left\":{\"value\":\"5\",\"unit\":\"px\"},\"right\":{\"value\":\"5\",\"unit\":\"px\"}},\"style\":\"solid\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"3\",\"unit\":\"px\"}},\"right\":{\"style\":\"solid\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}},\"left\":{\"style\":\"solid\",\"color\":\"${theme.colors.0}\",\"width\":{\"value\":\"0\",\"unit\":\"px\"}}},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"blur\":\"5\",\"y\":\"2\",\"color\":\"rgba(0, 0, 0, 0.1)\"}]},\"media\":{\"mobile\":{\"margin\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"30\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}},\"props\":{\"layout\":{\"vSpace\":{\"value\":\"10\"},\"horizontalInnerGap\":3,\"verticalInnerGap\":3}},\"nodes\":[\"3336-c22\",\"3336-c26\",\"3336-c30\"]},{\"id\":1134,\"style\":{\"descendants\":{\"inner\":{\"background\":{\"color\":\"${theme.colors.4}\"},\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"},\"left\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"right\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"color\":\"${theme.colors.1}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"path\":\"value\",\"value\":2},\"radius\":{\"right\":{\"path\":\"value\",\"value\":176},\"left\":{\"path\":\"value\",\"value\":176}},\"color\":\"${theme.colors.1}\"}},\"padding\":{\"top\":{\"path\":\"value\",\"value\":25},\"left\":{\"path\":\"value\",\"value\":25},\"right\":{\"path\":\"value\",\"value\":25},\"bottom\":{\"path\":\"value\",\"value\":25}},\"width\":{\"path\":\"value\",\"value\":\"100\"},\"fill\":\"${theme.colors.0}\",\"states\":{\"hover\":{\"fill\":\"${theme.colors.3}\"}},\"transform\":{\"rotate\":{\"2d\":{\"path\":\"value\",\"value\":118}}}},\"icon\":{\"fill\":\"${theme.colors.4}\",\"border\":{\"top\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}},\"style\":\"none\"},\"right\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"},\"bottom\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"radius\":{\"left\":{\"value\":\"300\",\"unit\":\"px\"},\"right\":{\"value\":\"300\",\"unit\":\"px\"}},\"style\":\"none\"},\"left\":{\"width\":{\"value\":\"0\",\"unit\":\"px\"},\"style\":\"none\"}},\"width\":{\"path\":\"value\",\"value\":\"40\"},\"height\":{\"path\":\"value\",\"value\":\"40\"},\"padding\":{\"top\":{\"path\":\"value\",\"value\":\"20\"},\"left\":{\"path\":\"value\",\"value\":\"20\"},\"right\":{\"path\":\"value\",\"value\":\"20\"},\"bottom\":{\"path\":\"value\",\"value\":\"20\"}},\"background\":{\"color\":\"${theme.colors.2}\"},\"boxShadow\":{\"enabled\":true,\"layers\":[{\"color\":\"rgba(0, 0, 0, 0.1)\",\"blur\":\"5\",\"y\":\"2\"}]}}},\"margin\":{\"top\":{\"value\":\"-70\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}},\"boxShadow\":{\"enabled\":false},\"media\":{\"tablet\":{\"margin\":{\"top\":{\"value\":\"-55\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}},\"mobile\":{\"margin\":{\"top\":{\"value\":\"-55\",\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}}},\"scope\":\"local\",\"type\":\"hop-icon\",\"v\":\"1.1\",\"nodes\":[\"3336-c23\"]},{\"id\":1135,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"nodeId\":\"3336-c57\",\"nodes\":[\"3336-c7\"],\"v\":\"1.1\"},{\"id\":1136,\"type\":\"hop-column\",\"nodeId\":\"3336-c58\",\"nodes\":[\"3336-c8\"],\"v\":\"1.1\"},{\"id\":1137,\"type\":\"hop-text\",\"nodeId\":\"3336-c59\",\"nodes\":[\"3336-c9\"],\"v\":\"1.1\",\"style\":{\"padding\":{\"top\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}},\"margin\":{\"top\":{\"value\":\"-125\",\"unit\":\"px\"},\"right\":{\"value\":\"-125\",\"unit\":\"px\"},\"bottom\":{\"value\":\"-125\",\"unit\":\"px\"},\"left\":{\"value\":\"-125\",\"unit\":\"px\"}}}},{\"id\":1138,\"type\":\"hop-content\",\"nodeId\":\"3491-c1\",\"nodes\":[\"3491-c1\"],\"style\":[],\"v\":\"1.1\"},{\"id\":1139,\"type\":\"hop-section\",\"props\":{\"showHeader\":true,\"width\":\"full-width\"},\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]},\"background\":{\"color\":\"#F5FAFD\"},\"padding\":{\"top\":{\"value\":25},\"bottom\":{\"value\":127}},\"customHeight\":{\"type\":\"full-screen\"}},\"v\":\"1.1\",\"nodes\":[\"3491-c2\"]},{\"id\":1140,\"props\":{\"layout\":{\"equalWidth\":false,\"itemsPerRow\":4,\"horizontalGap\":1,\"verticalGap\":1,\"equalHeight\":true},\"media\":{\"tablet\":{\"layout\":{\"itemsPerRow\":2}}}},\"type\":\"hop-row\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\",\"nodes\":[\"3491-c3\"]},{\"id\":1141,\"type\":\"hop-column\",\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0}},\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]},\"descendants\":{\"outer\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}},\"v\":\"1.1\",\"nodes\":[\"3491-c4\",\"3491-c12\",\"3491-c20\",\"3491-c28\"]},{\"id\":1142,\"props\":{\"layout\":{\"equalWidth\":false,\"verticalGap\":0,\"horizontalGap\":0},\"media\":{\"mobile\":{\"layout\":{\"horizontalGap\":2,\"verticalGap\":2}}}},\"type\":\"hop-row\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\",\"nodes\":[\"3491-c5\",\"3491-c13\",\"3491-c21\",\"3491-c29\"]},{\"id\":1143,\"type\":\"hop-column\",\"style\":{\"border\":{\"top\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.5}\"},\"right\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.5}\"},\"bottom\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.5}\"},\"left\":{\"style\":\"solid\",\"width\":{\"value\":\"1\",\"unit\":\"px\"},\"color\":\"${theme.colors.5}\"}},\"descendants\":{\"outer\":{\"media\":{\"mobile\":{\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}}}}}},\"media\":{\"mobile\":[],\"tablet\":[]},\"padding\":{\"left\":{\"unit\":\"px\",\"value\":\"\"},\"right\":{\"unit\":\"px\",\"value\":\"\"},\"top\":{\"unit\":\"px\",\"value\":\"\"},\"bottom\":{\"unit\":\"px\",\"value\":\"\"}},\"margin\":{\"top\":{\"value\":\"-44\",\"unit\":\"px\"},\"right\":{\"value\":\"-57\",\"unit\":\"px\"},\"bottom\":{\"value\":\"-116\",\"unit\":\"px\"},\"left\":{\"value\":\"-2\",\"unit\":\"px\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":3,\"verticalInnerGap\":3,\"vSpace\":{\"path\":\"value\",\"value\":12}}},\"v\":\"1.1\",\"nodes\":[\"3491-c6\",\"3491-c14\",\"3491-c22\",\"3491-c30\"]},{\"id\":1145,\"type\":\"hop-text\",\"style\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.5}\"}}},\"padding\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"35\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}},\"media\":{\"mobile\":[],\"tablet\":[],\"desktop\":{\"typography\":{\"holders\":{\"p\":{\"color\":\"${theme.colors.5}\"}}},\"padding\":{\"top\":{\"unit\":\"px\"},\"right\":{\"unit\":\"px\"},\"bottom\":{\"value\":\"35\",\"unit\":\"px\"},\"left\":{\"unit\":\"px\"}}}},\"margin\":{\"top\":{\"value\":\"-22\",\"unit\":\"px\"},\"right\":{\"value\":\"-22\",\"unit\":\"px\"},\"bottom\":{\"value\":\"-22\",\"unit\":\"px\"},\"left\":{\"value\":\"-22\",\"unit\":\"px\"}},\"textAlign\":\"left\"},\"v\":\"1.1\",\"nodes\":[\"3491-c8\",\"3491-c16\",\"3491-c24\",\"3491-c32\"]},{\"id\":1146,\"type\":\"hop-column\",\"style\":{\"background\":{\"color\":\"${theme.colors.0}\"},\"padding\":{\"top\":{\"value\":\"10\",\"unit\":\"px\"},\"right\":{\"value\":\"10\",\"unit\":\"px\"},\"bottom\":{\"value\":\"10\",\"unit\":\"px\"},\"left\":{\"value\":\"10\",\"unit\":\"px\"}},\"transform\":{\"translate\":{\"x\":{\"value\":0,\"unit\":\"%\"},\"y\":{\"value\":\"-50\",\"unit\":\"%\"}}},\"media\":{\"mobile\":[],\"tablet\":[]},\"margin\":{\"top\":{\"value\":\"0\",\"unit\":\"px\"},\"right\":{\"value\":\"0\",\"unit\":\"px\"},\"bottom\":{\"value\":\"0\",\"unit\":\"px\"},\"left\":{\"value\":\"0\",\"unit\":\"px\"}}},\"props\":{\"layout\":{\"horizontalInnerGap\":0,\"verticalInnerGap\":0,\"vSpace\":{\"path\":\"value\",\"value\":0}}},\"v\":\"1.1\",\"nodes\":[\"3491-c9\",\"3491-c17\",\"3491-c25\",\"3491-c33\"]},{\"id\":1147,\"type\":\"hop-heading\",\"style\":{\"typography\":{\"color\":\"${theme.colors.4}\"},\"media\":{\"mobile\":[],\"tablet\":[]}},\"props\":{\"headerType\":\"4\"},\"v\":\"1.1\",\"nodes\":[\"3491-c10\",\"3491-c18\",\"3491-c26\",\"3491-c34\"]},{\"id\":1149,\"props\":{\"layout\":{\"equalWidth\":false}},\"type\":\"hop-row\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}},\"v\":\"1.1\",\"nodes\":[\"3491-c36\"]},{\"id\":1150,\"type\":\"hop-column\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]},\"padding\":{\"top\":{\"value\":\"1\",\"unit\":\"px\"},\"right\":{\"value\":\"1\",\"unit\":\"px\"},\"bottom\":{\"value\":\"1\",\"unit\":\"px\"},\"left\":{\"value\":\"1\",\"unit\":\"px\"}},\"customHeight\":{\"min-height\":{\"unit\":\"px\",\"value\":199.625},\"type\":\"min-height\"}},\"v\":\"1.1\",\"nodes\":[\"3491-c37\"]},{\"id\":1151,\"props\":{\"headerType\":\"2\"},\"type\":\"hop-heading\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]},\"padding\":{\"top\":{\"value\":0,\"unit\":\"px\"},\"right\":{\"value\":0,\"unit\":\"px\"},\"bottom\":{\"value\":0,\"unit\":\"px\"},\"left\":{\"value\":0,\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"3491-c38\"]},{\"id\":1152,\"type\":\"hop-text\",\"props\":{\"type\":\"lead\"},\"style\":{\"media\":{\"mobile\":[],\"tablet\":[],\"desktop\":[]},\"margin\":{\"top\":{\"value\":\"33\",\"unit\":\"px\"},\"right\":{\"value\":\"33\",\"unit\":\"px\"},\"bottom\":{\"value\":\"33\",\"unit\":\"px\"},\"left\":{\"value\":\"33\",\"unit\":\"px\"}}},\"v\":\"1.1\",\"nodes\":[\"3491-c39\"]},{\"id\":1153,\"type\":\"hop-column\",\"nodeId\":\"3491-c40\",\"nodes\":[\"3491-c40\"],\"v\":\"1.1\",\"style\":{\"media\":{\"mobile\":[],\"tablet\":[]}}}]\";}", "off");
INSERT INTO `wp_options` VALUES("219", "colibriwp_activate_theme_name", "skyline-wp", "auto");
INSERT INTO `wp_options` VALUES("220", "colibri_page_builder_regenerate_tries_count", "1", "auto");
INSERT INTO `wp_options` VALUES("222", "colibriwp_fix_wp58_sidebar", "1", "auto");
INSERT INTO `wp_options` VALUES("223", "colibri_page_builder_use_fs", "c-40aa7d4a-465e5a73-14b3d413-3ebc374", "auto");
INSERT INTO `wp_options` VALUES("224", "colibri_page_builder_activation_time", "1736613995", "auto");
INSERT INTO `wp_options` VALUES("227", "extend_builder_theme_1736614015", "a:16:{s:5:\"fonts\";a:2:{s:6:\"google\";a:5:{s:4:\"Muli\";a:2:{s:7:\"weights\";a:14:{i:0;s:3:\"200\";i:1;s:9:\"200italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"400\";i:5;s:9:\"400italic\";i:6;s:3:\"600\";i:7;s:9:\"600italic\";i:8;s:3:\"700\";i:9;s:9:\"700italic\";i:10;s:3:\"800\";i:11;s:9:\"800italic\";i:12;s:3:\"900\";i:13;s:9:\"900italic\";}s:8:\"category\";s:10:\"sans-serif\";}s:9:\"Open Sans\";a:2:{s:7:\"weights\";a:10:{i:0;s:3:\"300\";i:1;s:9:\"300italic\";i:2;s:3:\"400\";i:3;s:9:\"400italic\";i:4;s:3:\"600\";i:5;s:9:\"600italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"800\";i:9;s:9:\"800italic\";}s:8:\"category\";s:10:\"sans-serif\";}s:16:\"Playfair Display\";a:2:{s:7:\"weights\";a:6:{i:0;s:3:\"400\";i:1;s:9:\"400italic\";i:2;s:3:\"700\";i:3;s:9:\"700italic\";i:4;s:3:\"900\";i:5;s:9:\"900italic\";}s:8:\"category\";s:10:\"sans-serif\";}s:6:\"Oswald\";a:3:{s:8:\"category\";s:10:\"sans-serif\";s:7:\"subsets\";a:4:{i:0;s:8:\"cyrillic\";i:1;s:10:\"vietnamese\";i:2;s:9:\"latin-ext\";i:3;s:5:\"latin\";}s:7:\"weights\";a:6:{i:0;s:3:\"200\";i:1;s:3:\"300\";i:2;s:3:\"400\";i:3;s:3:\"500\";i:4;s:3:\"600\";i:5;s:3:\"700\";}}s:4:\"Lato\";a:3:{s:8:\"category\";s:10:\"sans-serif\";s:7:\"subsets\";a:2:{i:0;s:9:\"latin-ext\";i:1;s:5:\"latin\";}s:7:\"weights\";a:10:{i:0;s:3:\"100\";i:1;s:9:\"100italic\";i:2;s:3:\"300\";i:3;s:9:\"300italic\";i:4;s:3:\"400\";i:5;s:9:\"400italic\";i:6;s:3:\"700\";i:7;s:9:\"700italic\";i:8;s:3:\"900\";i:9;s:9:\"900italic\";}}}s:6:\"native\";a:0:{}}s:11:\"dummyChange\";s:0:\"\";s:5:\"icons\";a:11:{s:17:\"brandico/facebook\";s:284:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"facebook\" viewBox=\"0 0 486.037 1007\"><path d=\"M124 1005V536H0V367h124V223C124 110 197 5 366 5c68 0 119 7 119 7l-4 158s-52-1-108-1c-61 0-71 28-71 75v123h183l-8 169H302v469H123\"/></svg>\";s:17:\"font-awesome/star\";s:395:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"star\" viewBox=\"0 0 1664 1896.0833\"><path d=\"M1664 647q0 22-26 48l-363 354 86 500q1 7 1 20 0 21-10.5 35.5T1321 1619q-19 0-40-12l-449-236-449 236q-22 12-40 12-21 0-31.5-14.5T301 1569q0-6 2-20l86-500L25 695Q0 668 0 647q0-37 56-46l502-73L783 73q19-41 49-41t49 41l225 455 502 73q56 9 56 46z\"/></svg>\";s:28:\"font-awesome/facebook-square\";s:410:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"facebook-square\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M1248 128q119 0 203.5 84.5T1536 416v960q0 119-84.5 203.5T1248 1664h-188v-595h199l30-232h-229V689q0-56 23.5-84t91.5-28l122-1V369q-63-9-178-9-136 0-217.5 80T820 666v171H620v232h200v595H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960z\"/></svg>\";s:27:\"font-awesome/twitter-square\";s:630:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"twitter-square\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M1280 610q-56 25-121 34 68-40 93-117-65 38-134 51-61-66-153-66-87 0-148.5 61.5T755 722q0 29 5 48-129-7-242-65T326 550q-29 50-29 106 0 114 91 175-47-1-100-26v2q0 75 50 133.5t123 72.5q-29 8-51 8-13 0-39-4 21 63 74.5 104t121.5 42q-116 90-261 90-26 0-50-3 148 94 322 94 112 0 210-35.5t168-95 120.5-137 75-162T1176 746q0-18-1-27 63-45 105-109zm256-194v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z\"/></svg>\";s:27:\"font-awesome/youtube-square\";s:1354:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"youtube-square\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M919 1303v-157q0-50-29-50-17 0-33 16v224q16 16 33 16 29 0 29-49zm184-122h66v-34q0-51-33-51t-33 51v34zM532 915v70h-80v423h-74V985h-78v-70h232zm201 126v367h-67v-40q-39 45-76 45-33 0-42-28-6-17-6-54v-290h66v270q0 24 1 26 1 15 15 15 20 0 42-31v-280h67zm252 111v146q0 52-7 73-12 42-53 42-35 0-68-41v36h-67V915h67v161q32-40 68-40 41 0 53 42 7 21 7 74zm251 129v9q0 29-2 43-3 22-15 40-27 40-80 40-52 0-81-38-21-27-21-86v-129q0-59 20-86 29-38 80-38t78 38q21 29 21 86v76h-133v65q0 51 34 51 24 0 30-26 0-1 .5-7t.5-16.5V1281h68zM785 457v156q0 51-32 51t-32-51V457q0-52 32-52t32 52zm533 713q0-177-19-260-10-44-43-73.5t-76-34.5q-136-15-412-15-275 0-411 15-44 5-76.5 34.5T238 910q-20 87-20 260 0 176 20 260 10 43 42.5 73t75.5 35q137 15 412 15t412-15q43-5 75.5-35t42.5-73q20-84 20-260zM563 519l90-296h-75l-51 195-53-195h-78q7 23 23 69l24 69q35 103 46 158v201h74V519zm289 81V470q0-58-21-87-29-38-78-38-51 0-78 38-21 29-21 87v130q0 58 21 87 27 38 78 38 49 0 78-38 21-27 21-87zm181 120h67V350h-67v283q-22 31-42 31-15 0-16-16-1-2-1-26V350h-67v293q0 37 6 55 11 27 43 27 36 0 77-45v40zm503-304v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z\"/></svg>\";s:25:\"font-awesome/vimeo-square\";s:540:\"<svg version=\"1.1\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" id=\"vimeo-square\" viewBox=\"0 0 1536 1896.0833\"><path d=\"M1292 638q10-216-161-222-231-8-312 261 44-19 82-19 85 0 74 96-4 57-74 167t-105 110q-43 0-82-169-13-54-45-255-30-189-160-177-59 7-164 100l-81 72-81 72 52 67q76-52 87-52 57 0 107 179 15 55 45 164.5t45 164.5q68 179 164 179 157 0 383-294 220-283 226-444zm244-222v960q0 119-84.5 203.5T1248 1664H288q-119 0-203.5-84.5T0 1376V416q0-119 84.5-203.5T288 128h960q119 0 203.5 84.5T1536 416z\"/></svg>\";s:17:\"font-awesome/plus\";s:353:\"<svg version=\"1.1\" xmlns=\"http://www